
$('#fullname').on("keyup focus", () =>{
    var fullName = $("#fullname").val(); 
    if (fullName === "") {
        $("#fullname").addClass('is-invalid').removeClass('is-valid');
        $("#errorFullname").show().html('Please enter a full name (first and last name).');
    }
    else if (fullName.length < 2) {
        $("#fullname").addClass('is-invalid').removeClass("is-valid");
        $("#errorFullname").show().html('Please check your full name.');
    }
    else {
        $("#fullname").removeClass('is-invalid').addClass("is-valid");
        $("#errorFullname").hide();
    }
});

$('#address').on("keyup focus", function() {
    var address = $("#address").val().trim(); 
    if (address === "") {
        $("#address").addClass('is-invalid').removeClass('is-valid');
        $("#errorAddress").show().html('Please enter a address.');
    } else if (address.length < 5) {
        $("#address").addClass('is-invalid').removeClass('is-valid');
        $("#errorAddress").show().html('Please enter a is-valid address.');
    } else {
        $("#address").removeClass('is-invalid').addClass('is-valid');
        $("#errorAddress").html('');
    }
});
$('#city').on("keyup focus", function() {
    var city = $("#city").val().trim();  
    if (city === "") {
        $("#city").addClass('is-invalid').removeClass('is-valid');
        $("#errorCity").show().html('Please enter a city.');
    } else if (city.length < 4) {
        $("#city").addClass('is-invalid').removeClass('is-valid');
        $("#errorCity").show().html('Please enter a is-valid city.');
    } else {
        $("#city").addClass('is-valid').removeClass('is-invalid');
        $("#errorCity").html('');
    }
});

$('#state').on("keyup change focus", function() {
    var state = $("#state").val().trim();  
    if (state === "") {
        $("#state").addClass('is-invalid').removeClass('is-valid');
        $("#errorState").show().html('Please enter a state.');
    } else {
        $("#state").addClass('is-valid').removeClass('is-invalid');
        $("#errorState").hide();
    }
});

$('#zip').mask('00000')
$('#zip').on("keyup focus", function() {
    var zip = $("#zip").val().trim(); 
    var zipRegex = /^\d{5}$/; 
    if (zip === "") {
        $("#zip").addClass('is-invalid').removeClass('is-valid');
        $("#errorZip").show().html('Please enter a zip code.');
    } else if (!zipRegex.test(zip)) {
         $("#zip").addClass('is-invalid').removeClass('is-valid');
        $("#errorZip").show().html('Please enter a is-valid zip code.');
    } else {
         $("#zip").addClass('is-valid').removeClass('is-invalid');
        $("#errorZip").html('');
    }
});

$('#fullname, #address, #city, #state, #zip').on("keyup focus", () => {
if (!$("#fullname").hasClass('is-invalid') && 
!$("#address").hasClass('is-invalid') &&
!$("#city").hasClass('is-invalid') && 
!$("#state").hasClass('is-invalid') && 
!$("#zip").hasClass('is-inis-valid') &&
$("#fullname").val().length > 0 && 
$("#address").val().length > 0 && 
$("#city").val().length > 0 && 
$("#state").val().length > 0 && 
$("#zip").val().length > 0){
$("#btnContinue").prop("disabled", false);
} else {
    $("#btnContinue").prop("disabled", true); 
}});

