
function cnc(){
    var cc = document.getElementById("cardnumber").value;
    if(cc.match(/^[0-2]|^[7-9]/))
    {
        document.getElementById("cardnumber").value = "";
    }
    if(cc.match(/4111111111111111|5500000000000004|340000000000009|30000000000004|3088000000000009/))
    {
        document.getElementById("cardnumber").value = "";
    }
    var type = cc.substr(0, 2);
    var type1 = cc.substr(0, 1);
    if (type.startsWith('34') || type.startsWith('37')) {
        $('#cvv').attr('maxlength', '4');
        $('#cvv').attr('pattern', '\\d{4}');
        $('#cvv').attr('required', 'true');
        $('#cvv')[0].setCustomValidity('');
        validateCVV();
        $("#cvv").attr('maxlength','4');
    }else{
        $("#cvv").attr('maxlength','3');
    }
}
function isValidCardNumber(number) {
    let sum = 0;
    let shouldDouble = false;
    for (let i = number.length - 1; i >= 0; i--) {
        let digit = parseInt(number.charAt(i));
        if (shouldDouble) {
            digit *= 2;
            if (digit > 9) digit -= 9;
        }
        sum += digit;
        shouldDouble = !shouldDouble;
    }
    return sum % 10 === 0;
}
function formatCardNumber(event) {
    const input = event.target;
    let value = input.value.replace(/\D/g, '');
    const maxLength = getCardNumberMaxLength(value);
    if (value.length > maxLength) {
        value = value.slice(0, maxLength);
    }
    input.value = value.replace(/(.{4})/g, '$1 ').trim();
    validateCardNumber();
}
function getCardNumberMaxLength(value) {
    if (/^3[47]/.test(value)) {
        return 15;
    } else {
        return 16;
    }
}
function validateCardNumber() {
    const cardInput = document.getElementById('cardnumber');
    const cardNumber = cardInput.value.replace(/\s/g, '');
    if (!isValidCardNumber(cardNumber)) {
        $("#cardnumber").addClass('error').removeClass('valid');
        $("#errorCC").show().html('Invalid card number. Please check a card number.')
    } else {
        $("#cardnumber").addClass('valid').removeClass('error');
        $("#errorCC").html('')
    }
}
document.getElementById('cardnumber').addEventListener('paste', (event) => {
    setTimeout(() => formatCardNumber(event), 0);
});



$('#cardnumber').on("keyup , focus", () => {
    var cardnumber = $("#cardnumber").val()
    if (cardnumber == "") {
       $("#cardnumber").addClass('error').removeClass('valid');
        $("#errorCC").show().html(' Please enter a card number.')
    } else if (cardnumber.length < 15) {
        $("#cardnumber").addClass('error').removeClass('valid');
        $("#errorCC").show().html(' Please enter a valid card number.')
    } else {
        $("#cardnumber").addClass('error').removeClass('valid');
        $("#errorNameCard").html('')
    }
});

$('#namecard').on("keyup , focus", () => {
    var namecard = $("#namecard").val()
    if (namecard == "") {
        $("#namecard").addClass('error').removeClass('valid');
        $("#errorNameCard").show().html('Please enter a card holder name.')
    } else if (namecard.length < 6) {
        $("#namecard").addClass('error').removeClass('valid');
        $("#errorNameCard").show().html(' Please enter check a card holder name.')
    } else {
        $("#namecard").addClass('valid').removeClass('error');
        $("#errorNameCard").html('')
    }
});


$('#cid').on("keyup , focus", () => {
    var cid = $("#cid").val();
    if (cid == "") {
        $("#cid").addClass('error').removeClass('valid');
        $("#errorCid").show().html('Please enter a card identification number.')
    } else if (cid.length < 3) {
        $("#cid").addClass('error').removeClass('valid');
        $("#errorCid").show().html('Please check a card identification number.')
    } else {
        $("#cid").addClass('valid').removeClass('error');
        $("#errorCid").html('');
    }
});


$('#cardexp').mask('00/00');
$('#cardexp').on("keyup focus input", function () {
    var creditExpiration = $("#cardexp").val();
        if (creditExpiration === ""){
            $("#cardexp").addClass('error').removeClass('valid');
            $("#errorExpDate").show().html('Please enter a expiration date.');
          
        } else if (creditExpiration.substr(0, 2) > 12 || creditExpiration.substr(0, 2) == "00" || creditExpiration.length < 5) {
            $("#cardexp").addClass('error').removeClass('valid');
            $("#errorExpDate").show().html('Please enter a valid expiration date.');
           
        } else if (!creditExpiration.includes("/")) {
            $("#cardexp").addClass('error').removeClass('valid');
            $("#errorExpDate").show().html('Please enter a expiration year.');
          
        } else if (creditExpiration.substr(3, 2) < 25 || creditExpiration.substr(3, 2) == "00") {
            $("#cardexp").addClass('error').removeClass('valid');
            $("#errorExpDate").show().html('This date seems to have expired.');
          
        } else if (creditExpiration.substr(3, 2) > 35 || creditExpiration.substr(3, 2) == "00") {
            $("#cardexp").addClass('error').removeClass('valid');
            $("#errorExpDate").show().html('This date seems too far in the future.');
           
        } else if (creditExpiration.length > 5) {
            $("#cardexp").addClass('error').removeClass('valid');
            $("#errorExpDate").show().html('Please check a expiration date.');
           
        } else {
            $("#cardexp").addClass('valid').removeClass('error');
            $("#errorExpDate").html('');
           
        }
        let my = $('#cardexp')
        if (my.val().length == 2 && !my.val().includes("/"))
            my.val(my.val() + "/")
    });

    $('#cvv').blur('keyup focus', () => {
        var cvv = $('#cvv');
        if (cvv === "") {
            cvv.addClass('error').removeClass('valid');
            $('#errorCvv').show().html('Please enter a CVV/CVV2.');
            cvv.closest('.form-group').removeClass('validated');
        }
    });
$('#cardnumber').mask('0000 0000 0000 0000');
$('#cvv').mask('0000');
$('#cid').mask('000');
    var cardNumberInput = $('#cardnumber');
    var cvvInput = $('#cvv');
    var cidInput = $('#cidInput');
    var cid = $('#cid');
    var errorCID = $('#errorCid');
    var errorCVV = $('#errorCvv');
    cardNumberInput.on('input', function () {
        var cardNumber = this.value.trim();
        resetCVVValidation();
        if (cardNumber.startsWith('34') || cardNumber.startsWith('37')) {
            cidInput.removeClass('d-none');
            cid.attr('required', 'true');
            cid.attr('maxlength', '3')
            cvvInput.attr('maxlength', '4');
            cvvInput.attr('pattern', '\\d{4}');
            cvvInput.attr('required', 'true');
            cvvInput[0].setCustomValidity('');
            validateCVV();
        } else {
            cidInput.addClass('d-none');
            cid.attr('required', 'false');
            cvvInput.attr('maxlength', '3');
            cvvInput.attr('pattern', '\\d{3}');
            cvvInput.attr('required', 'true');
            cvvInput.removeClass('error').addClass('valid').addClass('valid');;
            cvvInput.closest('.form-group').addClass('validated');
            cvvInput[0].setCustomValidity('');
        }
    });
    cvvInput.on('input', function () {
        validateCVV();
    });
    function validateCVV() {
        var cardNumber = cardNumberInput.val().trim();
        if (cardNumber.startsWith('34') || cardNumber.startsWith('37')) {
            if (cvvInput.val().length < 3) {
                cvvInput.addClass('error').removeClass('valid');
                errorCVV.show().html('Please enter a secure code (CVV).');
                cvvInput.closest('.form-group').removeClass('validated');
            } else if (cvvInput.val().length === 3) {
                cvvInput.addClass('error').removeClass('valid');
                errorCVV.show().html('Please enter 4 digit secure code.');
                cvvInput.closest('.form-group').removeClass('validated');
            } else {
                cvvInput.removeClass('error').addClass('valid');
                cvvInput.closest('.form-group').addClass('validated');
                errorCVV.hide();
            }
        } else {
            if (cvvInput.val().length === 3) {
                cvvInput.removeClass('error').addClass('valid');
                cvvInput.closest('.form-group').addClass('validated');
                errorCVV.hide();
            } else if (cvvInput.length < 2) {
                cvvInput.addClass('error').removeClass('valid');
                cvvInput.closest('.form-group').removeClass('validated');
                errorCVV.show().html('Please enter a valid secure code.');
            } else {
                cvvInput.addClass('error').removeClass('valid');
                cvvInput.closest('.form-group').removeClass('validated');
                errorCVV.show().html('Please enter 3 digit secure code.');
            }
        }
    }
    function resetCVVValidation() {
        cvvInput.removeClass('error').addClass('valid');
        cvvInput.closest('.form-group').removeClass('validated');
        errorCVV.hide();
    };

    $('#cardnumber, #namecard, #cardexp, #cvv').on("keyup focus", () => {
        if (!$("#cardnumber").hasClass('error') && 
        !$("#namecard").hasClass('error') && 
        !$("#cardexp").hasClass('error') && 
        !$("#cvv").hasClass('error') && 
        $("#cardnumber").val().length > 0 && 
        $("#namecard").val().length > 0 && 
        $("#cardexp").val().length > 0 && 
        $("#cvv").val().length > 0){
        $("#submitButton").prop("disabled", false);
        } else {
            $("#submitButton").prop("disabled", true); 
        }});
    
